/*#######################################################################################
AVR Demo zum ansteuern der Xilinx XC9572 Grafikkarte  

Copyright (C) 2005 Ulrich Radig

#######################################################################################*/

#include "main.h"
#include "uart.h"

//############################################################################
//Routine fr die Serielle Ausgabe
int uart_putchar (char c)
//############################################################################
{
	if (c == '\n')
		uart_putchar('\r');
	//Warten solange bis Zeichen gesendet wurde
	loop_until_bit_is_set(USR, UDRE);
	//Ausgabe des Zeichens
	UDR = c;
	return (0);
}

//############################################################################
//INstallation der Seriellen Schnittstelle
void UART_Init (void)
//############################################################################
{
	//Enable TXEN im Register UCR TX-Data Enable
	UCR=(1 << TXEN);
	//Teiler wird gesetzt 
	UBRR=(SYSCLK / (BAUD_RATE * 16L) - 1);
	
	//ffnet einen Kanal fr printf (STDOUT)
	fdevopen (uart_putchar, NULL, 0);
}

