#include <windows.h>
#include <iostream.h>
#include <conio.h>
#include <math.h>
#include "serial.h"
#include "lcd.h"

void lcd_demo(void)
{	unsigned int x1, x2, y1, y2, x, y, i, j;

	clearbuffer();							//LCD lschen
	transfer (0,0,640,480);					//Bildpuffer auf LCD ausgeben



// *************** Text Demo ***************

	setcursor(32,5);						//Cursor Positionieren
	writetext("Verf\x81gbare ASCII Zeichen");	//Text schreiben
	
	for (i=0; i<255; i++)					//ASCII Zeichen in 16x16 Block auf LCD schreiben
	{	setcursor(8+(i&15)*16,32+(i/16)*16);
		writechar(i);
	}
	getbmp("demo_ASCII.bmp");				//Screenshot von LCD machen



// *************** Linien Demo ***************

	for (i=0; i<10; i++)
	{	for (j=0; j<20; j++)
		{	while ((x1=rand())>=640);
			while ((y1=rand())>=480);
			while ((x2=rand())>=640);
			while ((y2=rand())>=480);
			lcd_line(x1,y1,x2,y2);
		}
		transfer(0,0,640,480);
	}

	getbmp("demo_lines.bmp");				//Screenshot von LCD machen



// *************** 3D Demo ***************

	#define sub 16
	#define mul 12

	signed char olddata[32][32];

	clearbuffer ();
	transfer(0,0,640,480);

	for (y=1; y<32; y++)
		for (x=0; x<32; x++)
			olddata[y][x]=0;

	for (i=0; i<120; i++)
	{	clearbuffer ();
		for (y=1; y<32; y++)
			for (x=0; x<32; x++)
				olddata[y-1][x]=olddata[y][x];
		y=31;
		for (x=0; x<32; x++)
			olddata[y][x]=(signed char)(sin(2*PI*x/8)*sin(2*PI*i/20)*50);

		for (y=1; y<32; y++)
			for (x=1; x<32; x++)
			{	lcd_line3d ((x-1-sub)*mul,(y-1-sub)*mul,olddata[y-1][x-1],(x-sub)*mul,(y-1-sub)*mul,olddata[y-1][x],4,0,i/20.0); 
				lcd_line3d ((x-1-sub)*mul,(y-1-sub)*mul,olddata[y-1][x-1],(x-1-sub)*mul,(y-sub)*mul,olddata[y][x-1],4,0,i/20.0); 
			}

		transfer(20,40,620,440);
	}

	getbmp("demo_3D.bmp");					//Screenshot von LCD machen

}