#include <windows.h>
#include <stdio.h>
#include <math.h>
#include "serial.h"
#include "lcd.h"

UART LCD;
unsigned char lcdbuffer[480][1000];

const int header[]={0x42,0x4D,0x0E,0x96,0x00,0x00,0x00,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x28,0x00,	//640x480 BMP Header
					0x00,0x00,0x7F,0x02,0x00,0x00,0xE0,0x01,0x00,0x00,0x01,0x00,0x01,0x00,0x00,0x00,
					0x00,0x00,0x00,0x96,0x00,0x00,0x23,0x2E,0x00,0x00,0x23,0x2E,0x00,0x00,0x00,0x00,
					0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0x00};

//Direkte LCD Befehle
void getbmp(char *filename)
{	int x,y,i;
	unsigned char temp[200];
	FILE *fp;
	fp=fopen(filename,"wb");
	if (fp==NULL)
		return;
	for (x=0; x<62; x++)
		fputc(header[x],fp);
	do	{x=LCD.ReadByte();}
	while (x>0);
	for (x=0; x<80; x++)
	{	temp[2*x+0]=Escape;
		temp[2*x+1]=12;		//Read Byte
	}
	for (y=0; y<480; y++)
	{	i=160;
		temp[i++]=Escape;
		temp[i++]=1;
		if (((char)((479-y)%240))==Escape)
			temp[i++]=Escape;
		temp[i++]=((char)((479-y)%240));
		if (((char)(((479-y)/240)*128))==Escape)
			temp[i++]=Escape;
		temp[i++]=((char)(((479-y)/240)*128));
		
		LCD.SendString(temp, i);
		for (x=0; x<80; x++)
			fputc(LCD.GetByte(),fp);	
	}
}

void writebyte (unsigned char wert)
{	unsigned char temp[5],i=0;
	if (wert==Escape)
		temp[i++]=Escape;
	temp[i++]=wert;
	LCD.SendString(temp,i);
}

void writecom (unsigned char wert)
{	unsigned char temp[5],i=0;
	temp[i++]=Escape;
	if (wert==Escape)
		temp[i++]=Escape;
	temp[i++]=wert;
	LCD.SendString(temp,i);
}

void setpixel (int x, int y)
{	if ((x<0)||(x>XMAX))
		return;
	if ((y<0)||(y>479))
		return;

	setcursor (x, y);
	writecom(16+(x&7));
}

void setpwm (unsigned char wert)
{	unsigned char temp[5],i=0;
	temp[i++]=Escape;
	temp[i++]=2;
	if (wert==Escape)
		temp[i++]=Escape;
	temp[i++]=wert;
	LCD.SendString(temp, i);
}

void setscroll (unsigned char wert)
{	unsigned char temp[5],i=0;
	temp[i++]=Escape;
	temp[i++]=3;
	if (wert==Escape)
		temp[i++]=Escape;
	temp[i++]=wert;
	LCD.SendString(temp, i);
}

void setcursor (unsigned int x, unsigned int y)
{	unsigned char temp[10],i=0;
	temp[i++]=Escape;
	temp[i++]=1;
	if (((char)(y%240))==Escape)
		temp[i++]=Escape;
	temp[i++]=((char)(y%240));
	if (((char)((y/240)*128+(x/8)))==Escape)
		temp[i++]=Escape;
	temp[i++]=((char)((y/240)*128+(x/8)));
	LCD.SendString(temp, i);
}

void writechar (char text)
{	unsigned char temp[5],i=0;
	temp[i++]=Escape;
	if (192==Escape)
		temp[i++]=Escape;
	temp[i++]=192;
	if (text==Escape)
		temp[i++]=Escape;
	temp[i++]=text;
	LCD.SendString(temp,i);
}

void writetext (char *text)
{	while (*text)
		writechar(*text++);
}



//Befehle ber Puffer

void lcd_set_pixel (int x, int y)
{	if ((x<0)||(x>XMAX))
		return;
	if ((y<0)||(y>479))
		return;
	lcdbuffer[y][x]=color;
}


void lcd_line (int x1, int y1, int x2, int y2)
{   int temp;

    if (y1==y2)
       {if (x1>x2)
            {temp=x1;
            x1=x2;
            x2=temp;}
        h_line (x1, x2, y1);}
    else if (x1==x2)
       {if (y1>y2)
            {temp=y1;
            y1=y2;
            y2=temp;}
        v_line (x1, y1, y2); }
    else
        bresenham_line (x1, y1, x2, y2);
}

void bresenham_line (int x1, int y1, int x2, int y2)
{	int dx, dy, x, y, temp;
    int IncrE, IncrNE, d;
      if (y1>y2)
       {temp=y1;
        y1=y2;
        y2=temp;
        temp=x1;
        x1=x2;
        x2=temp;}
    dy = y2-y1;
    if (x1>x2)
       {dx = x1-x2;
        if (dy>dx)
           {IncrE = 2*dx;
            IncrNE = 2*(dx-dy);
            d = IncrE -2*dy;
            x = x1;
            lcd_set_pixel (x,y1);
            for (y=y1+1; y<y2; y++)
               {if (d<=0)
                    d+=IncrE;
                else
                   {d+=IncrNE;
                    x--; }
                lcd_set_pixel (x,y); }}
        else
           {IncrE = 2*dy;
            IncrNE = 2*(dy-dx);
            d = IncrE -2*dx;
            y = y1;
            lcd_set_pixel (x1,y);
            for (x=x1-1; x>x2; x--)
               {if (d<=0)
                    d+=IncrE;
                else
                   {d+=IncrNE;
                    y++; }
                lcd_set_pixel (x,y); }}}
    else
       {dx = x2-x1;
        if (dy>dx)
           {IncrE = 2*dx;
            IncrNE = 2*(dx-dy);
            d = IncrE -2*dy;
            x = x1;
            lcd_set_pixel (x,y1);
            for (y=y1+1; y<y2; y++)
               {if (d<=0)
                    d+=IncrE;
                else
                   {d+=IncrNE;
                    x++; }
             lcd_set_pixel (x,y); }}
        else
           {IncrE = 2*dy;
            IncrNE = 2*(dy-dx);
            d = IncrE -2*dx;
            y = y1;
            lcd_set_pixel (x1,y);
            for (x=x1+1; x<x2; x++)
               {if (d<=0)
                    d+=IncrE;
                else
                   {d+=IncrNE;
                    y++; }
             lcd_set_pixel (x,y); }}}
}

void h_line (int x1, int x2, int y)
{	int x;
    for (x=x1; x<=x2; x++)
	lcd_set_pixel(x,y);
}

void v_line (int x, int y1, int y2)
{	int y;
    for (y=y1; y<=y2; y++)
	lcd_set_pixel(x,y);
}

void transfer (int xmin, int ymin, int xmax, int ymax)
{ 
	if ((xmin<0)||(xmin>XMAX))
		return;
	if ((ymin<0)||(ymin>480))
		return;
	if ((xmax<0)||(xmax>XMAX))
		return;
	if ((ymax<0)||(ymax>480))
		return;

	int y,x,i,j=0;
	unsigned char c;
	unsigned char temp[90000];

	for (y=ymin; y<ymax; y++)
	{	temp[j++]=Escape;
		temp[j++]=1;
		if (((char)(y%240))==Escape)
			temp[j++]=Escape;
		temp[j++]=((char)(y%240));
		if (((char)((y/240)*128+(xmin/8)))==Escape)
			temp[j++]=Escape;
		temp[j++]=((char)((y/240)*128+(xmin/8)));
			for (x=xmin; x<xmax; x+=8)
		{c=0;
			for (i=0; i<8;i++)
				c+=lcdbuffer[y][x+i]*(1<<(7-i));
			if (c==Escape)
				temp[j++]=Escape;
			temp[j++]=c;
		}
	}
	LCD.SendString(temp, j);
}

void clearbuffer (void)
{   unsigned int y,x;

	for (y=0; y<480; y++)
		for (x=0; x<XMAX; x++)
		lcdbuffer[y][x]=1-color;
}

#define x_Pos 320
#define y_Pos 240

void lcd_line3d (int x1,int y1,int z1, int x2,int y2,int z2, double W1, double W2, double W3)
{	int xr1,xr2 ;
	int yr1,yr2 ;

	double M[3][3], sinW1, sinW2, sinW3, cosW1, cosW2, cosW3;

    sinW1=sin(W1);
    sinW2=sin(W2);
    sinW3=sin(W3);
    cosW1=cos(W1);
    cosW2=cos(W2);
    cosW3=cos(W3);

  // Rotation-Matrix 
  // calculates the new position of the single vectors
  M[0][0] = ( cosW2*cosW3);
  M[1][0] = (-cosW2*sinW3);
  M[2][0] =   sinW2*2;

  M[0][1] = (cosW1*sinW3)  + (((sinW1*sinW2))*cosW3);
  M[1][1] = (cosW1*cosW3)  - (((sinW1*sinW2))*sinW3);
  M[2][1] =(-sinW1*cosW2);

  M[0][2] = (sinW1*sinW3)  - (((cosW1*sinW2))*cosW3);
  M[1][2] = (sinW1*cosW3)  + (((cosW1*sinW2))*sinW3);
  M[2][2] = (cosW1*cosW2);
 
    // Convert the vector through the Rotation-Matrix
    xr1 = (int)(M[0][0] * x1 + M[1][0]*y1 + M[2][0]*z1)+x_Pos;
    yr1 = (int)(M[0][1] * x1 + M[1][1]*y1 + M[2][1]*z1)+y_Pos;
    xr2 = (int)(M[0][0] * x2 + M[1][0]*y2 + M[2][0]*z2)+x_Pos;
    yr2 = (int)(M[0][1] * x2 + M[1][1]*y2 + M[2][1]*z2)+y_Pos;

    // Draws the line
    if ((xr1>0)&&(xr2>0)&&(yr1>0)&&(yr2>0))
        lcd_line( xr1, yr1, xr2, yr2);
}

void loadbmp(char *file, unsigned int xp, unsigned int yp,unsigned char invert)
{	unsigned int x, y, i, j, xsize,ysize,farbe,farben,daten;
	unsigned char buffer[200];
	unsigned char c;
	FILE *fp;

	fp=fopen (file,"rb");

	fread(buffer,1,2,fp);
	if ((buffer[0]!='B')&&(buffer[1]!='M'))		//Windows BMP Datei ?
	{	fclose(fp);
		printf ("Ungltige Datei !");
		return;
	}

	fread(buffer,1,16,fp);

	fread(&xsize,4,1,fp);	//Breite
	fread(&ysize,4,1,fp);	//Hhe

	fread(buffer,1,2,fp);
	fread(&farbe,2,1,fp);	//Farbe
	fread(buffer,1,4,fp);	//Compression

	if ((buffer[0]!=0)&&(buffer[1]!=0))
	{	fclose(fp);
		printf ("Unbekannte Kompression !");
		return;
	}

	fread(&daten,4,1,fp);	//Daten

	fread(buffer,1,8,fp);	//Auflsung
	
	fread(&farben,4,1,fp);	//Farben
	
	fread(buffer,1,4,fp);

	if (farben==0)
		farben=1<<farbe;

	if (farben!=2)			//Windows BMP Datei ?
	{	fclose(fp);
		printf ("Es werden nur 2 Farben SW BMPs untersttzt ! (BMP Datei hat %i Farben)",farben);
		return;
	}

	for (i=0; i<farben; i++)
		fread(buffer,1,4,fp);

	for (y=0; y<ysize; y++)
	{	j=0;
		setcursor (xp,ysize-1-y+yp);	//Cursor auf Zeilenbeginn setzen
		for (x=0; x<(xsize/8); x++)
		{	c=fgetc(fp);				//Byte (=8 Pixel) einlesen
			if (invert)
				c=~c;
			if (c==Escape)				//Wert = Escape ?
				buffer[j++]=Escape;		//Dann Wert doppelt senden, um als Daten zu kennzeichnen
			buffer[j++]=c;				//Wert in den Puffer kopieren
		}	
		LCD.SendString(buffer, j);		//Ganzes Bild senden.
		j=0;
		while (x&3)
		{	fread(buffer,1,1,fp);
			x++;
		}
	}
	fclose(fp);
}


