/**********************	C51 definitions for 89C20C51 ********************/
#ifndef _reg2051_h_
#define _reg2051_h_

sfr 	SP    	= 0x81;

sfr16	DPTR	= 0x82;
sfr 	DPL   	= 0x82;
sfr 	DPH   	= 0x83;

sfr 	PCON  	= 0x87;
#define	IDL_	0x01
#define	PD_	0x02
#define	GF0_	0x04
#define	GF1_	0x08
#define SMOD_ 	0x80

sfr 	TCON  	= 0x88;
sbit 	IT0   	= 0x88;
#define	IT0_	0x01
sbit 	IE0   	= 0x89;
#define	IE0_	0x02
sbit 	IT1   	= 0x8A;
#define	IT1_	0x04
sbit 	IE1   	= 0x8B;
#define	IE1_	0x08
sbit 	TR0   	= 0x8C;
#define	TR0_	0x10
sbit 	TF0   	= 0x8D;
#define	TF0_	0x20
sbit 	TR1   	= 0x8E;
#define TR1_	0x40
sbit 	TF1   	= 0x8F;
#define	TF1_	0x80

sfr 	TMOD  	= 0x89;
#define	T0_M0_	1
#define	T0_M1_	2
#define	T0_CT_	4
#define	T0_GA_	8
#define	T1_M0_	0x10
#define T1_M1_	0x20
#define	T1_CT_	0x40
#define	T1_GA_	0x80

sfr 	TL0   	= 0x8A;

sfr 	TL1   	= 0x8B;

sfr 	TH0   	= 0x8C;

sfr 	TH1   	= 0x8D;

sfr 	P1    	= 0x90;
sbit	ACINPOS = P1^0;
sbit	ACINNEG = P1^1;

sfr 	SCON  	= 0x98;
sbit 	RI    	= 0x98;
sbit 	TI    	= 0x99;
#define TI_	0x02
sbit 	RB8   	= 0x9A;
sbit 	TB8   	= 0x9B;
sbit 	REN   	= 0x9C;
#define REN_ 	0x10
sbit 	SM2   	= 0x9D;
#define	SM2_	0x20
sbit 	SM1   	= 0x9E;
#define	SM1_	0x40
sbit 	SM0   	= 0x9F;
#define SM0_	0x80

sfr 	SBUF  	= 0x99;

sfr 	IE    	= 0xA8;
sbit 	EX0   	= 0xA8;
#define EX0_ 	1
sbit 	ET0   	= 0xA9;
#define ET0_ 	2
sbit	EX1   	= 0xAA;
#define EX1_ 	4
sbit 	ET1   	= 0xAB;
#define ET1_ 	8
sbit 	ES    	= 0xAC;
#define ES_ 	0x10
sbit 	EA    	= 0xAF;
#define EA_ 	0x80

sfr 	P3    	= 0xB0;
sbit 	RXD   	= 0xB0;
#define	RXD_	0x01
sbit 	TXD   	= 0xB1;
#define	TXD_	0x02
sbit 	INT0  	= 0xB2;
#define	INT0_	0x04
sbit 	INT1  	= 0xB3;
#define	INT1_	0x08
sbit 	T0    	= 0xB4;
#define	T0_	0x10
sbit 	T1    	= 0xB5;
#define	T1_	0x20
sbit	ACOUT	= P3^6;

sfr 	IP    	= 0xB8;
sbit 	PX0   	= 0xB8;
#define	PX0_	0x01
sbit 	PT0   	= 0xB9;
#define	PT0_	0x02
sbit 	PX1   	= 0xBA;
#define	PX1_	0x04
sbit 	PT1   	= 0xBB;
#define	PT1_	0x08
sbit 	PS    	= 0xBC;
#define	PS_	0x10

sfr 	PSW   	= 0xD0;
sbit	P     	= 0xD0;
sbit 	F1    	= 0xD1;
sbit 	OV    	= 0xD2;
sbit 	RS0   	= 0xD3;
sbit 	RS1   	= 0xD4;
sbit 	F0    	= 0xD5;
sbit 	AC    	= 0xD6;
sbit 	CY    	= 0xD7;

sfr ACC   	= 0xE0;

sfr B     	= 0xF0;

/****************************** Interrupt sources ***********************/

#define INT_EX0		0
#define INT_T0		1	// Interrupt timer 0
#define INT_EX1		2
#define INT_T1		3
#define INT_UART	4

#endif
