#ifndef _types_h_
#define _types_h_

#ifdef __TURBOC__

#define	bit		char
#define	xdata
#define	idata
#define	bdata
#define pdata
#define	data
#define code
#define	sfr		char
#define	sbit		char
#define	sfr16		int
#define interrupt	/##/		// comment
#define int_unused(x)	/##/
#define _at_		;/##/
#else

#define int_unused(x)	void int_##x(void) interrupt x {}
#endif

typedef unsigned char	uchar;
typedef	unsigned int	uint;
typedef unsigned long	ulong;

#define ucchar	uchar code
#define uichar	uchar idata
//typedef	uchar idata	uichar;

#define upchar	uchar pdata
#define uxchar	uchar xdata

#define BIN8(b7,b6,b5,b4,b3,b2,b1,b0) ((uchar)\
                          (b0 << 0)\
                        | (b1 << 1)\
                        | (b2 << 2)\
                        | (b3 << 3)\
                        | (b4 << 4)\
                        | (b5 << 5)\
                        | (b6 << 6)\
                        | (b7 << 7))

union bw {
  uint w;
  struct{
    uchar h;                    // MSB first
    uchar l;
  }b;
};

union blw {
  ulong lw;
  struct{
    uchar b3;                    // MSB first
    uchar b2;
    uchar b1;
    uchar b0;
  }b;
};


#define CALL(addr)	(((void(*)(void))(char code *)addr)())
#define elseif 		else if
#define b2(x,y) 	(((uint)(x)<<8)|(y))		// combine 2 bytes
//#define b2(x,y)       (((uint)(x|0x20)<<8)|(y|0x20))  // lower case

#define TOGGLE(x)	x = ~ x

#define DELAY(x)	{uint i=x;for(;--i;i);}		// x * 8 cycle

#endif
