#include <stdlib.h>
#include <avr/io.h>

#include <avr/interrupt.h>

#include "main.h"
#include "uart.h"









u32 t2_soft;





ISR(TIMER0_OVF_vect)

{

  t2_soft += 256;

}





void t2_init( void )

{

  t2_soft = 0;

  TCCR0 = 1<<CS00;	// mode 0, prescaler 1
  TIMSK |= 1<<TOIE0;	// enable overflow interrupt

}





u32 get_ticks( void )			  // read T0 as 32 bit timer

{

  u32 val;

  u8 tifr;



  cli();

  val = t2_soft + TCNT0;

  tifr = TIFR;				  // read interrupt flags

  sei();

  if( (tifr & 1<<TOV0) && !(val & 0x80) ) // overflow prior reading TCNT0 ?

    val += 256;				  // then add overflow



  return val;

}





int main( void )

{

  char buffer[20];
  uinit();
  uputs("Test Sensor Key:\n\r");


  u32 timerticks;

  t2_init();

  sei();



  for(;;){

    timerticks = get_ticks();

	ultoa( timerticks, buffer, 10 ); //convert unsigned long u32 to char
	uputs( buffer ); //UART output of buffer
	uputs( "\n\r" );


  }

}
