#include "main.h"


void uinit( void )
{
  UBRRL = (u8)bauddivider;		//set baud rate
  UBRRH = bauddivider >> 8;
  UCSRA = 0;				//no U2X, MPCM
  UCSRC = 1<<URSEL^1<<UCSZ1^1<<UCSZ0;	//8 Bit
  UCSRB = 1<<RXEN^1<<TXEN;		//enable RX, TX
}


void uputchar( u8 c )
{
  while( (UCSRA & 1<<UDRE) == 0 );
  UDR = c;
}


void uputs( u8 *s )
{
  while( *s )
    uputchar( *s++ );
}
