#include <avr/io.h>
#include <avr/interrupt.h>
#include <stdio.h>
#include <stdlib.h>
#include "Enc28j60.h"
#include "Spi.h"
#include "uart.h"
#include "uip.h"
#include "uip_arp.h"
#include "uip_split.h"
#include "uip_TcpAppHub.h"
#include "uip_UdpAppHub.h"

#define UART_BAUD_RATE 9600

int _uart_putc(char c, FILE *file)
{
	uart_putc((unsigned)c);
	return 0;
}

static uint8_t g_nPrescaler = 100;
static volatile struct{
	uint8_t fPeriodic :1;
} g_nFlags = { 0 };

int main(void){
	uip_ipaddr_t IpAddr;

	uart_init(UART_BAUD_SELECT(UART_BAUD_RATE, F_CPU));
	fdevopen(_uart_putc, NULL);
	SpiInit();
	Enc28j60Init();
	uip_arp_init();
	uip_init();
	uip_TcpAppHubInit();
	uip_UdpAppHubInit();
	Enc28j60SetClockPrescaler(2);

	// 10Hz Timer
	TCCR1B = (1<<WGM12)|(3<<CS10);
	OCR1A = 25000; // 16000000 / 64 / 25000 = 10Hz (100ms)
	TIMSK1 |= (1<<OCIE1A);

	//IP
	uip_ipaddr(IpAddr, 192, 168, 0, 100);
	uip_sethostaddr(IpAddr);

	//Router
	uip_ipaddr(IpAddr, 192, 168, 0, 1);
	uip_setdraddr(IpAddr);

	//Subnetzmaske
	uip_ipaddr(IpAddr, 255, 255, 255, 0);
	uip_setnetmask(IpAddr);

	sei();

	//printf("\nCIFS\n");


	while (1){
		if(uart_getc()=='#')
		{
			UdpAppData_t *tmp = (UdpAppData_t*) malloc(sizeof(UdpAppData_t));
			uip_ipaddr(tmp->ip, 192,168,0,255);
			tmp->type = NBT_NAME_QUERY;
			//tmp->data.nbt_name_query.flags = nbt_nsOPCODE_QUERY|nbt_nsRD_BIT|nbt_nsB_BIT;
			tmp->data.nbt_name_query.query_type = 0x20;
			tmp->data.nbt_name_query.suffix = 0x00;
			
			int c;
			uint8_t i=0;
			while((c=uart_getc()) != '#')
				if(!(c & 0xFF00))
					tmp->data.nbt_name_query.name[i++] = (uint8_t) c;
			tmp->data.nbt_name_query.name[i] = '\0';
		}
				
		
		// Netzwerk
		uip_len = Enc28j60Receive(uip_buf);

		if (uip_len > 0){
			if (((struct uip_eth_hdr *)&uip_buf[0])->type == htons(UIP_ETHTYPE_IP)){
				uip_arp_ipin();
				uip_input();

				if (uip_len > 0){
					uip_arp_out();
					uip_split_output();
				}
			}
			else if (((struct uip_eth_hdr *)&uip_buf[0])->type == htons(UIP_ETHTYPE_ARP)){
				uip_arp_arpin();
				if (uip_len > 0)
					uip_split_output();
			}
		}

		if (g_nFlags.fPeriodic){
			cli();
			g_nFlags.fPeriodic = 0;
			sei();

			int i = UIP_CONNS;
			while (i){
				i--;
				uip_periodic(i);
				if (uip_len > 0){
					uip_arp_out();
					uip_split_output();
				}
			}

			i = UIP_UDP_CONNS;
			while (i){
				i--;
				uip_udp_periodic(i);
				if (uip_len > 0){
					uip_arp_out();
					uip_split_output();
				}
			}

			g_nPrescaler--;

			if (g_nPrescaler == 0){
				//Every 10 seconds
				uip_arp_timer();
				g_nPrescaler = 100;
			}
		}
	}

	return 0;
}

ISR(TIMER1_COMPA_vect){
	g_nFlags.fPeriodic = 1;
}

