#ifndef CIFS_COMMON_H
#define CIFS_COMMON_H
/* ========================================================================== **
 *                                cifs_common.h
 *
 * Copyright:
 *  Copyright (C) 2000-2003 by Christopher R. Hertel
 *
 * Email: crh@ubiqx.mn.org
 *
 * $Id: cifs_common.h,v 0.8 2004/05/30 20:45:19 crh Exp $
 *
 * -------------------------------------------------------------------------- **
 *
 * Description:
 *
 *  This is the common header file for the modules that make up the
 *  "Implementing CIFS" library and toolkit.  This file is included
 *  by all modules in the directory tree below it.  It includes all
 *  of the common definitions, types, prototypes, etc. used by the
 *  library.  It is not meant to be included in applications.  Use
 *  the "cifs.h" file instead.
 *
 * -------------------------------------------------------------------------- **
 *
 * License:
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public   
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *  
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of   
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *  
 *  You should have received a copy of the GNU Lesser General Public   
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------- **
 *
 * Notes:
 *
 *  This file is *not* meant for inclusion by applications.  You should
 *  include the "cifs.h" file instead.  This file is the common set for
 *  all of the bits and pieces lower down in the tree.
 *
 * ========================================================================== **
 */

#include "cifs_typedefs.h"  /* Common type declarations.          */
#include "cifs_errors.h"    /* Project-specific error codes.      */
#include "cifs_block.h"     /* CIFS library memory block manager. */


/* ========================================================================== */
#endif /* CIFS_COMMON_H */
