#include "nbt_ns.h"

#include <stdlib.h>

#include "cifs.h"
#include "Names.h"
#include "uip.h"
#include "uip_UdpAppHub.h"

#include "uart.h"

void NBTNSInit()
{
	uip_ipaddr_t dummy_ip;
	struct uip_udp_conn *udp_conn;

	uip_ipaddr(&dummy_ip, 255,255,255,255);
	udp_conn = uip_udp_new(&dummy_ip, HTONS(PORT_NBT_NS));
	uip_udp_bind(udp_conn, HTONS(PORT_NBT_NS));
	
	//if(udp_conn == NULL)
	//	printf("Fehler beim Anlegen der UDP-Verbindung (Port 137)\n");
}

void NBTNSCall(uint8_t* buffer, uint16_t bytes, UdpAppData_t **UdpAppData)
{
	static uint8_t name_trn_id = 0x00;
	
	if(uip_newdata())
	{
		uint8_t *decoded_name_1 = (uint8_t*) malloc(strlen((char*) &(buffer[12]) ));
		uint8_t *decoded_name_2 = (uint8_t*) malloc(nbt_NB_NAME_MAX);
		
		nbt_L2Decode(decoded_name_1, buffer, 12);
		nbt_L1Decode(decoded_name_2, decoded_name_1, 0, 0x20, (unsigned char*)"\0");
		
		uart_puts((char*)decoded_name_2);
		uart_puts(": ");
		itoa(buffer[58],(char*) decoded_name_1, 10);
		uart_puts((char*)decoded_name_1);
		uart_putc('.');
		itoa(buffer[59], (char*)decoded_name_1, 10);
		uart_puts((char*)decoded_name_1);
		uart_putc('.');
		itoa(buffer[60], (char*)decoded_name_1, 10);
		uart_puts((char*)decoded_name_1);
		uart_putc('.');
		itoa(buffer[61], (char*)decoded_name_1, 10);
		uart_puts((char*)decoded_name_1);
		uart_putc('\n');
		
		free(decoded_name_1);
		free(decoded_name_2);
		
	}
	
	uint8_t delete_item;
	UdpAppData_t *current_item = *UdpAppData;
		
	while(current_item != NULL)
	{
		uip_udp_conn->ripaddr = current_item->ip;
		
		delete_item = 1;
		switch(current_item->type)
		{
			case NBT_NAME_QUERY:
				
				uint8_t bytes_count = 0;
	
				nbt_NameRec nbtNameRec;
				nbtNameRec.scope_id = NULL;
				nbtNameRec.namelen = strlen((char*) current_item->data.nbt_name_query.name);
				nbtNameRec.name = current_item->data.nbt_name_query.name;
	
				if(*nbtNameRec.name == '*' && nbtNameRec.namelen == 1)		
					nbtNameRec.pad = 0x00;
				else
					nbtNameRec.pad = 0x20;
	
				nbtNameRec.sfx = current_item->data.nbt_name_query.suffix;
	
				// NBT Header ID
				buffer[0] = 0x00;
				buffer[1] = name_trn_id++;
	
				// Restlicher Header
				bytes_count += nbt_nsSetHdr(&buffer[bytes_count], 34, nbt_nsOPCODE_QUERY|nbt_nsRD_BIT|nbt_nsB_BIT /*current_item->data.nbt_name_query.flags*/, nbt_nsQUERYREC);
	
				// L2-kodierter Name
				bytes_count += nbt_L2Encode(&buffer[bytes_count], &nbtNameRec);
		
				// Query Type
				buffer[bytes_count++] = 0x00;
				buffer[bytes_count++] = current_item->data.nbt_name_query.query_type;
	
				// Query Class: Internet Class
				buffer[bytes_count++] = 0x00;
				buffer[bytes_count++] = 0x01;
	
				uip_udp_send(bytes_count);
			break;
				
			default:
				delete_item = 0;
			break;
		}
			
		if(delete_item)
			*UdpAppData = deleteUdpAppData(*UdpAppData, current_item);
		
		current_item = current_item->next;
	}
}