#ifndef NBT_NS_H
#define NBT_NS_H
/* ========================================================================== **
 *
 *                                  nbt_ns.h
 *
 * Copyright:
 *  Copyright (C) 2001, 2002 by Christopher R. Hertel
 *
 * Email:
 *  crh@ubiqx.mn.org
 *
 * $Id: nbt_ns.h,v 0.6 2003/11/19 07:03:27 crh Exp $
 *
 * -------------------------------------------------------------------------- **
 *
 * Description:
 *  This is the global header file for the NBT Name Service subsystem.
 *  Including this header will include all of the following:
 *    libcifs/NBT/NS/<whatever>.h
 *
 * -------------------------------------------------------------------------- **
 *
 * License:
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public   
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *  
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of   
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *  
 *  You should have received a copy of the GNU Lesser General Public   
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------- **
 *
 * Notes:
 *  The purpose of this file is to offer one-stop shopping.  Simply include
 *  this file and all of the headers for the NBT Name Service subsystem will
 *  be included for you.  There is no run-time penalty for including
 *  everything.
 *
 * ========================================================================== **
 */

#include "Packet.h"
#include "Message.h"
#include "uip_UdpAppHub.h"

#define PORT_NBT_NS 137

void NBTNSInit();
void NBTNSCall(uint8_t* pBuffer, uint16_t nBytes, UdpAppData_t **UdpAppData);

/* ========================================================================== */
#endif /* NBT_NS_H */
