/*
 * See uip_TcpAppHub.c for Explanations
 * 
 * Author: Simon Kueppers
 * Email: simon.kueppers@web.de
 * Homepage: http://klinkerstein.m-faq.de
 * 
 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 
 Copyright 2008 Simon Kueppers
 * */

#include <stdlib.h>
#include "uip_UdpAppHub.h"
#include "uip.h"
#include "nbt_ns.h"

UdpAppData_t *UdpAppData = NULL;



void uip_UdpAppHubCall(void){
	switch(uip_udp_conn->lport){
		case (HTONS(PORT_NBT_NS)):
			NBTNSCall(uip_appdata, uip_datalen(), &UdpAppData);
		break;
	}		
}

void uip_UdpAppHubInit(void){
	NBTNSInit();
}

UdpAppData_t* getUdpAppDataByType(UdpAppData_t *start, enum UdpAppData_e type)
{
	while(start != NULL && start->type != type) 
	{
		start = start->next;
	}

	return start;	
}

UdpAppData_t* addUdpAppData(UdpAppData_t *start, UdpAppData_t *new_element)
{
	if(start != NULL)
	{
		UdpAppData_t *current_element = start;
		
		while(current_element->next != NULL) 
			current_element = current_element->next;
		
		current_element->next = new_element;
		new_element->prev = current_element;
		new_element->next = NULL;
		
		return start;
	}
	else
	{
		new_element->next = NULL;
		new_element->prev = NULL;
		
		return new_element;
	}
}

UdpAppData_t* deleteUdpAppData(UdpAppData_t *start, UdpAppData_t *delete_element)
{
	UdpAppData_t *new_start = start;
	
	if(delete_element != start)
	{
		while(start->next != delete_element && start->next != NULL)
			start = start->next;
		
		if(start->next != NULL)
		{
			start->next = start->next->next;
			start->next->next->prev = start;
			free(start->next);
		}
	}
	else if(start != NULL)
	{
		new_start = delete_element->next;
		free(delete_element);
		new_start->prev = NULL;
	}
	
	return new_start;
}

