#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/signal.h>
#include <avr/wdt.h>
#include "uart.h"
#include "global.h"

#define PUD	0		//Schwacher Pullup/down: ber je 10k an Testanschluss 1-3
#define D1	2		//Testanschluss 1
#define D2	3		//Testanschluss 1
#define D3	4		//Testanschluss 1
#define R1	5		//starker Pullup/down 1: ber 1k an Testanschluss 1
#define R2	6		//starker Pullup/down 2: ber 1k an Testanschluss 2
#define R3	7		//starker Pullup/down 3: ber 1k an Testanschluss 3

#define XTAL_CPU         8000000 
#define UART_BAUD_RATE     19200 

#define DELAY				1000


unsigned char dtest0,dtest1,bdtest0,bdtest1;

unsigned char make_dtest(unsigned char ps);		//Alle Diodenverbindungen testen (6 Mglichkeiten), 3. Pin ist PullUp/Down
unsigned char bitcnt(unsigned char c);			//Bits zhlen die 1 sind

int main(void)
{ unsigned char i,dif;
    uart_init(UART_BAUD_SELECT(UART_BAUD_RATE, XTAL_CPU)); 
	sei();

	for (;;)
	{
	dtest0=make_dtest(0);
	dtest1=make_dtest(1);
	dif=dtest0^dtest1;
	bdtest0=bitcnt(dtest0);
	bdtest1=bitcnt(dtest1);

	if ((dif==0)&&(dtest0==0))
			uart_puts_P("Kein Transistor angeschlossen");

	else if ((bdtest0==1)&&(dif==0))	//Kein Unterschied bei Basisansteuerung, 1 Diode -> Diode
		{uart_puts_P("Diode: ");
		if (dtest0==1)
			uart_puts_P("A: 2, K: 1");
		else if (dtest0==2)
			uart_puts_P("A: 3, K: 1");
		else if (dtest0==4)
			uart_puts_P("A: 1, K: 2");
		else if (dtest0==8)
			uart_puts_P("A: 3, K: 2");
		else if (dtest0==16)
			uart_puts_P("A: 1, K: 3");
		else if (dtest0==32)
			uart_puts_P("A: 2, K: 3");
		}

	else if (bdtest0>bdtest1)			//Mehr Verbindungen mit eingeschaltetem Pulldown ? -> PNP
		{if (bdtest1==1)				//1 Diode -> MOSFET
			uart_puts_P("P Kanal MOSFET ");
		if (bdtest1==2)					//2 Dioden -> Transistor
			uart_puts_P("PNP ");
		if (bdtest1==3)					//3 Dioden -> Transistor mit Diode
			uart_puts_P("PNP mit Diode ");

		if (dif==1)						//Was ndert sich wenn die Basis angesteuert wird ? Darauf lsst sich die Anschlussbelegung ermitteln
			uart_puts_P("E: 2, B: 3, C: 1");
		else if (dif==2)
			uart_puts_P("E: 3, B: 2, C: 1");
		else if (dif==4)
			uart_puts_P("E: 1, B: 3, C: 2");
		else if (dif==8)
			uart_puts_P("E: 3, B: 1, C: 2");
		else if (dif==16)
			uart_puts_P("E: 1, B: 2, C: 3");
		else if (dif==32)
			uart_puts_P("E: 2, B: 1, C: 3");
		}
	else if (bdtest1>bdtest0)			//Mehr Verbindungen mit eingeschaltetem Pullup ? -> NPN
		{if (bdtest0==1)				//1 Diode  -> MOSFET
			uart_puts_P("N Kanal MOSFET ");
		if (bdtest0==2)					//2 Dioden -> Transistor
			uart_puts_P("NPN ");
		if (bdtest0==3)					//3 Dioden -> Transistor mit Diode
			uart_puts_P("NPN mit Diode ");

		if (dif==1)						//Was ndert sich wenn die Basis angesteuert wird ? Darauf lsst sich die Anschlussbelegung ermitteln
			uart_puts_P("E: 1, B: 3, C: 2");
		else if (dif==2)
			uart_puts_P("E: 1, B: 2, C: 3");
		else if (dif==4)
			uart_puts_P("E: 2, B: 3, C: 1");
		else if (dif==8)
			uart_puts_P("E: 2, B: 1, C: 3");
		else if (dif==16)
			uart_puts_P("E: 3, B: 2, C: 1");
		else if (dif==32)
			uart_puts_P("E: 3, B: 1, C: 2");
		}
	else if (bdtest0==bdtest1)			//Keine nderung bei Basisansteuerung, aber mehr als eine Diode
		{uart_puts_P("Doppeldiode ?");
		}

	else								//Und der ganze Rest was sonst noch passieren kann
		{uart_puts_P("Unbekannt");
		}

#ifdef debugout
	uart_putc(' ');		
	uart_putc(' ');		
	uart_putc((dtest0/10)+48);	
	uart_putc((dtest0%10)+48);	
	uart_putc(' ');		
	uart_putc((dtest1/10)+48);	
	uart_putc((dtest1%10)+48);	
#endif
	
	uart_putc('\n');	

	for (i=0; i<50; i++)
		delay (10000);

	}
}

void delay (unsigned int us)		    //Fr 8MHz kalibriert !
{   unsigned int i;
    for (i=0;i<us;i++)
    {         
        asm ("nop");}
}

unsigned char make_dtest(unsigned char ps)
{unsigned char result=0;
	PORTB=0;
	DDRB=0;

	sbi (DDRB, PUD);
	if (ps)
		sbi (PORTB, PUD);
	else
		cbi (PORTB, PUD);

	sbi (DDRB, D1);		//1 GND
	sbi (DDRB, R2);		//2 R +
	sbi (PORTB, R2);
	delay(DELAY);
	if (PINB&(1<<D2)) {}
	else
		result|=1;
	cbi (PORTB, R2);
	cbi (DDRB, R2);

	sbi (PORTB, R3);	//3 R +
	sbi (DDRB, R3);
	delay(DELAY);
	if (PINB&(1<<D3)) {}
	else
		result|=2;
	cbi (DDRB, D1);
	cbi (PORTB, R3);
	cbi (DDRB, R3);

	sbi (DDRB, D2);		//2 GND
	sbi (PORTB, R1);	//1 R +
	sbi (DDRB, R1);
	delay(DELAY);
	if (PINB&(1<<D1)) {}
	else
		result|=4;
	cbi (PORTB, R1);
	cbi (DDRB, R1);

	sbi (PORTB, R3);	//3 R +
	sbi (DDRB, R3);
	delay(DELAY);
	if (PINB&(1<<D3)) {}
	else
		result|=8;
	cbi (PORTB, R3);
	cbi (DDRB, R3);
	cbi (DDRB, D2);

	sbi (DDRB, D3);		//3 GND
	sbi (PORTB, R1);	//1 R +
	sbi (DDRB, R1);
	delay(DELAY);
	if (PINB&(1<<D1)) {}
	else
		result|=16;
	cbi (PORTB, R1);
	cbi (DDRB, R1);

	sbi (PORTB, R2);	//2 R+
	sbi (DDRB, R2);
	delay(DELAY);
	if (PINB&(1<<D2)) {}
	else
		result|=32;
	cbi (PORTB, R2);
	cbi (DDRB, R2);
	cbi (DDRB, D3);

return result;
}

unsigned char bitcnt(unsigned char c)
{unsigned char i, result=0;
	for (i=0; i<8; i++)
		{if (c&(1<<i))
			result++;}
	return result;
}