

; by Clemens Helfmeier,
; ClemensHelfmeier (at) gmx (dot) de
; very simple jtag implementation
; this is a very light wheight jtag implementation
; it doesn't check if the controller is in the correct state

; the jtag speed:
.equ	jtag_Delay_us		= 1

; registers to use:
; all definitions between horizontal lines can be the same registers
; ------
.def	jtag_rClockCounter	= r25		; a different register than jtag_rCounter also for counting with ldi support.
; ------
.def	jtag_rCounter		= rArg0		; some register to count with (ldi supported!)
.def	jtag_rArgument		= rArg0		; this is the register where arguments are passed to the jtag functions
; ------
.def	jtag_rTemp0		= rTemp0	; this is needed by jtag_shift_reg
; ------
.def	jtag_rTemp1		= rTemp1	; this is needed by jtag_shift_reg
; ------

#define jtag_rSrcPointer	x
#define jtag_rDestPointer	y


; io definitinons ...
.equ	jtag_bitTMS	= PC3
.equ	jtag_bitTCK	= PC2
.equ	jtag_bitTDI	= PC5
.equ	jtag_bitTDO	= PC4
; this is a bit tricky: the jtag_bitTDI pin is the "input" into the programmer. Thus connected to the 
; targets chain's last TDO line. Same with jtag_bitTDO, which is connected to the targets chain's first
; TDI line. (This is as if the Programmer would be an elemnt of the chain.

.equ	jtag_portTMS	= PORTC
.equ	jtag_portTCK	= PORTC
.equ	jtag_portTDO	= PORTC
.equ	jtag_portTDI	= PORTC

.equ	jtag_dirTDI	= jtag_portTDI-1
.equ	jtag_pinTDI	= jtag_portTDI-2
.equ	jtag_dirTDO	= jtag_portTDO-1
.equ	jtag_pinTDO	= jtag_portTDO-2
.equ	jtag_dirTMS	= jtag_portTMS-1
.equ	jtag_pinTMS	= jtag_portTMS-2
.equ	jtag_dirTCK	= jtag_portTCK-1
.equ	jtag_pinTCK	= jtag_portTCK-2

#include "jtag_macros.asm"

; currently needs 140 bytes which is 70 words

jtag_Init:
	;initialize the port
	; everything zero
	cbi jtag_portTDI, jtag_bitTDI
	cbi jtag_portTDO, jtag_bitTDO
	sbi jtag_portTMS, jtag_bitTMS		; TMS high puts devices into TEST-LOGIC-RESET
	cbi jtag_portTCK, jtag_bitTCK
	; correct direction
	cbi jtag_dirTDI, jtag_bitTDI
	sbi jtag_dirTDO, jtag_bitTDO
	sbi jtag_dirTMS, jtag_bitTMS
	sbi jtag_dirTCK, jtag_bitTCK
	; put the chain into TEST-LOGIC/RESET state
	rjmp jtag_ResetChain
	

	
; --- jtag_toTLR ---
; puts the target in TEST-LOGIC/RESET state
; needs rCounter
jtag_ResetChain:
jtag_toTLR:
	; at least five TCK clocks with TMS high
	jtag_setTMS
	ldi jtag_rCounter, 5
jtag_ResetChain_a:
		jtag_clock
		dec jtag_rCounter
		brne jtag_ResetChain_a
	; now every chip in the chain is in TEST-LOGIC-RESET
	; and the IR is either BYPASS or IDCODE
	ret
	
; --- jtag_toCapIR ---
; this function puts the target in CAPTURE-IR state
; target _must_ be in RTI, UDR or UIR state
jtag_RTItoCapIR:
	jtag_setTMS
	jtag_clock			; now in Select DR
	jtag_clock			; now in SELECT-IR

	jtag_clearTMS
	jtag_clock			; now in CAPTURE-IR
	ret
	
; --- jtag_toCapDR ---
; this function puts the target in CAPTURE-DR state
; target _must_ be in RTI, UDR or UIR state
jtag_RTItoCapDR:
	jtag_setTMS
	jtag_clock			; now in Select DR
	
	jtag_clearTMS
	jtag_clock			; now in CAPTURE-DR
	ret


; --- jtag_toEx1R ---
; this places the target in either EXIT1-DR or EXIT1-IR depending
; on the state the target is at before the call
; the target _must_ be in CapR or in ShR
jtag_CaptoEx1R:
; --- jtag_Ex1toUR
; goes from Exit1 to Update Register
; same as CaptoEx1R
jtag_Ex1RtoUR:
	jtag_setTMS
	jtag_clock			; now in EXIT1-D/IR
	ret

; --- jtag_toPsIR ---
; this places the target in PAUSE-IR state
; the target _must_ be in Exit1R before the call
jtag_Ex1toPsR:
; --- jtag_toRTI ---
; puts the target in RUN-TEST/IDLE state
; target _must_ be in TLR, UDR or UIR
jtag_TLRtoRTI:
jtag_URtoRTI:
	; both functions have the same opcode :)
	jtag_clearTMS
	jtag_clock				; now in PAUSE-I/DR
	ret
		
	
; ; --- jtag_toUR ---
; ; places the target in the UPDATE-IR or UPDATE-DR state depending on the
; ; state before the call.
; ; the target _must_ be in PausR or ShiftR before the call
; jtag_PstoUR:
; 	jtag_setTMS			; from everywhere the TMS line must be set :)
; 	
; 	jtag_clock			; now in either Ex1R or Ex2R
; 	jtag_clock			; now in UR
; 	ret
; 	

; --- jtag_shift_reg ---
; this shifts data in/out of the selected register (IR or DR)
; needs jtag_rTemp0, jtag_rTemp1
; number of bits in jtag_rArgument
; jtag_rSrcPointer is the data which should be send
; jtag_rDestPointer points to the destination of read data (these could be the same)
;
; the controller state _must_ be either CAPTURE-DR, CAPTURE-IR,
; SHIFT-DR or SHIFT-IR otherwise the function will fail.
; after the routine finished, the controller state is SHIFT-DR or SHIFT-IR
jtag_shift_reg:	
	jtag_clearTMS				; stay in Shift-D/IR state
	
	inc jtag_rArgument
jtag_shift_reg_c:	
	ldi jtag_rTemp0, 0x80			; place stop bit in input register
	ld jtag_rTemp1, jtag_rSrcPointer+	; load the value to be shifted into D/IR
jtag_shift_reg_a:
		dec jtag_rArgument
		breq jtag_shift_reg_finished	; if all bits read -> exit
	
		jtag_clock			; perform clock (take new data and shift out old data)
		
		lsr jtag_rTemp1
		jtag_Carry2TDO			; put data on output
		
		jtag_TDI2Carry
		ror jtag_rTemp0			; read one bit and shift it into register
		
	brcc jtag_shift_reg_a			; if not last bit for this byte read, continue
	
	st jtag_rDestPointer+, jtag_rTemp0	; store the read byte
	rjmp jtag_shift_reg_c			; load the stop bit again
	
jtag_shift_reg_finished:
	cpi jtag_rTemp0, 0x80
	breq jtag_shift_reg_b
		st jtag_rDestPointer+, rTemp0	; store if not yet stored	
jtag_shift_reg_b:

	; leave controller in shift state
	; it is easy to send more bits by calling shift_reg again then
	ret
