



; JTAG code by Clemens Helfmeier, CLemensHelfmeier (at) gmx (dot) de
; please report bugs!
; use it as is, NO WARRANTY AT ALL!

; Jtag macros


; hp_delay slows down jtag communication
.macro jtag_hp_delay
	ldi jtag_rClockCounter, (((F_CPU * jtag_Delay_us) / 1000000) / 2) / 3
jtag_hp_delay_a:
	dec jtag_rClockCounter
	brne jtag_hp_delay_a	
.endm	

.macro jtag_qp_delay
	ldi jtag_rClockCounter, (((F_CPU * jtag_Delay_us) / 1000000) / 4) / 3
jtag_qp_delay_a:
	dec jtag_rClockCounter
	brne jtag_qp_delay_a	
.endm	


.macro jtag_Carry2TDO
	jtag_clearTDO
	brcc jtag_Carry2TDO_a
		jtag_setTDO
jtag_Carry2TDO_a:
.endm

.macro jtag_TDI2Carry
	; this sets the carry flag
	clc
	sbic jtag_pinTDI, jtag_bitTDI
		sec
.endm

; common macros for setting/resetting the io lines
.macro jtag_setTMS
	sbi jtag_portTMS, jtag_bitTMS
.endm
.macro jtag_setTCK
	sbi jtag_portTCK, jtag_bitTCK
.endm
.macro jtag_setTDO
	sbi jtag_portTDO, jtag_bitTDO
.endm
.macro jtag_clearTMS
	cbi jtag_portTMS, jtag_bitTMS
.endm
.macro jtag_clearTCK
	cbi jtag_portTCK, jtag_bitTCK
.endm
.macro jtag_clearTDO
	cbi jtag_portTDO, jtag_bitTDO
.endm

; this is the clock macro
; since it is slowed down by the delay loop, it is not needed, to
; put the code everywhere ;)
.macro jtag_clock
	rcall jtag_clockFunction
.endm
jtag_clockFunction:
	jtag_qp_delay
	sbi jtag_portTCK, jtag_bitTCK
	jtag_hp_delay
	cbi jtag_portTCK, jtag_bitTCK
	jtag_qp_delay
	ret
