
; Macros
; by Clemens Helfmeier
; ClemensHelfmeier (at) gmx (dot) de
;
; supports some debug methods

SendArg0:
	push rArg0
	rcall Bin2BCH8
	push rArg0
	mov rArg0, rArg1
	rcall uart_putc
	pop rArg0
	rcall uart_putc
	pop rArg0
	ret

Bin2BCH8:
	mov rArg1, rArg0
	swap rArg1
	andi rArg1, 0x0F
	andi rArg0, 0x0F
	cpi rArg0, 10
	brlo NormalNumber1
		subi rArg0, -'A'+'0'+10
NormalNumber1:
	subi rArg0, -'0'
	cpi rArg1, 10
	brlo NormalNumber2
		subi rArg1, -'A'+'0'+10
NormalNumber2:
	subi rArg1, -'0'
	ret


.macro Bin2BCH8M
	mov @1, @0
	swap @1
	andi @1, 0x0F
	andi @0, 0x0F
	cpi @0, 10
	brlo NormalNumber1M
		subi @0, -'A'+'0'+10
NormalNumber1M:
	subi @0, -'0'
	cpi @1, 10
	brlo NormalNumber2M
		subi @1, -'A'+'0'+10
NormalNumber2M:
	subi @1, -'0'
.endm



.macro dbgMemDump
	; this is no call!
	ldi zl, 0x00
	ldi zh, 0x00
	ldi rArg2, RAMEND/0x30+1
dbgMemDump_b:
		mov rArg0, zh
		dbgSendReg
		mov rArg0, zl
		dbgSendReg
		dbgSendChar ' '
		dbgSendChar ':'
		ldi rTemp1, 3
dbgMemDump_d:
			dbgSendChar ' '
			ldi rArg1, 0x10
			dbgMemDump_a
			dec rTemp1
		brne dbgMemDump_d
		
		dbgSendChar '\n'
		dec rArg2
		breq dbgMemDump_c
	rjmp dbgMemDump_b
dbgMemDump_c:
.endm
	

.macro dbgSendReg
	Bin2BCH8M rArg0, rTemp0
	dbgSendPureReg rTemp0
	dbgSendPureReg rArg0
.endm
.macro dbgSendChar
	push rArg0
	ldi rArg0, @0
	dbgSendPureReg rArg0
	pop rArg0
.endm
.macro dbgSendPureReg
dbgSendPureRega:
	sbis UCSRA, UDRE
		rjmp dbgSendPureRega
	out UDR, @0
.endm


.macro dbgMemDump_a
dbgMemDump_a_a:
		ld rArg0, z+
		dbgSendReg
		dec rArg1
	brne dbgMemDump_a_a
.endm
	

#endif