.include "m32def.inc"

; This file was written by Clemens Helfmeier
; if you find any bugs or errors, please let me know at:
; ClemensHelfmeier (at) gmx (dot) de
;

; only a very general main program for mega32
; calls mysvf2

;#define DEBUG
#define UART_PUFFER
;#define UART_REPORT_ERRORS
#define RESET
#define SLEEP
; after each shift instruction goto RTI (don't stay in UpdateRegister)
#define ENDSTATE_RTI


.equ	F_CPU		= 16000000
.equ	F_BAUD		= 115200

#define	rArg0		r16
#define rArg1		r17
#define	rArg2		r18
#define	rTemp0		r19
#define	rTemp1		r20
#define	rTemp2		r21


; include the ram definitions
#include "main.ram"

; -----
; flow control for ringpuffer and uart (input)

.cseg
.org 0x0000
	rjmp Main
.org INT0addr
	reti
.org INT1addr
	reti
.org INT2addr
	reti
.org OC2addr
	reti
.org OVF2addr
	reti
.org ICP1addr
	reti
.org OC1Aaddr
	reti
.org OC1Baddr
	reti
.org OVF1addr
	reti
.org OC0addr
	reti
.org OVF0addr
	reti
.org SPIaddr
	reti
.org URXCaddr
	#ifdef UART_PUFFER
		rjmp URXCInt
	#else
		reti
	#endif
.org UDREaddr
	reti
.org UTXCaddr
	reti
.org ADCCaddr
	reti
.org ERDYaddr
	reti
.org ACIaddr
	reti
.org TWSIaddr
	reti
.org SPMRaddr
	reti


.macro rp_BufferOverrun
	ldi rArg0, mysvf2_vBufferOverrun
	rcall uart_putc
.endm
.macro rp_BufferFilling
.endm

#include "macros.asm"
#include "uart.asm"
#include "jtag.asm"
#include "mysvf2.asm"

Main:
	#ifdef DEBUG
		dbgMemDump
	#endif
	
	ldi rArg0, low(RAMEND)
	out SPL, rArg0
	ldi rArg0, high(RAMEND)
	out SPH, rArg0

	rcall jtag_init
	rcall uart_init


	sei

	
	rcall mysvf2

	___mysvf2_Report xxx

forEver:
	rjmp forEver





xxx:
.db "the program has ended.", 0