

; decoding of mySVF format version 2
; by Clemens Helfmeier
; 10.9.2005


; the following codes are recognized:
; CODE
; 0xAA		Reset		executes a software reset
; 0xAE		Esc		escape any reserved charater with this one
;
; 0x01		TIR
; 0x02		HIR
; 0x03		TDR
; 0x04		HDR
;
; 0x05		ENDIR
; 0x06		ENDDR
;
; 0x07		RUNTEST
;
; 0x08		SIR
; 0x09		SDR
;
; 0x0A		STATE
;
; 0xFE		COMMENT
;
;

#define RESET


#include "mysvf2.def"
		; include the ram address definitions
#include "mysvf2.inc"
		; include the macros and special function
#include "mysvf2_instructions.asm"


mysvf2:
	mysvf2_Init		; initialize engine
	
mysvf2_loop:
	
	ldi rArg0, mysvf2_vReady
	mysvf2_Writebyte
	
	mysvf2_Readbyte		; read one command byte
	
	; test for commands

	; Shift instruction
	mysvf2_Cpi rArg0, mysvf2_vSDR, rcall mysvf2_Shift_DRFunction
	mysvf2_Cpi rArg0, mysvf2_vSIR, rcall mysvf2_Shift_IRFunction

	; Runtest instruction
	mysvf2_Cpi rArg0, mysvf2_vRUNTEST, rcall mysvf2_RUNTESTFunction

	; State instruction
	mysvf2_Cpi rArg0, mysvf2_vTLR, rcall mysvf2_TLRFunction

	; Comment instruction
	mysvf2_Cpi rArg0, mysvf2_vCOMMENT, rcall mysvf2_COMMENTFunction

	rcall mysvf2_UnknownCommandFunction

	rjmp mysvf2_loop
	
	

	
