

;mysvf2 
; by Clemens Helfmeier,
; ClemensHelfmeier (at) gmx (dot) de
;
; includes for mysvf2
;
;

; ---- MACROS ----
.macro ___mysvf2_Report
#ifdef DEBUG
	ldi zl, low( @0<<1 )
	ldi zh, high( @0<<1 )
	rcall ___mysvf2_WriteString
#endif
.endm

; -------
; cpi
.macro mysvf2_cpi
	cpi @0, @1
	brne mysvf2_cpi_a
		@2
		rjmp mysvf2_loop
mysvf2_cpi_a:
.endm

; --------
; Readbyte
.macro mysvf2_Readbyte
	rcall mysvf2_ReadbyteFunction
.endm

; ---------
; Writebyte
.macro mysvf2_Writebyte
	rcall mysvf2_WritebyteFunction
.endm

; ----
; Init
.macro mysvf2_Init
	mysvf2_ldi16 xl, xh, mysvf2_RamBase
	ldi rArg0, mysvf2_RamLength
	clr rTemp0
mysvf2_init_a:
	st x+, rTemp0
	dec rArg0
	brne mysvf2_init_a

	ldi rArg0, mysvf2_vRESET
	mysvf2_Writebyte
	mysvf2_Writebyte
.endm

; ------
; subi16
.macro mysvf2_subi16
	subi @0, low(@2)
	sbci @1, high(@2)
.endm
.macro mysvf2_ldi16
	ldi @0, low(@2)
	ldi @1, high(@2)
.endm

; ---- Functions -----

mysvf2_WritebyteFunction:
#ifdef RESET
	cpi rArg0, mysvf2_vRESET
	brne mysvf2_WritebyteFunction_a
		push rArg0
		ldi rArg0, mysvf2_vESC
		rcall uart_putc
		pop rArg0
mysvf2_WritebyteFunction_a:
#endif
	rjmp uart_putc

mysvf2_ReadbyteFunction:
	; read one byte from uart and test for escape character
	rcall uart_getc
#ifdef RESET
	cpi rArg0, mysvf2_vRESET
	brne mysvf2_ReadbyteFunction_noReset
		cli
		___mysvf2_Report swreset
		jmp Main		; perform a reset
mysvf2_ReadbyteFunction_noReset:
	cpi rArg0, mysvf2_vESC
	brne mysvf2_ReadbyteFunction_exit
		rcall uart_getc
mysvf2_ReadbyteFunction_exit:
#endif
	ret
	

#ifdef DEBUG

___mysvf2_WriteString:
	lpm rArg0, z+
	mysvf2_WriteByte
	cpi rArg0, mysvf2_vTERMINATOR
	brne ___mysvf2_WriteString
	ret

runtest:
.db mysvf2_vCOMMENT, "runtest", mysvf2_vTERMINATOR
tlr:
.db mysvf2_vCOMMENT, "tlr", mysvf2_vTERMINATOR
comment:
.db mysvf2_vCOMMENT, "comment", mysvf2_vTERMINATOR
ir:
.db mysvf2_vCOMMENT, "shiftir", mysvf2_vTERMINATOR
dr:
.db mysvf2_vCOMMENT, "shiftdr", mysvf2_vTERMINATOR
swreset:
.db mysvf2_vCOMMENT, "swreset", mysvf2_vTERMINATOR
runtestend:
.db mysvf2_vCOMMENT, "runtest ed", mysvf2_vTERMINATOR
unknownCommand:
.db mysvf2_vCOMMENT, "unknown command", mysvf2_vTERMINATOR
#endif