

;mysvf2 instruction
; by Clemens Helfmeier,
; ClemensHelfmeier (at) gmx (dot) de
;

; every mysvf2 command _must_ leave the controller in one of the following states:
; TLR, RTI, UDR, UIR


.macro mysvf2_Shift
mysvf2_Shift_a:
	mysvf2_ldi16 xl, xh, @0				; load src pointer
	mysvf2_ldi16 yl, yh, mysvf2_Out			; load dest pointer
	lds rArg0, @0 + mysvf2_LengthOffset		; load the length
	rcall jtag_shift_reg				; shift the data
	rcall jtag_CaptoEx1R
	rcall jtag_Ex1RtoUR				; goto update register
	#ifdef ENDSTATE_RTI
		rcall jtag_URtoRTI			; if the end-state should be RTI do this here.
	#endif
	lds rTemp0, @0 + mysvf2_ActionOffset		; if action specified
	sez
	sbrs rTemp0, mysvf2_bActionCompare		; copmare if needed
		rjmp mysvf2_Shift_exit
		lds rArg1, @0 + mysvf2_LengthOffset		; load the length again
		mysvf2_CompareData @0				; and compare
		breq mysvf2_Shift_exit				; ok
mysvf2_Shift_exit:
.endm

.macro mysvf2_ReadShiftInstruction
	mysvf2_ldi16 yl, yh, @0
	rcall mysvf2_ReadShiftInstructionFunction
.endm
.macro mysvf2_ReadShiftInstructionA
	push yl
	push yh
	ldd rTemp1, y+mysvf2_LengthOffset
	mysvf2_subi16 yl, yh, -(@0)
	rcall mysvf2_ReadShiftInstructionFunctionA
	pop yh
	pop yl
.endm

mysvf2_ReadShiftInstructionFunction:
	mysvf2_Readbyte
	std y+mysvf2_LengthOffset, rArg0		; store the number of bits to handle
	#ifdef DEBUG
		rcall SendArg0
	#endif
		
	mysvf2_Readbyte
	std y+mysvf2_ActionOffset, rArg0		; store the action flags
	#ifdef DEBUG
		rcall SendArg0
	#endif
	
	ldd rArg1, y+mysvf2_ActionOffset
	sbrs rArg1, mysvf2_bReadInput				; if action flag is set ...
		rjmp mysvf2_ReadShiftInstructionFunction_a
		mysvf2_ReadShiftInstructionA mysvf2_TDIOffset
mysvf2_ReadShiftInstructionFunction_a:

	ldd rArg1, y+mysvf2_ActionOffset
	sbrs rArg1, mysvf2_bReadOutput
		rjmp mysvf2_ReadShiftInstructionFunction_b
		mysvf2_ReadShiftInstructionA mysvf2_TDOOffset
mysvf2_ReadShiftInstructionFunction_b:
	
	ldd rArg1, y+mysvf2_ActionOffset
	sbrs rArg1, mysvf2_bReadMask
		rjmp mysvf2_ReadShiftInstructionFunction_c
		mysvf2_ReadShiftInstructionA mysvf2_MASKOffset
mysvf2_ReadShiftInstructionFunction_c:
	#ifdef DEBUG
		dbgSendChar '@'
	#endif
	ret

mysvf2_ReadShiftInstructionFunctionA:
	; read rTemp1 bits... to y+
	#ifdef DEBUG
		mov rArg0, rArg1
		rcall SendArg0
	#endif
	cpi rTemp1, 0x00
	breq mysvf2_ReadShiftInstructionFunctionA_exit
mysvf2_ReadShiftInstructionFunctionA_a:
		mysvf2_Readbyte
		st y+, rArg0
		#ifdef DEBUG
			rcall SendArg0
		#endif
		subi rTemp1, 8		; 8 bits read
		breq mysvf2_ReadShiftInstructionFunctionA_exit
		brcc mysvf2_ReadShiftInstructionFunctionA_a
mysvf2_ReadShiftInstructionFunctionA_exit:
	#ifdef DEBUG
		ldi rArg0, ''
		rcall uart_putc
	#endif
	ret

.macro mysvf2_CompareData
	; compares the data in y
	mysvf2_ldi16 yl, yh, @0 + mysvf2_TDOOffset
	rcall mysvf2_CompareDataFunction
.endm
mysvf2_CompareDataFunction:
	; length in rArg1 (in bits)
	; set the zero flag if equal
	mysvf2_ldi16 xl, xh, mysvf2_Out
mysvf2_CompareDataFunction_a:
		ldd rArg0, y+mysvf2_regLength
		ld rTemp0, y+
		ld rTemp1, x+				; read and go on
			
		and rTemp0, rArg0
		and rTemp1, rArg0			; mask
		cp rTemp0, rTemp1
		brne mysvf2_CompareDataFunction_err	; on error goto away
		
		subi rArg1, 8				; we handled 8 bit
		breq mysvf2_CompareDataFunction_equals	; if no error yet -> equal
		brcc mysvf2_CompareDataFunction_a	; repeat until all bits handled

mysvf2_CompareDataFunction_equals:
		sez
		ret
mysvf2_CompareDataFunction_err:
mov rArg0, rTemp0
rcall SendArg0
mov rArg0, rTemp1
rcall SendArg0
		clz
		ret

; -------- The Handling of the instructions follows here: ---------------
		
mysvf2_UnknownCommandFunction:
	rcall SendArg0
	___mysvf2_Report unknownCommand
	ldi rArg0, mysvf2_vUnknownInstruction
	mysvf2_Writebyte
	ret
	
mysvf2_RUNTESTFunction:
	; read two bytes (number of clocks to perform)
	mysvf2_Readbyte
	mov rArg1, rArg0
	mysvf2_Readbyte
	mov rArg2, rArg0
___mysvf2_Report runtest
mysvf2_RUNTEST_a:
		;rcall jtag_TLRtoRTI		; perform clock
mysvf2_RUNTEST_b:
		rcall jtag_TLRtoRTI
		mysvf2_subi16 rArg1, rArg2, 1
		brne mysvf2_RUNTEST_a
___mysvf2_Report runtestend
	ret

mysvf2_TLRFunction:
___mysvf2_Report tlr
	; this resets the device
	rcall jtag_toTLR
	rcall jtag_TLRtoRTI
	ret


mysvf2_Shift_DRFunction:
	mysvf2_ReadShiftInstruction mysvf2_DR		; read from input
___mysvf2_Report dr
	ldi rArg2, 8
mysvf2_Shift_DR_a:
	rcall jtag_RTItoCapDR				; goto capture register
	mysvf2_Shift mysvf2_DR
	breq mysvf2_Shift_DR_b
		ldi rArg0, mysvf2_vCompareMismatch_DR
		mysvf2_Writebyte
		dec rArg2
		brne mysvf2_Shift_DR_a			; try again if not often enough yet
		; if no ok after the retrys, report
		ldi rArg0, mysvf2_vCompareFailed_DR
		mysvf2_Writebyte			; send error and return
mysvf2_Shift_DR_b:
	ret

mysvf2_Shift_IRFunction:
	mysvf2_ReadShiftInstruction mysvf2_IR		; read from input
___mysvf2_Report ir
	ldi rArg2, 8
mysvf2_Shift_IR_a:
	rcall jtag_RTItoCapIR				; goto capture register
	mysvf2_Shift mysvf2_IR
	breq mysvf2_Shift_IR_b
		ldi rArg0, mysvf2_vCompareMismatch_IR
		mysvf2_Writebyte
		dec rArg2
		brne mysvf2_Shift_IR_a			; try again if not often enough yet
		; if no ok after the retrys, report
		ldi rArg0, mysvf2_vCompareFailed_IR
		mysvf2_Writebyte			; send error and return
mysvf2_Shift_IR_b:
	ret

mysvf2_COMMENTFunction:
	; echo bytes until 0 recieved...
mysvf2_COMMENT_a:
		mysvf2_Readbyte
		cpi rArg0, mysvf2_vTERMINATOR
		breq mysvf2_COMMENT_exit
		mysvf2_Writebyte
	rjmp mysvf2_COMMENT_a
mysvf2_COMMENT_exit:
;___mysvf2_Report comment
	ret
