
; Uart routines for AVRs
; by Clemens Helfmeier,
; ClemensHelfmeier (at) gmx (dot) de
;
; This is a very simple read and write procedure for the uart
; totally written in assembler :)
; the data is piped through an input buffer (rp_Put & rp_Get)
; outputdata is not buffered

#ifdef UART_PUFFER
	#include "ringpuffer.asm"
#endif

.macro uart_putXOFF
	sbi PORTD, PD2
.endm
.macro uart_putXON
	cbi PORTD, PD2
.endm
	

; this initializes the output stream / input stream
uart_init:
	;initialize baud-rate-register
	ldi rArg0, low(F_CPU/(8*F_BAUD) -1)
	out UBRRL, rArg0
	ldi rArg0, high(F_CPU/(8*F_BAUD) -1) & ~(1<<URSEL)
	out UBRRH, rArg0
	
	;initialize the interrupts
	ldi rArg0, (1<<U2X)
	out UCSRA, rArg0
	#ifdef UART_PUFFER
		ldi rArg0, (1<<RXCIE) | (1<<RXEN) | (1<<TXEN)
	#else
		ldi rArg0, (0<<RXCIE) | (1<<RXEN) | (1<<TXEN)
	#endif
	out UCSRB, rArg0
	ldi rArg0, (1<<URSEL) | (1<<UCSZ1) | (1<<UCSZ0) | (0<<UPM1) | (0<<UPM0)	; 8 bit, 1 stop bit, no parity
	out UCSRC, rArg0
	
	;initialize the output&input pins...
	sbi DDRD, PD1
	cbi DDRD, PD0
	sbi DDRD, PD2
	cbi PORTD, PD2

	#ifdef UART_PUFFER
		rp_init ram_rp_uart_in, uart_putXON
		sei
	#endif
	ret

#ifdef UART_PUFFER
URXCInt:
	push rArg0
	in rArg0, SREG
	push rArg0
	push rTemp0

	in rArg0, UDR
	rp_Put ram_rp_uart_in, ram_rp_uart_in_length, uart_putXOFF

	pop rTemp0
	pop rArg0
	out SREG, rArg0
	pop rArg0
	reti
#endif

uart_getc:
	; read one byte from the uart puffer
	; uses rArg0, rTemp0
	; returnvalue in rArg0
	#ifdef UART_PUFFER
		rp_Get ram_rp_uart_in, ram_rp_uart_in_length, uart_putXON
	#else
		sbis UCSRA, RXC
			rjmp uart_getc
		
		in rTemp0, UCSRA
		in rArg0, UDR

		#ifdef UART_REPORT_ERROR
			push rArg0
			sbrc rTemp0, FE
				rcall hFE
			sbrc rTemp0, PE
				rcall hPE
			sbrc rTemp0, DOR
				rcall hDOR
			pop rArg0
		#endif
	#endif
	ret

	#ifndef UART_PUFFER
	#ifdef UART_REPORT_ERRORS
	; report an error if happend
hFE:
	ldi rArg0, 'W'
	rcall uart_putc
	ret
hPE:
	ldi rArg0, 'Z'
	rcall uart_putc
	ret
hDOR:
	ldi rArg0, 'T'
	rcall uart_putc
	ret
	#endif
	#endif
	
uart_putc:
	; puts the argument on rArg0
	sbis UCSRA, UDRE
		rjmp uart_putc
	out UDR, rArg0
	ret

