#define XTAL F_CPU

/*
 Copyright:      Hagen Reddmann  mailto HaReddmann at T-Online dot de
 Author:         Hagen Reddmann
 Remarks:        this Copyright must be included
 known Problems: none
 Version:        1.0. 2004
 Description:    I2C Routines, I2C EEPROM Routines
                 use hardware TWI with polling
 Resources:       56 bytes code for TWI
                 164 bytes code for I2C EEPROM without sanity, 176 with sanity checks on
*/

#include <avr/io.h>
#include <compat/twi.h>

#ifndef     i2c_H
#define     i2c_H

#ifdef      XTAL
  #define   TWI_TWBR(baudrate)  (uint8_t)(((XTAL + baudrate -1) / baudrate - 15.0) / 2.0)
#else
  #define   TWI_TWBR(baudrate)  (uint8_t)(((16000000 + baudrate -1) / baudrate - 15.0) / 2.0)
#endif

#define     i2cInit(baudrate)   {TWBR = TWI_TWBR(baudrate);}


// follow functions retuns always i2cStatus() == TWSR == TWI Status register
extern uint8_t i2cStart(void);
extern uint8_t i2cStop(void);    // deactivate TWI !!
extern uint8_t i2cStatus(void);  // returns TWSR status register
extern uint8_t i2cWait(void);    // same as i2cStatus() but wait for current action ready
extern uint8_t i2cWrite(uint8_t Value);
// resceive a byte, returns resceived Byte, transmit acknowledge dependend of Ack
extern uint8_t i2cRead(uint8_t Ack);

// select EEPROM with hardware address Device, setup memory address to Address, and if Wait != 0 waits eventually for prior
// written bytes to finish. returns != 0 if all operations success, otherwise returns 0.
extern uint8_t i2cMemSelect(uint8_t Device, uint16_t Address, uint8_t Wait);
// write from Source, Count bytes to memory location at Address on EEPROM Device. If FlashStored != 0 Source points to
// programmemory. Returns count of succesfully bytes written.
extern uint16_t i2cMemWrite(uint8_t Device, uint16_t Address, const uint8_t *Source, uint16_t Count, uint8_t FlashStored);
// read from EEPROM Device at memory location Address Count bytes to Dest. Returns count of successfully bytes read.
extern uint16_t i2cMemRead(uint8_t Device, uint16_t Address, const uint8_t *Dest, uint16_t Count);

#endif

