#include "key.h"

uint8_t keyvar[KEYS];
uint8_t key[KEYS];
volatile uint8_t key_update_req;
volatile uint8_t soft_prescaler = SOFTPRESCALER;
uint8_t keychanged;
volatile uint16_t timer;

void key_init(void)
{
    PORTB |= 0b00111100;   
    
    // Timer 0 konfigurieren
    TCCR0 = (1<<CS01);// Prescaler 8
    
    // Overflow Interrupt erlauben
    TIMSK |= (1<<TOIE0);

}

void update(uint8_t i, uint8_t i2, uint8_t value)
{
    if((value == 0) == ((keyvar[i] & STATE) == 0))
    {
        if((++keyvar[i] & MASK) == (STATE - 1))
        {
            keychanged |= i2;
            keyvar[i] &= CLEAR;
            if(((key[i] & KEYSTATE) ^ (keyvar[i] & STATE)) == 0)
                key[i] |= KEYREPEAT;
            else
                key[i] = keyvar[i] & STATE;  
        }
    }
    else
        keyvar[i] = (keyvar[i] ^ STATE) & CLEAR;
}

void key_update(void)
{
    keychanged = 0;
    update(3, (1 << 3), PINB & (1 << PB2)); 
    update(2, (1 << 2), PINB & (1 << PB3)); 
    update(1, (1 << 1), PINB & (1 << PB4)); 
    update(0, (1 << 0), PINB & (1 << PB5)); 
    key_update_req = 0;
}

ISR (TIMER0_OVF_vect)
{
    if(--soft_prescaler == 0)
    {
        soft_prescaler = SOFTPRESCALER;
        key_update_req = 1;
    }
    ++timer;
}
