#ifndef KEY
#define KEY

#include "settings.h"

#define SOFTPRESCALER 1
#define KEYS 4
#define STATE 128
#define CLEAR (STATE)
#define MASK (~CLEAR)

#define KEYSTATE STATE
#define KEYREPEAT 64

#define nOK 1
#define nADD 0
#define nSUB 2
#define nBACK 3
#define OK key[nOK]
#define ADD key[nADD]
#define SUB key[nSUB]
#define BACK key[nBACK]
#define UP(k) (!((k) & KEYSTATE))
#define DOWN(k) ((k) & KEYSTATE)
#define REPEAT(k) ((k) & KEYREPEAT)

void key_init(void);
void key_update(void);

extern volatile uint8_t key_update_req;
extern uint8_t key[KEYS];
extern uint8_t keychanged;
extern volatile uint16_t timer;

#endif
