#include "settings.h"
#include "uart.h"
#include "lcd.h"
#include "log.h"
#include "key.h"
#include "menu.h"
#include "filesystem.h"


int main(void){
    //Watchdog deaktivieren
    cli();
    wdt_disable();
    wdt_reset();
    //init uart
    uart_init(UART_BAUD_SELECT(BAUDRATE, F_CPU));
    lcd_init();
    key_init();
    sei();
    
    uart_puts("Show Startscreen\n");
    lcd_setcursor(1,1);
    lcd_puts("4 Kanal-Logger");
    lcd_setcursor(1,2);
    lcd_puts("Samuel Kleiser");
    uart_puts("done\n");
    
    _delay_ms(1000);
    
    /*FS_Init();
    FS_NewFile("Die Testdatei");
    FS_WriteS("Hallo! Das ist eine kleine Testdatei um das neue Dateisystem zu testen!");
    FS_Close();
    FS_OpenFile("Die Testdatei");
    char* buff[100];
    FS_Read(buff, 100);
    FS_Close();
    uart_puts(buff);*/
    i2cInit(100000);
    /*char* buff[100];
    i2cMemRead(0xA0, 0, buff, 100);
    uart_puts(buff);*/

    
    ADC_Init();
    //lcd_clear();
    //lcd_setcursor(0,1);
    //lcd_puts("Kanal 1:");
    do_menu(&Mstart);
    for(;;)
    {
        if((unsigned char)uart_getc())
        {
            cli();
            wdt_enable(0);
            for(;;) asm volatile("nop");
        }
        /*lcd_setcursor(9,1);
        print5V(ADC_Read16(0));*/
        lcd_setcursor(1,2);
        if(key_update_req)
            key_update();
        lcd_putc(key[0] & KEYSTATE ? 'D' : 'U');
        lcd_putc(key[1] & KEYSTATE ? 'D' : 'U');
        lcd_putc(key[2] & KEYSTATE ? 'D' : 'U');
        lcd_putc(key[3] & KEYSTATE ? 'D' : 'U');
    }
    return 0;   
}
