#include "menu.h"

uint8_t Vintervall = 0;
uint8_t Vchannels = 0;
uint8_t Vdepth = 0;

/**************************Men - Texte**************************/
//Startmenu
const char newf[] PROGMEM = "Neue Messung";
const char edit[] PROGMEM = "Mess. l\xefschen";
const char info[] PROGMEM = "\xf9bersicht";

//Neue Messung
const char start[] PROGMEM = "Start";
const char intervall[] PROGMEM = "Intervall";
const char channels[] PROGMEM = "Kan\xe1le";
//const char depth[] PROGMEM = "Aufl\xefsung";

//Intervall
const char _1s[] PROGMEM = "1s";
const char _3s[] PROGMEM = "3s";
const char _5s[] PROGMEM = "5s";
const char _10s[] PROGMEM = "10s";
const char _30s[] PROGMEM = "30s";
const char _1m[] PROGMEM = "1m";
const char _3m[] PROGMEM = "3m";
const char _5m[] PROGMEM = "5m";
const char _10m[] PROGMEM = "10m";
const char _30m[] PROGMEM = "30m";
const char _1h[] PROGMEM = "1h";
const char _3h[] PROGMEM = "3h";
const char _6h[] PROGMEM = "6h";
const char _12h[] PROGMEM = "12h";
const char _18h[] PROGMEM = "18h";

const uint16_t intervall_int[] PROGMEM = {1, 3, 5, 10, 30, 60, 180, 300, 600, 1800, 3600, 10800, 21600, 43200, 64800};

/*//Auflsung
const char _8b[] PROGMEM = "8b";
const char _10b[] PROGMEM = "10b";
const char _12b[] PROGMEM = "12b";
*/
/**************************Men - Texte**************************/


/***********************Men - Definition************************/
//Neue Messung
const MenuEntry Estart PROGMEM = {start, MENU_TYPE_FUNC, 0, 1, {{.func=rec}}};
const MenuEntry Eintervall PROGMEM = {intervall, MENU_TYPE_STR, &Vintervall, 15, 
    {{_1s},{_3s},{_5s},{_10s},{_30s},{_1m},{_3m},{_5m},{_10m},{_30m},{_1h},{_3h},{_6h},{_12h},{_18h}}};
const MenuEntry Echannels PROGMEM = {channels, MENU_TYPE_INT, &Vchannels, 4, 
    {{.uint=1},{.uint=2},{.uint=3},{.uint=4}}};
//const MenuEntry Edepth PROGMEM = {depth, MENU_TYPE_STR, &Vdepth, 3, {{_8b},{_10b},{_12b}}};
const Menu Mnewf PROGMEM = {3,  {&Estart, &Eintervall, &Echannels}};

//Startmen
const MenuEntry Enewf PROGMEM = {newf, MENU_TYPE_MENU, 0, 1,{{&Mnewf}}};
const Menu Mstart PROGMEM = {1,{&Enewf}};

/***********************Men - Definition************************/



void do_menu(Menu* m)
{
    uint8_t level = 0;
    uint8_t current = 0;
    int8_t add;
    uint8_t len     = pgm_read_byte(&(m->len));
    MenuEntry* currentEntry;
    while(1)
    {    
        lcd_clear();
        lcd_setcursor(0,1);
        lcd_putc(level == 0 ? '>' : 126);
        currentEntry = (MenuEntry*)pgm_read_word(&(m->entry[current]));
        write_entry(current,currentEntry);   
        lcd_setcursor(0,2);
        if(current + 1 != len)
        {
            lcd_putc(' ');
            write_entry(current + 1,(MenuEntry*)pgm_read_word(&(m->entry[current + 1])));   
        }
        while(1)
        {
            if(key_update_req)
            {
                key_update();
                if(keychanged & (1 << nOK))
                    if(DOWN(OK) && !REPEAT(OK))
                    {
                        switch(pgm_read_byte(&(currentEntry->type)))
                        {
                            case MENU_TYPE_INT:
                            case MENU_TYPE_STR:
                                level = 1 - level;
                                break;
                            case MENU_TYPE_MENU:
                                do_menu((Menu*)pgm_read_word(&(currentEntry->value[0])));
                                break;
                            case MENU_TYPE_FUNC:
                                ((MenuFunc)pgm_read_word(&(currentEntry->value[0].func)))();
                                break;
                        }
                        break;                         
                    }
                if(keychanged & (1 << nBACK))    
                    if(DOWN(BACK) && !REPEAT(BACK))
                        if(level == 0)
                            return;
                        else
                        {
                            level = 0;
                            break;
                        }                        
                add = 0;
                if(keychanged & (1 << nADD))
                    if(DOWN(ADD) && !REPEAT(ADD))
                        add = 1;
                if(keychanged & (1 << nSUB))
                    if(DOWN(SUB) && !REPEAT(SUB))
                        add = -1;
                if(add != 0)
                {
                    if(level == 0)
                    {
                        current += add + len;
                        while(current >= len)
                            current -= len;
                    }
                    else             
                        entry_add(((MenuEntry*)pgm_read_word(&(m->entry[current]))), add);
                    break;
                }
            }
            unsigned char c = (unsigned char)uart_getc();
            if(c)
            {
                if(c == (unsigned char)'B')
                {
                    cli();
                    wdt_enable(0);
                    for(;;) asm volatile("nop");
                }
                else if(c == (unsigned char)'G')
                {
                    uint8_t buffer[64];
                    for(uint16_t i = 0; i < 16384; i += 64)
                    {
                        i2cMemRead(0xA0,i,buffer,64);
                        for(uint8_t x = 0; x < 64; x++)
                            uart_putc(buffer[x]);   
                    }
                }
                else if(c == (unsigned char)'C')
                {
                    uart_putc('c');
                    uint8_t buffer[64];
                    for(uint8_t i = 0; i <64; i++)
                        buffer[i] = 0xFF;
                    for(uint16_t i = 0; i < 16384; i+=64)
                        i2cMemWrite(0xA0, i, buffer, 64, 0);   
                }
                else if(c == (unsigned char)'W')
                    i2cMemWrite(0xA0, 0, newf, 13, 1);
            }
        }  
    }
}

void entry_add(MenuEntry* m, int8_t i)
{
    uint8_t* p = (uint8_t*) pgm_read_word(&(m->current));
    uint8_t len = pgm_read_byte(&(m)->len);
    *p += i + len;
    while(*p >= len)
        *p -= len;
}

void write_entry(uint8_t i, MenuEntry* m)
{
    char c;
    uint8_t len = 12;                   //Lnge des Lcds - "> [...]: "
                                        //          16       -2     -2 = 12
                                        //Len ist wichtig um Data spter rechtsbndig darzustellen
    char* p = (char*)pgm_read_word(&(m->name));//char* name: Zeiger auf array im Flash
    while(c = pgm_read_byte(p++))       //nchtes Byte lesen und Zeiger um 1 erhhen
    {
        len--;
        lcd_putc(c);
    }
    uint8_t current = *((uint8_t*)pgm_read_word(&(m->current)));
    switch(pgm_read_byte(&(m->type)))
    {
        case MENU_TYPE_INT:
            lcd_putc(':');
            lcd_putc(' ');
            len -= 3;
            lcd_putsp(len);
            char buffer[4];
            itoa8(pgm_read_byte(&(m->value[current].uint)), buffer);
            lcd_puts(buffer);
            break;
        case MENU_TYPE_STR:
            lcd_putc(':');
            lcd_putc(' ');
            p = (char*)pgm_read_word(&(m->value[current].str));
            while(pgm_read_byte(p++))
                len--;
            lcd_putsp(len);
            p = (char*)pgm_read_word(&(m->value[current].str));
            while(c = pgm_read_byte(p++))
                lcd_putc(c);
            break;
        case MENU_TYPE_MENU:
        case MENU_TYPE_FUNC:
            lcd_putsp(len + 2);
            lcd_putc(126); //126 = ->
            break;
    }
}

void lcd_putsp(uint8_t count)
{
    while(count--)
        lcd_putc(' ');
}

//REC
#define CLKDIV 24000
volatile uint16_t sprescaler = 0;
volatile uint8_t next = 0;
volatile uint8_t sec = 0;
volatile uint16_t count;
uint16_t Mcount, hours;
uint8_t secs, mins;

void StartTimer(void)
{
    cli();
    TCCR1B |= (1 << CS12) | (1 << WGM12); //Prescaler 256 + CTC
    OCR1A = CLKDIV - 1;
    TIMSK |= 1 << OCIE1A; //Compare Match interrupt erlauben 
    sei(); 
}

void StopTimer(void)
{
    cli();
    TIMSK &= ~(1 << OCIE1A); //Compare Match interrupt erlauben 
    sei(); 
}

void rec(void)
{
    count = pgm_read_word(&(intervall_int[Vintervall]));
    StartTimer();
    uart_puts_P("REC\r\n");
    lcd_clear();
    NewStream(Vchannels + 1);
    uint8_t b = 0;
    Mcount = 0;
    secs = mins = hours = 0;
    do
    {
        cli();
        if(next)
        {
            for(uint8_t i = 0; i <= Vchannels; i++)
                WriteBuffer13(ADC_Read13(i));   
            Mcount++;
            b = 1 - b;
            next = 0;
        }
        if(key_update_req)
            key_update();
        if(sec)
        {
            secs += sec;       
            sec = 0;
            while(secs >= 60)
            {
                secs = 0;
                if(++mins == 60)
                {
                    mins = 0;
                    ++hours;        
                }   
            }
            lcd_setcursor(0, 1);
            for(uint8_t i = 0; i <= Vchannels; i++)
            {
                print13s(ADC_Read13(i));
                if(i != Vchannels)
                    lcd_putc(' ');
            }
            lcd_putc('V');
            lcd_setcursor(0, 2);
            char buff[6];
            itoa16(Mcount, buff);
            lcd_puts(buff);
            itoa16(hours, buff);
            lcd_puts(buff);
            lcd_putc(':');
            itoa8(mins, buff);
            lcd_puts(buff + 1);
            lcd_putc(':');
            itoa8(secs, buff);
            lcd_puts(buff + 1);   
        }
        sei();   
    }
    while(UP(BACK));
    StopTimer();
    ClearBuffer();
}

ISR (TIMER1_COMPA_vect)
{
    sec++;
    if(sprescaler == 0)
    {
        sprescaler = count;
        next = 1;
    }
    sprescaler--;
}

