#ifndef MENU
#define MENU

#define min(a,b) ((a<b)?(a):(b))

#include "settings.h"
#include "log.h"
#include "lcd.h"
#include "key.h"
#include "uart.h"
#include "i2c.h"

#define MENU_TYPE_INT 0
#define MENU_TYPE_STR 1
#define MENU_TYPE_MENU 2
#define MENU_TYPE_FUNC 3

typedef void (*MenuFunc) (void);

typedef union 
{
    char* str;
    uint8_t uint;
    void* menu;  
    MenuFunc func; 
}Data;

typedef struct 
{
    char* name;
    uint8_t type;
    uint8_t* current;
    uint8_t len;
    Data value[];
}MenuEntry;

typedef struct 
{
    uint8_t len;
    MenuEntry* entry[];
}Menu;

extern const Menu Mstart PROGMEM;

void do_menu(Menu* m);
void write_entry(uint8_t i, MenuEntry* m);
void lcd_putsp(uint8_t count);
void entry_add(MenuEntry* m, int8_t i);

void rec(void);

#endif
