#include <avr/io.h>

;PortD
#define TXD			1
#define VSync		2
#define HSync		3
#define Clear		6
#define Sample		7

#define Zeilstart	100		//X Start Position des Zhlfensters
#define Zeilende	155		//X End Position des Zhlfensters
#define Spaltstart 	40		//Y Start Position des Zhlfensters
#define Spaltende	50		//Y End Position des Zhlfensters

;Register
#define temp		16
#define Spalte		2
#define Zeile		3
#define ZeileL		4
#define rsave		5

.global sample
sample:

	clr temp
	mov Zeile, temp
	mov ZeileL, temp
	mov Spalte, temp

	sei

	cbi _SFR_IO_ADDR(PORTD), Sample

mainlp:
	cli
	mov temp, Zeile
	cpi temp, Zeilende
	brsh endsample

	cpi temp, Zeilstart
	brsh startsample
	sei
rjmp mainlp

startsample:
	sei
	mov temp, Spalte
startsample2:
	inc temp 
	cpi temp, Spaltstart
	brlo startsample2
	sbi _SFR_IO_ADDR(PORTD), Sample
sampling:
	inc temp 
	cpi temp, Spaltende
	brlo sampling
	cbi _SFR_IO_ADDR(PORTD), Sample
	mov Spalte, temp
endsampling:
	mov temp, Spalte
	cpi temp, 0 
	brne endsampling
rjmp mainlp
	
endsample:
	sei
	cbi _SFR_IO_ADDR(PORTD), Sample

	ldi temp, (1<<ADEN)|(1<<ADSC)|(1<<ADIF)|6;
	sts 32+_SFR_IO_ADDR(ADCSRA), temp

adcready:
	lds temp, 32+_SFR_IO_ADDR(ADCSRA)
	sbrs temp, ADIF
	rjmp adcready
	sbi _SFR_IO_ADDR(PORTD), Clear	;Ladung lschen

	push 17
	rcall calcvalue
	pop 17

warte:
	mov temp, Zeile
	cpi temp, Zeilstart
	brsh warte
rjmp mainlp

;****************************************************************************
;	Interrupt Vektoren
;****************************************************************************

.global SIG_INTERRUPT0
 SIG_INTERRUPT0:
	push temp
	ldi temp, 0
	mov Zeile, temp
	mov ZeileL, temp
	cbi _SFR_IO_ADDR(PORTD), Clear
	pop temp
reti

.global SIG_INTERRUPT1
 SIG_INTERRUPT1:
	push temp
	in rsave, _SFR_IO_ADDR(SREG)
	mov temp, ZeileL
	subi temp, lo8(-128)
	mov ZeileL, temp

	mov temp, Zeile
	sbci temp,  hi8(-128)
	mov Zeile, temp

	clr temp
	mov Spalte, temp
	out _SFR_IO_ADDR(SREG), rsave
	pop temp
reti
