#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/signal.h>
#include <avr/pgmspace.h>
#include "asm.h"

// PortD
#define TXD			1
#define VSync		2
#define HSync		3
#define Clear		6
#define Sample		7

#define WERTE	32L			// Anzahl an Messwerten fr die Ausgleichsgerade
#define X		(WERTE*(WERTE-1)/2)	
#define X2		(WERTE*(WERTE-1)*(2*WERTE-1)/6)
#define D		(WERTE*X2-X*X)

#define Thr1	50			//Schwellwert 1
#define Thr2	150			//Schwellwert 2
	
#define ThrP0	0			//Pin fr Schwelle 1
#define ThrP1	1			//Pin fr Schwelle 2

#define ALP		PORTB		//Port an dem die Schwellwert Anzeigen sind

	unsigned char wpointer=0;
	unsigned int werte[WERTE];

int main(void)
{ 
	EICRA=(1<<ISC11)|(1<<ISC01);	//HSync, VSync Interrupts
	EIMSK=(1<<INT0)|(1<<INT1);
        
	UBRR0=25;						//UART: Gibt Steigung der Gerade aus
	UCSR0B=(1<<TXEN0);

	ADMUX=(1<<REFS1)|(1<<REFS0)|1;	//ADC
	ADCSRA=(1<<ADEN)|(1<<ADSC)|6;

	DIDR0=255;						//Ports
	DDRD=(1<<TXD)|(1<<Clear)|(1<<Sample);
	PORTD=255;
	DDRB=255;

	sample();			//Messroutine (in Assembler)
}

void calcvalue(void)
{
	signed long XY,Y;
	signed int a;
	unsigned int aa;
	unsigned char rpointer=0,i;

	werte[wpointer]=ADC;
	wpointer++;
	if (wpointer>=WERTE)
		wpointer=0;

	Y=0;
	XY=0;
	rpointer=wpointer;
	for (i=0; i<WERTE; i++)
		{XY+=(unsigned int)werte[rpointer]*i;
		Y+=werte[rpointer];	
		rpointer++;
		if (rpointer>=WERTE)
			rpointer=0;
		}

	a=((signed long)256*((long)WERTE*XY-(long)X*Y))/D;	//Steigung berechnen (Festkommazahl: 24bit signed Wert + 8bit Kommastelle)

	if (a<0)		//Betrag bilden
		aa=-a;
	else
		aa=a;

	if (aa>Thr1)	sbi (ALP, ThrP0);	//Schwellwerte testen, Pins setzen
	else			cbi (ALP, ThrP0);

	if (aa>Thr2)	sbi (ALP, ThrP1);
	else			cbi (ALP, ThrP1);

	a/=8;			//Werte fr UART aufbereiten
	if (a>127)
		a=127;
	if (a<-128)
		a=-128;
	a+=128;
	UDR0=a;
}

