#include <stdlib.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>

#include "uart.c"

#ifndef F_CPU
	#define F_CPU 16000000UL
#endif

#define UART_BAUD_RATE      19200 

#include <util/delay.h>

#define Ddr_sck 	DDRC
#define Port_sck	PORTC
#define sck			4
#define Ddr_sdio 	DDRC
#define Port_sdio	PORTB
#define Pin_sdio	PINC0
#define sdio		5
 
void PrintByte(uint8_t num){
	char buffer[3];
    itoa( num, buffer, 10);   					// convert interger into string (decimal format)         
    uart_puts(buffer);        					// and transmit string to UART
}

uint8_t Adns2610_read_byte(void){
	unsigned char Byte = 0;
	for (unsigned char a=8; a>0; a--){			//das Byte wird Bitweise nacheinander Empangen MSB First
		Port_sck &=~(1<<sck);					//erzeugt ein Clock Impuls (Low) 
		if (Pin_sdio & sdio){					//Lesen des Pegels von MMC_DI
			Byte |= (1<<(a-1));
		}
		else{
			Byte &=~(1<<(a-1));
		}
		Port_sck |=(1<<sck);					//setzt Clock Impuls wieder auf (High)		
	}
	return (Byte);
}

void Adns2610_write_byte(uint8_t Byte){
	Ddr_sdio |= (1<<sdio);
	for (unsigned char a=8; a>0; a--){			//das Byte wird Bitweise nacheinander Gesendet MSB First
		if (bit_is_set(Byte,(a-1))>0){			//Ist Bit a in Byte gesetzt
			Port_sck |= (1<<sdio);				//Set Output High
		}
		else{
			Port_sck &= ~(1<<sdio);				//Set Output Low
		}
		Port_sck &= ~(1<<sck);					//erzeugt ein Clock Impuls (LOW)
		Port_sck |= (1<<sck);					//setzt Clock Impuls wieder auf (High)
	}
	Ddr_sdio &= ~(1<<sdio);
	Port_sdio &= ~(1<<sdio);

}

void Adns2610_write_operation(uint8_t Address_byte, uint8_t Data_byte){
	Address_byte |= 128;
	Adns2610_write_byte(Address_byte);
	Adns2610_write_byte(Data_byte);
}

uint8_t Adns2610_read_operation(uint8_t Address_byte){
	Adns2610_write_byte(Address_byte);
	return Adns2610_read_byte();
}

void Picture(void){
	Adns2610_write_operation(0x00 , 0x01);
	_delay_us(500);
	Adns2610_write_operation(0x08 , 0x00);
	_delay_us(100);
	for(uint16_t I = 1; I < 325; I++){
		PrintByte(Adns2610_read_operation(0x0));
		_delay_ms(10);
	}
}

void Properties(void){
	PrintByte(Adns2610_read_operation(0x04));
	_delay_ms(10);
	PrintByte(Adns2610_read_operation(0x09));
	_delay_ms(10);
	PrintByte(Adns2610_read_operation(0x0a));
}

void Xy(void){
	PrintByte(Adns2610_read_operation(0x03));
	_delay_ms(10);
	PrintByte(Adns2610_read_operation(0x02));
}

void Adns2610_init(void){
	Ddr_sck |= (1<<sck);
	Ddr_sdio |= (1<<sdio);
	Port_sck |= (1<<sck);
	Port_sdio |= (1<<sdio);
	Adns2610_write_operation(0x00 , 0x80);
	_delay_us(250);
}

int main(void){
	uart_init(UART_BAUD_SELECT_DOUBLE_SPEED(UART_BAUD_RATE,F_CPU));
	sei();
	while(1){													// Endlosschleife
    	uint16_t c = uart_getc();
        if (!(c & UART_NO_DATA )){
            /*
             * new data available from UART
             * check for Frame or Overrun error
             */
            if ( c & UART_FRAME_ERROR ){
                /* Framing Error detected, i.e no stop bit detected */
                uart_puts_P("UART Frame Error: ");
            }
            else if ( c & UART_OVERRUN_ERROR ){
                uart_puts_P("UART Overrun Error: ");
            }
            else if ( c & UART_BUFFER_OVERFLOW ){
                uart_puts_P("Buffer overflow error: ");
            }
			else{
            	if((unsigned char)c == '#'){
					Picture();
				}
				else if((unsigned char)c == '!'){
					Properties();
				}
				else if((unsigned char)c == '$'){
					Xy();
				}
			}
        }
	}
}
