#include <windows.h>
#include "vis.h"
#include <iostream.h>
#include <math.h>
#include "serial.h"

int totala=0,GPage=0,max[2]={0,0},peak[2]={0,0};
char szAppName[] = "SimpleVis"; // Our window class, etc

// configuration declarations
int config_x=50, config_y=50;	// screen X position and Y position, repsectively
void config_read(struct winampVisModule *this_mod);		// reads the configuration
void config_write(struct winampVisModule *this_mod);	// writes the configuration
void config_getinifn(struct winampVisModule *this_mod, char *ini_file); // makes the .ini file filename

// returns a winampVisModule when requested. Used in hdr, below
winampVisModule *getModule(int which);

// "member" functions
void config(struct winampVisModule *this_mod); // configuration dialog
int init(struct winampVisModule *this_mod);	   // initialization for module
int render1(struct winampVisModule *this_mod);  // rendering for module 1
int render2(struct winampVisModule *this_mod);  // rendering for module 2
int render3(struct winampVisModule *this_mod);  // rendering for module 3
int render4(struct winampVisModule *this_mod);  // rendering for module 4
int render5(struct winampVisModule *this_mod);  // rendering for module 5
int render6(struct winampVisModule *this_mod);  // rendering for module 6
int render7(struct winampVisModule *this_mod);  // rendering for module 7
int render8(struct winampVisModule *this_mod);  // rendering for module 8
int render9(struct winampVisModule *this_mod);  // rendering for module 9
void quit(struct winampVisModule *this_mod);   // deinitialization for module



void writebyte (unsigned char wert);

void writecom (unsigned char wert);

void setpwm (unsigned char wert);

void setscroll (unsigned char wert);

void setcursor (unsigned int x, unsigned int y);

void writetext (char *text);

void initlcd(void);

void clearbuffer(void);

void transfer(int xmin, int ymin, int xmax, int ymax);

void lcd_line (int x1, int y1, int x2, int y2);

void bresenham_line (int x1, int y1, int x2, int y2);

void h_line (int x1, int x2, int y);

void v_line (int x1, int y1, int y2);

void lcd_line3d (int x1,int y1,int z1, int x2,int y2,int z2, int W1, int W2, int W3);

unsigned char lcdbuffer[480][640];

#define CPULast	20		// Je hher, desto langsamer das Plugin, aber kleiner die CPU Last



const signed char SIN[64]=
{0, 12, 24, 37, 48, 60, 71, 81, 90, 98, 106, 112, 118, 122, 125, 127,
 127, 127, 125, 122, 118, 112, 106, 98, 90, 81, 71, 60, 48, 37, 24, 12,
 0,-12,-24,-37,-48,-60,-71,-81,-90,-98,-106,-112,-118,-122,-125,-127,
-127,-127,-125,-122,-118,-112,-106,-98,-90,-81,-71,-60,-48,-37,-24,-12};

const signed char COS[64]=
{127, 127, 125, 122, 118, 112, 106, 98, 90, 81, 71, 60, 48, 37, 24, 12,
 0,-12,-24,-37,-48,-60,-71,-81,-90,-98,-106,-112,-118,-122,-125,-127,
-127,-127,-125,-122,-118,-112,-106,-98,-90,-81,-71,-60,-48,-37,-24,-12,
 0, 12, 24, 37, 48, 60, 71, 81, 90, 98, 106, 112, 118, 122, 125, 127};


// Double buffering data
HDC memDC;		// memory device context
HBITMAP	memBM,  // memory bitmap (for memDC)
		oldBM;  // old bitmap (from memDC)

// Module header, includes version, description, and address of the module retriever function
winampVisHeader hdr = { VIS_HDRVER, "Benedikts USB KS0108 Visualisation Library v0.1", getModule };

// first module (oscilliscope)
winampVisModule mod1 =
{
	"Oscilliscope",
	NULL,	// hwndParent
	NULL,	// hDllInstance
	0,		// sRate
	0,		// nCh
	0,		// latencyMS
	CPULast,// delayMS
	0,		// spectrumNch
	2,		// waveformNch
	{ 0, },	// spectrumData
	{ 0, },	// waveformData
	config,
	init,
	render1, 
	quit
};

// second module (spectrum analyser)
winampVisModule mod2 =
{
	"Spectrum Analyser",
	NULL,	// hwndParent
	NULL,	// hDllInstance
	0,		// sRate
	0,		// nCh
	0,		// latencyMS
	CPULast,// delayMS
	2,		// spectrumNch
	0,		// waveformNch
	{ 0, },	// spectrumData
	{ 0, },	// waveformData
	config,
	init,
	render2, 
	quit
};

// third module (Peak VU meter)
winampVisModule mod3 =
{
	"Fast Oscilloscope",
	NULL,	// hwndParent
	NULL,	// hDllInstance
	0,		// sRate
	0,		// nCh
	0, 	// latencyMS
	CPULast,// delayMS
	0,		// spectrumNch
	2,		// waveformNch
	{ 0, },	// spectrumData
	{ 0, },	// waveformData
	config,
	init,
	render3, 
	quit
};

// forth module (FX meter)
winampVisModule mod4 =
{
	"3D Spectrum Analyser",
	NULL,	// hwndParent
	NULL,	// hDllInstance
	0,		// sRate
	0,		// nCh
	0,  	// latencyMS
	CPULast,// delayMS
	1,		// spectrumNch
	0,		// waveformNch
	{ 0, },	// spectrumData
	{ 0, },	// waveformData
	config,
	init,
	render4, 
	quit
};

// fifth module
winampVisModule mod5 =
{
	"Rotating 3D Oscilloscope",
	NULL,	// hwndParent
	NULL,	// hDllInstance
	0,		// sRate
	0,		// nCh
	0,  	// latencyMS
	CPULast,// delayMS
	0,		// spectrumNch
	1,		// waveformNch
	{ 0, },	// spectrumData
	{ 0, },	// waveformData
	config,
	init,
	render5, 
	quit
};

// sixth module (True RMS VU Meter)
winampVisModule mod6 =
{
	"3D Oscilloscope",
	NULL,	// hwndParent
	NULL,	// hDllInstance
	0,		// sRate
	0,		// nCh
	0,  	// latencyMS
	CPULast,// delayMS
	0,		// spectrumNch
	1,		// waveformNch
	{ 0, },	// spectrumData
	{ 0, },	// waveformData
	config,
	init,
	render6, 
	quit
};

// seventh module (Graph Meter)
winampVisModule mod7 =
{
	"VU Graph",
	NULL,	// hwndParent
	NULL,	// hDllInstance
	0,		// sRate
	0,		// nCh
	0,  	// latencyMS
	CPULast,// delayMS
	0,		// spectrumNch
	2,		// waveformNch
	{ 0, },	// spectrumData
	{ 0, },	// waveformData
	config,
	init,
	render7, 
	quit
};

// eighth module (Graph Spec)
winampVisModule mod8 =
{
	"Spec Graph",
	NULL,	// hwndParent
	NULL,	// hDllInstance
	0,		// sRate
	0,		// nCh
	0,  	// latencyMS
	CPULast,// delayMS
	2,		// spectrumNch
	0,		// waveformNch
	{ 0, },	// spectrumData
	{ 0, },	// waveformData
	config,
	init,
	render8, 
	quit
};


// eighth module (Graph Spec)
winampVisModule mod9 =
{
	"Landscape",
	NULL,	// hwndParent
	NULL,	// hDllInstance
	0,		// sRate
	0,		// nCh
	0,  	// latencyMS
	CPULast,// delayMS
	0,		// spectrumNch
	1,		// waveformNch
	{ 0, },	// spectrumData
	{ 0, },	// waveformData
	config,
	init,
	render9, 
	quit
};

// this is the only exported symbol. returns our main header.
// if you are compiling C++, the extern "C" { is necessary, so we just #ifdef it
#ifdef __cplusplus
extern "C" {
#endif
__declspec( dllexport ) winampVisHeader *winampVisGetHeader()
{
	return &hdr;
}
#ifdef __cplusplus
}
#endif

// getmodule routine from the main header. Returns NULL if an invalid module was requested,
// otherwise returns either mod1, mod2 or mod3 depending on 'which'.
winampVisModule *getModule(int which)
{
	switch (which)
	{
		case 0: return &mod1;
		case 1: return &mod2;
		case 2: return &mod3;
		case 3: return &mod4;	
		case 4: return &mod5;
		case 5: return &mod6;
		case 6:	return &mod7;
		case 7:	return &mod8;
		case 8:	return &mod9;

		default:return NULL;
	}
}

// configuration. Passed this_mod, as a "this" parameter. Allows you to make one configuration
// function that shares code for all your modules (you don't HAVE to use it though, you can make
// config1(), config2(), etc...)
void config(struct winampVisModule *this_mod)
{
	MessageBox(this_mod->hwndParent,"Dieses Plugin basiert auf einem Demo Plugin von Justin Frankel/Nullsoft\n"
									"Wer Ideen hat, was man noch so alles einbauen kann\n"
									"bitte auf\n"
									"http://www.mikrocontroller.net/forum/read-4-160854.html\n"
									"posten","Konfiguration",MB_OK);
}

// initialization. Registers our window class, creates our window, etc. Again, this one works for
// both modules, but you could make init1() and init2()...
// returns 0 on success, 1 on failure.
int init(struct winampVisModule *this_mod)
{

	config_read(this_mod);
	initlcd();
	
// create our doublebuffer
	memDC = CreateCompatibleDC(NULL);
	memBM = CreateCompatibleBitmap(memDC,256,32);
	oldBM = SelectObject(memDC,memBM);
	Serial_Init("COM5", 19200);
	SendByte('I');
	SendByte('n');
	SendByte('i');
	SendByte('t');
	return 0;
}

// render function for oscilliscope. Returns 0 if successful, 1 if visualization should end.
int render1(struct winampVisModule *this_mod)
{	int x,y,c=0,ya;
	clearbuffer ();
		for (c=0;c<2;c++)
		{	ya=(this_mod->waveformData[c][0])^128;
			for (x = 1; x < 576; x ++)
		{		y=(this_mod->waveformData[c][x])^128;
				lcd_line (32+x-1,ya+c*224,32+x,y+c*224);
				ya=y;
		}}
			transfer(32,0,608,480);
	return 0;
}

// render function for analyser. Returns 0 if successful, 1 if visualization should end.
int render2(struct winampVisModule *this_mod)
{
	int x, y,c;
	// clear background
	clearbuffer ();

	// draw analyser
	for (c = 0; c < 2; c ++)
	{
		for (x = 1; x < 288; x ++)
		{
			y=479-((this_mod->spectrumData[c][x])>>(this_mod->nCh-1));
			lcd_line(x+c*320,479,x+c*320,y);
		}
	}
			transfer(0,350,640,480);
	return 0;
}

// render function for fast analyser. Returns 0 if successful, 1 if visualization should end.
int render3(struct winampVisModule *this_mod)
{	int x=0, y, ya=128;
	clearbuffer ();

ya=367-(((this_mod->waveformData[0][0])^128)+((this_mod->waveformData[1][0])^128))/2;
			for (x = 1; x < 576; x ++)
		{
					y=367-(((this_mod->waveformData[0][x])^128)+((this_mod->waveformData[1][x])^128))/2;
					lcd_line (32+x-1,ya,32+x,y);
					ya=y;
			}
			transfer(32,112,608,368);
	return 0;
}


// render function for FX. Returns 0 if successful, 1 if visualization should end.
int render4(struct winampVisModule *this_mod)
{	int x, y;

#define sub 16
#define mul 12

#define aw	10
#define bw	0
#define cw	14+16
//	static int cw;
	static unsigned char olddata[32][64];
	clearbuffer ();

//	cw++;
//	cw&=63;


	for (y=1; y<32; y++)
		for (x=0; x<43; x++)
			olddata[y-1][x]=olddata[y][x];
	y=31;
	for (x=0; x<43; x++)
		olddata[y][x]=sqrt(100*(this_mod->spectrumData[0][1+(int)sqrt(x*x*x)])>>(this_mod->nCh-1));

for (y=1; y<32; y++)
	for (x=1; x<43; x++)
	{	lcd_line3d ((x-1-sub-5)*mul,(y-1-sub)*mul,olddata[y-1][x-1],(x-sub-5)*mul,(y-1-sub)*mul,olddata[y-1][x],aw,bw,cw); 
		lcd_line3d ((x-1-sub-5)*mul,(y-1-sub)*mul,olddata[y-1][x-1],(x-1-sub-5)*mul,(y-sub)*mul,olddata[y][x-1],aw,bw,cw); 
	}


			transfer(30,50,600,380);
	return 0;
}

#undef cw


// render function for Landscape. Returns 0 if successful, 1 if visualization should end.
int render5(struct winampVisModule *this_mod)
{	int x, y;

#define sub 16
#define mul 12

#define aw	10
#define bw	0
//#define cw	8
	static int cw;
	static unsigned char olddata[31][31];
	clearbuffer ();

	cw++;
	cw&=63;

	for (y=1; y<32; y++)
		for (x=0; x<32; x++)
			olddata[y-1][x]=olddata[y][x];
	y=31;
	for (x=0; x<32; x++)
		olddata[y][x]=((this_mod->waveformData[0][16*x])^128)/2;

for (y=1; y<32; y++)
	for (x=1; x<32; x++)
	{	lcd_line3d ((x-1-sub)*mul,(y-1-sub)*mul,olddata[y-1][x-1],(x-sub)*mul,(y-1-sub)*mul,olddata[y-1][x],aw,bw,cw); 
		lcd_line3d ((x-1-sub)*mul,(y-1-sub)*mul,olddata[y-1][x-1],(x-1-sub)*mul,(y-sub)*mul,olddata[y][x-1],aw,bw,cw); 
	}

			transfer(320-20*mul,200-13*mul,320+20*mul,200+14*mul);
	return 0;
}

// render function for True RMS VU meter. Returns 0 if successful, 1 if visualization should end.
int render6(struct winampVisModule *this_mod)
{	int x, y;

#define sub 16
#define mul 12

#define aw	10
#define bw	0
#define cw	8+32
//	static int cw;
	static unsigned char olddata[31][31];
	clearbuffer ();

	for (y=1; y<32; y++)
		for (x=0; x<32; x++)
			olddata[y-1][x]=olddata[y][x];
	y=31;
	for (x=0; x<32; x++)
		olddata[y][x]=((this_mod->waveformData[0][16*x])^128)/3;

for (y=1; y<32; y++)
	for (x=1; x<32; x++)
	{	lcd_line3d ((x-1-sub)*mul,(y-1-sub)*mul,olddata[y-1][x-1],(x-sub)*mul,(y-1-sub)*mul,olddata[y-1][x],aw,bw,cw); 
		lcd_line3d ((x-1-sub)*mul,(y-1-sub)*mul,olddata[y-1][x-1],(x-1-sub)*mul,(y-sub)*mul,olddata[y][x-1],aw,bw,cw); 
	}

			transfer(320-20*mul,200-13*mul,320+20*mul,240+13*mul);
	return 0;
}


// render function for Graph VU meter. Returns 0 if successful, 1 if visualization should end.
int render7(struct winampVisModule *this_mod)
{
	int x, y,ya,y1,y2;

	
	int total=0;
	for (x = 1; x < 576; x ++)
	{
		y1=(this_mod->waveformData[1][x])^128;
		y2=(this_mod->waveformData[0][x])^128;
		ya=(y1+y2)-256;
		total+=abs(ya);
	}

		for (x=1;x<640;x++)
		for (y=0;y<480;y++)
			lcdbuffer[y][x-1]=lcdbuffer[y][x];
	
	for (y=0;y<480;y++)
		lcdbuffer[y][639]=0;
	
		total=sqrt(total);

	lcd_line (639, 479, 639, 479-total);

	transfer(0,200,640,480);
	return 0;
}


// render function for Graph Spec meter. Returns 0 if successful, 1 if visualization should end.
int render8(struct winampVisModule *this_mod)
{
	int x, y;


		{
		int total=0;
		for (x=1;x<640;x++)
			for (y=0;y<480;y++)
				lcdbuffer[y][x-1]=lcdbuffer[y][x];
		
		for (y=0;y<480;y++)
			lcdbuffer[y][639]=0;
		
		for (x = 2; x < 288; x++)
		{
			y=((this_mod->spectrumData[0][x])>>(this_mod->nCh-1))+((this_mod->spectrumData[1][x])>>(this_mod->nCh-1));
		
			if (y>(2000/(x+25)))
				lcdbuffer [480-x][639]=1;
		}		
	}
	transfer(0,195,640,480);
	return 0;
}


// render function for True RMS VU meter. Returns 0 if successful, 1 if visualization should end.
int render9(struct winampVisModule *this_mod)
{	int x, y, z, rol;

#define sub 20
#define suby 300
#define mul 20
#define mulx 16

#define aw	16		//X Winkel
#define bw	0		//Y Winkel
#define cw	32		//Z Winkel

#define FAK	2

	static unsigned char olddata[16][41];
	clearbuffer ();

	for (y=1; y<16; y++)
		for (x=0; x<41; x++)
			olddata[y-1][x]=olddata[y][x];
	y=15;
	for (x=0; x<41; x++)
		olddata[y][x]=((this_mod->waveformData[0][x*14])^128)/3;

for (y=1; y<16; y++)
{	rol=SIN[y];
	for (x=1; x<41; x++)
	lcd_line3d ((x-1-sub)*mulx,(y-1)*mul,rol*FAK+olddata[y-1][x-1]-suby,(x-sub)*mulx,(y-1)*mul,rol*FAK+olddata[y-1][x]-suby,aw,bw,cw); 
}
		transfer(0,200,640,480);
	return 0;
}


// cleanup (opposite of init()). Destroys the window, unregisters the window class
void quit(struct winampVisModule *this_mod)
{
	config_write(this_mod);		// write configuration
	SelectObject(memDC,oldBM);	// delete our doublebuffer
	DeleteObject(memDC);
	DeleteObject(memBM);	
	UnregisterClass(szAppName,this_mod->hDllInstance); // unregister window class

	Uninit_Serial();

}

// window procedure for our window
LRESULT CALLBACK WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_CREATE:		return 0;
		case WM_ERASEBKGND: return 0;
		case WM_PAINT:
			{ // update from doublebuffer
				PAINTSTRUCT ps;
				RECT r;
				HDC hdc = BeginPaint(hwnd,&ps);
				GetClientRect(hwnd,&r);
				BitBlt(hdc,0,0,r.right,r.bottom,memDC,0,0,SRCCOPY);
				EndPaint(hwnd,&ps);
			}
		return 0;
		case WM_DESTROY: PostQuitMessage(0); return 0;
		case WM_KEYDOWN: // pass keyboard messages to main winamp window (for processing)
		case WM_KEYUP:
			{	// get this_mod from our window's user data
				winampVisModule *this_mod = (winampVisModule *) GetWindowLong(hwnd,GWL_USERDATA);
				PostMessage(this_mod->hwndParent,message,wParam,lParam);
			}
		return 0;
		case WM_MOVE:
			{	// get config_x and config_y for configuration
			//	RECT r;
		//		GetWindowRect(hMainWnd,&r);
			//	config_x = r.left;
			//	config_y = r.top;
			}
		return 0;
	}
	return DefWindowProc(hwnd,message,wParam,lParam);
}


void config_getinifn(struct winampVisModule *this_mod, char *ini_file)
{	// makes a .ini file in the winamp directory named "plugin.ini"
	char *p;
	GetModuleFileName(this_mod->hDllInstance,ini_file,MAX_PATH);
	p=ini_file+strlen(ini_file);
	while (p >= ini_file && *p != '\\') p--;
	if (++p >= ini_file) *p = 0;
	strcat(ini_file,"plugin.ini");
}


void config_read(struct winampVisModule *this_mod)
{
	char ini_file[MAX_PATH];
	config_getinifn(this_mod,ini_file);
	config_x = GetPrivateProfileInt(this_mod->description,"Screen_x",config_x,ini_file);
	config_y = GetPrivateProfileInt(this_mod->description,"Screen_y",config_y,ini_file);
}

void config_write(struct winampVisModule *this_mod)
{
	char string[32];
	char ini_file[MAX_PATH];
	config_getinifn(this_mod,ini_file);
	wsprintf(string,"%d",config_x);
	WritePrivateProfileString(this_mod->description,"Screen_x",string,ini_file);
	wsprintf(string,"%d",config_y);
	WritePrivateProfileString(this_mod->description,"Screen_y",string,ini_file);
}



#include <stdlib.h>
#include <conio.h>

void writebyte (unsigned char wert)
{
	while (!(_inp(0x379) & 128));
	_outp (0x37A, 2);
	_outp (0x378, wert);
#ifdef SEC
	_outp (0x37A, 2);
#endif
	_outp (0x37A, 3);
	_outp (0x37A, 2);
}

void writecom (unsigned char wert)
{
	while (!(_inp(0x379) & 128));
#ifdef SEC
	_outp (0x37A, 0);
#endif
	_outp (0x378, wert);
	_outp (0x37A, 0);
	_outp (0x37A, 1);
	_outp (0x37A, 0);
}

void setpwm (unsigned char wert)
{
	writecom (2);
	writebyte (wert);
}

void setscroll (unsigned char wert)
{
	writecom (3);
	writebyte (wert);
}

void setcursor (unsigned int x, unsigned int y)
{
	writecom(1);
	writebyte((char)(y%240));
	writebyte((char)((y/240)*128+(x/8)));
}

void writetext (char *text)
{
	while (*text)
	{	writecom(192);
		writebyte(*text++);
	}
}

void initlcd(void)
{	unsigned int x, y;

	setpwm(75);	//Kontrast einstellen

	setscroll(0);	

	for (y=0; y<480; y++)		
	{	setcursor (0, y);
		for (x=0; x<125; x++)
			writebyte (0);		//Just Clear the fuckin LCD
	}


}

#define color 1

void lcd_set_pixel (int x, int y)
{	if ((x<0)||(x>639))
		return;
	if ((y<0)||(y>479))
		return;
	lcdbuffer[y][x]=color;
}


void lcd_line (int x1, int y1, int x2, int y2)
{   int temp;
    if (y1==y2)
       {if (x1>x2)
            {temp=x1;
            x1=x2;
            x2=temp;}
        h_line (x1, x2, y1);}
    else if (x1==x2)
       {if (y1>y2)
            {temp=y1;
            y1=y2;
            y2=temp;}
        v_line (x1, y1, y2); }
    else
        bresenham_line (x1, y1, x2, y2);
}

void bresenham_line (int x1, int y1, int x2, int y2)
   {int dx, dy, x, y, temp;
    int IncrE, IncrNE, d;
      if (y1>y2)
       {temp=y1;
        y1=y2;
        y2=temp;
        temp=x1;
        x1=x2;
        x2=temp;}
    dy = y2-y1;
    if (x1>x2)
       {dx = x1-x2;
        if (dy>dx)
           {IncrE = 2*dx;
            IncrNE = 2*(dx-dy);
            d = IncrE -2*dy;
            x = x1;
            lcd_set_pixel (x,y1);
            for (y=y1+1; y<y2; y++)
               {if (d<=0)
                    d+=IncrE;
                else
                   {d+=IncrNE;
                    x--; }
                lcd_set_pixel (x,y); }}
        else
           {IncrE = 2*dy;
            IncrNE = 2*(dy-dx);
            d = IncrE -2*dx;
            y = y1;
            lcd_set_pixel (x1,y);
            for (x=x1-1; x>x2; x--)
               {if (d<=0)
                    d+=IncrE;
                else
                   {d+=IncrNE;
                    y++; }
                lcd_set_pixel (x,y); }}}
    else
       {dx = x2-x1;
        if (dy>dx)
           {IncrE = 2*dx;
            IncrNE = 2*(dx-dy);
            d = IncrE -2*dy;
            x = x1;
            lcd_set_pixel (x,y1);
            for (y=y1+1; y<y2; y++)
               {if (d<=0)
                    d+=IncrE;
                else
                   {d+=IncrNE;
                    x++; }
             lcd_set_pixel (x,y); }}
        else
           {IncrE = 2*dy;
            IncrNE = 2*(dy-dx);
            d = IncrE -2*dx;
            y = y1;
            lcd_set_pixel (x1,y);
            for (x=x1+1; x<x2; x++)
               {if (d<=0)
                    d+=IncrE;
                else
                   {d+=IncrNE;
                    y++; }
             lcd_set_pixel (x,y); }}}
}

void h_line (int x1, int x2, int y)
   {int x;
    for (x=x1; x<=x2; x++)
	lcd_set_pixel(x,y);
}

void v_line (int x, int y1, int y2)
   {int y;
    for (y=y1; y<=y2; y++)
	lcd_set_pixel(x,y);
}

void transfer (int xmin, int ymin, int xmax, int ymax)
{   int y,x,i;
	unsigned char c;


	for (y=ymin; y<ymax; y++)
	{	setcursor (xmin, y);
		for (x=xmin; x<xmax; x+=8)
		{c=0;
			for (i=0; i<8;i++)
				c+=lcdbuffer[y][x+i]*(1<<(7-i));
			writebyte (c);
		}
	}
    
}


void clearbuffer (void)
{   unsigned int y,x;

	for (y=0; y<480; y++)
		for (x=0; x<640; x++)
		lcdbuffer[y][x]=1-color;

}

int M[3][3];

void Make_Matrix(unsigned char W1,unsigned char W2,unsigned char W3) 
{signed char cosW1, cosW2, cosW3, sinW1, sinW2, sinW3;

    sinW1=SIN[W1];
    sinW2=SIN[W2];
    sinW3=SIN[W3];
    cosW1=COS[W1];
    cosW2=COS[W2];
    cosW3=COS[W3];

  // Rotation-Matrix 
  // calculates the new position of the single vectors
  M[0][0] = ( cosW2*cosW3)/64;
  M[1][0] = (-cosW2*sinW3)/64;
  M[2][0] =   sinW2*2;

  M[0][1] = (cosW1*sinW3)/64  + (((sinW1*sinW2)/256)*cosW3)/32;
  M[1][1] = (cosW1*cosW3)/64  - (((sinW1*sinW2)/256)*sinW3)/32;
  M[2][1] =(-sinW1*cosW2)/64;

  M[0][2] = (sinW1*sinW3)/64  - (((cosW1*sinW2)/256)*cosW3)/32;
  M[1][2] = (sinW1*cosW3)/64  + (((cosW1*sinW2)/256)*sinW3)/32;
  M[2][2] = (cosW1*cosW2)/64;
}

#define MUL 256
#define x_Pos 320
#define y_Pos 240

void lcd_line3d (int x1,int y1,int z1, int x2,int y2,int z2, int W1, int W2, int W3)
{int xr1,xr2 ;
 int yr1,yr2 ;

  Make_Matrix (W1,W2,W3);
 
    // Convert the vector through the Rotation-Matrix
    xr1 = (M[0][0] * x1 + M[1][0]*y1 + M[2][0]*z1)/MUL;
    yr1 = (M[0][1] * x1 + M[1][1]*y1 + M[2][1]*z1)/MUL;
    xr2 = (M[0][0] * x2 + M[1][0]*y2 + M[2][0]*z2)/MUL;
    yr2 = (M[0][1] * x2 + M[1][1]*y2 + M[2][1]*z2)/MUL;

    // Draws the line
    if (((xr1+x_Pos)>0)&&((xr2+x_Pos)>0)&&((yr1+y_Pos)>0)&&((yr1+y_Pos)>0))
        lcd_line( xr1 + x_Pos, yr1 + y_Pos, xr2 + x_Pos, yr2 + y_Pos);
}




