// lcdcon.cpp : Definiert den Einsprungpunkt fr die Konsolenanwendung.
//

#include "stdafx.h"
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <time.h>

void writebyte (unsigned char wert)
{
	while (!(_inp(0x379) & 128));
	_outp (0x37A, 2);
	_outp (0x378, wert);
	_outp (0x37A, 3);
	_outp (0x37A, 2);
}

void writecom (unsigned char wert)
{
	while (!(_inp(0x379) & 128));
	_outp (0x37A, 0);
	_outp (0x378, wert);
	_outp (0x37A, 1);
	_outp (0x37A, 0);
}

void setpwm (unsigned char wert)
{
	writecom (2);
	writebyte (wert);
}

void setscroll (unsigned char wert)
{
	writecom (3);
	writebyte (wert);
}

void setcursor (unsigned int x, unsigned int y)
{
	writecom(1);
	writebyte(y%240);
	writebyte((y/240)*128+(x/8));
}

void writetext (char *text)
{
	while (*text)
	{	writecom(192);
		writebyte(*text++);
	}
}

void loadbmp(char *file, unsigned int xp, unsigned int yp)
{	unsigned int x, y, i, xsize,ysize,farbe,farben,daten;
	char buffer[32];
	FILE *fp;

	fp=fopen (file,"rb");

	fread(buffer,1,2,fp);
	if ((buffer[0]!='B')&&(buffer[1]!='M'))		//Windows BMP Datei ?
	{	fclose(fp);
		return;
	}

	fread(buffer,1,16,fp);

	fread(&xsize,4,1,fp);	//Breite
	fread(&ysize,4,1,fp);	//Hhe

	fread(buffer,1,2,fp);
	fread(&farbe,2,1,fp);	//Farbe
	fread(buffer,1,4,fp);	//Compression

	fread(&daten,4,1,fp);	//Daten

	fread(buffer,1,8,fp);	//Auflsung
	
	fread(&farben,4,1,fp);	//Farben
	
	fread(buffer,1,4,fp);

	if (farben==0)
		farben=1<<farbe;

	for (i=0; i<farben; i++)
		fread(buffer,1,4,fp);

	printf ("Breite : %i\n",xsize);
	printf ("Hhe   : %i\n",ysize);
	printf ("Farben : %i\n",farben);

	for (y=0; y<ysize; y++)
	{
		setcursor (xp,ysize-1-y+yp);
		for (x=0; x<(xsize/8); x++)
			writebyte (fgetc(fp));
		while (x&3)
		{	fread(buffer,1,1,fp);
			x++;
		}
	}
	fclose(fp);
}

int main(int argc, char* argv[])
{	unsigned int x, y;
	unsigned int frames, zeit;

	setpwm(75);							//Kontrast einstellen

	for (y=0; y<480; y++)				//Schachbrettmuster erzeugen
	{
		setcursor (0, y);
		for (x=0; x<125; x++)
		{if (((y/2)&1))
				writebyte (204);
			else
				writebyte (51);
		}
	}

	loadbmp ("F:\\lcdavi\\player560330.bmp", 32,50);

FILE *fp;

#define XSize	560
#define YSize	315

#define Filename "F:\\lcdavi\\cw2.vid"

	setcursor (200,60);
	writetext (Filename);

unsigned char datei[XSize*YSize/8];
unsigned int vzeit;
unsigned char xpos=0;
float fps, kbs;

zeit=time(0)-1;
fp=fopen (Filename,"rb");

frames=0;

while (!feof(fp)&&(!kbhit()))			//Daten bis zum Dateiende oder Tastendruck ausgeben
{
	setscroll (xpos++);
	if (xpos>=90)
		xpos=0;

	fread(datei,1,XSize*YSize/8,fp);	//Frame in Puffer einlesen

	vzeit=time(0)-zeit;					//Der ganze Block ist nur Statusausgabe
	fps=(float)frames/vzeit;
	kbs=(float)((XSize/8)+3)*YSize*fps/1024;
	printf ("%4is Frame %6i  %2.2f fps %3.2f kB/s\n", vzeit, frames,fps,kbs);
	frames++;

	for (y=0; y<YSize; y++)				//Der kleine Teil ist die eigentliche Datenausgabe
	{	setcursor ((640-XSize)/2, y+(480-YSize)/2);
		for (x=0; x<(XSize/8); x++)
			writebyte (datei[x+y*(XSize/8)]);
	}
}
	fclose(fp);
	return 0;
}