#include "stdafx.h"
#include "serial.h"
#include "time.h"


HANDLE
  hCom=NULL;

int Serial_Init(char port[], int baud_rate)
	{
	DCB		dcb;
	BOOL	fSuccess;
	COMMTIMEOUTS noblock;

	if(hCom)
		CloseHandle(hCom);

	hCom = CreateFile(
		port,
		GENERIC_READ | GENERIC_WRITE,
		0,             /* comm devices must be opened w/exclusive-access */
		NULL,          /* no security attrs */
		OPEN_EXISTING, /* comm devices must use OPEN_EXISTING */
		0,             /* not overlapped I/O */
		NULL           /* hTemplate must be NULL for comm devices */
		);

	if(hCom == INVALID_HANDLE_VALUE)
    {
    hCom=0;
		return(1);
    }

	fSuccess = GetCommTimeouts(hCom, &noblock);
	noblock.ReadTotalTimeoutConstant = 500;
	noblock.ReadTotalTimeoutMultiplier = MAXDWORD;
	noblock.ReadIntervalTimeout = MAXDWORD;
	fSuccess = SetCommTimeouts(hCom, &noblock);


	fSuccess = GetCommState(hCom, &dcb);
	if(!fSuccess)
    {
    hCom=0;
		return(2);
    }

  	dcb.BaudRate = baud_rate;
	dcb.ByteSize = 8;
	dcb.Parity = NOPARITY;
	dcb.StopBits = ONESTOPBIT;

	dcb.fAbortOnError = FALSE; 
	fSuccess = SetCommState(hCom, &dcb);

	if(!fSuccess)
    {
    hCom=0;
		return(3);
    }

	return(0);
	}

void Uninit_Serial()
  {
	CloseHandle(hCom);
	hCom=NULL;
  }

int ReadByte(void)
	{unsigned char wert;
	 DWORD bytes_read;
	 bytes_read=0;

  if(hCom)
//    {do
	  {if(TRUE!=ReadFile(
				hCom,				// handle of file to write to
				&wert,      		// address of data to write to file
				1,              	// number of bytes to write
				&bytes_read,		// address of number of bytes written
				NULL))	 		 	// addr. of structure needed for overlapped I/O
			{return -2;	}			// Fehler
//		if ((clock()-zeit)>10)
		if (bytes_read!=1)
			return -1; 
//	  }
//		while (bytes_read!=1);
		
    }	
  else
	return -3;
  return wert;
	}

int SendByte(unsigned char wert)
	{
	DWORD bytes_written;
	bytes_written=0;

  if(hCom)
    {	if(TRUE!=WriteFile(
				hCom,							// handle of file to write to
				&wert,      			// address of data to write to file
				1,              	// number of bytes to write
				&bytes_written,	  // address of number of bytes written
				NULL))	 		 			// addr. of structure needed for overlapped I/O
			{	return -2;	}
		if(bytes_written!=1)
			{return -1;		}
    }	
  else
  	return -3;
  return 0;
	}

int SendString(char *data)
  {int feedback;
  while(*data)
    feedback=SendByte(*data++);
  return feedback;
}