#!/bin/bash

# source bootloader linux

args=("$@")

COMMAND=${args[0]}
BUILDDIR=$(pwd)

ROOTDIR=$(pwd)
ADDREPLACEDIR=$ROOTDIR/replaceAdd
TARGETDIR=$ROOTDIR/hdd_board/sda2
LOC_LOGGER=$ROOTDIR/workdir/log_me.sh
WINCEFILE=$ROOTDIR/bootloader/$FINALIMG
export PNX8950_BUILDER_ROOT="$(pwd)"

if [ -f $PNX8950_BUILDER_ROOT/.config ]; then
	source $PNX8950_BUILDER_ROOT/.config
else
	echo "Fehler: .config nicht gefunden"
	exit 1
fi

# ----------------- Funktionen -------------------------------------------------------------

function do_cmd {
    $1

    if [ $? = 1 ]; then
		$LOC_LOGGER "write" "Fehler: $1"
		exit 1
    fi
    }

function do_checksize {
	LOC_FILESIZE=$(du $1 | cut -d'/' -f1)
	#LOC_FILESIZE=$(stat -c %s $1)
	echo "-----------------------------------------------------------------"
	
	if [ $LOC_FILESIZE -gt 50000000 ]; then
		echo " !!!! WARNUNG: Flashimage zu gro -> $LOC_FILESIZE KB"
		echo "               nicht in den NAND flashen"
	else
	#	echo " Flashimages grer 50000 nicht flashen !!!"
		echo " Filesize von WinCe1.nb0 ist $LOC_FILESIZE KB"
	fi	
	echo ""
	echo " Grenberechnung geht noch nicht !!!!"
	echo " fertig"
	echo "-----------------------------------------------------------------"
	echo "-----------------------------------------------------------------"
    }
	

# ----------------- Auswertung -------------------------------------------------------------

if [ $# -eq 0 ] ; then
	echo ""
	echo "--------------------------------"
    echo "PNX8950-Flashbuilder - Anwendung"
	echo "--------------------------------"
	echo "./build.sh {source|bootloader|linux}"
	echo " -> keine 'Mehrfach'-Argumente <-"
	echo ""
	echo " source		Erstinitialisierung"
	echo " bootloader 	Baut/Aktualisiert u-boot im Flashimage"
	echo " linux 		Kompiliert und Aktualisiert das Linux im Flashimage"
	echo " distclean	Lscht alle Image-Files und subert das Workdir"
	echo "--------------------------------"
	echo ""
    exit 0
fi

# ----------------- source -------------------------------------------------------------

if [ $COMMAND = 'source' ]; then

	cd $BUILDDIR
	
	# Check Umgebung
	do_cmd "$BUILDDIR/workdir/check_me.sh"

	# neues Log schreiben
	$LOC_LOGGER "start" "dummy"
	$LOC_LOGGER "write" "Baue Verzeichnisse neu auf"
	$LOC_LOGGER "write" "--------------------------"

	rm -r $BUILDDIR/bootloader
	mkdir bootloader
	rm -r $BUILDDIR/hdd_board/sda1
	mkdir hdd_board/sda1
	rm -r $BUILDDIR/hdd_board/sda2
	mkdir hdd_board/sda2
	
	cd $BUILDDIR/workdir
	$LOC_LOGGER "write" "get_source: Download Sourcen (wenn nicht vorhanden)"
	do_cmd "$BUILDDIR/workdir/get_source.sh"
	
	$LOC_LOGGER "write" "build_initial: Erst-/Neuinstallation"
	do_cmd "$BUILDDIR/workdir/build_initial.sh"

	# NAND-Image wird bei Ersterstellung immer erstellt und bereitgestellt
	echo "[Linux] NAND-Image wurde erstellt"
	$LOC_LOGGER "write" "Kopiere usb-Files nach bootloader"
	cp $BUILDDIR/workdir/dUSB/*.* $BUILDDIR/bootloader/

	$LOC_LOGGER "write" "Kopiere rootfs (bitte Geduld)"
	echo "Kopiere rootfs (bitte Geduld)"
	cp -R $BUILDDIR/workdir/dHarddisk/* $BUILDDIR/hdd_board/sda2
	
	# Soll das HDD-Image kopiert werden
	if [ -z $UCONF_SATA_IMAGE ]; then
		echo "[Linux] kein SATA-Image erstellt"
		$LOC_LOGGER "write" "[Linux] SATA Image wurde nicht erstellt"
	else
		echo "[Linux] SATA-Image wurde erstellt"
		$LOC_LOGGER "write" "[Linux] SATA Image wurde erstellt und wird nun kopiert"
		mkdir $BUILDDIR/hdd_board/sda1
		cp $BUILDDIR/workdir/dHarddisk/boot/uImage $BUILDDIR/hdd_board/sda1/
	fi		
	
	# Austausch bzw. kopieren der angepassten Files nach linux
	cd $ADDREPLACEDIR

	if [ -d linux ]; then
	  for FILE in `find linux/* -print | sort`; do
		DEST=$TARGETDIR/${FILE#}
		  if [ -f $FILE -a ! -e ${DEST} ]; then
			FILE=${FILE/linux/} # replace first match
			DEST=$TARGETDIR$FILE
			$LOC_LOGGER "write" "rootfs Ersetzung: Copy File $FILE"
			echo "Copy File $FILE"
			cp $ADDREPLACEDIR/linux/$FILE $DEST
		  elif [ -d $FILE -a ! -e ${DEST} ]; then
			FILE=${FILE/linux/} # replace first match
			DEST=$TARGETDIR$FILE
			if [ -d $DEST ]; then
				$LOC_LOGGER "write" "rootfs Ersetzung: Directory $FILE ok"
				echo "Dir OK: $FILE"
			else
				$LOC_LOGGER "write" "rootfs Ersetzung: Create Directory $FILE"
				echo "Create Dir: $FILE"
				mkdir -p $DEST
			fi
		  fi
		done
	fi
	
	# PollinHDD.tar.gz erstellen
	if [ -d $TARGETDIR ]; then
		$LOC_LOGGER "write" "PollinHDD.tar.gz wird erstellt"
		echo "PollinHDD.tar.gz wird erstellt"
		
		# ins Verzeichnis wechseln
		cd $TARGETDIR
		# packen 
		 tar cfvz PollinHDD.tar.gz *
		# verschieben
		mv $TARGETDIR/PollinHDD.tar.gz $ROOTDIR/hdd_board/PollinHDD.tar.gz
	else
		$LOC_LOGGER "write" "PollinHDD.tar.gz konnte nicht erstellt werden, Verzeichnis sda2 nicht vorhanden"
		echo "PollinHDD.tar.gz konnte nicht erstellt werden, Verzeichnis sda2 nicht vorhanden"
	fi
	
	# Check, ob das File berhaupt in das NAND passt, wenn nicht, Warnung ausgeben
	do_checksize "$WINCEFILE"

# ----------------- bootloader -------------------------------------------------------------
	
else 
	if [ $COMMAND = 'bootloader' ]; then
		$LOC_LOGGER "write" "./build.sh bootloader"
		$LOC_LOGGER "write" "---------------------"
		$LOC_LOGGER "write" "Baue Verzeichnisse neu auf"
		rm -r $BUILDDIR/bootloader
		mkdir bootloader
		cd $BUILDDIR/workdir
		$LOC_LOGGER "write" "rebuild_bootloader: Starte Kompilierung"
		do_cmd "$BUILDDIR/workdir/rebuild_bootloader.sh"
		$LOC_LOGGER "write" "Kopiere neue USB-Files"
		cp $BUILDDIR/workdir/dUSB/*.* $BUILDDIR/bootloader/
		
		# Check, ob das File berhaupt in das NAND passt, wenn nicht, Warnung ausgeben
		do_checksize "$WINCEFILE"

# ----------------- linux -------------------------------------------------------------		

	else 
		if [ $COMMAND = 'linux' ]; then
			$LOC_LOGGER "write" "./build.sh linux"
			$LOC_LOGGER "write" "----------------"
			$LOC_LOGGER "write" "Baue Verzeichnisse neu auf"
			#rm -r $BUILDDIR/hdd_board
			#mkdir hdd_board
			#mkdir hdd_board/boot
			cd $BUILDDIR/workdir
			$LOC_LOGGER "write" "rebuild_linux: Starte Kompilierung"
			do_cmd "$BUILDDIR/workdir/rebuild_linux.sh"
			
			# Soll das NAND-Image kopiert werden
			if [ -z $UCONF_NAND_IMAGE ]; then
				$LOC_LOGGER "write" "[Linux] kein NAND-Image erstellt"
				echo "[Linux] kein NAND-Image erstellt"
			else
				$LOC_LOGGER "write" "[Linux] NAND-Image wurde erstellt"
				echo "[Linux] NAND-Image wurde erstellt"
				cp $BUILDDIR/workdir/dUSB/*.* $BUILDDIR/bootloader/
			fi

			# Soll das HDD-Image kopiert werden
			if [ -z $UCONF_SATA_IMAGE ]; then
				$LOC_LOGGER "write" "[Linux] kein SATA-Image erstellt"
				echo "[Linux] kein SATA-Image erstellt"
			else
				$LOC_LOGGER "write" "[Linux] SATA-Image wurde erstellt"
				echo "[Linux] SATA-Image wurde erstellt"
				cp $BUILDDIR/workdir/dHarddisk/boot/uImage $BUILDDIR/hdd_board/sda1/
			fi			
			
			$LOC_LOGGER "write" "Kopiere neues rootfs"
			
			cp $BUILDDIR/workdir/dHarddisk/*.* $BUILDDIR/hdd_board/sda2/
			
			# Austausch bzw. kopieren der angepassten Files nach linux
			cd $ADDREPLACEDIR

			if [ -d linux ]; then
			  for FILE in `find linux/* -print | sort`; do
				DEST=$TARGETDIR/${FILE#}
				  if [ -f $FILE -a ! -e ${DEST} ]; then
					FILE=${FILE/linux/} # replace first match
					DEST=$TARGETDIR$FILE
					$LOC_LOGGER "write" "rootfs: Copy File $FILE"
					echo "Copy File $FILE"
					cp $ADDREPLACEDIR/linux/$FILE $DEST
				  elif [ -d $FILE -a ! -e ${DEST} ]; then
					FILE=${FILE/linux/} # replace first match
					DEST=$TARGETDIR$FILE
					if [ -d $DEST ]; then
						$LOC_LOGGER "write" "rootfs: Dir OK: $FILE"
						echo "Dir OK: $FILE"
					else
						$LOC_LOGGER "write" "rootfs: Create Dir: $FILE"
						echo "Create Dir: $FILE"
						mkdir -p $DEST
					fi
				  fi
				done
			fi
			
			# PollinHDD.tar.gz erstellen
			if [ -d $TARGETDIR ]; then
				$LOC_LOGGER "write" "PollinHDD.tar.gz wird erstellt"
				echo "PollinHDD.tar.gz wird erstellt"
				
				# ins Verzeichnis wechseln
				cd $TARGETDIR
				# packen 
				 tar cfvz PollinHDD.tar.gz *
				# verschieben
				mv $TARGETDIR/PollinHDD.tar.gz $ROOTDIR/hdd_board/PollinHDD.tar.gz
			else
				$LOC_LOGGER "write" "PollinHDD.tar.gz konnte nicht erstellt werden, Verzeichnis sda2 nicht vorhanden"
				echo "PollinHDD.tar.gz konnte nicht erstellt werden, Verzeichnis sda2 nicht vorhanden"
			fi
			
			# Check, ob das File berhaupt in das NAND passt, wenn nicht, Warnung ausgeben
			do_checksize "$WINCEFILE"			

# ----------------- distclean -------------------------------------------------------------
			
		else 
			if [ $COMMAND = 'distclean' ]; then
				$LOC_LOGGER "write" "./build.sh distclean"
				$LOC_LOGGER "write" "--------------------"
				$LOC_LOGGER "write" "Baue Verzeichnisse neu auf"
				
				cd $BUILDDIR
				rm -r $BUILDDIR/bootloader
				mkdir bootloader
				rm -r $BUILDDIR/hdd_board/sda1
				mkdir hdd_board/sda1
				rm -r $BUILDDIR/hdd_board/sda2
				mkdir hdd_board/sda2
				rm $BUILDDIR/hdd_board/PollinHDD.tar.gz
				cd $BUILDDIR/workdir
				do_cmd "$BUILDDIR/workdir/clear_me.sh"
				
# ----------------- rescue -------------------------------------------------------------
				
			else 
				if [ $COMMAND = 'rescue' ]; then
					$LOC_LOGGER "write" "./build.sh rescue"
					$LOC_LOGGER "write" "---------------------"
					$LOC_LOGGER "write" "Baue Verzeichnisse neu auf"
					rm -r $BUILDDIR/bootloader
					mkdir bootloader
					cd $BUILDDIR/workdir
					$LOC_LOGGER "write" "rebuild_rescue: Fge Rescue-Image neu hinzu"
					do_cmd "$BUILDDIR/workdir/rebuild_rescue.sh"
					$LOC_LOGGER "write" "Kopiere neue USB-Files"
					cp $BUILDDIR/workdir/dUSB/*.* $BUILDDIR/bootloader/
					
					# Check, ob das File berhaupt in das NAND passt, wenn nicht, Warnung ausgeben
					do_checksize "$WINCEFILE"
				else 
				
# ----------------- check -------------------------------------------------------------
				
					if [ $COMMAND = 'check' ]; then
						do_cmd "$BUILDDIR/workdir/check_me.sh"

# ----------------- wrong arg -------------------------------------------------------------

					else 
						echo ""
						echo "--------------------------------"
						echo "PNX8950-Flashbuilder - Anwendung"
						echo "Error - wrong argument"
						echo "--------------------------------"
						echo "./build.sh {source|bootloader|linux}"
						echo " -> keine 'Mehrfach'-Argumente <-"
						echo ""
						echo " source		Erstinitialisierung"
						echo " bootloader 	Baut/Aktualisiert u-boot im Flashimage"
						echo " linux 		Kompiliert und Aktualisiert das Linux im Flashimage"
						echo " distclean	Lscht alle Image-Files und subert das Workdir"
						echo "--------------------------------"
						echo ""
					fi
				fi 
			fi 
		fi 
	fi 
fi 
