#!/bin/bash

# -------------------------------------------------------- Settings -----------------------------------------------

if [ -f $PNX8950_BUILDER_ROOT/.config ]; then
	source $PNX8950_BUILDER_ROOT/.config

	# Directorys for build flashimage
	ROOTDIR=$PNX8950_BUILDER_ROOT/workdir
	WORKDIR=$ROOTDIR/dWork
	SOURCEDIR=$ROOTDIR/dSource
	PATCHDIR=$ROOTDIR/dPatch
	USBDIR=$ROOTDIR/dUSB
	HDDDIR=$ROOTDIR/dHarddisk
	BOOTDIR=$HDDDIR/boot
	PREDIR=$ROOTDIR/dPrebuild
	LOC_LOGGER=$PNX8950_BUILDER_ROOT/workdir/log_me.sh

	# Files for build flashimage
	LINUXBIN='vmlinux'

	# Buildconfig
	RESCUEMK=mk_$RESCUEBIN
	LINUXMK=mk_$LINUXBIN
	LOC_DD_BS='bs=1M'

	# -------------------------------------------------------- u-boot -------------------------------------------------
	#  u-boot Source ins work-Verzeichnis entpacken
	$LOC_LOGGER "write" " u-boot -> Entpacken"
	cd $WORKDIR
	tar xfvj $SOURCEDIR/$UBOOTFILE.tar.bz2
	cd $WORKDIR/$UBOOTFILE

	# Patch fr u-boot fahren
	$LOC_LOGGER "write" " u-boot -> Patch einspielen"
	patch -p1 < $PATCHDIR/$UBOOTPATCH

	# Standard Config sichern
	$LOC_LOGGER "write" " u-boot -> Backup Original-Config"
	cp $WORKDIR/$UBOOTFILE/include/configs/silverbox.h $WORKDIR/$UBOOTFILE/include/configs/silverbox.orig

	# Binde die User Config ein
	$LOC_LOGGER "write" " u-boot -> Ersetze Vars durch UCONF_UBOOT_* Vars"
	cd $ROOTDIR
	$ROOTDIR/set_vars_u-boot.sh
	cd $WORKDIR/$UBOOTFILE

	# u-boot bauen
	$LOC_LOGGER "write" " u-boot -> make silverbox_config"
	make silverbox_config
	$LOC_LOGGER "write" " u-boot -> make"
	make
	
	# u-boot.bin vorhanden ?
	if [ -f $WORKDIR/$UBOOTFILE/u-boot.bin ]; then
		$LOC_LOGGER "write" " u-boot -> Check u-boot.bin ok"
		echo "Check u-boot.bin ok"
	else
		$LOC_LOGGER "write" " u-boot -> Check u-boot.bin failed"
		echo "Check u-boot.bin failed"
		exit 1
	fi

	# -------------------------------------------------------- linux -----------------------------------------------------

	# erstelle Linux Image fr "normalen" Start
	$LOC_LOGGER "write" " linux -> Entpacke Linuxarchiv"
	cd $WORKDIR
	tar xfvz $SOURCEDIR/$LINUXSOURCE.tar.gz
	cd $WORKDIR/$LINUXSOURCE

	# Patch fr linux fahren
	$LOC_LOGGER "write" " linux -> Patch einspielen"
	patch -p1 < $PATCHDIR/$LINUXPATCH

	# config kopieren
	$LOC_LOGGER "write" " linux -> kopieren von $LINUXCONF nach .config"
	cp $PATCHDIR/$LINUXCONF .config
	make oldconfig
	make oldconfig

	# Standard config sichern
	$LOC_LOGGER "write" " linux -> .config Arbeitskopie erstellen"
	cp .config .config.orig

	# Binde die User Config ein
	$LOC_LOGGER "write" " linux -> Ersetzung Vars durch UCONF_LINUX* Vars"
	cd $ROOTDIR
	$ROOTDIR/set_vars_linux.sh
	cd $WORKDIR/$LINUXSOURCE
	
	# .config (also linux) vorhanden ?
	if [ -f $WORKDIR/$LINUXSOURCE/.config ]; then
		$LOC_LOGGER "write" " linux -> Check .config ok"
		echo "Check linux .config ok"
	else
		$LOC_LOGGER "write" " linux -> Check .config failed"
		echo "Check linux .config failed"
		exit 1
	fi

	# linux bauen
	$LOC_LOGGER "write" " linux -> make"
	make
	$LOC_LOGGER "write" " linux -> make modules"
	make modules
	
	# vmlinux vorhanden ?
	if [ -f $WORKDIR/$LINUXSOURCE/vmlinux ]; then
		$LOC_LOGGER "write" " linux -> Check vmlinux ok"
		echo "Check linux vmlinux ok"
	else
		$LOC_LOGGER "write" " linux -> Check vmlinux failed"
		echo "Check linux vmlinux failed"
		exit 1
	fi

	cd $WORKDIR

	# -------------------------------------------------------- verheiraten -----------------------------------------------
	# u-boot + prebuild rescue-image (buildroot) + linux-start-image = pnx8950-bootloader
	# Adressen
	#   u-boot    0x80100000        (ca. 260 kB) + Puffer (~ 5MB)
	#   rescue    0x805E2000        (ca. 15 MB) + Puffer
	#   linux     0x81500000       	(ca. 10 MB)
	# Erstelle Files fr USB-Update
	# Container erstellen mittels dd - Gre 20 MB
	
	# rescue-bin vorhanden ?
	if [ -f $PREDIR/$RESCUEBIN ]; then
		$LOC_LOGGER "write" " Rescue -> Check $RESCUEBIN ok"
		echo "Check Rescue $RESCUEBIN ok"
	else
		$LOC_LOGGER "write" " Rescue -> Check $RESCUEBIN failed"
		echo "Check Rescue $RESCUEBIN failed"
		exit 1
	fi
	
	echo "-----------------------------------------------"
	echo "Loadadressen und Kernel-Entry-Points ermitteln"
	echo "----------------------------------------------"
	$LOC_LOGGER "write" "  Heirat -> Loadadressen und Kernel-Entry-Points ermitteln"
	# Loadadresse ermitteln fr Rescue
	LOADADRESS_RESCUE=$(readelf -l $PREDIR/$RESCUEBIN | grep LOAD | cut -d' ' -f15)
	echo "Loadadress Rescue: " $LOADADRESS_RESCUE
	$LOC_LOGGER "write" "  Heirat -> Loadadress Rescue: $LOADADRESS_RESCUE"

	# kernel-entry-point ermitteln fr Rescue
	ENTRYADRESS_RESCUE=$(readelf -l $PREDIR/$RESCUEBIN | grep Entry | cut -d' ' -f3)
	echo "Entry-Point Rescue: " $ENTRYADRESS_RESCUE
	$LOC_LOGGER "write" "  Heirat -> Entry-Point Rescue: $ENTRYADRESS_RESCUE"

	# Loadadresse ermitteln fr Linux
	LOADADRESS_LINUX=$(readelf -l $WORKDIR/$LINUXSOURCE/$LINUXBIN | grep LOAD | cut -d' ' -f15)
	echo "Loadadress Linux: " $LOADADRESS_LINUX
	$LOC_LOGGER "write" "  Heirat -> Loadadress Linux: $LOADADRESS_LINUX"

	# kernel-entry-point ermitteln fr Linux
	ENTRYADRESS_LINUX=$(readelf -l $WORKDIR/$LINUXSOURCE/$LINUXBIN | grep Entry | cut -d' ' -f3)
	echo "Entry-Point Linux: " $ENTRYADRESS_LINUX
	$LOC_LOGGER "write" "  Heirat -> Entry-Point Linux: $ENTRYADRESS_LINUX"

	echo "-----------------------------------------------"
	$LOC_LOGGER "write" "  Heirat -> Lsche $USBDIR/$FINALIMG"
	rm $USBDIR/$FINALIMG

	echo "Dummy File wird erstellt"
	echo "------------------------"
	$LOC_LOGGER "write" "  Heirat -> Erstelle Dummy-Container fr Flashimage (USB)"
	dd if=/dev/zero of=$USBDIR/$FINALIMG bs=1M count=20

	echo "-----------------------------------------------"
	
	# Check Dummy-Container vorhanden
	if [ -f $USBDIR/$FINALIMG ]; then
		$LOC_LOGGER "write" " Flashimage -> Check $FINALIMG ok"
		echo " Flashimage -> Check $FINALIMG ok"
	else
		$LOC_LOGGER "write" " Flashimage -> Check $FINALIMG failed"
		echo " Flashimage -> Check $FINALIMG failed"
		exit 1
	fi

	# u-boot berfhren
	echo "Verarbeitung u-boot"
	echo "-------------------"
	$LOC_LOGGER "write" "  Heirat -> Dumpe u-boot in Dummy-Container"
	dd if=$WORKDIR/$UBOOTFILE/u-boot.bin of=$USBDIR/$FINALIMG conv=notrunc bs=1

	echo "-----------------------------------------------"

	# rescue-image berfhren
	echo "Verarbeitung Rescue-Image"
	echo "-------------------------"
	echo "Konvertierung von " $RESCUEBIN
	$LOC_LOGGER "write" "  Heirat -> Konvertierung von $RESCUEBIN"
	$MIPSOBJ -O binary $PREDIR/$RESCUEBIN $WORKDIR/$RESCUEBIN.bin

	echo "-----------------------------------------------"

	
	# TEST 2011.2 >>>
	# Soll das Rescue komprimiert werden?
	if [ -z $TEST_USE_GZIP ]; then
		# bootbares Image fr u-boot erstellen
		echo "mkimage Rescue"
		$LOC_LOGGER "write" " Erstelle bootbares u-boot Image"
		mkimage -A mips -O linux -T kernel -C none -a $LOADADRESS_RESCUE -e $ENTRYADRESS_RESCUE -n 'PNX8xxx-MIPS-Rescue' -d $WORKDIR/$RESCUEBIN.bin $WORKDIR/$RESCUEMK
	else
		# bootbares Image fr u-boot erstellen
		if [ -f $WORKDIR/$RESCUEBIN.bin.gz ]; then
			rm $WORKDIR/$RESCUEBIN.bin.gz
		fi
		
		echo "mkimage Rescue gzip"
		gzip -9 $WORKDIR/$RESCUEBIN.bin
		
		$LOC_LOGGER "write" " Erstelle bootbares u-boot Image"
		mkimage -A mips -O linux -T kernel -C gzip -a $LOADADRESS_RESCUE -e $ENTRYADRESS_RESCUE -n 'PNX8xxx-MIPS-Rescue-gzip' -d $WORKDIR/$RESCUEBIN.bin.gz $WORKDIR/$RESCUEMK
	fi	
	# TEST 2011.2 <<<	
	
	# TEST 2011.2 ORIGINAL >>>
	# bootbares Image fr u-boot erstellen
	#echo "mkimage Rescue"
	#$LOC_LOGGER "write" "  Heirat -> Erstelle bootbares u-boot Image von Rescue-Image"
	#mkimage -A mips -O linux -T kernel -C none -a $LOADADRESS_RESCUE -e $ENTRYADRESS_RESCUE -n 'PNX8xxx-MIPS-Rescue' -d $WORKDIR/$RESCUEBIN.bin $WORKDIR/$RESCUEMK
	# TEST 2011.2 <<<	
	
	echo "-----------------------------------------------"
	
	# Check Rescue-Image (uBoot) vorhanden
	if [ -f $WORKDIR/$RESCUEMK ]; then
		$LOC_LOGGER "write" " $RESCUEMK -> Check $RESCUEMK ok"
		echo " $RESCUEMK -> Check $RESCUEMK ok"
	else
		$LOC_LOGGER "write" " $RESCUEMK -> Check $RESCUEMK failed"
		echo " $RESCUEMK -> Check $RESCUEMK failed"
		exit 1
	fi
	

	echo "Verarbeitung Rescue-Image (bitte Geduld)"
	echo "----------------------------------------"
	$LOC_LOGGER "write" "  Heirat -> Dumpe Rescue-Image in Dummy-Container (bitte Geduld)"
	dd if=$WORKDIR/$RESCUEMK of=$USBDIR/$FINALIMG conv=notrunc bs=1 seek=5000K

	echo "-----------------------------------------------"

	# linux-image berfhren
	echo "Verarbeitung Linux-Image"
	echo "------------------------"
	echo "Konvertierung von " $LINUXBIN
	$LOC_LOGGER "write" "  Heirat -> Konvertierung von $LINUXBIN"
	$MIPSOBJ -O binary $WORKDIR/$LINUXSOURCE/$LINUXBIN $WORKDIR/$LINUXBIN.bin

	echo "-----------------------------------------------"

	# bootbares Image fr u-boot erstellen
	echo "mkimage Linux-Image"
	$LOC_LOGGER "write" "  Heirat -> Erstelle bootbares u-boot Image von Linux-Image"
	mkimage -A mips -O linux -T kernel -C none -a $LOADADRESS_LINUX -e $ENTRYADRESS_LINUX -n 'PNX8xxx-MIPS-Linux' -d $WORKDIR/$LINUXBIN.bin $WORKDIR/$LINUXMK

	echo "-----------------------------------------------"

	# Check Linux-Image (uBoot) vorhanden
	if [ -f $WORKDIR/$LINUXMK ]; then
		$LOC_LOGGER "write" " $LINUXMK -> Check $LINUXMK ok"
		echo " $LINUXMK -> Check $LINUXMK ok"
	else
		$LOC_LOGGER "write" " $LINUXMK -> Check $LINUXMK failed"
		echo " $LINUXMK -> Check $LINUXMK failed"
		exit 1
	fi

	echo "Verarbeitung Linux-Image (bitte Geduld)"
	echo "---------------------------------------"
	$LOC_LOGGER "write" "  Heirat -> Dumpe Linux-Image in Dummy-Container (bitte Geduld)"
	dd if=$WORKDIR/$LINUXMK of=$USBDIR/$FINALIMG conv=notrunc bs=1 seek=20M

	# -------------------------------------------------------- usb update files ------------------------------------------

	# zustzliche Dummy-Files fr das Firmwareupdate (per Original-Firmware) erstellen
	echo "Dummy-Files fr USB-Stick erstellen"
	echo "-----------------------------------"
	$LOC_LOGGER "write" "  USB -> Erstelle Dummy-Files"

	# flashing.txt
	$LOC_LOGGER "write" "  USB -> Erstelle flashing.txt"
	touch $USBDIR/flashing.txt
	echo "mode 1" > $USBDIR/flashing.txt

	# phStbRootApp_256M_0_t.mi
	$LOC_LOGGER "write" "  USB -> Erstelle phStbRootApp_256M_0_t.mi"
	dd if=/dev/urandom of=$USBDIR/phStbRootApp_256M_0_t.mi bs=1k count=150

	# phStbRootApp_256M_1_t.mi
	$LOC_LOGGER "write" "  USB -> Erstelle phStbRootApp_256M_1_t.mi"
	dd if=/dev/urandom of=$USBDIR/phStbRootApp_256M_1_t.mi bs=1k count=150

	# -------------------------------------------------------- rootfs -------------------------------------------------------
	echo "Rootfs erstellen, pacthen, anpassen"
	echo "-----------------------------------"
	$LOC_LOGGER "write" "  ROOTFS -> Erstelle rootfs"

	echo "Verarbeitung rootfs "
	echo "--------------------"

	# ins workdir
	cd $WORKDIR

	# entpacke pollinux
	echo "Entpacken..."
	echo "------------"
	$LOC_LOGGER "write" "  ROOTFS -> Enpacken von $POLLINUXFILE.tar.gz"
	tar xvf $SOURCEDIR/$POLLINUXFILE.tar.gz

	# Test 2011.3 >>>
	# Partitionen werden direkt kopiert
	# fr die Zukunft schon mal ein Verteichnis /opt/pollin anlegen
	$LOC_LOGGER "write" "  ROOTFS -> Lege Verzeichnis /opt/pollin/ an"
	mkdir $WORKDIR/$POLLINUXFILE/nandfs/opt/pollin
	
	# Kopiere nandfs.user
	$LOC_LOGGER "write" "  ROOTFS -> kopiere nandfs.user"
	echo " Kopiere nandfs.user"
	cp -R $WORKDIR/$POLLINUXFILE/nandfs.user/* $WORKDIR/$POLLINUXFILE/nandfs/usr/local/
	
	# Kopiere nandfs.config
	$LOC_LOGGER "write" "  ROOTFS -> kopiere nandfs.config"
	echo " Kopiere nandfs.config"
	cp -R $WORKDIR/$POLLINUXFILE/nandfs.config/* $WORKDIR/$POLLINUXFILE/nandfs/config/
	
	# Kopiere nandfs.profile
	$LOC_LOGGER "write" "  ROOTFS -> kopiere nandfs.profile"
	echo " Kopiere nandfs.profile"
	cp -R $WORKDIR/$POLLINUXFILE/nandfs.config/* $WORKDIR/$POLLINUXFILE/nandfs/profile/
	# Test 2011.3 <<<
	
	# TEST 2011.3 ORIGINAL >>>
	# Anmerkung: loop Devices lassen sich nicht einbinden -> vermutlich buildroot bug?!
	# erstelle Verzeichnis im nandfs fr die LOOP Devices
	#$LOC_LOGGER "write" "  ROOTFS -> Lege Verzeichnis fr LOOP-Devices an /opt/pollin/"
	#mkdir $WORKDIR/$POLLINUXFILE/nandfs/opt/pollin

	# erstelle loop device fr .user	(500 MB, nandfs.user)
	#echo "-----------------------------------"
	#echo "Erstellung LOOP-Device .user"
	#echo "----------------------------"
	#$LOC_LOGGER "write" "  ROOTFS -> Erstelle LOOP-Device loop.user Size $UCONF_LOOP_USER"
	#dd if=/dev/zero of=$WORKDIR/$POLLINUXFILE/nandfs/opt/pollin/loop.user $LOC_DD_BS count=$UCONF_LOOP_USER

	# erstelle loop device fr .config	(100 MB, leer)
	#echo "-----------------------------------"
	#echo "Erstellung LOOP-Device .config"
	#echo "------------------------------"
	#$LOC_LOGGER "write" "  ROOTFS -> Erstelle LOOP-Device loop.config Size $UCONF_LOOP_CONFIG"
	#dd if=/dev/zero of=$WORKDIR/$POLLINUXFILE/nandfs/opt/pollin/loop.config $LOC_DD_BS count=$UCONF_LOOP_CONFIG

	# erstelle loop device fr .profile	(100 MB, leer)
	#echo "-----------------------------------"
	#echo "Erstellung LOOP-Device .profile"
	#echo "-------------------------------"
	#$LOC_LOGGER "write" "  ROOTFS -> Erstelle LOOP-Device loop.profile Size $UCONF_LOOP_PROFILE"
	#dd if=/dev/zero of=$WORKDIR/$POLLINUXFILE/nandfs/opt/pollin/loop.profile $LOC_DD_BS count=$UCONF_LOOP_PROFILE
	# TEST 2011.3 ORIGINAL <<<

	echo "-----------------------------------"
	echo "Patche rootfs"
	echo "-------------"
	$LOC_LOGGER "write" "  ROOTFS -> Patche einspielen..."
	# Patch fr Loop Devices usw. einspielen
	cd $WORKDIR/$POLLINUXFILE
	$LOC_LOGGER "write" "  ROOTFS ->  $POLLINUX_PATCH_LOOP_1"
	patch -p1 < $PATCHDIR/$POLLINUX_PATCH_LOOP_1
	$LOC_LOGGER "write" "  ROOTFS ->  $POLLINUX_PATCH_NET_1"
	patch -p1 < $PATCHDIR/$POLLINUX_PATCH_NET_1
	$LOC_LOGGER "write" "  ROOTFS ->  $POLLINUX_PATCH_LOCAL_1"
	patch -p1 < $PATCHDIR/$POLLINUX_PATCH_LOCAL_1
	$LOC_LOGGER "write" "  ROOTFS ->  $POLLINUX_PATCH_USER_1"
	patch -p1 < $PATCHDIR/$POLLINUX_PATCH_USER_1

	# nach dHarddisk
	$LOC_LOGGER "write" "  ROOTFS -> Kopiere Grund-Rootfs nach $HDDDIR"
	cp -R $WORKDIR/$POLLINUXFILE/nandfs/* $HDDDIR
	
	# Soll das HDD-Image bereitgestellt werden ?
	if [ -z $UCONF_SATA_IMAGE ]; then
		$LOC_LOGGER "write" "  Heirat -> Linux-Image SATA wird nicht bereit gestellt"
	else
		$LOC_LOGGER "write" "  Heirat -> Bereitstellung SATA Linux-Image uImage"
		cp $WORKDIR/$LINUXMK $BOOTDIR/uImage
	fi	
	
	$LOC_LOGGER "write" " fertig"
	exit 0

else
	exit 1
fi
