#!/bin/bash

# Download der bentigten Sourcen

if [ -f $PNX8950_BUILDER_ROOT/.config ]; then
	source $PNX8950_BUILDER_ROOT/.config

	ROOTDIR=$PNX8950_BUILDER_ROOT/workdir
	SOURCEDIR=$ROOTDIR/dSource
	PREDIR=$ROOTDIR/dPrebuild
	PATCHDIR=$ROOTDIR/dPatch
	LOC_LOGGER=$PNX8950_BUILDER_ROOT/workdir/log_me.sh

	$LOC_LOGGER "write" " Wechsel nach $SOURCEDIR"
	cd $SOURCEDIR

	# Download u-boot
	$LOC_LOGGER "write" " Download u-boot"
	wget -N $UCONF_WGET_UBOOT

	# Download linux
	$LOC_LOGGER "write" " Download linux"
	wget -N $UCONF_WGET_LINUX

	# Download pollinux.tar.gz
	$LOC_LOGGER "write" " Download pollinux"
	wget -N $UCONF_WGET_POLLINUX

	
	# check ob Sourcen vorhanden
	if [ -f $SOURCEDIR/$UBOOTFILE.tar.bz2 ]; then
		echo " Check Source u-boot ok"
		$LOC_LOGGER "write" " Check Source u-boot ok"
	else
		echo " Check Source u-boot failed"
		$LOC_LOGGER "write" " Check Source u-boot failed"
		exit 1
	fi

	if [ -f $SOURCEDIR/$LINUXSOURCE.tar.gz ]; then
		echo " Check Source linux ok"
		$LOC_LOGGER "write" " Check Source linux ok"
	else
		echo " Check Source linux failed"
		$LOC_LOGGER "write" " Check Source linux failed"
		exit 1
	fi

	# check ob Sourcen vorhanden
	if [ -f $SOURCEDIR/$UBOOTFILE.tar.bz2 ]; then
		echo " Check Source u-boot ok"
		$LOC_LOGGER "write" " Check Source u-boot ok"
	else
		echo " Check Source u-boot failed"
		$LOC_LOGGER "write" " Check Source u-boot failed"
		exit 1
	fi

	if [ -f $SOURCEDIR/$POLLINUXFILE.tar.gz ]; then
		echo " Check Source pollinux ok"
		$LOC_LOGGER "write" " Check Source pollinux ok"
	else
		echo " Check Source pollinux failed"
		$LOC_LOGGER "write" " Check Source pollinux failed"
		exit 1
	fi	
	
	# check Prebuilds
	if [ -f $PREDIR/$RESCUEBIN ]; then
		echo " Check Prebuild $RESCUEBIN ok"
		$LOC_LOGGER "write" " Check Prebuild $RESCUEBIN ok"
	else
		echo " Check Prebuild $RESCUEBIN failed"
		$LOC_LOGGER "write" " Check Prebuild $RESCUEBIN failed"
		exit 1
	fi

	# kein Check der Patch-Files -> evtl. kommt einer hinzu, oder wird nicht verwenden
	$LOC_LOGGER "write" " Check Patch-Files -> derzeit kein Bedarf :-)"
	
	exit 0
else
	exit 1
fi
