#!/bin/bash

if [ -f $PNX8950_BUILDER_ROOT/.config ]; then
	source $PNX8950_BUILDER_ROOT/.config

	# Directorys for build flashimage
	#ROOTDIR=$(pwd)
	ROOTDIR=$PNX8950_BUILDER_ROOT/workdir
	WORKDIR=$ROOTDIR/dWork
	USBDIR=$ROOTDIR/dUSB
	LOC_LOGGER=$PNX8950_BUILDER_ROOT/workdir/log_me.sh

	echo $WORKDIR/$UBOOTFILE

	# -------------------------------------------------------- u-boot -------------------------------------------------
	cd $WORKDIR/$UBOOTFILE

	# u-boot bauen
	$LOC_LOGGER "write" " make clean"
	make clean
	
	# Binde die User Config ein
	$LOC_LOGGER "write" " u-boot -> Ersetze Vars durch UCONF_UBOOT_* Vars"
	cd $ROOTDIR
	$ROOTDIR/set_vars_u-boot.sh
	cd $WORKDIR/$UBOOTFILE
	
	#$LOC_LOGGER "write" " make silverbox_config"
	#make silverbox_config
	$LOC_LOGGER "write" " make"
	make

	echo "-----------------------------------------------"

	# u-boot berfhren
	echo "Verarbeitung u-boot"
	echo "-------------------"
	$LOC_LOGGER "write" " Heirat u-boot mit Dummy-Container"
	dd if=$WORKDIR/$UBOOTFILE/u-boot.bin of=$USBDIR/$FINALIMG conv=notrunc bs=1

	echo "-----------------------------------------------"

	# -------------------------------------------------------- usb update files ------------------------------------------

	# zustzliche Dummy-Files fr das Firmwareupdate (per Original-Firmware) erstellen
	echo "Dummy-Files fr USB-Stick erstellen"
	echo "-----------------------------------"

	# flashing.txt
	$LOC_LOGGER "write" " Erstellung flashing.txt"
	touch $USBDIR/flashing.txt
	echo "mode 1" > $USBDIR/flashing.txt

	# phStbRootApp_256M_0_t.mi
	$LOC_LOGGER "write" " Erstellung phStbRootApp_256M_0_t.mi"
	dd if=/dev/urandom of=$USBDIR/phStbRootApp_256M_0_t.mi bs=1k count=150

	# phStbRootApp_256M_1_t.mi
	$LOC_LOGGER "write" " Erstellung phStbRootApp_256M_1_t.mi"
	dd if=/dev/urandom of=$USBDIR/phStbRootApp_256M_1_t.mi bs=1k count=150
	
	$LOC_LOGGER "write" " fertig"
	exit 0
else
	exit 1
fi
