#!/bin/bash

if [ -f $PNX8950_BUILDER_ROOT/.config ]; then
	source $PNX8950_BUILDER_ROOT/.config

	# Directorys for build flashimage
	#ROOTDIR=$(pwd)
	ROOTDIR=$PNX8950_BUILDER_ROOT/workdir
	WORKDIR=$ROOTDIR/dWork
	USBDIR=$ROOTDIR/dUSB
	HDDDIR=$ROOTDIR/dHarddisk
	BOOTDIR=$HDDDIR/boot
	LOC_LOGGER=$PNX8950_BUILDER_ROOT/workdir/log_me.sh

	# Files for build flashimage
	LINUXBIN='vmlinux'

	# Buildconfig
	LINUXMK=mk_$LINUXBIN

	# -------------------------------------------------------- linux -----------------------------------------------------
	# erstelle Linux Image fr "normalen" Start
	$LOC_LOGGER "write" " Wechsel ins Verzeichnis $WORKDIR/$LINUXSOURCE"
	cd $WORKDIR/$LINUXSOURCE

	# linux bauen
	#$LOC_LOGGER "write" " make clean"
	#make clean 
	$LOC_LOGGER "write" " make"
	make 
	$LOC_LOGGER "write" " make modules"
	make modules

	echo "-----------------------------------------------"
	echo "Loadadresse und Kernel-Entry-Point ermitteln"
	echo "----------------------------------------------"
	
	$LOC_LOGGER "write" " Loadadresse und Kernel-Entry-Point ermitteln"

	# Loadadresse ermitteln fr Linux
	LOADADRESS_LINUX=$(readelf -l $WORKDIR/$LINUXSOURCE/$LINUXBIN | grep LOAD | cut -d' ' -f15)
	$LOC_LOGGER "write" " Loadadress Linux: $LOADADRESS_LINUX"
	echo "Loadadress Linux: " $LOADADRESS_LINUX

	# kernel-entry-point ermitteln fr Linux
	ENTRYADRESS_LINUX=$(readelf -l $WORKDIR/$LINUXSOURCE/$LINUXBIN | grep Entry | cut -d' ' -f3)
	$LOC_LOGGER "write" " Entry-Point Linux: $ENTRYADRESS_LINUX"
	echo "Entry-Point Linux: " $ENTRYADRESS_LINUX

	echo "-----------------------------------------------"
	#$LOC_LOGGER "write" " Delete Files in $USBDIR/$FINALIMG"
	#rm $USBDIR/$FINALIMG


	# linux-image berfhren
	echo "Verarbeitung Linux-Image"
	echo "------------------------"
	echo "Konvertierung von " $LINUXBIN
	$LOC_LOGGER "write" " Konvertierung von $LINUXBIN"
	$MIPSOBJ -O binary $WORKDIR/$LINUXSOURCE/$LINUXBIN $WORKDIR/$LINUXBIN.bin

	echo "-----------------------------------------------"

	# bootbares Image fr u-boot erstellen
	echo "mkimage linux"
	$LOC_LOGGER "write" " Erstelle bootbares u-boot Image"
	mkimage -A mips -O linux -T kernel -C none -a $LOADADRESS_LINUX -e $ENTRYADRESS_LINUX -n 'PNX8xxx-MIPS-Linux' -d $WORKDIR/$LINUXBIN.bin $WORKDIR/$LINUXMK

	echo "-----------------------------------------------"

	echo "Verarbeitung Linux-Image (bitte Geduld)"
	echo "---------------------------------------"
	$LOC_LOGGER "write" " Heirat Linux-Image mit Dummy-Container"
	dd if=$WORKDIR/$LINUXMK of=$USBDIR/$FINALIMG conv=notrunc bs=1 seek=20M

	echo "-----------------------------------------------"
	# -------------------------------------------------------- usb update files ------------------------------------------

	# zustzliche Dummy-Files fr das Firmwareupdate (per Original-Firmware) erstellen
	echo "Dummy-Files fr USB-Stick erstellen"
	echo "-----------------------------------"
	$LOC_LOGGER "write" " USB Dummy-Files erstellen"

	# flashing.txt
	$LOC_LOGGER "write" " Erstelle flashing.txt"
	touch $USBDIR/flashing.txt
	echo "mode 1" > $USBDIR/flashing.txt

	# phStbRootApp_256M_0_t.mi
	$LOC_LOGGER "write" " Erstelle phStbRootApp_256M_0_t.mi"
	dd if=/dev/urandom of=$USBDIR/phStbRootApp_256M_0_t.mi bs=1k count=150

	# phStbRootApp_256M_1_t.mi
	$LOC_LOGGER "write" " Erstelle phStbRootApp_256M_1_t.mi"
	dd if=/dev/urandom of=$USBDIR/phStbRootApp_256M_1_t.mi bs=1k count=150

	# Soll das HDD-Image bereitgestellt werden ?
	if [ -z $UCONF_SATA_IMAGE ]; then
		$LOC_LOGGER "write" "  Heirat -> Linux-Image SATA wird nicht bereit gestellt"
	else
		$LOC_LOGGER "write" "  Heirat -> Bereitstellung SATA Linux-Image uImage"
		cp $WORKDIR/$LINUXMK $BOOTDIR/uImage
	fi	
	
	$LOC_LOGGER "write" " fertig"
	exit 0
else
	exit 1
fi	
