#!/bin/bash

# -------------------------------------------------------- Settings -----------------------------------------------

if [ -f $PNX8950_BUILDER_ROOT/.config ]; then
	source $PNX8950_BUILDER_ROOT/.config

	# Directorys for build flashimage
	#ROOTDIR=$(pwd)
	ROOTDIR=$PNX8950_BUILDER_ROOT/workdir
	WORKDIR=$ROOTDIR/dWork
	USBDIR=$ROOTDIR/dUSB
	PREDIR=$ROOTDIR/dPrebuild
	LOC_LOGGER=$PNX8950_BUILDER_ROOT/workdir/log_me.sh

	# Buildconfig
	RESCUEMK=mk_$RESCUEBIN

	echo "-----------------------------------------------"
	echo "-----------------------------------------------"
	echo " Pollin-Board PNX8xxx Bootloader-Rescue-Builder"
	echo "-----------------------------------------------"
	echo "Loadadressen und Kernel-Entry-Points ermitteln"
	echo "----------------------------------------------"
	$LOC_LOGGER "write" " Loadadressen und Kernel-Entry-Points ermitteln"
	# Loadadresse ermitteln fr Rescue
	LOADADRESS_RESCUE=$(readelf -l $PREDIR/$RESCUEBIN | grep LOAD | cut -d' ' -f15)
	echo "Loadadress Rescue: " $LOADADRESS_RESCUE
	$LOC_LOGGER "write" " Loadadress Rescue: $LOADADRESS_RESCUE"

	# kernel-entry-point ermitteln fr Rescue
	ENTRYADRESS_RESCUE=$(readelf -l $PREDIR/$RESCUEBIN | grep Entry | cut -d' ' -f3)
	echo "Entry-Point Rescue: " $ENTRYADRESS_RESCUE
	$LOC_LOGGER "write" " Entry-Point Rescue: $ENTRYADRESS_RESCUE"

	# rescue-image berfhren
	echo "Verarbeitung Rescue-Image"
	echo "-------------------------"
	echo "Konvertierung von " $RESCUEBIN
	$LOC_LOGGER "write" " Konvertierung von $RESCUEBIN"
	$MIPSOBJ -O binary $PREDIR/$RESCUEBIN $WORKDIR/$RESCUEBIN.bin
	
	# TEST 2011.1 >>>
	# Soll das Rescue komprimiert werden?
	if [ -z $TEST_USE_GZIP ]; then
		# bootbares Image fr u-boot erstellen
		echo "mkimage Rescue"
		$LOC_LOGGER "write" " Erstelle bootbares u-boot Image"
		mkimage -A mips -O linux -T kernel -C none -a $LOADADRESS_RESCUE -e $ENTRYADRESS_RESCUE -n 'PNX8xxx-MIPS-Rescue' -d $WORKDIR/$RESCUEBIN.bin $WORKDIR/$RESCUEMK
	else
		# bootbares Image fr u-boot erstellen
		if [ -f $WORKDIR/$RESCUEBIN.bin.gz ]; then
			rm $WORKDIR/$RESCUEBIN.bin.gz
		fi
		
		echo "mkimage Rescue gzip"
		gzip -9 $WORKDIR/$RESCUEBIN.bin
		
		$LOC_LOGGER "write" " Erstelle bootbares u-boot Image"
		mkimage -A mips -O linux -T kernel -C gzip -a $LOADADRESS_RESCUE -e $ENTRYADRESS_RESCUE -n 'PNX8xxx-MIPS-Rescue-gzip' -d $WORKDIR/$RESCUEBIN.bin.gz $WORKDIR/$RESCUEMK
	fi	
	# TEST 2011.1 <<<

	# TEST 2011 ORIGINAL >>>
	#echo "-----------------------------------------------"

	# bootbares Image fr u-boot erstellen
	#echo "mkimage Rescue"
	#$LOC_LOGGER "write" " Erstelle bootbares u-boot Image"
	#mkimage -A mips -O linux -T kernel -C none -a $LOADADRESS_RESCUE -e $ENTRYADRESS_RESCUE -n 'PNX8xxx-MIPS-Rescue' -d $WORKDIR/$RESCUEBIN.bin $WORKDIR/$RESCUEMK

	#echo "-----------------------------------------------"
	# TEST 2011 ORIGINAL <<<

	echo "Verarbeitung Rescue-Image (bitte Geduld)"
	echo "----------------------------------------"
	$LOC_LOGGER "write" " Heirat Rescue-Image mit Dummy-Container (dauert etwas - Geduld)"
	dd if=$WORKDIR/$RESCUEMK of=$USBDIR/$FINALIMG conv=notrunc bs=1 seek=5000K

	echo "-----------------------------------------------"


	# -------------------------------------------------------- usb update files ------------------------------------------

	# zustzliche Dummy-Files fr das Firmwareupdate (per Original-Firmware) erstellen
	echo "Dummy-Files fr USB-Stick erstellen"
	echo "-----------------------------------"
	$LOC_LOGGER "write" " USB Dummy-Files erstellen"

	# flashing.txt
	$LOC_LOGGER "write" " Erstelle flashing.txt"
	touch $USBDIR/flashing.txt
	echo "mode 1" > $USBDIR/flashing.txt

	# phStbRootApp_256M_0_t.mi
	$LOC_LOGGER "write" " Erstelle phStbRootApp_256M_0_t.mi"
	dd if=/dev/urandom of=$USBDIR/phStbRootApp_256M_0_t.mi bs=1k count=150

	# phStbRootApp_256M_1_t.mi
	$LOC_LOGGER "write" " Erstelle phStbRootApp_256M_1_t.mi"
	dd if=/dev/urandom of=$USBDIR/phStbRootApp_256M_1_t.mi bs=1k count=150
	
	$LOC_LOGGER "write" " fertig"

	exit 0
else
	exit 1
fi






