#!/bin/bash

# Setzt vor dem Kompilieren einige Einstellungen in silverbox.h

if [ -f $PNX8950_BUILDER_ROOT/.config ]; then
	source $PNX8950_BUILDER_ROOT/.config

	ROOTDIR=$(pwd)
	WORKDIR=$ROOTDIR/dWork

	SEDDIR=$WORKDIR/$UBOOTFILE/include/configs
	LOC_LOGGER=$PNX8950_BUILDER_ROOT/workdir/log_me.sh

	# Arbeitskopie erstellen
	$LOC_LOGGER "write" " Erstelle Arbeitskopie von Config-File"
	cp $WORKDIR/$UBOOTFILE/include/configs/silverbox.orig $WORKDIR/$UBOOTFILE/include/configs/silverbox.bak

	# Autoboot konfigurieren -> Boot von ...
	if [ -z $UCONF_UBOOT_START_LINUX_SATA ]; then
		if [ -z $UCONF_UBOOT_START_LINUX_NAND ]; then
			if [ -z $UCONF_UBOOT_START_RESCUE ]; then
				# Defaultwert setzen, wenn Param nicht gesetzt
				#echo "default"
				LOC_AUTO='linux"'
			else
				#echo "Rescue"
				LOC_AUTO='rescue"'
			fi
		else
			#echo "Nand"
			LOC_AUTO='linux"'
		fi
	else
		#echo "Sata"
		LOC_AUTO='sata"'
	fi

	# Bootdelay setzen
	if [ -z $UCONF_UBOOT_START_DELAY ]; then
		#echo "5"
		LOC_DELAY='5'
	else
		#echo "USER"
		LOC_DELAY=$UCONF_UBOOT_START_DELAY
	fi

	# Console setzen
	if [ -z $UCONF_UBOOT_CONSOLE ]; then
		#echo "ttyS1"
		LOC_PORT='1'
	else
		#echo "ttyS$UCONF_UBOOT_CONSOLE"
		LOC_PORT=$UCONF_UBOOT_CONSOLE
	fi

	# Baudrate setzen
	if [ -z $UCONF_UBOOT_BAUD ]; then
		#echo "Baud 38400"
		LOC_BAUD='38400'
	else
		#echo "Baud $UCONF_UBOOT_BAUD"
		LOC_BAUD=$UCONF_UBOOT_BAUD
	fi

	LOC_CONSOLE='"ttyS'$LOC_PORT','$LOC_BAUD'n8"'

	# Setzte Auto-Bootcommand
	$LOC_LOGGER "write" " Setze Auto-Bootcommand auf $LOC_AUTO"
	sed -e '/#define USER_bootcommand	"run load_linux"/c\#define USER_bootcommand	"run load_'$LOC_AUTO'' $SEDDIR/silverbox.bak > $SEDDIR/silverbox.h
	cp $SEDDIR/silverbox.h $SEDDIR/silverbox.bak

	# Setzte Bootdelay
	$LOC_LOGGER "write" " Setze Bootdelay auf $LOC_DELAY"
	sed -e '/#define CONFIG_BOOTDELAY	5/c\#define CONFIG_BOOTDELAY '$LOC_DELAY'' $SEDDIR/silverbox.bak > $SEDDIR/silverbox.h
	cp $SEDDIR/silverbox.h $SEDDIR/silverbox.bak

	# Setzte Consolenport
	$LOC_LOGGER "write" " Setze Consolen Port auf $LOC_PORT"
	sed -e '/#define CFG_CONSOLE_PORT       CFG_SERIAL_PORT_1/c\#define CFG_CONSOLE_PORT       CFG_SERIAL_PORT_'$LOC_PORT'' $SEDDIR/silverbox.bak > $SEDDIR/silverbox.h
	cp $SEDDIR/silverbox.h $SEDDIR/silverbox.bak

	# Setzte Baudrate
	$LOC_LOGGER "write" " Setze Baudrate auf $LOC_BAUD"
	sed -e '/#define CONFIG_BAUDRATE		38400/c\#define CONFIG_BAUDRATE '$LOC_BAUD'' $SEDDIR/silverbox.bak > $SEDDIR/silverbox.h
	cp $SEDDIR/silverbox.h $SEDDIR/silverbox.bak

	# bergabe bei Linuxboot (noch nicht implementiert in Schnittstelle u-boot -> kernel)
	$LOC_LOGGER "write" " Setze Linuxboot Args auf $LOC_CONSOLE (noch nicht implementiert in Schnittstelle u-boot -> kernel)"
	sed -e '/#define USER_console		"ttyS0,38400n8"/c\#define USER_console '$LOC_CONSOLE'' $SEDDIR/silverbox.bak > $SEDDIR/silverbox.h
	cp $SEDDIR/silverbox.h $SEDDIR/silverbox.bak

	$LOC_LOGGER "write" " fertig"
	exit 0
else
	exit 1
fi