//POVRay-Datei erstellt mit 3d41.ulp v1.05
//W:/Projekte/mame/buttonpanel/Eagle/V-USB_Mame_Panel_Atmega32_V1.00/MamePanelAtmega32.brd
//16.10.2009 19:40:59

#version 3.5;

//Set to on if the file should be used as .inc
#local use_file_as_inc = off;
#if(use_file_as_inc=off)


//changes the apperance of resistors (1 Blob / 0 real)
#declare global_res_shape = 1;
//randomize color of resistors 1=random 0=same color
#declare global_res_colselect = 0;
//Number of the color for the resistors
//0=Green, 1="normal color" 2=Blue 3=Brown
#declare global_res_col = 1;
//Set to on if you want to render the PCB upside-down
#declare pcb_upsidedown = off;
//Set to x or z to rotate around the corresponding axis (referring to pcb_upsidedown)
#declare pcb_rotdir = x;
//Set the length off short pins over the PCB
#declare pin_length = 2.5;
#declare global_diode_bend_radius = 1;
#declare global_res_bend_radius = 1;
#declare global_solder = on;

#declare global_show_screws = on;
#declare global_show_washers = on;
#declare global_show_nuts = on;

//Animation
#declare global_anim = off;
#local global_anim_showcampath = no;

#declare global_fast_mode = off;

#declare col_preset = 2;
#declare pin_short = on;

#declare environment = off;

#local cam_x = 0;
#local cam_y = 308;
#local cam_z = -163;
#local cam_a = 20;
#local cam_look_x = 0;
#local cam_look_y = -7;
#local cam_look_z = 0;

#local pcb_rotate_x = 0;
#local pcb_rotate_y = 0;
#local pcb_rotate_z = 0;

#local pcb_board = on;
#local pcb_parts = on;
#if(global_fast_mode=off)
	#local pcb_polygons = on;
	#local pcb_silkscreen = on;
	#local pcb_wires = on;
	#local pcb_pads_smds = on;
#else
	#local pcb_polygons = off;
	#local pcb_silkscreen = off;
	#local pcb_wires = off;
	#local pcb_pads_smds = off;
#end

#local lgt1_pos_x = 36;
#local lgt1_pos_y = 55;
#local lgt1_pos_z = 37;
#local lgt1_intense = 0.798038;
#local lgt2_pos_x = -36;
#local lgt2_pos_y = 55;
#local lgt2_pos_z = 37;
#local lgt2_intense = 0.798038;
#local lgt3_pos_x = 36;
#local lgt3_pos_y = 55;
#local lgt3_pos_z = -25;
#local lgt3_intense = 0.798038;
#local lgt4_pos_x = -36;
#local lgt4_pos_y = 55;
#local lgt4_pos_z = -25;
#local lgt4_intense = 0.798038;

//Do not change these values
#declare pcb_height = 1.500000;
#declare pcb_cuheight = 0.035000;
#declare pcb_x_size = 96.507500;
#declare pcb_y_size = 71.110000;
#declare pcb_layer1_used = 1;
#declare pcb_layer16_used = 1;
#declare inc_testmode = off;
#declare global_seed=seed(495);
#declare global_pcb_layer_dis = array[16]
{
	0.000000,
	0.000000,
	0.000000,
	0.000000,
	0.000000,
	0.000000,
	0.000000,
	0.000000,
	0.000000,
	0.000000,
	0.000000,
	0.000000,
	0.000000,
	0.000000,
	0.000000,
	1.535000,
}
#declare global_pcb_real_hole = 2.000000;

#include "tools.inc"
#include "user.inc"

global_settings{charset utf8}

#if(environment=on)
sky_sphere {pigment {Navy}
pigment {bozo turbulence 0.65 octaves 7 omega 0.7 lambda 2
color_map {
[0.0 0.1 color rgb <0.85, 0.85, 0.85> color rgb <0.75, 0.75, 0.75>]
[0.1 0.5 color rgb <0.75, 0.75, 0.75> color rgbt <1, 1, 1, 1>]
[0.5 1.0 color rgbt <1, 1, 1, 1> color rgbt <1, 1, 1, 1>]}
scale <0.1, 0.5, 0.1>} rotate -90*x}
plane{y, -10.0-max(pcb_x_size,pcb_y_size)*abs(max(sin((pcb_rotate_x/180)*pi),sin((pcb_rotate_z/180)*pi)))
texture{T_Chrome_2D
normal{waves 0.1 frequency 3000.0 scale 3000.0}} translate<0,0,0>}
#end

//Animationsdaten
#if(global_anim=on)
#declare global_anim_showcampath = no;
#end

#if((global_anim=on)|(global_anim_showcampath=yes))
#declare global_anim_npoints_cam_flight=0;
#warning "Keine/zu wenig Animationsdaten vorhanden (mind. 3 Punkte) (Flugpfad)"
#end

#if((global_anim=on)|(global_anim_showcampath=yes))
#declare global_anim_npoints_cam_view=0;
#warning "Keine/zu wenig Animationsdaten vorhanden (mind. 3 Punkte) (Blickpunktpfad)"
#end

#if((global_anim=on)|(global_anim_showcampath=yes))
#end

#if((global_anim_showcampath=yes)&(global_anim=off))
#end
#if(global_anim=on)
camera
{
	location global_anim_spline_cam_flight(clock)
	#if(global_anim_npoints_cam_view>2)
		look_at global_anim_spline_cam_view(clock)
	#else
		look_at global_anim_spline_cam_flight(clock+0.01)-<0,-0.01,0>
	#end
	angle 45
}
light_source
{
	global_anim_spline_cam_flight(clock)
	color rgb <1,1,1>
	spotlight point_at 
	#if(global_anim_npoints_cam_view>2)
		global_anim_spline_cam_view(clock)
	#else
		global_anim_spline_cam_flight(clock+0.01)-<0,-0.01,0>
	#end
	radius 35 falloff  40
}
#else
camera
{
	location <cam_x,cam_y,cam_z>
	look_at <cam_look_x,cam_look_y,cam_look_z>
	angle cam_a
	//versetzt die Kamera, sodass <0,0,0> ber dem Eagle-Nullpunkt ist
	//translate<-48.253750,0,-35.555000>
}
#end

background{col_bgr}


//Axis uncomment to activate
//object{TOOLS_AXIS_XYZ(100,100,100 //texture{ pigment{rgb<1,0,0>} finish{diffuse 0.8 phong 1}}, //texture{ pigment{rgb<1,1,1>} finish{diffuse 0.8 phong 1}})}

light_source{<lgt1_pos_x,lgt1_pos_y,lgt1_pos_z> White*lgt1_intense}
light_source{<lgt2_pos_x,lgt2_pos_y,lgt2_pos_z> White*lgt2_intense}
light_source{<lgt3_pos_x,lgt3_pos_y,lgt3_pos_z> White*lgt3_intense}
light_source{<lgt4_pos_x,lgt4_pos_y,lgt4_pos_z> White*lgt4_intense}
#end


#macro MAMEPANELATMEGA32(mac_x_ver,mac_y_ver,mac_z_ver,mac_x_rot,mac_y_rot,mac_z_rot)
union{
#if(pcb_board = on)
difference{
union{
//Platine
prism{-1.500000,0.000000,8
<0.000000,0.000000><96.507500,0.000000>
<96.507500,0.000000><96.507500,71.110000>
<96.507500,71.110000><0.000000,71.110000>
<0.000000,71.110000><0.000000,0.000000>
texture{col_brd}}
}//End union(Platine)
//Bohrungen(real)/Bauteile
cylinder{<83.820000,1,53.340000><83.820000,-5,53.340000>1.500000 texture{col_hls}}
cylinder{<83.820000,1,15.240000><83.820000,-5,15.240000>1.500000 texture{col_hls}}
cylinder{<5.080000,1,25.400000><5.080000,-5,25.400000>1.500000 texture{col_hls}}
cylinder{<19.990000,1,60.960000><19.990000,-5,60.960000>1.150000 texture{col_hls}}
cylinder{<7.950000,1,60.960000><7.950000,-5,60.960000>1.150000 texture{col_hls}}
//Bohrungen(real)/Platine
//Bohrungen(real)/Durchkontaktierungen
}//End difference(reale Bohrungen/Durchbrche)
#end
#if(pcb_parts=on)//Bauteile
union{
//MPD-File
#ifndef(pack_C1) #declare global_pack_C1=yes; object {CAP_DIS_CERAMIC_25MM_50MM("22p",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-90.000000,0> rotate<0,0,0> translate<43.180000,0.000000,54.610000>}#end		//WIMA-Kondensator Raster 2.54 (capacitator-wima.lib) C1 22p C2.5-2
#ifndef(pack_C2) #declare global_pack_C2=yes; object {CAP_DIS_CERAMIC_25MM_50MM("22p",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-90.000000,0> rotate<0,0,0> translate<48.260000,0.000000,54.610000>}#end		//WIMA-Kondensator Raster 2.54 (capacitator-wima.lib) C2 22p C2.5-2
#ifndef(pack_C3) #declare global_pack_C3=yes; object {CAP_DIS_WIMA_5_025_072_065("100n",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<53.340000,0.000000,55.880000>}#end		//WIMA-Kondensator Raster 5.08 (capacitator-wima.lib) C3 100n C5B2.5
#ifndef(pack_C4) #declare global_pack_C4=yes; object {CAP_DIS_ELKO_2MM5_6MM3("4u7",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<8.890000,0.000000,48.260000>}#end		//Elko 2,5mm Pitch, 6mm Durchmesser, 11,2mm Hoehe C4 4u7 E2,5-6
#ifndef(pack_C5) #declare global_pack_C5=yes; object {CAP_DIS_ELKO_2MM5_6MM3("4u7",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-90.000000,0> rotate<0,0,0> translate<20.320000,0.000000,31.724600>}#end		//Elko 2,5mm Pitch, 6mm Durchmesser, 11,2mm Hoehe C5 4u7 E2,5-6
#ifndef(pack_C6) #declare global_pack_C6=yes; object {CAP_DIS_WIMA_5_025_072_065("100n",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<53.340000,0.000000,20.320000>}#end		//WIMA-Kondensator Raster 5.08 (capacitator-wima.lib) C6 100n C5B2.5
#ifndef(pack_D1) #declare global_pack_D1=yes; object {DIODE_DIS_DO35_076MM_H("1N4148DO35-7",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<8.890000,0.000000,43.180000>}#end		//Diode DO35 7mm hor. D1 1N4148DO35-7 DO35-7
#ifndef(pack_IC1) #declare global_pack_IC1=yes; object {IC_DIS_DIP40_W("MEGA32-P","ATMEL",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<52.070000,0.000000,33.020000>translate<0,3.000000,0> }#end		//DIP40 IC1 MEGA32-P DIL40
#ifndef(pack_IC1) object{SOCKET_DIP40W()rotate<0,-180.000000,0> rotate<0,0,0> translate<52.070000,0.000000,33.020000>}#end					//IC-Sockel 40Pin 600mil IC1 MEGA32-P
#ifndef(pack_IC2) #declare global_pack_IC2=yes; object {TR_TO252("LD117ADT33TR","ATMEL",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<12.700000,0.000000,33.020000>translate<0,0.035000,0> }#end		//TO252 IC2 LD117ADT33TR DPACK
#ifndef(pack_Q1) #declare global_pack_Q1=yes; object {SPC_XTAL_5MM("12.000MHz",12,)translate<0,0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,0> translate<45.720000,0.000000,48.260000>}#end		//Quarz 4,9MM Q1 12.000MHz HC18U-V
#ifndef(pack_R1) #declare global_pack_R1=yes; object {RES_DIS_0207_10MM(texture{pigment{Yellow}finish{phong 0.2}},texture{pigment{Violet*1.2}finish{phong 0.2}},texture{pigment{Red*0.7}finish{phong 0.2}},texture {T_Gold_5C finish{reflection 0.1}},)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-270.000000,0> rotate<0,0,0> translate<55.880000,0.000000,48.260000>}#end		//Diskreter Widerstand 0,3W 10MM Raster R1 4k7 0207/10
#ifndef(pack_R2) #declare global_pack_R2=yes; object {RES_DIS_0207_10MM(texture{pigment{Blue}finish{phong 0.2}},texture{pigment{Gray45}finish{phong 0.2}},texture{pigment{Black}finish{phong 0.2}},texture {T_Gold_5C finish{reflection 0.1}},)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-270.000000,0> rotate<0,0,0> translate<22.860000,0.000000,45.720000>}#end		//Diskreter Widerstand 0,3W 10MM Raster R2 68 0207/10
#ifndef(pack_R3) #declare global_pack_R3=yes; object {RES_DIS_0207_10MM(texture{pigment{Blue}finish{phong 0.2}},texture{pigment{Gray45}finish{phong 0.2}},texture{pigment{Black}finish{phong 0.2}},texture {T_Gold_5C finish{reflection 0.1}},)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-90.000000,0> rotate<0,0,0> translate<20.320000,0.000000,45.720000>}#end		//Diskreter Widerstand 0,3W 10MM Raster R3 68 0207/10
#ifndef(pack_R4) #declare global_pack_R4=yes; object {RES_DIS_0207_10MM(texture{pigment{DarkBrown}finish{phong 0.2}},texture{pigment{Green*0.7}finish{phong 0.2}},texture{pigment{Red*0.7}finish{phong 0.2}},texture {T_Gold_5C finish{reflection 0.1}},)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-90.000000,0> rotate<0,0,0> translate<25.400000,0.000000,45.720000>}#end		//Diskreter Widerstand 0,3W 10MM Raster R4 1k5 0207/10
#ifndef(pack_R5) #declare global_pack_R5=yes; object {RES_DIS_0207_10MM(texture{pigment{DarkBrown}finish{phong 0.2}},texture{pigment{Black}finish{phong 0.2}},texture{pigment{Green*0.7}finish{phong 0.2}},texture {T_Gold_5C finish{reflection 0.1}},)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-270.000000,0> rotate<0,0,0> translate<15.240000,0.000000,45.720000>}#end		//Diskreter Widerstand 0,3W 10MM Raster R5 1M 0207/10
#ifndef(pack_X1) #declare global_pack_X1=yes; object {CON_USB_B_001()translate<-10,0,0> rotate<0,-90.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<13.970000,0.000000,60.960000>}#end		//USB-B Stecker X1  PN61729
#ifndef(pack_X2) #declare global_pack_X2=yes; object {CON_DIS_WS6G()translate<0,0,0> rotate<0,0.000000,0>rotate<0,-90.000000,0> rotate<0,0,0> translate<85.090000,0.000000,33.020000>}#end		//Wannenstecker 6Pin X2  CON06L
#ifndef(pack_X3) #declare global_pack_X3=yes; object {ARK_5MM_8()translate<0,0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,0> translate<22.860000,0.000000,5.715000>}#end		//Anreihklemmen 8Pin (con-ptr500.lib) X3  W237-8P
#ifndef(pack_X4) #declare global_pack_X4=yes; object {ARK_5MM_8()translate<0,0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,0> translate<63.500000,0.000000,5.715000>}#end		//Anreihklemmen 8Pin (con-ptr500.lib) X4  W237-8P
#ifndef(pack_X5) #declare global_pack_X5=yes; object {ARK_5MM_8()translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<43.180000,0.000000,65.405000>}#end		//Anreihklemmen 8Pin (con-ptr500.lib) X5  W237-8P
#ifndef(pack_X6) #declare global_pack_X6=yes; object {ARK_5MM_2()translate<0,0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,0> translate<88.900000,0.000000,5.715000>}#end		//Anreihklemmen 2Pin (con-ptr500.lib) X6  W237-132
#ifndef(pack_X7) #declare global_pack_X7=yes; object {ARK_5MM_2()translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<78.740000,0.000000,65.405000>}#end		//Anreihklemmen 2Pin (con-ptr500.lib) X7  W237-132
#ifndef(pack_X8) #declare global_pack_X8=yes; object {ARK_5MM_2()translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<68.580000,0.000000,65.405000>}#end		//Anreihklemmen 2Pin (con-ptr500.lib) X8  W237-132
#ifndef(pack_X9) #declare global_pack_X9=yes; object {ARK_5MM_2()translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<88.900000,0.000000,65.405000>}#end		//Anreihklemmen 2Pin (con-ptr500.lib) X9  W237-132
}//End union
#end
#if(pcb_pads_smds=on)
//Ltaugen&SMD/Bauteile
#ifndef(global_pack_C1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.600200,0.812800,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<43.180000,0,53.340000> texture{col_thl}}
#ifndef(global_pack_C1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.600200,0.812800,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<43.180000,0,55.880000> texture{col_thl}}
#ifndef(global_pack_C2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.600200,0.812800,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<48.260000,0,53.340000> texture{col_thl}}
#ifndef(global_pack_C2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.600200,0.812800,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<48.260000,0,55.880000> texture{col_thl}}
#ifndef(global_pack_C3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.600200,0.812800,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<55.880000,0,55.880000> texture{col_thl}}
#ifndef(global_pack_C3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.600200,0.812800,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<50.800000,0,55.880000> texture{col_thl}}
#ifndef(global_pack_C4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.600200,0.812800,1,16,1+global_tmp,0) rotate<0,-180.000000,0>translate<10.160000,0,48.260000> texture{col_thl}}
#ifndef(global_pack_C4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.600200,0.812800,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<7.620000,0,48.260000> texture{col_thl}}
#ifndef(global_pack_C5) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.600200,0.812800,1,16,1+global_tmp,0) rotate<0,-90.000000,0>translate<20.320000,0,30.454600> texture{col_thl}}
#ifndef(global_pack_C5) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.600200,0.812800,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<20.320000,0,32.994600> texture{col_thl}}
#ifndef(global_pack_C6) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.600200,0.812800,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<55.880000,0,20.320000> texture{col_thl}}
#ifndef(global_pack_C6) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.600200,0.812800,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<50.800000,0,20.320000> texture{col_thl}}
#ifndef(global_pack_D1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-180.000000,0>translate<5.080000,0,43.180000> texture{col_thl}}
#ifndef(global_pack_D1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-180.000000,0>translate<12.700000,0,43.180000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<76.200000,0,40.640000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<73.660000,0,40.640000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<71.120000,0,40.640000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<68.580000,0,40.640000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<66.040000,0,40.640000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<63.500000,0,40.640000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<60.960000,0,40.640000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<58.420000,0,40.640000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<55.880000,0,40.640000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<53.340000,0,40.640000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<50.800000,0,40.640000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<48.260000,0,40.640000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<45.720000,0,40.640000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<43.180000,0,40.640000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<40.640000,0,40.640000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<38.100000,0,40.640000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<35.560000,0,40.640000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<33.020000,0,40.640000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<30.480000,0,40.640000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<27.940000,0,40.640000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<27.940000,0,25.400000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<30.480000,0,25.400000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<33.020000,0,25.400000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<35.560000,0,25.400000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<38.100000,0,25.400000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<40.640000,0,25.400000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<43.180000,0,25.400000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<45.720000,0,25.400000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<48.260000,0,25.400000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<50.800000,0,25.400000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<53.340000,0,25.400000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<55.880000,0,25.400000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<58.420000,0,25.400000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<60.960000,0,25.400000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<63.500000,0,25.400000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<66.040000,0,25.400000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<68.580000,0,25.400000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<71.120000,0,25.400000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<73.660000,0,25.400000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<76.200000,0,25.400000> texture{col_thl}}
object{TOOLS_PCB_SMD(1.600000,3.000000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<14.980000,0.000000,37.820000>}
object{TOOLS_PCB_SMD(1.600000,3.000000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<10.420000,0.000000,37.820000>}
object{TOOLS_PCB_SMD(5.800000,6.200000,0.037000,0) rotate<0,-180.000000,0> texture{col_pds} translate<12.700000,0.000000,30.640000>}
#ifndef(global_pack_Q1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,1+global_tmp,0) rotate<0,-0.000000,0>translate<43.180000,0,48.260000> texture{col_thl}}
#ifndef(global_pack_Q1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,1+global_tmp,0) rotate<0,-0.000000,0>translate<48.260000,0,48.260000> texture{col_thl}}
#ifndef(global_pack_R1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,2+global_tmp,0) rotate<0,-270.000000,0>translate<55.880000,0,53.340000> texture{col_thl}}
#ifndef(global_pack_R1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,2+global_tmp,0) rotate<0,-270.000000,0>translate<55.880000,0,43.180000> texture{col_thl}}
#ifndef(global_pack_R2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,2+global_tmp,0) rotate<0,-270.000000,0>translate<22.860000,0,50.800000> texture{col_thl}}
#ifndef(global_pack_R2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,2+global_tmp,0) rotate<0,-270.000000,0>translate<22.860000,0,40.640000> texture{col_thl}}
#ifndef(global_pack_R3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<20.320000,0,40.640000> texture{col_thl}}
#ifndef(global_pack_R3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<20.320000,0,50.800000> texture{col_thl}}
#ifndef(global_pack_R4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<25.400000,0,40.640000> texture{col_thl}}
#ifndef(global_pack_R4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<25.400000,0,50.800000> texture{col_thl}}
#ifndef(global_pack_R5) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,2+global_tmp,0) rotate<0,-270.000000,0>translate<15.240000,0,50.800000> texture{col_thl}}
#ifndef(global_pack_R5) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.320800,0.812800,1,16,2+global_tmp,0) rotate<0,-270.000000,0>translate<15.240000,0,40.640000> texture{col_thl}}
#ifndef(global_pack_X1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.458000,0.950000,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<12.720000,0,56.250000> texture{col_thl}}
#ifndef(global_pack_X1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.458000,0.950000,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<15.220000,0,56.250000> texture{col_thl}}
#ifndef(global_pack_X1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.458000,0.950000,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<15.220000,0,58.250000> texture{col_thl}}
#ifndef(global_pack_X1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.458000,0.950000,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<12.720000,0,58.250000> texture{col_thl}}
#ifndef(global_pack_X2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.422400,0.914400,1,16,1+global_tmp,0) rotate<0,-90.000000,0>translate<83.820000,0,35.560000> texture{col_thl}}
#ifndef(global_pack_X2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.422400,0.914400,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<86.360000,0,35.560000> texture{col_thl}}
#ifndef(global_pack_X2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.422400,0.914400,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<83.820000,0,33.020000> texture{col_thl}}
#ifndef(global_pack_X2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.422400,0.914400,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<86.360000,0,33.020000> texture{col_thl}}
#ifndef(global_pack_X2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.422400,0.914400,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<83.820000,0,30.480000> texture{col_thl}}
#ifndef(global_pack_X2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.422400,0.914400,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<86.360000,0,30.480000> texture{col_thl}}
#ifndef(global_pack_X3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.790800,1.193800,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<5.080000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_X3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.790800,1.193800,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<10.160000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_X3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.790800,1.193800,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<15.240000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_X3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.790800,1.193800,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<20.320000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_X3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.790800,1.193800,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<25.400000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_X3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.790800,1.193800,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<30.480000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_X3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.790800,1.193800,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<35.560000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_X3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.790800,1.193800,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<40.640000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_X4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.790800,1.193800,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<45.720000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_X4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.790800,1.193800,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<50.800000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_X4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.790800,1.193800,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<55.880000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_X4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.790800,1.193800,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<60.960000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_X4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.790800,1.193800,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<66.040000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_X4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.790800,1.193800,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<71.120000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_X4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.790800,1.193800,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<76.200000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_X4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.790800,1.193800,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<81.280000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_X5) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.790800,1.193800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<60.960000,0,66.040000> texture{col_thl}}
#ifndef(global_pack_X5) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.790800,1.193800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<55.880000,0,66.040000> texture{col_thl}}
#ifndef(global_pack_X5) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.790800,1.193800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<50.800000,0,66.040000> texture{col_thl}}
#ifndef(global_pack_X5) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.790800,1.193800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<45.720000,0,66.040000> texture{col_thl}}
#ifndef(global_pack_X5) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.790800,1.193800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<40.640000,0,66.040000> texture{col_thl}}
#ifndef(global_pack_X5) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.790800,1.193800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<35.560000,0,66.040000> texture{col_thl}}
#ifndef(global_pack_X5) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.790800,1.193800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<30.480000,0,66.040000> texture{col_thl}}
#ifndef(global_pack_X5) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.790800,1.193800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<25.400000,0,66.040000> texture{col_thl}}
#ifndef(global_pack_X6) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.790800,1.193800,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<86.360000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_X6) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.790800,1.193800,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<91.440000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_X7) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.790800,1.193800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<81.280000,0,66.040000> texture{col_thl}}
#ifndef(global_pack_X7) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.790800,1.193800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<76.200000,0,66.040000> texture{col_thl}}
#ifndef(global_pack_X8) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.790800,1.193800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<71.120000,0,66.040000> texture{col_thl}}
#ifndef(global_pack_X8) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.790800,1.193800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<66.040000,0,66.040000> texture{col_thl}}
#ifndef(global_pack_X9) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.790800,1.193800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<91.440000,0,66.040000> texture{col_thl}}
#ifndef(global_pack_X9) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.790800,1.193800,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<86.360000,0,66.040000> texture{col_thl}}
//Ltaugen/Durchkontaktierungen
object{TOOLS_PCB_VIA(1.500000,1.000000,1,16,1,0) translate<12.700000,0,33.020000> texture{col_thl}}
object{TOOLS_PCB_VIA(1.500000,1.000000,1,16,1,0) translate<86.360000,0,43.180000> texture{col_thl}}
object{TOOLS_PCB_VIA(1.500000,1.000000,1,16,1,0) translate<55.880000,0,58.420000> texture{col_thl}}
object{TOOLS_PCB_VIA(1.500000,1.000000,1,16,0,0) translate<86.360000,0,48.260000> texture{col_thl}}
object{TOOLS_PCB_VIA(1.500000,1.000000,1,16,0,0) translate<88.900000,0,58.420000> texture{col_thl}}
object{TOOLS_PCB_VIA(1.500000,1.000000,1,16,0,0) translate<10.160000,0,38.100000> texture{col_thl}}
object{TOOLS_PCB_VIA(1.500000,1.000000,1,16,0,0) translate<15.240000,0,38.100000> texture{col_thl}}
object{TOOLS_PCB_VIA(1.500000,1.000000,1,16,0,0) translate<35.560000,0,43.180000> texture{col_thl}}
object{TOOLS_PCB_VIA(1.500000,1.000000,1,16,0,0) translate<35.560000,0,55.880000> texture{col_thl}}
object{TOOLS_PCB_VIA(1.500000,1.000000,1,16,0,0) translate<40.640000,0,43.180000> texture{col_thl}}
object{TOOLS_PCB_VIA(1.500000,1.000000,1,16,0,0) translate<40.640000,0,60.960000> texture{col_thl}}
object{TOOLS_PCB_VIA(1.500000,1.000000,1,16,0,0) translate<33.020000,0,43.180000> texture{col_thl}}
object{TOOLS_PCB_VIA(1.500000,1.000000,1,16,0,0) translate<33.020000,0,55.880000> texture{col_thl}}
object{TOOLS_PCB_VIA(1.500000,1.000000,1,16,0,0) translate<30.480000,0,43.180000> texture{col_thl}}
object{TOOLS_PCB_VIA(1.500000,1.000000,1,16,0,0) translate<30.480000,0,55.880000> texture{col_thl}}
object{TOOLS_PCB_VIA(1.500000,1.000000,1,16,0,0) translate<27.940000,0,43.180000> texture{col_thl}}
object{TOOLS_PCB_VIA(1.500000,1.000000,1,16,0,0) translate<27.940000,0,55.880000> texture{col_thl}}
#end
#if(pcb_wires=on)
union{
//Signale
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<5.080000,-1.535000,5.080000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<5.080000,-1.535000,17.780000>}
box{<0,0,-0.635000><12.700000,0.035000,0.635000> rotate<0,90.000000,0> translate<5.080000,-1.535000,17.780000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<5.080000,-1.535000,33.020000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<5.080000,-1.535000,43.180000>}
box{<0,0,-0.635000><10.160000,0.035000,0.635000> rotate<0,90.000000,0> translate<5.080000,-1.535000,43.180000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<5.080000,-1.535000,43.180000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<5.080000,-1.535000,63.500000>}
box{<0,0,-0.635000><20.320000,0.035000,0.635000> rotate<0,90.000000,0> translate<5.080000,-1.535000,63.500000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<7.620000,-1.535000,35.560000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<7.620000,-1.535000,48.260000>}
box{<0,0,-0.635000><12.700000,0.035000,0.635000> rotate<0,90.000000,0> translate<7.620000,-1.535000,48.260000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<7.620000,-1.535000,48.260000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<7.620000,-1.535000,58.420000>}
box{<0,0,-0.635000><10.160000,0.035000,0.635000> rotate<0,90.000000,0> translate<7.620000,-1.535000,58.420000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<10.160000,-1.535000,5.080000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<10.160000,-1.535000,15.240000>}
box{<0,0,-0.635000><10.160000,0.035000,0.635000> rotate<0,90.000000,0> translate<10.160000,-1.535000,15.240000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<10.160000,0.000000,37.820000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<10.160000,0.000000,38.100000>}
box{<0,0,-0.635000><0.280000,0.035000,0.635000> rotate<0,90.000000,0> translate<10.160000,0.000000,38.100000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<10.160000,-1.535000,38.100000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<10.160000,-1.535000,43.180000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,90.000000,0> translate<10.160000,-1.535000,43.180000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<10.160000,-1.535000,43.180000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<10.160000,-1.535000,48.260000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,90.000000,0> translate<10.160000,-1.535000,48.260000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<10.160000,-1.535000,48.260000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<10.160000,-1.535000,55.880000>}
box{<0,0,-0.635000><7.620000,0.035000,0.635000> rotate<0,90.000000,0> translate<10.160000,-1.535000,55.880000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<10.160000,0.000000,37.820000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<10.420000,0.000000,37.820000>}
box{<0,0,-0.635000><0.260000,0.035000,0.635000> rotate<0,0.000000,0> translate<10.160000,0.000000,37.820000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<5.080000,-1.535000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<12.700000,-1.535000,17.780000>}
box{<0,0,-0.635000><7.620000,0.035000,0.635000> rotate<0,0.000000,0> translate<5.080000,-1.535000,17.780000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<12.700000,-1.535000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<12.700000,-1.535000,25.400000>}
box{<0,0,-0.635000><7.620000,0.035000,0.635000> rotate<0,90.000000,0> translate<12.700000,-1.535000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<12.700000,-1.535000,30.640000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<12.700000,-1.535000,30.480000>}
box{<0,0,-0.635000><0.160000,0.035000,0.635000> rotate<0,-90.000000,0> translate<12.700000,-1.535000,30.480000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<12.700000,0.000000,33.020000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<12.700000,0.000000,30.640000>}
box{<0,0,-0.635000><2.380000,0.035000,0.635000> rotate<0,-90.000000,0> translate<12.700000,0.000000,30.640000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<12.700000,-1.535000,33.020000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<12.700000,-1.535000,30.640000>}
box{<0,0,-0.635000><2.380000,0.035000,0.635000> rotate<0,-90.000000,0> translate<12.700000,-1.535000,30.640000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<5.080000,-1.535000,33.020000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<12.700000,-1.535000,33.020000>}
box{<0,0,-0.635000><7.620000,0.035000,0.635000> rotate<0,0.000000,0> translate<5.080000,-1.535000,33.020000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<10.160000,-1.535000,43.180000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<12.700000,-1.535000,43.180000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,0.000000,0> translate<10.160000,-1.535000,43.180000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<12.700000,-1.535000,45.720000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<12.700000,-1.535000,53.340000>}
box{<0,0,-0.635000><7.620000,0.035000,0.635000> rotate<0,90.000000,0> translate<12.700000,-1.535000,53.340000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<10.160000,-1.535000,55.880000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<12.700000,-1.535000,55.880000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,0.000000,0> translate<10.160000,-1.535000,55.880000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<12.700000,-1.535000,55.880000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<12.700000,-1.535000,56.250000>}
box{<0,0,-0.635000><0.370000,0.035000,0.635000> rotate<0,90.000000,0> translate<12.700000,-1.535000,56.250000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<12.700000,-1.535000,58.420000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<12.700000,-1.535000,58.250000>}
box{<0,0,-0.635000><0.170000,0.035000,0.635000> rotate<0,-90.000000,0> translate<12.700000,-1.535000,58.250000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<7.620000,-1.535000,58.420000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<12.700000,-1.535000,58.420000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,0.000000,0> translate<7.620000,-1.535000,58.420000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<12.700000,-1.535000,56.250000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<12.720000,-1.535000,56.250000>}
box{<0,0,-0.635000><0.020000,0.035000,0.635000> rotate<0,0.000000,0> translate<12.700000,-1.535000,56.250000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<12.700000,-1.535000,58.250000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<12.720000,-1.535000,58.250000>}
box{<0,0,-0.635000><0.020000,0.035000,0.635000> rotate<0,0.000000,0> translate<12.700000,-1.535000,58.250000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<14.980000,0.000000,38.100000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<14.980000,0.000000,37.820000>}
box{<0,0,-0.635000><0.280000,0.035000,0.635000> rotate<0,-90.000000,0> translate<14.980000,0.000000,37.820000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<15.240000,-1.535000,5.080000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<15.240000,-1.535000,12.700000>}
box{<0,0,-0.635000><7.620000,0.035000,0.635000> rotate<0,90.000000,0> translate<15.240000,-1.535000,12.700000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<10.160000,-1.535000,15.240000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<15.240000,-1.535000,15.240000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,0.000000,0> translate<10.160000,-1.535000,15.240000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<15.240000,-1.535000,15.240000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<15.240000,-1.535000,22.860000>}
box{<0,0,-0.635000><7.620000,0.035000,0.635000> rotate<0,90.000000,0> translate<15.240000,-1.535000,22.860000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<7.620000,-1.535000,35.560000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<15.240000,-1.535000,35.560000>}
box{<0,0,-0.635000><7.620000,0.035000,0.635000> rotate<0,0.000000,0> translate<7.620000,-1.535000,35.560000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<14.980000,0.000000,38.100000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<15.240000,0.000000,38.100000>}
box{<0,0,-0.635000><0.260000,0.035000,0.635000> rotate<0,0.000000,0> translate<14.980000,0.000000,38.100000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<15.240000,-1.535000,35.560000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<15.240000,-1.535000,38.100000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,90.000000,0> translate<15.240000,-1.535000,38.100000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<15.240000,-1.535000,38.100000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<15.240000,-1.535000,40.640000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,90.000000,0> translate<15.240000,-1.535000,40.640000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<12.700000,-1.535000,53.340000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<15.240000,-1.535000,53.340000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,0.000000,0> translate<12.700000,-1.535000,53.340000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<15.220000,-1.535000,56.250000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<15.240000,-1.535000,56.250000>}
box{<0,0,-0.635000><0.020000,0.035000,0.635000> rotate<0,0.000000,0> translate<15.220000,-1.535000,56.250000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<15.240000,-1.535000,53.340000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<15.240000,-1.535000,56.250000>}
box{<0,0,-0.635000><2.910000,0.035000,0.635000> rotate<0,90.000000,0> translate<15.240000,-1.535000,56.250000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<15.220000,-1.535000,58.250000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<15.240000,-1.535000,58.250000>}
box{<0,0,-0.635000><0.020000,0.035000,0.635000> rotate<0,0.000000,0> translate<15.220000,-1.535000,58.250000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<15.240000,-1.535000,58.420000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<15.240000,-1.535000,58.250000>}
box{<0,0,-0.635000><0.170000,0.035000,0.635000> rotate<0,-90.000000,0> translate<15.240000,-1.535000,58.250000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<15.240000,-1.535000,12.700000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<17.780000,-1.535000,12.700000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,0.000000,0> translate<15.240000,-1.535000,12.700000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<17.780000,-1.535000,12.700000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<17.780000,-1.535000,20.320000>}
box{<0,0,-0.635000><7.620000,0.035000,0.635000> rotate<0,90.000000,0> translate<17.780000,-1.535000,20.320000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<12.700000,-1.535000,30.480000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<17.780000,-1.535000,30.480000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,0.000000,0> translate<12.700000,-1.535000,30.480000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<12.700000,-1.535000,45.720000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<17.780000,-1.535000,45.720000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,0.000000,0> translate<12.700000,-1.535000,45.720000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<17.780000,-1.535000,38.100000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<17.780000,-1.535000,45.720000>}
box{<0,0,-0.635000><7.620000,0.035000,0.635000> rotate<0,90.000000,0> translate<17.780000,-1.535000,45.720000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<20.320000,-1.535000,5.080000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<20.320000,-1.535000,17.780000>}
box{<0,0,-0.635000><12.700000,0.035000,0.635000> rotate<0,90.000000,0> translate<20.320000,-1.535000,17.780000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<17.780000,-1.535000,30.480000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<20.320000,-1.535000,30.454600>}
box{<0,0,-0.635000><2.540127,0.035000,0.635000> rotate<0,0.572901,0> translate<17.780000,-1.535000,30.480000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<20.320000,-1.535000,35.560000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<20.320000,-1.535000,32.994600>}
box{<0,0,-0.635000><2.565400,0.035000,0.635000> rotate<0,-90.000000,0> translate<20.320000,-1.535000,32.994600> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<20.320000,-1.535000,32.994600>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<20.320000,-1.535000,33.020000>}
box{<0,0,-0.635000><0.025400,0.035000,0.635000> rotate<0,90.000000,0> translate<20.320000,-1.535000,33.020000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<15.240000,-1.535000,35.560000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<20.320000,-1.535000,35.560000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,0.000000,0> translate<15.240000,-1.535000,35.560000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<20.320000,-1.535000,40.640000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<20.320000,-1.535000,45.720000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,90.000000,0> translate<20.320000,-1.535000,45.720000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<15.240000,-1.535000,50.800000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<20.320000,-1.535000,50.800000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,0.000000,0> translate<15.240000,-1.535000,50.800000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<15.240000,-1.535000,58.420000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<20.320000,-1.535000,58.420000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,0.000000,0> translate<15.240000,-1.535000,58.420000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<20.320000,-1.535000,50.800000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<20.320000,-1.535000,58.420000>}
box{<0,0,-0.635000><7.620000,0.035000,0.635000> rotate<0,90.000000,0> translate<20.320000,-1.535000,58.420000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<17.780000,-1.535000,38.100000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<22.860000,-1.535000,38.100000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,0.000000,0> translate<17.780000,-1.535000,38.100000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<22.860000,-1.535000,38.100000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<22.860000,-1.535000,40.640000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,90.000000,0> translate<22.860000,-1.535000,40.640000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<22.860000,-1.535000,48.260000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<22.860000,-1.535000,50.800000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,90.000000,0> translate<22.860000,-1.535000,50.800000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<22.860000,-1.535000,63.500000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<22.860000,-1.535000,53.340000>}
box{<0,0,-0.635000><10.160000,0.035000,0.635000> rotate<0,-90.000000,0> translate<22.860000,-1.535000,53.340000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<5.080000,-1.535000,63.500000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<22.860000,-1.535000,63.500000>}
box{<0,0,-0.635000><17.780000,0.035000,0.635000> rotate<0,0.000000,0> translate<5.080000,-1.535000,63.500000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<25.400000,-1.535000,5.080000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<25.400000,-1.535000,15.240000>}
box{<0,0,-0.635000><10.160000,0.035000,0.635000> rotate<0,90.000000,0> translate<25.400000,-1.535000,15.240000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<22.860000,-1.535000,40.640000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<25.400000,-1.535000,40.640000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,0.000000,0> translate<22.860000,-1.535000,40.640000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<25.400000,-1.535000,53.340000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<25.400000,-1.535000,50.800000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,-90.000000,0> translate<25.400000,-1.535000,50.800000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<22.860000,-1.535000,53.340000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<25.400000,-1.535000,53.340000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,0.000000,0> translate<22.860000,-1.535000,53.340000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<25.400000,-1.535000,55.880000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<25.400000,-1.535000,66.040000>}
box{<0,0,-0.635000><10.160000,0.035000,0.635000> rotate<0,90.000000,0> translate<25.400000,-1.535000,66.040000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<12.700000,-1.535000,25.400000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<27.940000,-1.535000,25.400000>}
box{<0,0,-0.635000><15.240000,0.035000,0.635000> rotate<0,0.000000,0> translate<12.700000,-1.535000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<27.940000,-1.535000,40.640000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<27.940000,-1.535000,43.180000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,90.000000,0> translate<27.940000,-1.535000,43.180000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<25.400000,-1.535000,55.880000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<27.940000,-1.535000,55.880000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,0.000000,0> translate<25.400000,-1.535000,55.880000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<27.940000,0.000000,43.180000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<27.940000,0.000000,55.880000>}
box{<0,0,-0.635000><12.700000,0.035000,0.635000> rotate<0,90.000000,0> translate<27.940000,0.000000,55.880000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<30.480000,-1.535000,5.080000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<30.480000,-1.535000,12.700000>}
box{<0,0,-0.635000><7.620000,0.035000,0.635000> rotate<0,90.000000,0> translate<30.480000,-1.535000,12.700000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<15.240000,-1.535000,22.860000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<30.480000,-1.535000,22.860000>}
box{<0,0,-0.635000><15.240000,0.035000,0.635000> rotate<0,0.000000,0> translate<15.240000,-1.535000,22.860000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<30.480000,-1.535000,22.860000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<30.480000,-1.535000,25.400000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,90.000000,0> translate<30.480000,-1.535000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<30.480000,-1.535000,40.640000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<30.480000,-1.535000,43.180000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,90.000000,0> translate<30.480000,-1.535000,43.180000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<30.480000,0.000000,43.180000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<30.480000,0.000000,55.880000>}
box{<0,0,-0.635000><12.700000,0.035000,0.635000> rotate<0,90.000000,0> translate<30.480000,0.000000,55.880000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<30.480000,-1.535000,55.880000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<30.480000,-1.535000,66.040000>}
box{<0,0,-0.635000><10.160000,0.035000,0.635000> rotate<0,90.000000,0> translate<30.480000,-1.535000,66.040000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<17.780000,-1.535000,20.320000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<33.020000,-1.535000,20.320000>}
box{<0,0,-0.635000><15.240000,0.035000,0.635000> rotate<0,0.000000,0> translate<17.780000,-1.535000,20.320000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<33.020000,-1.535000,20.320000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<33.020000,-1.535000,25.400000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,90.000000,0> translate<33.020000,-1.535000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<33.020000,-1.535000,40.640000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<33.020000,-1.535000,43.180000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,90.000000,0> translate<33.020000,-1.535000,43.180000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<33.020000,0.000000,43.180000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<33.020000,0.000000,55.880000>}
box{<0,0,-0.635000><12.700000,0.035000,0.635000> rotate<0,90.000000,0> translate<33.020000,0.000000,55.880000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<33.020000,-1.535000,55.880000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<33.020000,-1.535000,60.960000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,90.000000,0> translate<33.020000,-1.535000,60.960000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<35.560000,-1.535000,5.080000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<35.560000,-1.535000,10.160000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,90.000000,0> translate<35.560000,-1.535000,10.160000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<20.320000,-1.535000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<35.560000,-1.535000,17.780000>}
box{<0,0,-0.635000><15.240000,0.035000,0.635000> rotate<0,0.000000,0> translate<20.320000,-1.535000,17.780000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<35.560000,-1.535000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<35.560000,-1.535000,25.400000>}
box{<0,0,-0.635000><7.620000,0.035000,0.635000> rotate<0,90.000000,0> translate<35.560000,-1.535000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<35.560000,-1.535000,40.640000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<35.560000,-1.535000,43.180000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,90.000000,0> translate<35.560000,-1.535000,43.180000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<35.560000,0.000000,43.180000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<35.560000,0.000000,55.880000>}
box{<0,0,-0.635000><12.700000,0.035000,0.635000> rotate<0,90.000000,0> translate<35.560000,0.000000,55.880000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<33.020000,-1.535000,60.960000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<35.560000,-1.535000,60.960000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,0.000000,0> translate<33.020000,-1.535000,60.960000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<35.560000,-1.535000,60.960000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<35.560000,-1.535000,66.040000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,90.000000,0> translate<35.560000,-1.535000,66.040000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<25.400000,-1.535000,15.240000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<38.100000,-1.535000,15.240000>}
box{<0,0,-0.635000><12.700000,0.035000,0.635000> rotate<0,0.000000,0> translate<25.400000,-1.535000,15.240000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<38.100000,-1.535000,15.240000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<38.100000,-1.535000,25.400000>}
box{<0,0,-0.635000><10.160000,0.035000,0.635000> rotate<0,90.000000,0> translate<38.100000,-1.535000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<38.100000,-1.535000,45.720000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<38.100000,-1.535000,40.640000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,-90.000000,0> translate<38.100000,-1.535000,40.640000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<20.320000,-1.535000,45.720000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<38.100000,-1.535000,45.720000>}
box{<0,0,-0.635000><17.780000,0.035000,0.635000> rotate<0,0.000000,0> translate<20.320000,-1.535000,45.720000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<35.560000,-1.535000,55.880000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<38.100000,-1.535000,55.880000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,0.000000,0> translate<35.560000,-1.535000,55.880000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<38.100000,0.000000,43.180000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<38.100000,0.000000,60.960000>}
box{<0,0,-0.635000><17.780000,0.035000,0.635000> rotate<0,90.000000,0> translate<38.100000,0.000000,60.960000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<38.100000,-1.535000,55.880000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<38.100000,-1.535000,63.500000>}
box{<0,0,-0.635000><7.620000,0.035000,0.635000> rotate<0,90.000000,0> translate<38.100000,-1.535000,63.500000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<40.640000,-1.535000,5.080000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<40.640000,-1.535000,7.620000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,90.000000,0> translate<40.640000,-1.535000,7.620000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<30.480000,-1.535000,12.700000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<40.640000,-1.535000,12.700000>}
box{<0,0,-0.635000><10.160000,0.035000,0.635000> rotate<0,0.000000,0> translate<30.480000,-1.535000,12.700000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<40.640000,-1.535000,12.700000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<40.640000,-1.535000,25.400000>}
box{<0,0,-0.635000><12.700000,0.035000,0.635000> rotate<0,90.000000,0> translate<40.640000,-1.535000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<38.100000,0.000000,43.180000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<40.640000,0.000000,43.180000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,0.000000,0> translate<38.100000,0.000000,43.180000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<40.640000,-1.535000,40.640000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<40.640000,-1.535000,43.180000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,90.000000,0> translate<40.640000,-1.535000,43.180000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<40.640000,-1.535000,48.260000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<40.640000,-1.535000,45.720000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,-90.000000,0> translate<40.640000,-1.535000,45.720000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<22.860000,-1.535000,48.260000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<40.640000,-1.535000,48.260000>}
box{<0,0,-0.635000><17.780000,0.035000,0.635000> rotate<0,0.000000,0> translate<22.860000,-1.535000,48.260000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<25.400000,-1.535000,53.340000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<40.640000,-1.535000,53.340000>}
box{<0,0,-0.635000><15.240000,0.035000,0.635000> rotate<0,0.000000,0> translate<25.400000,-1.535000,53.340000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<40.640000,-1.535000,53.340000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<40.640000,-1.535000,58.420000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,90.000000,0> translate<40.640000,-1.535000,58.420000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<38.100000,0.000000,60.960000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<40.640000,0.000000,60.960000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,0.000000,0> translate<38.100000,0.000000,60.960000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<38.100000,-1.535000,63.500000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<40.640000,-1.535000,63.500000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,0.000000,0> translate<38.100000,-1.535000,63.500000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<40.640000,-1.535000,63.500000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<40.640000,-1.535000,66.040000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,90.000000,0> translate<40.640000,-1.535000,66.040000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<35.560000,-1.535000,10.160000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<43.180000,-1.535000,10.160000>}
box{<0,0,-0.635000><7.620000,0.035000,0.635000> rotate<0,0.000000,0> translate<35.560000,-1.535000,10.160000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<43.180000,-1.535000,10.160000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<43.180000,-1.535000,25.400000>}
box{<0,0,-0.635000><15.240000,0.035000,0.635000> rotate<0,90.000000,0> translate<43.180000,-1.535000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<43.180000,-1.535000,45.720000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<43.180000,-1.535000,40.640000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,-90.000000,0> translate<43.180000,-1.535000,40.640000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<40.640000,-1.535000,45.720000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<43.180000,-1.535000,45.720000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,0.000000,0> translate<40.640000,-1.535000,45.720000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.180000,-1.535000,48.260000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.180000,-1.535000,53.340000>}
box{<0,0,-0.203200><5.080000,0.035000,0.203200> rotate<0,90.000000,0> translate<43.180000,-1.535000,53.340000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<43.180000,-1.535000,48.260000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<43.180000,-1.535000,53.340000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,90.000000,0> translate<43.180000,-1.535000,53.340000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<40.640000,-1.535000,7.620000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<45.720000,-1.535000,7.620000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,0.000000,0> translate<40.640000,-1.535000,7.620000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<45.720000,-1.535000,7.620000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<45.720000,-1.535000,25.400000>}
box{<0,0,-0.635000><17.780000,0.035000,0.635000> rotate<0,90.000000,0> translate<45.720000,-1.535000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<43.180000,-1.535000,48.260000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<45.720000,-1.535000,48.260000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,0.000000,0> translate<43.180000,-1.535000,48.260000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<45.720000,-1.535000,40.640000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<45.720000,-1.535000,48.260000>}
box{<0,0,-0.635000><7.620000,0.035000,0.635000> rotate<0,90.000000,0> translate<45.720000,-1.535000,48.260000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<40.640000,-1.535000,60.960000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<45.720000,-1.535000,60.960000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,0.000000,0> translate<40.640000,-1.535000,60.960000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<45.720000,-1.535000,60.960000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<45.720000,-1.535000,66.040000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,90.000000,0> translate<45.720000,-1.535000,66.040000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<45.720000,-1.535000,5.080000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<48.260000,-1.535000,5.080000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,0.000000,0> translate<45.720000,-1.535000,5.080000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<48.260000,-1.535000,5.080000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<48.260000,-1.535000,25.400000>}
box{<0,0,-0.635000><20.320000,0.035000,0.635000> rotate<0,90.000000,0> translate<48.260000,-1.535000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<48.260000,-1.535000,40.640000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<48.260000,-1.535000,48.260000>}
box{<0,0,-0.635000><7.620000,0.035000,0.635000> rotate<0,90.000000,0> translate<48.260000,-1.535000,48.260000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.260000,-1.535000,48.260000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.260000,-1.535000,53.340000>}
box{<0,0,-0.203200><5.080000,0.035000,0.203200> rotate<0,90.000000,0> translate<48.260000,-1.535000,53.340000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<48.260000,-1.535000,48.260000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<48.260000,-1.535000,53.340000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,90.000000,0> translate<48.260000,-1.535000,53.340000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.180000,-1.535000,55.880000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.260000,-1.535000,55.880000>}
box{<0,0,-0.203200><5.080000,0.035000,0.203200> rotate<0,0.000000,0> translate<43.180000,-1.535000,55.880000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.180000,-1.535000,55.880000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.260000,-1.535000,55.880000>}
box{<0,0,-0.203200><5.080000,0.035000,0.203200> rotate<0,0.000000,0> translate<43.180000,-1.535000,55.880000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<43.180000,-1.535000,55.880000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<48.260000,-1.535000,55.880000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,0.000000,0> translate<43.180000,-1.535000,55.880000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<50.800000,-1.535000,5.080000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<50.800000,-1.535000,12.700000>}
box{<0,0,-0.635000><7.620000,0.035000,0.635000> rotate<0,90.000000,0> translate<50.800000,-1.535000,12.700000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<50.800000,-1.535000,30.480000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<50.800000,-1.535000,25.400000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,-90.000000,0> translate<50.800000,-1.535000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<17.780000,-1.535000,30.480000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<50.800000,-1.535000,30.480000>}
box{<0,0,-0.635000><33.020000,0.035000,0.635000> rotate<0,0.000000,0> translate<17.780000,-1.535000,30.480000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<20.320000,-1.535000,33.020000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<50.800000,-1.535000,33.020000>}
box{<0,0,-0.635000><30.480000,0.035000,0.635000> rotate<0,0.000000,0> translate<20.320000,-1.535000,33.020000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<50.800000,-1.535000,33.020000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<50.800000,-1.535000,40.640000>}
box{<0,0,-0.635000><7.620000,0.035000,0.635000> rotate<0,90.000000,0> translate<50.800000,-1.535000,40.640000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<48.260000,-1.535000,55.880000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<50.800000,-1.535000,55.880000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,0.000000,0> translate<48.260000,-1.535000,55.880000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<50.800000,-1.535000,40.640000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<50.800000,-1.535000,55.880000>}
box{<0,0,-0.635000><15.240000,0.035000,0.635000> rotate<0,90.000000,0> translate<50.800000,-1.535000,55.880000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<50.800000,-1.535000,60.960000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<50.800000,-1.535000,66.040000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,90.000000,0> translate<50.800000,-1.535000,66.040000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<50.800000,-1.535000,20.320000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<53.340000,-1.535000,20.320000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,0.000000,0> translate<50.800000,-1.535000,20.320000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<53.340000,-1.535000,20.320000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<53.340000,-1.535000,25.400000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,90.000000,0> translate<53.340000,-1.535000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<53.340000,-1.535000,25.400000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<53.340000,-1.535000,27.940000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,90.000000,0> translate<53.340000,-1.535000,27.940000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<53.340000,-1.535000,33.020000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<53.340000,-1.535000,27.940000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,-90.000000,0> translate<53.340000,-1.535000,27.940000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<50.800000,-1.535000,33.020000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<53.340000,-1.535000,33.020000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,0.000000,0> translate<50.800000,-1.535000,33.020000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<53.340000,-1.535000,53.340000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<53.340000,-1.535000,40.640000>}
box{<0,0,-0.635000><12.700000,0.035000,0.635000> rotate<0,-90.000000,0> translate<53.340000,-1.535000,40.640000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<55.880000,-1.535000,5.080000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<55.880000,-1.535000,10.160000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,90.000000,0> translate<55.880000,-1.535000,10.160000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<55.880000,-1.535000,20.320000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<55.880000,-1.535000,25.400000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,90.000000,0> translate<55.880000,-1.535000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<55.880000,-1.535000,30.480000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<55.880000,-1.535000,40.640000>}
box{<0,0,-0.635000><10.160000,0.035000,0.635000> rotate<0,90.000000,0> translate<55.880000,-1.535000,40.640000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<55.880000,-1.535000,40.640000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<55.880000,-1.535000,43.180000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,90.000000,0> translate<55.880000,-1.535000,43.180000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<53.340000,-1.535000,53.340000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<55.880000,-1.535000,53.340000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,0.000000,0> translate<53.340000,-1.535000,53.340000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<55.880000,-1.535000,55.880000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<55.880000,-1.535000,53.340000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,-90.000000,0> translate<55.880000,-1.535000,53.340000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<55.880000,-1.535000,55.880000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<55.880000,-1.535000,53.340000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,-90.000000,0> translate<55.880000,-1.535000,53.340000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<55.880000,-1.535000,58.420000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<55.880000,-1.535000,55.880000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,-90.000000,0> translate<55.880000,-1.535000,55.880000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<40.640000,-1.535000,58.420000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<55.880000,-1.535000,58.420000>}
box{<0,0,-0.635000><15.240000,0.035000,0.635000> rotate<0,0.000000,0> translate<40.640000,-1.535000,58.420000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<55.880000,-1.535000,63.500000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<55.880000,-1.535000,66.040000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,90.000000,0> translate<55.880000,-1.535000,66.040000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<50.800000,-1.535000,12.700000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<58.420000,-1.535000,12.700000>}
box{<0,0,-0.635000><7.620000,0.035000,0.635000> rotate<0,0.000000,0> translate<50.800000,-1.535000,12.700000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<58.420000,-1.535000,12.700000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<58.420000,-1.535000,25.400000>}
box{<0,0,-0.635000><12.700000,0.035000,0.635000> rotate<0,90.000000,0> translate<58.420000,-1.535000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<58.420000,-1.535000,33.020000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<58.420000,-1.535000,40.640000>}
box{<0,0,-0.635000><7.620000,0.035000,0.635000> rotate<0,90.000000,0> translate<58.420000,-1.535000,40.640000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<50.800000,-1.535000,60.960000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<58.420000,-1.535000,60.960000>}
box{<0,0,-0.635000><7.620000,0.035000,0.635000> rotate<0,0.000000,0> translate<50.800000,-1.535000,60.960000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<58.420000,-1.535000,40.640000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<58.420000,-1.535000,60.960000>}
box{<0,0,-0.635000><20.320000,0.035000,0.635000> rotate<0,90.000000,0> translate<58.420000,-1.535000,60.960000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<60.960000,-1.535000,5.080000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<60.960000,-1.535000,7.620000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,90.000000,0> translate<60.960000,-1.535000,7.620000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<55.880000,-1.535000,10.160000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<60.960000,-1.535000,10.160000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,0.000000,0> translate<55.880000,-1.535000,10.160000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<60.960000,-1.535000,10.160000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<60.960000,-1.535000,25.400000>}
box{<0,0,-0.635000><15.240000,0.035000,0.635000> rotate<0,90.000000,0> translate<60.960000,-1.535000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<60.960000,-1.535000,35.560000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<60.960000,-1.535000,40.640000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,90.000000,0> translate<60.960000,-1.535000,40.640000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<55.880000,-1.535000,63.500000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<60.960000,-1.535000,63.500000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,0.000000,0> translate<55.880000,-1.535000,63.500000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<60.960000,-1.535000,40.640000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<60.960000,-1.535000,63.500000>}
box{<0,0,-0.635000><22.860000,0.035000,0.635000> rotate<0,90.000000,0> translate<60.960000,-1.535000,63.500000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<60.960000,-1.535000,7.620000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<63.500000,-1.535000,7.620000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,0.000000,0> translate<60.960000,-1.535000,7.620000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<63.500000,-1.535000,7.620000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<63.500000,-1.535000,25.400000>}
box{<0,0,-0.635000><17.780000,0.035000,0.635000> rotate<0,90.000000,0> translate<63.500000,-1.535000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<63.500000,-1.535000,38.100000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<63.500000,-1.535000,40.640000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,90.000000,0> translate<63.500000,-1.535000,40.640000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<60.960000,-1.535000,66.040000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<63.500000,-1.535000,66.040000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,0.000000,0> translate<60.960000,-1.535000,66.040000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<63.500000,-1.535000,40.640000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<63.500000,-1.535000,66.040000>}
box{<0,0,-0.635000><25.400000,0.035000,0.635000> rotate<0,90.000000,0> translate<63.500000,-1.535000,66.040000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<66.040000,-1.535000,5.080000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<66.040000,-1.535000,25.400000>}
box{<0,0,-0.635000><20.320000,0.035000,0.635000> rotate<0,90.000000,0> translate<66.040000,-1.535000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<66.040000,-1.535000,40.640000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<66.040000,-1.535000,66.040000>}
box{<0,0,-0.635000><25.400000,0.035000,0.635000> rotate<0,90.000000,0> translate<66.040000,-1.535000,66.040000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<68.580000,-1.535000,7.620000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<68.580000,-1.535000,25.400000>}
box{<0,0,-0.635000><17.780000,0.035000,0.635000> rotate<0,90.000000,0> translate<68.580000,-1.535000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<68.580000,-1.535000,40.640000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<68.580000,-1.535000,53.340000>}
box{<0,0,-0.635000><12.700000,0.035000,0.635000> rotate<0,90.000000,0> translate<68.580000,-1.535000,53.340000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<68.580000,-1.535000,7.620000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<71.120000,-1.535000,7.620000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,0.000000,0> translate<68.580000,-1.535000,7.620000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<71.120000,-1.535000,5.080000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<71.120000,-1.535000,7.620000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,90.000000,0> translate<71.120000,-1.535000,7.620000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<71.120000,-1.535000,10.160000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<71.120000,-1.535000,25.400000>}
box{<0,0,-0.635000><15.240000,0.035000,0.635000> rotate<0,90.000000,0> translate<71.120000,-1.535000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<71.120000,-1.535000,40.640000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<71.120000,-1.535000,50.800000>}
box{<0,0,-0.635000><10.160000,0.035000,0.635000> rotate<0,90.000000,0> translate<71.120000,-1.535000,50.800000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<68.580000,-1.535000,53.340000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<71.120000,-1.535000,53.340000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,0.000000,0> translate<68.580000,-1.535000,53.340000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<71.120000,-1.535000,53.340000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<71.120000,-1.535000,66.040000>}
box{<0,0,-0.635000><12.700000,0.035000,0.635000> rotate<0,90.000000,0> translate<71.120000,-1.535000,66.040000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<73.660000,-1.535000,12.700000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<73.660000,-1.535000,25.400000>}
box{<0,0,-0.635000><12.700000,0.035000,0.635000> rotate<0,90.000000,0> translate<73.660000,-1.535000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<73.660000,-1.535000,40.640000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<73.660000,-1.535000,48.260000>}
box{<0,0,-0.635000><7.620000,0.035000,0.635000> rotate<0,90.000000,0> translate<73.660000,-1.535000,48.260000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<71.120000,-1.535000,50.800000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<73.660000,-1.535000,50.800000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,0.000000,0> translate<71.120000,-1.535000,50.800000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<73.660000,-1.535000,50.800000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<73.660000,-1.535000,63.500000>}
box{<0,0,-0.635000><12.700000,0.035000,0.635000> rotate<0,90.000000,0> translate<73.660000,-1.535000,63.500000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<71.120000,-1.535000,10.160000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<76.200000,-1.535000,10.160000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,0.000000,0> translate<71.120000,-1.535000,10.160000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<76.200000,-1.535000,5.080000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<76.200000,-1.535000,10.160000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,90.000000,0> translate<76.200000,-1.535000,10.160000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<76.200000,-1.535000,22.860000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<76.200000,-1.535000,25.400000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,90.000000,0> translate<76.200000,-1.535000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<73.660000,-1.535000,48.260000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<76.200000,-1.535000,48.260000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,0.000000,0> translate<73.660000,-1.535000,48.260000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<76.200000,-1.535000,48.260000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<76.200000,-1.535000,60.960000>}
box{<0,0,-0.635000><12.700000,0.035000,0.635000> rotate<0,90.000000,0> translate<76.200000,-1.535000,60.960000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<73.660000,-1.535000,63.500000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<76.200000,-1.535000,63.500000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,0.000000,0> translate<73.660000,-1.535000,63.500000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<76.200000,-1.535000,63.500000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<76.200000,-1.535000,66.040000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,90.000000,0> translate<76.200000,-1.535000,66.040000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<73.660000,-1.535000,12.700000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<78.740000,-1.535000,12.700000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,0.000000,0> translate<73.660000,-1.535000,12.700000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<78.740000,-1.535000,5.080000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<78.740000,-1.535000,12.700000>}
box{<0,0,-0.635000><7.620000,0.035000,0.635000> rotate<0,90.000000,0> translate<78.740000,-1.535000,12.700000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<76.200000,-1.535000,40.640000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<78.740000,-1.535000,40.640000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,0.000000,0> translate<76.200000,-1.535000,40.640000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<78.740000,-1.535000,40.640000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<78.740000,-1.535000,58.420000>}
box{<0,0,-0.635000><17.780000,0.035000,0.635000> rotate<0,90.000000,0> translate<78.740000,-1.535000,58.420000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<78.740000,-1.535000,5.080000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<81.280000,-1.535000,5.080000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,0.000000,0> translate<78.740000,-1.535000,5.080000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<63.500000,-1.535000,38.100000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<81.280000,-1.535000,38.100000>}
box{<0,0,-0.635000><17.780000,0.035000,0.635000> rotate<0,0.000000,0> translate<63.500000,-1.535000,38.100000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<81.280000,-1.535000,38.100000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<81.280000,-1.535000,45.720000>}
box{<0,0,-0.635000><7.620000,0.035000,0.635000> rotate<0,90.000000,0> translate<81.280000,-1.535000,45.720000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<76.200000,-1.535000,60.960000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<81.280000,-1.535000,60.960000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,0.000000,0> translate<76.200000,-1.535000,60.960000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<81.280000,-1.535000,60.960000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<81.280000,-1.535000,66.040000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,90.000000,0> translate<81.280000,-1.535000,66.040000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<55.880000,-1.535000,30.480000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<83.820000,-1.535000,30.480000>}
box{<0,0,-0.635000><27.940000,0.035000,0.635000> rotate<0,0.000000,0> translate<55.880000,-1.535000,30.480000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<58.420000,-1.535000,33.020000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<83.820000,-1.535000,33.020000>}
box{<0,0,-0.635000><25.400000,0.035000,0.635000> rotate<0,0.000000,0> translate<58.420000,-1.535000,33.020000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<60.960000,-1.535000,35.560000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<83.820000,-1.535000,35.560000>}
box{<0,0,-0.635000><22.860000,0.035000,0.635000> rotate<0,0.000000,0> translate<60.960000,-1.535000,35.560000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<86.360000,-1.535000,5.080000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<86.360000,-1.535000,7.620000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,90.000000,0> translate<86.360000,-1.535000,7.620000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<53.340000,-1.535000,27.940000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<86.360000,-1.535000,27.940000>}
box{<0,0,-0.635000><33.020000,0.035000,0.635000> rotate<0,0.000000,0> translate<53.340000,-1.535000,27.940000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<86.360000,-1.535000,27.940000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<86.360000,-1.535000,30.480000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,90.000000,0> translate<86.360000,-1.535000,30.480000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<86.360000,-1.535000,43.180000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<86.360000,-1.535000,35.560000>}
box{<0,0,-0.635000><7.620000,0.035000,0.635000> rotate<0,-90.000000,0> translate<86.360000,-1.535000,35.560000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<86.360000,0.000000,48.260000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<86.360000,0.000000,43.180000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,-90.000000,0> translate<86.360000,0.000000,43.180000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<78.740000,-1.535000,58.420000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<86.360000,-1.535000,58.420000>}
box{<0,0,-0.635000><7.620000,0.035000,0.635000> rotate<0,0.000000,0> translate<78.740000,-1.535000,58.420000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<86.360000,-1.535000,58.420000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<86.360000,-1.535000,66.040000>}
box{<0,0,-0.635000><7.620000,0.035000,0.635000> rotate<0,90.000000,0> translate<86.360000,-1.535000,66.040000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<86.360000,-1.535000,7.620000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<88.900000,-1.535000,7.620000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,0.000000,0> translate<86.360000,-1.535000,7.620000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<76.200000,-1.535000,22.860000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<88.900000,-1.535000,22.860000>}
box{<0,0,-0.635000><12.700000,0.035000,0.635000> rotate<0,0.000000,0> translate<76.200000,-1.535000,22.860000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<88.900000,-1.535000,7.620000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<88.900000,-1.535000,22.860000>}
box{<0,0,-0.635000><15.240000,0.035000,0.635000> rotate<0,90.000000,0> translate<88.900000,-1.535000,22.860000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<86.360000,-1.535000,33.020000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<88.900000,-1.535000,33.020000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,0.000000,0> translate<86.360000,-1.535000,33.020000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<88.900000,-1.535000,45.720000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<88.900000,-1.535000,33.020000>}
box{<0,0,-0.635000><12.700000,0.035000,0.635000> rotate<0,-90.000000,0> translate<88.900000,-1.535000,33.020000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<81.280000,-1.535000,45.720000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<88.900000,-1.535000,45.720000>}
box{<0,0,-0.635000><7.620000,0.035000,0.635000> rotate<0,0.000000,0> translate<81.280000,-1.535000,45.720000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<86.360000,-1.535000,48.260000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<88.900000,-1.535000,48.260000>}
box{<0,0,-0.635000><2.540000,0.035000,0.635000> rotate<0,0.000000,0> translate<86.360000,-1.535000,48.260000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<88.900000,-1.535000,58.420000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<88.900000,-1.535000,48.260000>}
box{<0,0,-0.635000><10.160000,0.035000,0.635000> rotate<0,-90.000000,0> translate<88.900000,-1.535000,48.260000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<55.880000,0.000000,58.420000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<88.900000,0.000000,58.420000>}
box{<0,0,-0.635000><33.020000,0.035000,0.635000> rotate<0,0.000000,0> translate<55.880000,0.000000,58.420000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<91.440000,-1.535000,27.940000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<91.440000,-1.535000,5.080000>}
box{<0,0,-0.635000><22.860000,0.035000,0.635000> rotate<0,-90.000000,0> translate<91.440000,-1.535000,5.080000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<86.360000,-1.535000,27.940000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<91.440000,-1.535000,27.940000>}
box{<0,0,-0.635000><5.080000,0.035000,0.635000> rotate<0,0.000000,0> translate<86.360000,-1.535000,27.940000> }
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<91.440000,-1.535000,27.940000>}
cylinder{<0,0,0><0,0.035000,0>0.635000 translate<91.440000,-1.535000,66.040000>}
box{<0,0,-0.635000><38.100000,0.035000,0.635000> rotate<0,90.000000,0> translate<91.440000,-1.535000,66.040000> }
//Text
//Rect
union{
texture{col_pds}
}
texture{col_wrs}
}
#end
#if(pcb_polygons=on)
union{
//Polygone
texture{col_pol}
}
#end
union{
cylinder{<43.180000,0.038000,53.340000><43.180000,-1.538000,53.340000>0.406400}
cylinder{<43.180000,0.038000,55.880000><43.180000,-1.538000,55.880000>0.406400}
cylinder{<48.260000,0.038000,53.340000><48.260000,-1.538000,53.340000>0.406400}
cylinder{<48.260000,0.038000,55.880000><48.260000,-1.538000,55.880000>0.406400}
cylinder{<55.880000,0.038000,55.880000><55.880000,-1.538000,55.880000>0.406400}
cylinder{<50.800000,0.038000,55.880000><50.800000,-1.538000,55.880000>0.406400}
cylinder{<10.160000,0.038000,48.260000><10.160000,-1.538000,48.260000>0.406400}
cylinder{<7.620000,0.038000,48.260000><7.620000,-1.538000,48.260000>0.406400}
cylinder{<20.320000,0.038000,30.454600><20.320000,-1.538000,30.454600>0.406400}
cylinder{<20.320000,0.038000,32.994600><20.320000,-1.538000,32.994600>0.406400}
cylinder{<55.880000,0.038000,20.320000><55.880000,-1.538000,20.320000>0.406400}
cylinder{<50.800000,0.038000,20.320000><50.800000,-1.538000,20.320000>0.406400}
cylinder{<5.080000,0.038000,43.180000><5.080000,-1.538000,43.180000>0.406400}
cylinder{<12.700000,0.038000,43.180000><12.700000,-1.538000,43.180000>0.406400}
cylinder{<76.200000,0.038000,40.640000><76.200000,-1.538000,40.640000>0.406400}
cylinder{<73.660000,0.038000,40.640000><73.660000,-1.538000,40.640000>0.406400}
cylinder{<71.120000,0.038000,40.640000><71.120000,-1.538000,40.640000>0.406400}
cylinder{<68.580000,0.038000,40.640000><68.580000,-1.538000,40.640000>0.406400}
cylinder{<66.040000,0.038000,40.640000><66.040000,-1.538000,40.640000>0.406400}
cylinder{<63.500000,0.038000,40.640000><63.500000,-1.538000,40.640000>0.406400}
cylinder{<60.960000,0.038000,40.640000><60.960000,-1.538000,40.640000>0.406400}
cylinder{<58.420000,0.038000,40.640000><58.420000,-1.538000,40.640000>0.406400}
cylinder{<55.880000,0.038000,40.640000><55.880000,-1.538000,40.640000>0.406400}
cylinder{<53.340000,0.038000,40.640000><53.340000,-1.538000,40.640000>0.406400}
cylinder{<50.800000,0.038000,40.640000><50.800000,-1.538000,40.640000>0.406400}
cylinder{<48.260000,0.038000,40.640000><48.260000,-1.538000,40.640000>0.406400}
cylinder{<45.720000,0.038000,40.640000><45.720000,-1.538000,40.640000>0.406400}
cylinder{<43.180000,0.038000,40.640000><43.180000,-1.538000,40.640000>0.406400}
cylinder{<40.640000,0.038000,40.640000><40.640000,-1.538000,40.640000>0.406400}
cylinder{<38.100000,0.038000,40.640000><38.100000,-1.538000,40.640000>0.406400}
cylinder{<35.560000,0.038000,40.640000><35.560000,-1.538000,40.640000>0.406400}
cylinder{<33.020000,0.038000,40.640000><33.020000,-1.538000,40.640000>0.406400}
cylinder{<30.480000,0.038000,40.640000><30.480000,-1.538000,40.640000>0.406400}
cylinder{<27.940000,0.038000,40.640000><27.940000,-1.538000,40.640000>0.406400}
cylinder{<27.940000,0.038000,25.400000><27.940000,-1.538000,25.400000>0.406400}
cylinder{<30.480000,0.038000,25.400000><30.480000,-1.538000,25.400000>0.406400}
cylinder{<33.020000,0.038000,25.400000><33.020000,-1.538000,25.400000>0.406400}
cylinder{<35.560000,0.038000,25.400000><35.560000,-1.538000,25.400000>0.406400}
cylinder{<38.100000,0.038000,25.400000><38.100000,-1.538000,25.400000>0.406400}
cylinder{<40.640000,0.038000,25.400000><40.640000,-1.538000,25.400000>0.406400}
cylinder{<43.180000,0.038000,25.400000><43.180000,-1.538000,25.400000>0.406400}
cylinder{<45.720000,0.038000,25.400000><45.720000,-1.538000,25.400000>0.406400}
cylinder{<48.260000,0.038000,25.400000><48.260000,-1.538000,25.400000>0.406400}
cylinder{<50.800000,0.038000,25.400000><50.800000,-1.538000,25.400000>0.406400}
cylinder{<53.340000,0.038000,25.400000><53.340000,-1.538000,25.400000>0.406400}
cylinder{<55.880000,0.038000,25.400000><55.880000,-1.538000,25.400000>0.406400}
cylinder{<58.420000,0.038000,25.400000><58.420000,-1.538000,25.400000>0.406400}
cylinder{<60.960000,0.038000,25.400000><60.960000,-1.538000,25.400000>0.406400}
cylinder{<63.500000,0.038000,25.400000><63.500000,-1.538000,25.400000>0.406400}
cylinder{<66.040000,0.038000,25.400000><66.040000,-1.538000,25.400000>0.406400}
cylinder{<68.580000,0.038000,25.400000><68.580000,-1.538000,25.400000>0.406400}
cylinder{<71.120000,0.038000,25.400000><71.120000,-1.538000,25.400000>0.406400}
cylinder{<73.660000,0.038000,25.400000><73.660000,-1.538000,25.400000>0.406400}
cylinder{<76.200000,0.038000,25.400000><76.200000,-1.538000,25.400000>0.406400}
cylinder{<43.180000,0.038000,48.260000><43.180000,-1.538000,48.260000>0.406400}
cylinder{<48.260000,0.038000,48.260000><48.260000,-1.538000,48.260000>0.406400}
cylinder{<55.880000,0.038000,53.340000><55.880000,-1.538000,53.340000>0.406400}
cylinder{<55.880000,0.038000,43.180000><55.880000,-1.538000,43.180000>0.406400}
cylinder{<22.860000,0.038000,50.800000><22.860000,-1.538000,50.800000>0.406400}
cylinder{<22.860000,0.038000,40.640000><22.860000,-1.538000,40.640000>0.406400}
cylinder{<20.320000,0.038000,40.640000><20.320000,-1.538000,40.640000>0.406400}
cylinder{<20.320000,0.038000,50.800000><20.320000,-1.538000,50.800000>0.406400}
cylinder{<25.400000,0.038000,40.640000><25.400000,-1.538000,40.640000>0.406400}
cylinder{<25.400000,0.038000,50.800000><25.400000,-1.538000,50.800000>0.406400}
cylinder{<15.240000,0.038000,50.800000><15.240000,-1.538000,50.800000>0.406400}
cylinder{<15.240000,0.038000,40.640000><15.240000,-1.538000,40.640000>0.406400}
cylinder{<12.720000,0.038000,56.250000><12.720000,-1.538000,56.250000>0.475000}
cylinder{<15.220000,0.038000,56.250000><15.220000,-1.538000,56.250000>0.475000}
cylinder{<15.220000,0.038000,58.250000><15.220000,-1.538000,58.250000>0.475000}
cylinder{<12.720000,0.038000,58.250000><12.720000,-1.538000,58.250000>0.475000}
cylinder{<83.820000,0.038000,35.560000><83.820000,-1.538000,35.560000>0.457200}
cylinder{<86.360000,0.038000,35.560000><86.360000,-1.538000,35.560000>0.457200}
cylinder{<83.820000,0.038000,33.020000><83.820000,-1.538000,33.020000>0.457200}
cylinder{<86.360000,0.038000,33.020000><86.360000,-1.538000,33.020000>0.457200}
cylinder{<83.820000,0.038000,30.480000><83.820000,-1.538000,30.480000>0.457200}
cylinder{<86.360000,0.038000,30.480000><86.360000,-1.538000,30.480000>0.457200}
cylinder{<5.080000,0.038000,5.080000><5.080000,-1.538000,5.080000>0.596900}
cylinder{<10.160000,0.038000,5.080000><10.160000,-1.538000,5.080000>0.596900}
cylinder{<15.240000,0.038000,5.080000><15.240000,-1.538000,5.080000>0.596900}
cylinder{<20.320000,0.038000,5.080000><20.320000,-1.538000,5.080000>0.596900}
cylinder{<25.400000,0.038000,5.080000><25.400000,-1.538000,5.080000>0.596900}
cylinder{<30.480000,0.038000,5.080000><30.480000,-1.538000,5.080000>0.596900}
cylinder{<35.560000,0.038000,5.080000><35.560000,-1.538000,5.080000>0.596900}
cylinder{<40.640000,0.038000,5.080000><40.640000,-1.538000,5.080000>0.596900}
cylinder{<45.720000,0.038000,5.080000><45.720000,-1.538000,5.080000>0.596900}
cylinder{<50.800000,0.038000,5.080000><50.800000,-1.538000,5.080000>0.596900}
cylinder{<55.880000,0.038000,5.080000><55.880000,-1.538000,5.080000>0.596900}
cylinder{<60.960000,0.038000,5.080000><60.960000,-1.538000,5.080000>0.596900}
cylinder{<66.040000,0.038000,5.080000><66.040000,-1.538000,5.080000>0.596900}
cylinder{<71.120000,0.038000,5.080000><71.120000,-1.538000,5.080000>0.596900}
cylinder{<76.200000,0.038000,5.080000><76.200000,-1.538000,5.080000>0.596900}
cylinder{<81.280000,0.038000,5.080000><81.280000,-1.538000,5.080000>0.596900}
cylinder{<60.960000,0.038000,66.040000><60.960000,-1.538000,66.040000>0.596900}
cylinder{<55.880000,0.038000,66.040000><55.880000,-1.538000,66.040000>0.596900}
cylinder{<50.800000,0.038000,66.040000><50.800000,-1.538000,66.040000>0.596900}
cylinder{<45.720000,0.038000,66.040000><45.720000,-1.538000,66.040000>0.596900}
cylinder{<40.640000,0.038000,66.040000><40.640000,-1.538000,66.040000>0.596900}
cylinder{<35.560000,0.038000,66.040000><35.560000,-1.538000,66.040000>0.596900}
cylinder{<30.480000,0.038000,66.040000><30.480000,-1.538000,66.040000>0.596900}
cylinder{<25.400000,0.038000,66.040000><25.400000,-1.538000,66.040000>0.596900}
cylinder{<86.360000,0.038000,5.080000><86.360000,-1.538000,5.080000>0.596900}
cylinder{<91.440000,0.038000,5.080000><91.440000,-1.538000,5.080000>0.596900}
cylinder{<81.280000,0.038000,66.040000><81.280000,-1.538000,66.040000>0.596900}
cylinder{<76.200000,0.038000,66.040000><76.200000,-1.538000,66.040000>0.596900}
cylinder{<71.120000,0.038000,66.040000><71.120000,-1.538000,66.040000>0.596900}
cylinder{<66.040000,0.038000,66.040000><66.040000,-1.538000,66.040000>0.596900}
cylinder{<91.440000,0.038000,66.040000><91.440000,-1.538000,66.040000>0.596900}
cylinder{<86.360000,0.038000,66.040000><86.360000,-1.538000,66.040000>0.596900}
//Bohrungen(schnell)/Durchkontaktierungen
cylinder{<12.700000,0.038000,33.020000><12.700000,-1.538000,33.020000>0.500000 }
cylinder{<86.360000,0.038000,43.180000><86.360000,-1.538000,43.180000>0.500000 }
cylinder{<55.880000,0.038000,58.420000><55.880000,-1.538000,58.420000>0.500000 }
cylinder{<86.360000,0.038000,48.260000><86.360000,-1.538000,48.260000>0.500000 }
cylinder{<88.900000,0.038000,58.420000><88.900000,-1.538000,58.420000>0.500000 }
cylinder{<10.160000,0.038000,38.100000><10.160000,-1.538000,38.100000>0.500000 }
cylinder{<15.240000,0.038000,38.100000><15.240000,-1.538000,38.100000>0.500000 }
cylinder{<35.560000,0.038000,43.180000><35.560000,-1.538000,43.180000>0.500000 }
cylinder{<35.560000,0.038000,55.880000><35.560000,-1.538000,55.880000>0.500000 }
cylinder{<40.640000,0.038000,43.180000><40.640000,-1.538000,43.180000>0.500000 }
cylinder{<40.640000,0.038000,60.960000><40.640000,-1.538000,60.960000>0.500000 }
cylinder{<33.020000,0.038000,43.180000><33.020000,-1.538000,43.180000>0.500000 }
cylinder{<33.020000,0.038000,55.880000><33.020000,-1.538000,55.880000>0.500000 }
cylinder{<30.480000,0.038000,43.180000><30.480000,-1.538000,43.180000>0.500000 }
cylinder{<30.480000,0.038000,55.880000><30.480000,-1.538000,55.880000>0.500000 }
cylinder{<27.940000,0.038000,43.180000><27.940000,-1.538000,43.180000>0.500000 }
cylinder{<27.940000,0.038000,55.880000><27.940000,-1.538000,55.880000>0.500000 }
//Bohrungen(schnell)/Platine
texture{col_hls}
}
#if(pcb_silkscreen=on)
//Bestckungsdruck
union{
//C1 silk screen
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<41.910000,0.000000,52.451000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<41.910000,0.000000,56.769000>}
box{<0,0,-0.076200><4.318000,0.036000,0.076200> rotate<0,90.000000,0> translate<41.910000,0.000000,56.769000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<44.450000,0.000000,56.769000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<44.450000,0.000000,52.451000>}
box{<0,0,-0.076200><4.318000,0.036000,0.076200> rotate<0,-90.000000,0> translate<44.450000,0.000000,52.451000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<42.164000,0.000000,57.023000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<44.196000,0.000000,57.023000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,0.000000,0> translate<42.164000,0.000000,57.023000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<42.164000,0.000000,52.197000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<44.196000,0.000000,52.197000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,0.000000,0> translate<42.164000,0.000000,52.197000> }
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<42.164000,0.000000,56.769000>}
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<42.164000,0.000000,52.451000>}
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<44.196000,0.000000,56.769000>}
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<44.196000,0.000000,52.451000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,55.880000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,54.991000>}
box{<0,0,-0.076200><0.889000,0.036000,0.076200> rotate<0,-90.000000,0> translate<43.180000,0.000000,54.991000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,54.991000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,54.864000>}
box{<0,0,-0.076200><0.127000,0.036000,0.076200> rotate<0,-90.000000,0> translate<43.180000,0.000000,54.864000> }
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<43.180000,0.000000,54.864000>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<42.418000,0.000000,54.864000>}
box{<0,0,-0.127000><0.762000,0.036000,0.127000> rotate<0,0.000000,0> translate<42.418000,0.000000,54.864000> }
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<43.180000,0.000000,54.864000>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<43.942000,0.000000,54.864000>}
box{<0,0,-0.127000><0.762000,0.036000,0.127000> rotate<0,0.000000,0> translate<43.180000,0.000000,54.864000> }
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<42.418000,0.000000,54.356000>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<43.180000,0.000000,54.356000>}
box{<0,0,-0.127000><0.762000,0.036000,0.127000> rotate<0,0.000000,0> translate<42.418000,0.000000,54.356000> }
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<43.180000,0.000000,54.356000>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<43.942000,0.000000,54.356000>}
box{<0,0,-0.127000><0.762000,0.036000,0.127000> rotate<0,0.000000,0> translate<43.180000,0.000000,54.356000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,54.356000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,54.229000>}
box{<0,0,-0.076200><0.127000,0.036000,0.076200> rotate<0,-90.000000,0> translate<43.180000,0.000000,54.229000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,54.229000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,53.340000>}
box{<0,0,-0.076200><0.889000,0.036000,0.076200> rotate<0,-90.000000,0> translate<43.180000,0.000000,53.340000> }
//C2 silk screen
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<46.990000,0.000000,52.451000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<46.990000,0.000000,56.769000>}
box{<0,0,-0.076200><4.318000,0.036000,0.076200> rotate<0,90.000000,0> translate<46.990000,0.000000,56.769000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<49.530000,0.000000,56.769000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<49.530000,0.000000,52.451000>}
box{<0,0,-0.076200><4.318000,0.036000,0.076200> rotate<0,-90.000000,0> translate<49.530000,0.000000,52.451000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<47.244000,0.000000,57.023000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<49.276000,0.000000,57.023000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,0.000000,0> translate<47.244000,0.000000,57.023000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<47.244000,0.000000,52.197000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<49.276000,0.000000,52.197000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,0.000000,0> translate<47.244000,0.000000,52.197000> }
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<47.244000,0.000000,56.769000>}
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<47.244000,0.000000,52.451000>}
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<49.276000,0.000000,56.769000>}
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<49.276000,0.000000,52.451000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<48.260000,0.000000,55.880000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<48.260000,0.000000,54.991000>}
box{<0,0,-0.076200><0.889000,0.036000,0.076200> rotate<0,-90.000000,0> translate<48.260000,0.000000,54.991000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<48.260000,0.000000,54.991000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<48.260000,0.000000,54.864000>}
box{<0,0,-0.076200><0.127000,0.036000,0.076200> rotate<0,-90.000000,0> translate<48.260000,0.000000,54.864000> }
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<48.260000,0.000000,54.864000>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<47.498000,0.000000,54.864000>}
box{<0,0,-0.127000><0.762000,0.036000,0.127000> rotate<0,0.000000,0> translate<47.498000,0.000000,54.864000> }
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<48.260000,0.000000,54.864000>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<49.022000,0.000000,54.864000>}
box{<0,0,-0.127000><0.762000,0.036000,0.127000> rotate<0,0.000000,0> translate<48.260000,0.000000,54.864000> }
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<47.498000,0.000000,54.356000>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<48.260000,0.000000,54.356000>}
box{<0,0,-0.127000><0.762000,0.036000,0.127000> rotate<0,0.000000,0> translate<47.498000,0.000000,54.356000> }
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<48.260000,0.000000,54.356000>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<49.022000,0.000000,54.356000>}
box{<0,0,-0.127000><0.762000,0.036000,0.127000> rotate<0,0.000000,0> translate<48.260000,0.000000,54.356000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<48.260000,0.000000,54.356000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<48.260000,0.000000,54.229000>}
box{<0,0,-0.076200><0.127000,0.036000,0.076200> rotate<0,-90.000000,0> translate<48.260000,0.000000,54.229000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<48.260000,0.000000,54.229000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<48.260000,0.000000,53.340000>}
box{<0,0,-0.076200><0.889000,0.036000,0.076200> rotate<0,-90.000000,0> translate<48.260000,0.000000,53.340000> }
//C3 silk screen
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<53.644800,0.000000,55.245000>}
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<53.644800,0.000000,55.880000>}
box{<0,0,-0.152400><0.635000,0.036000,0.152400> rotate<0,90.000000,0> translate<53.644800,0.000000,55.880000> }
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<53.644800,0.000000,55.880000>}
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<53.644800,0.000000,56.515000>}
box{<0,0,-0.152400><0.635000,0.036000,0.152400> rotate<0,90.000000,0> translate<53.644800,0.000000,56.515000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<53.644800,0.000000,55.880000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<54.864000,0.000000,55.880000>}
box{<0,0,-0.076200><1.219200,0.036000,0.076200> rotate<0,0.000000,0> translate<53.644800,0.000000,55.880000> }
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<53.009800,0.000000,55.245000>}
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<53.009800,0.000000,55.880000>}
box{<0,0,-0.152400><0.635000,0.036000,0.152400> rotate<0,90.000000,0> translate<53.009800,0.000000,55.880000> }
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<53.009800,0.000000,55.880000>}
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<53.009800,0.000000,56.515000>}
box{<0,0,-0.152400><0.635000,0.036000,0.152400> rotate<0,90.000000,0> translate<53.009800,0.000000,56.515000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<53.009800,0.000000,55.880000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<51.816000,0.000000,55.880000>}
box{<0,0,-0.076200><1.193800,0.036000,0.076200> rotate<0,0.000000,0> translate<51.816000,0.000000,55.880000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<57.023000,0.000000,54.864000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<57.023000,0.000000,56.896000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,90.000000,0> translate<57.023000,0.000000,56.896000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<56.769000,0.000000,57.150000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<49.911000,0.000000,57.150000>}
box{<0,0,-0.076200><6.858000,0.036000,0.076200> rotate<0,0.000000,0> translate<49.911000,0.000000,57.150000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<49.657000,0.000000,56.896000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<49.657000,0.000000,54.864000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,-90.000000,0> translate<49.657000,0.000000,54.864000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<49.911000,0.000000,54.610000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<56.769000,0.000000,54.610000>}
box{<0,0,-0.076200><6.858000,0.036000,0.076200> rotate<0,0.000000,0> translate<49.911000,0.000000,54.610000> }
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<49.911000,0.000000,54.864000>}
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<49.911000,0.000000,56.896000>}
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<56.769000,0.000000,56.896000>}
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<56.769000,0.000000,54.864000>}
//C4 silk screen
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<10.922000,0.000000,46.990000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<10.541000,0.000000,46.990000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,0.000000,0> translate<10.541000,0.000000,46.990000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<10.541000,0.000000,47.371000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<10.541000,0.000000,46.990000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,-90.000000,0> translate<10.541000,0.000000,46.990000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<10.541000,0.000000,46.990000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<10.160000,0.000000,46.990000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,0.000000,0> translate<10.160000,0.000000,46.990000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<10.541000,0.000000,46.990000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<10.541000,0.000000,46.609000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,-90.000000,0> translate<10.541000,0.000000,46.609000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<10.541000,0.000000,48.260000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<9.652000,0.000000,48.260000>}
box{<0,0,-0.076200><0.889000,0.036000,0.076200> rotate<0,0.000000,0> translate<9.652000,0.000000,48.260000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<9.652000,0.000000,48.260000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<9.652000,0.000000,49.530000>}
box{<0,0,-0.076200><1.270000,0.036000,0.076200> rotate<0,90.000000,0> translate<9.652000,0.000000,49.530000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<9.652000,0.000000,49.530000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<9.144000,0.000000,49.530000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<9.144000,0.000000,49.530000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<9.144000,0.000000,49.530000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<9.144000,0.000000,46.990000>}
box{<0,0,-0.076200><2.540000,0.036000,0.076200> rotate<0,-90.000000,0> translate<9.144000,0.000000,46.990000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<9.144000,0.000000,46.990000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<9.652000,0.000000,46.990000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<9.144000,0.000000,46.990000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<9.652000,0.000000,46.990000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<9.652000,0.000000,48.260000>}
box{<0,0,-0.076200><1.270000,0.036000,0.076200> rotate<0,90.000000,0> translate<9.652000,0.000000,48.260000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<8.255000,0.000000,48.260000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<7.239000,0.000000,48.260000>}
box{<0,0,-0.076200><1.016000,0.036000,0.076200> rotate<0,0.000000,0> translate<7.239000,0.000000,48.260000> }
difference{
cylinder{<8.890000,0,48.260000><8.890000,0.036000,48.260000>2.870200 translate<0,0.000000,0>}
cylinder{<8.890000,-0.1,48.260000><8.890000,0.135000,48.260000>2.717800 translate<0,0.000000,0>}}
box{<-0.254000,0,-1.270000><0.254000,0.036000,1.270000> rotate<0,-180.000000,0> translate<8.382000,0.000000,48.260000>}
//C5 silk screen
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<19.050000,0.000000,29.692600>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<19.050000,0.000000,30.073600>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,90.000000,0> translate<19.050000,0.000000,30.073600> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<19.431000,0.000000,30.073600>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<19.050000,0.000000,30.073600>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,0.000000,0> translate<19.050000,0.000000,30.073600> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<19.050000,0.000000,30.073600>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<19.050000,0.000000,30.454600>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,90.000000,0> translate<19.050000,0.000000,30.454600> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<19.050000,0.000000,30.073600>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<18.669000,0.000000,30.073600>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,0.000000,0> translate<18.669000,0.000000,30.073600> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<20.320000,0.000000,30.073600>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<20.320000,0.000000,30.962600>}
box{<0,0,-0.076200><0.889000,0.036000,0.076200> rotate<0,90.000000,0> translate<20.320000,0.000000,30.962600> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<20.320000,0.000000,30.962600>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<21.590000,0.000000,30.962600>}
box{<0,0,-0.076200><1.270000,0.036000,0.076200> rotate<0,0.000000,0> translate<20.320000,0.000000,30.962600> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<21.590000,0.000000,30.962600>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<21.590000,0.000000,31.470600>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,90.000000,0> translate<21.590000,0.000000,31.470600> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<21.590000,0.000000,31.470600>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<19.050000,0.000000,31.470600>}
box{<0,0,-0.076200><2.540000,0.036000,0.076200> rotate<0,0.000000,0> translate<19.050000,0.000000,31.470600> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<19.050000,0.000000,31.470600>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<19.050000,0.000000,30.962600>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,-90.000000,0> translate<19.050000,0.000000,30.962600> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<19.050000,0.000000,30.962600>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<20.320000,0.000000,30.962600>}
box{<0,0,-0.076200><1.270000,0.036000,0.076200> rotate<0,0.000000,0> translate<19.050000,0.000000,30.962600> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<20.320000,0.000000,32.359600>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<20.320000,0.000000,33.375600>}
box{<0,0,-0.076200><1.016000,0.036000,0.076200> rotate<0,90.000000,0> translate<20.320000,0.000000,33.375600> }
difference{
cylinder{<20.320000,0,31.724600><20.320000,0.036000,31.724600>2.870200 translate<0,0.000000,0>}
cylinder{<20.320000,-0.1,31.724600><20.320000,0.135000,31.724600>2.717800 translate<0,0.000000,0>}}
box{<-0.254000,0,-1.270000><0.254000,0.036000,1.270000> rotate<0,-90.000000,0> translate<20.320000,0.000000,32.232600>}
//C6 silk screen
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<53.644800,0.000000,19.685000>}
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<53.644800,0.000000,20.320000>}
box{<0,0,-0.152400><0.635000,0.036000,0.152400> rotate<0,90.000000,0> translate<53.644800,0.000000,20.320000> }
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<53.644800,0.000000,20.320000>}
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<53.644800,0.000000,20.955000>}
box{<0,0,-0.152400><0.635000,0.036000,0.152400> rotate<0,90.000000,0> translate<53.644800,0.000000,20.955000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<53.644800,0.000000,20.320000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<54.864000,0.000000,20.320000>}
box{<0,0,-0.076200><1.219200,0.036000,0.076200> rotate<0,0.000000,0> translate<53.644800,0.000000,20.320000> }
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<53.009800,0.000000,19.685000>}
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<53.009800,0.000000,20.320000>}
box{<0,0,-0.152400><0.635000,0.036000,0.152400> rotate<0,90.000000,0> translate<53.009800,0.000000,20.320000> }
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<53.009800,0.000000,20.320000>}
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<53.009800,0.000000,20.955000>}
box{<0,0,-0.152400><0.635000,0.036000,0.152400> rotate<0,90.000000,0> translate<53.009800,0.000000,20.955000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<53.009800,0.000000,20.320000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<51.816000,0.000000,20.320000>}
box{<0,0,-0.076200><1.193800,0.036000,0.076200> rotate<0,0.000000,0> translate<51.816000,0.000000,20.320000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<57.023000,0.000000,19.304000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<57.023000,0.000000,21.336000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,90.000000,0> translate<57.023000,0.000000,21.336000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<56.769000,0.000000,21.590000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<49.911000,0.000000,21.590000>}
box{<0,0,-0.076200><6.858000,0.036000,0.076200> rotate<0,0.000000,0> translate<49.911000,0.000000,21.590000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<49.657000,0.000000,21.336000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<49.657000,0.000000,19.304000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,-90.000000,0> translate<49.657000,0.000000,19.304000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<49.911000,0.000000,19.050000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<56.769000,0.000000,19.050000>}
box{<0,0,-0.076200><6.858000,0.036000,0.076200> rotate<0,0.000000,0> translate<49.911000,0.000000,19.050000> }
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<49.911000,0.000000,19.304000>}
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<49.911000,0.000000,21.336000>}
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<56.769000,0.000000,21.336000>}
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<56.769000,0.000000,19.304000>}
//D1 silk screen
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<5.080000,0.000000,43.180000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<5.969000,0.000000,43.180000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,0.000000,0> translate<5.080000,0.000000,43.180000> }
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<12.700000,0.000000,43.180000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<11.811000,0.000000,43.180000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,0.000000,0> translate<11.811000,0.000000,43.180000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<9.525000,0.000000,43.180000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<8.890000,0.000000,43.180000>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,0.000000,0> translate<8.890000,0.000000,43.180000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<7.874000,0.000000,42.545000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<7.874000,0.000000,43.815000>}
box{<0,0,-0.076200><1.270000,0.036000,0.076200> rotate<0,90.000000,0> translate<7.874000,0.000000,43.815000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<7.874000,0.000000,43.815000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<8.890000,0.000000,43.180000>}
box{<0,0,-0.076200><1.198116,0.036000,0.076200> rotate<0,32.003271,0> translate<7.874000,0.000000,43.815000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<8.890000,0.000000,43.180000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<7.366000,0.000000,43.180000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,0.000000,0> translate<7.366000,0.000000,43.180000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<8.890000,0.000000,43.180000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<7.874000,0.000000,42.545000>}
box{<0,0,-0.076200><1.198116,0.036000,0.076200> rotate<0,-32.003271,0> translate<7.874000,0.000000,42.545000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<8.890000,0.000000,42.545000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<8.890000,0.000000,43.180000>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,90.000000,0> translate<8.890000,0.000000,43.180000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<8.890000,0.000000,43.180000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<8.890000,0.000000,43.815000>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,90.000000,0> translate<8.890000,0.000000,43.815000> }
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<6.858000,0.000000,42.418000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<6.604000,0.000000,42.418000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<6.604000,0.000000,43.942000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,90.000000,0> translate<6.604000,0.000000,43.942000> }
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<6.858000,0.000000,43.942000>}
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<10.922000,0.000000,42.418000>}
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<10.922000,0.000000,43.942000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<10.922000,0.000000,44.196000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<6.858000,0.000000,44.196000>}
box{<0,0,-0.076200><4.064000,0.036000,0.076200> rotate<0,0.000000,0> translate<6.858000,0.000000,44.196000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<11.176000,0.000000,42.418000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<11.176000,0.000000,43.942000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,90.000000,0> translate<11.176000,0.000000,43.942000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<10.922000,0.000000,42.164000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<6.858000,0.000000,42.164000>}
box{<0,0,-0.076200><4.064000,0.036000,0.076200> rotate<0,0.000000,0> translate<6.858000,0.000000,42.164000> }
box{<-0.254000,0,-1.016000><0.254000,0.036000,1.016000> rotate<0,-180.000000,0> translate<10.541000,0.000000,43.180000>}
box{<-0.317500,0,-0.254000><0.317500,0.036000,0.254000> rotate<0,-180.000000,0> translate<6.286500,0.000000,43.180000>}
box{<-0.317500,0,-0.254000><0.317500,0.036000,0.254000> rotate<0,-180.000000,0> translate<11.493500,0.000000,43.180000>}
//H1 silk screen
object{ARC(2.159000,2.489200,180.000000,270.000000,0.036000) translate<83.820000,0.000000,53.340000>}
object{ARC(2.159000,2.489200,0.000000,90.000000,0.036000) translate<83.820000,0.000000,53.340000>}
difference{
cylinder{<83.820000,0,53.340000><83.820000,0.036000,53.340000>3.505200 translate<0,0.000000,0>}
cylinder{<83.820000,-0.1,53.340000><83.820000,0.135000,53.340000>3.352800 translate<0,0.000000,0>}}
difference{
cylinder{<83.820000,0,53.340000><83.820000,0.036000,53.340000>0.990600 translate<0,0.000000,0>}
cylinder{<83.820000,-0.1,53.340000><83.820000,0.135000,53.340000>0.533400 translate<0,0.000000,0>}}
difference{
cylinder{<83.820000,0,53.340000><83.820000,0.036000,53.340000>1.701600 translate<0,0.000000,0>}
cylinder{<83.820000,-0.1,53.340000><83.820000,0.135000,53.340000>1.498400 translate<0,0.000000,0>}}
//H2 silk screen
object{ARC(2.159000,2.489200,180.000000,270.000000,0.036000) translate<83.820000,0.000000,15.240000>}
object{ARC(2.159000,2.489200,0.000000,90.000000,0.036000) translate<83.820000,0.000000,15.240000>}
difference{
cylinder{<83.820000,0,15.240000><83.820000,0.036000,15.240000>3.505200 translate<0,0.000000,0>}
cylinder{<83.820000,-0.1,15.240000><83.820000,0.135000,15.240000>3.352800 translate<0,0.000000,0>}}
difference{
cylinder{<83.820000,0,15.240000><83.820000,0.036000,15.240000>0.990600 translate<0,0.000000,0>}
cylinder{<83.820000,-0.1,15.240000><83.820000,0.135000,15.240000>0.533400 translate<0,0.000000,0>}}
difference{
cylinder{<83.820000,0,15.240000><83.820000,0.036000,15.240000>1.701600 translate<0,0.000000,0>}
cylinder{<83.820000,-0.1,15.240000><83.820000,0.135000,15.240000>1.498400 translate<0,0.000000,0>}}
//H3 silk screen
object{ARC(2.159000,2.489200,180.000000,270.000000,0.036000) translate<5.080000,0.000000,25.400000>}
object{ARC(2.159000,2.489200,0.000000,90.000000,0.036000) translate<5.080000,0.000000,25.400000>}
difference{
cylinder{<5.080000,0,25.400000><5.080000,0.036000,25.400000>3.505200 translate<0,0.000000,0>}
cylinder{<5.080000,-0.1,25.400000><5.080000,0.135000,25.400000>3.352800 translate<0,0.000000,0>}}
difference{
cylinder{<5.080000,0,25.400000><5.080000,0.036000,25.400000>0.990600 translate<0,0.000000,0>}
cylinder{<5.080000,-0.1,25.400000><5.080000,0.135000,25.400000>0.533400 translate<0,0.000000,0>}}
difference{
cylinder{<5.080000,0,25.400000><5.080000,0.036000,25.400000>1.701600 translate<0,0.000000,0>}
cylinder{<5.080000,-0.1,25.400000><5.080000,0.135000,25.400000>1.498400 translate<0,0.000000,0>}}
//IC1 silk screen
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<78.486000,0.000000,34.290000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<78.486000,0.000000,39.624000>}
box{<0,0,-0.076200><5.334000,0.036000,0.076200> rotate<0,90.000000,0> translate<78.486000,0.000000,39.624000> }
object{ARC(1.270000,0.152400,90.000000,270.000000,0.036000) translate<78.486000,0.000000,33.020000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<25.654000,0.000000,39.624000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<25.654000,0.000000,26.416000>}
box{<0,0,-0.076200><13.208000,0.036000,0.076200> rotate<0,-90.000000,0> translate<25.654000,0.000000,26.416000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<78.486000,0.000000,26.416000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<78.486000,0.000000,31.750000>}
box{<0,0,-0.076200><5.334000,0.036000,0.076200> rotate<0,90.000000,0> translate<78.486000,0.000000,31.750000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<78.486000,0.000000,26.416000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<25.654000,0.000000,26.416000>}
box{<0,0,-0.076200><52.832000,0.036000,0.076200> rotate<0,0.000000,0> translate<25.654000,0.000000,26.416000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<78.486000,0.000000,39.624000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<25.654000,0.000000,39.624000>}
box{<0,0,-0.076200><52.832000,0.036000,0.076200> rotate<0,0.000000,0> translate<25.654000,0.000000,39.624000> }
//IC2 silk screen
cylinder{<0,0,0><0,0.036000,0>0.099900 translate<15.265400,0.000000,29.024000>}
cylinder{<0,0,0><0,0.036000,0>0.099900 translate<10.134600,0.000000,29.024000>}
box{<0,0,-0.099900><5.130800,0.036000,0.099900> rotate<0,0.000000,0> translate<10.134600,0.000000,29.024000> }
cylinder{<0,0,0><0,0.036000,0>0.099900 translate<15.265400,0.000000,28.824200>}
cylinder{<0,0,0><0,0.036000,0>0.099900 translate<10.134600,0.000000,28.824200>}
box{<0,0,-0.099900><5.130800,0.036000,0.099900> rotate<0,0.000000,0> translate<10.134600,0.000000,28.824200> }
cylinder{<0,0,0><0,0.036000,0>0.099900 translate<15.265400,0.000000,28.624400>}
cylinder{<0,0,0><0,0.036000,0>0.099900 translate<10.134600,0.000000,28.624400>}
box{<0,0,-0.099900><5.130800,0.036000,0.099900> rotate<0,0.000000,0> translate<10.134600,0.000000,28.624400> }
cylinder{<0,0,0><0,0.036000,0>0.099900 translate<15.265400,0.000000,28.424600>}
cylinder{<0,0,0><0,0.036000,0>0.099900 translate<10.134600,0.000000,28.424600>}
box{<0,0,-0.099900><5.130800,0.036000,0.099900> rotate<0,0.000000,0> translate<10.134600,0.000000,28.424600> }
cylinder{<0,0,0><0,0.036000,0>0.099900 translate<15.118400,0.000000,28.224800>}
cylinder{<0,0,0><0,0.036000,0>0.099900 translate<10.281600,0.000000,28.224800>}
box{<0,0,-0.099900><4.836800,0.036000,0.099900> rotate<0,0.000000,0> translate<10.281600,0.000000,28.224800> }
cylinder{<0,0,0><0,0.036000,0>0.099900 translate<14.918600,0.000000,28.025000>}
cylinder{<0,0,0><0,0.036000,0>0.099900 translate<10.481400,0.000000,28.025000>}
box{<0,0,-0.099900><4.437200,0.036000,0.099900> rotate<0,0.000000,0> translate<10.481400,0.000000,28.025000> }
cylinder{<0,0,0><0,0.036000,0>0.099900 translate<15.265400,0.000000,29.083000>}
cylinder{<0,0,0><0,0.036000,0>0.099900 translate<15.265400,0.000000,28.371800>}
box{<0,0,-0.099900><0.711200,0.036000,0.099900> rotate<0,-90.000000,0> translate<15.265400,0.000000,28.371800> }
cylinder{<0,0,0><0,0.036000,0>0.099900 translate<15.265400,0.000000,28.371800>}
cylinder{<0,0,0><0,0.036000,0>0.099900 translate<14.808200,0.000000,27.914600>}
box{<0,0,-0.099900><0.646578,0.036000,0.099900> rotate<0,-44.997030,0> translate<14.808200,0.000000,27.914600> }
cylinder{<0,0,0><0,0.036000,0>0.099900 translate<14.808200,0.000000,27.914600>}
cylinder{<0,0,0><0,0.036000,0>0.099900 translate<10.591800,0.000000,27.914600>}
box{<0,0,-0.099900><4.216400,0.036000,0.099900> rotate<0,0.000000,0> translate<10.591800,0.000000,27.914600> }
cylinder{<0,0,0><0,0.036000,0>0.099900 translate<10.591800,0.000000,27.914600>}
cylinder{<0,0,0><0,0.036000,0>0.099900 translate<10.134600,0.000000,28.371800>}
box{<0,0,-0.099900><0.646578,0.036000,0.099900> rotate<0,44.997030,0> translate<10.134600,0.000000,28.371800> }
cylinder{<0,0,0><0,0.036000,0>0.099900 translate<10.134600,0.000000,28.371800>}
cylinder{<0,0,0><0,0.036000,0>0.099900 translate<10.134600,0.000000,29.083000>}
box{<0,0,-0.099900><0.711200,0.036000,0.099900> rotate<0,90.000000,0> translate<10.134600,0.000000,29.083000> }
cylinder{<0,0,0><0,0.036000,0>0.099900 translate<10.134600,0.000000,29.083000>}
cylinder{<0,0,0><0,0.036000,0>0.099900 translate<15.265400,0.000000,29.083000>}
box{<0,0,-0.099900><5.130800,0.036000,0.099900> rotate<0,0.000000,0> translate<10.134600,0.000000,29.083000> }
cylinder{<0,0,0><0,0.036000,0>0.101600 translate<9.423400,0.000000,29.184600>}
cylinder{<0,0,0><0,0.036000,0>0.101600 translate<9.423000,0.000000,35.179000>}
box{<0,0,-0.101600><5.994400,0.036000,0.101600> rotate<0,89.990237,0> translate<9.423000,0.000000,35.179000> }
cylinder{<0,0,0><0,0.036000,0>0.101600 translate<9.423000,0.000000,35.179000>}
cylinder{<0,0,0><0,0.036000,0>0.101600 translate<15.977000,0.000000,35.179000>}
box{<0,0,-0.101600><6.554000,0.036000,0.101600> rotate<0,0.000000,0> translate<9.423000,0.000000,35.179000> }
cylinder{<0,0,0><0,0.036000,0>0.101600 translate<15.977000,0.000000,35.179000>}
cylinder{<0,0,0><0,0.036000,0>0.101600 translate<15.976600,0.000000,29.184600>}
box{<0,0,-0.101600><5.994400,0.036000,0.101600> rotate<0,-89.990237,0> translate<15.976600,0.000000,29.184600> }
cylinder{<0,0,0><0,0.036000,0>0.101600 translate<15.977000,0.000000,29.185000>}
cylinder{<0,0,0><0,0.036000,0>0.101600 translate<9.422600,0.000000,29.185400>}
box{<0,0,-0.101600><6.554400,0.036000,0.101600> rotate<0,0.003496,0> translate<9.422600,0.000000,29.185400> }
cylinder{<0,0,0><0,0.036000,0>0.101600 translate<15.265400,0.000000,29.083000>}
cylinder{<0,0,0><0,0.036000,0>0.101600 translate<15.265400,0.000000,28.371800>}
box{<0,0,-0.101600><0.711200,0.036000,0.101600> rotate<0,-90.000000,0> translate<15.265400,0.000000,28.371800> }
cylinder{<0,0,0><0,0.036000,0>0.101600 translate<15.265400,0.000000,28.371800>}
cylinder{<0,0,0><0,0.036000,0>0.101600 translate<14.808200,0.000000,27.914600>}
box{<0,0,-0.101600><0.646578,0.036000,0.101600> rotate<0,-44.997030,0> translate<14.808200,0.000000,27.914600> }
cylinder{<0,0,0><0,0.036000,0>0.101600 translate<14.808200,0.000000,27.914600>}
cylinder{<0,0,0><0,0.036000,0>0.101600 translate<10.591800,0.000000,27.914600>}
box{<0,0,-0.101600><4.216400,0.036000,0.101600> rotate<0,0.000000,0> translate<10.591800,0.000000,27.914600> }
cylinder{<0,0,0><0,0.036000,0>0.101600 translate<10.591800,0.000000,27.914600>}
cylinder{<0,0,0><0,0.036000,0>0.101600 translate<10.134600,0.000000,28.371800>}
box{<0,0,-0.101600><0.646578,0.036000,0.101600> rotate<0,44.997030,0> translate<10.134600,0.000000,28.371800> }
cylinder{<0,0,0><0,0.036000,0>0.101600 translate<10.134600,0.000000,28.371800>}
cylinder{<0,0,0><0,0.036000,0>0.101600 translate<10.134600,0.000000,29.083000>}
box{<0,0,-0.101600><0.711200,0.036000,0.101600> rotate<0,90.000000,0> translate<10.134600,0.000000,29.083000> }
cylinder{<0,0,0><0,0.036000,0>0.101600 translate<10.134600,0.000000,29.083000>}
cylinder{<0,0,0><0,0.036000,0>0.101600 translate<15.265400,0.000000,29.083000>}
box{<0,0,-0.101600><5.130800,0.036000,0.101600> rotate<0,0.000000,0> translate<10.134600,0.000000,29.083000> }
box{<-0.431800,0,-1.447800><0.431800,0.036000,1.447800> rotate<0,-180.000000,0> translate<14.986000,0.000000,36.728400>}
box{<-0.431800,0,-1.447800><0.431800,0.036000,1.447800> rotate<0,-180.000000,0> translate<10.414000,0.000000,36.728400>}
box{<-0.431800,0,-0.381000><0.431800,0.036000,0.381000> rotate<0,-180.000000,0> translate<12.700000,0.000000,35.661600>}
//Q1 silk screen
cylinder{<0,0,0><0,0.036000,0>0.203200 translate<50.800000,0.000000,46.355000>}
cylinder{<0,0,0><0,0.036000,0>0.203200 translate<50.800000,0.000000,50.165000>}
box{<0,0,-0.203200><3.810000,0.036000,0.203200> rotate<0,90.000000,0> translate<50.800000,0.000000,50.165000> }
cylinder{<0,0,0><0,0.036000,0>0.203200 translate<40.640000,0.000000,50.165000>}
cylinder{<0,0,0><0,0.036000,0>0.203200 translate<40.640000,0.000000,46.355000>}
box{<0,0,-0.203200><3.810000,0.036000,0.203200> rotate<0,-90.000000,0> translate<40.640000,0.000000,46.355000> }
cylinder{<0,0,0><0,0.036000,0>0.203200 translate<41.275000,0.000000,50.800000>}
cylinder{<0,0,0><0,0.036000,0>0.203200 translate<50.165000,0.000000,50.800000>}
box{<0,0,-0.203200><8.890000,0.036000,0.203200> rotate<0,0.000000,0> translate<41.275000,0.000000,50.800000> }
cylinder{<0,0,0><0,0.036000,0>0.203200 translate<41.275000,0.000000,45.720000>}
cylinder{<0,0,0><0,0.036000,0>0.203200 translate<50.165000,0.000000,45.720000>}
box{<0,0,-0.203200><8.890000,0.036000,0.203200> rotate<0,0.000000,0> translate<41.275000,0.000000,45.720000> }
object{ARC(0.635000,0.406400,270.000000,360.000000,0.036000) translate<50.165000,0.000000,46.355000>}
object{ARC(0.635000,0.406400,0.000000,90.000000,0.036000) translate<50.165000,0.000000,50.165000>}
object{ARC(0.635000,0.406400,90.000000,180.000000,0.036000) translate<41.275000,0.000000,50.165000>}
object{ARC(0.635000,0.406400,180.000000,270.000000,0.036000) translate<41.275000,0.000000,46.355000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<41.402000,0.000000,46.355000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<50.038000,0.000000,46.355000>}
box{<0,0,-0.076200><8.636000,0.036000,0.076200> rotate<0,0.000000,0> translate<41.402000,0.000000,46.355000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<50.038000,0.000000,46.355000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<50.165000,0.000000,46.482000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<50.038000,0.000000,46.355000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<50.165000,0.000000,46.482000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<50.165000,0.000000,50.038000>}
box{<0,0,-0.076200><3.556000,0.036000,0.076200> rotate<0,90.000000,0> translate<50.165000,0.000000,50.038000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<50.038000,0.000000,50.165000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<50.165000,0.000000,50.038000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<50.038000,0.000000,50.165000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<50.038000,0.000000,50.165000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<41.402000,0.000000,50.165000>}
box{<0,0,-0.076200><8.636000,0.036000,0.076200> rotate<0,0.000000,0> translate<41.402000,0.000000,50.165000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<41.275000,0.000000,50.038000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<41.402000,0.000000,50.165000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<41.275000,0.000000,50.038000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<41.275000,0.000000,50.038000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<41.275000,0.000000,46.482000>}
box{<0,0,-0.076200><3.556000,0.036000,0.076200> rotate<0,-90.000000,0> translate<41.275000,0.000000,46.482000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<41.402000,0.000000,46.355000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<41.275000,0.000000,46.482000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<41.275000,0.000000,46.482000> }
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<45.389800,0.000000,49.530000>}
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<45.389800,0.000000,46.990000>}
box{<0,0,-0.152400><2.540000,0.036000,0.152400> rotate<0,-90.000000,0> translate<45.389800,0.000000,46.990000> }
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<45.389800,0.000000,46.990000>}
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<46.024800,0.000000,46.990000>}
box{<0,0,-0.152400><0.635000,0.036000,0.152400> rotate<0,0.000000,0> translate<45.389800,0.000000,46.990000> }
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<46.024800,0.000000,46.990000>}
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<46.024800,0.000000,49.530000>}
box{<0,0,-0.152400><2.540000,0.036000,0.152400> rotate<0,90.000000,0> translate<46.024800,0.000000,49.530000> }
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<46.024800,0.000000,49.530000>}
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<45.389800,0.000000,49.530000>}
box{<0,0,-0.152400><0.635000,0.036000,0.152400> rotate<0,0.000000,0> translate<45.389800,0.000000,49.530000> }
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<46.659800,0.000000,49.530000>}
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<46.659800,0.000000,48.260000>}
box{<0,0,-0.152400><1.270000,0.036000,0.152400> rotate<0,-90.000000,0> translate<46.659800,0.000000,48.260000> }
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<44.780200,0.000000,49.530000>}
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<44.780200,0.000000,48.260000>}
box{<0,0,-0.152400><1.270000,0.036000,0.152400> rotate<0,-90.000000,0> translate<44.780200,0.000000,48.260000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<46.659800,0.000000,48.260000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<47.244000,0.000000,48.260000>}
box{<0,0,-0.076200><0.584200,0.036000,0.076200> rotate<0,0.000000,0> translate<46.659800,0.000000,48.260000> }
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<46.659800,0.000000,48.260000>}
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<46.659800,0.000000,46.990000>}
box{<0,0,-0.152400><1.270000,0.036000,0.152400> rotate<0,-90.000000,0> translate<46.659800,0.000000,46.990000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<44.780200,0.000000,48.260000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<44.196000,0.000000,48.260000>}
box{<0,0,-0.076200><0.584200,0.036000,0.076200> rotate<0,0.000000,0> translate<44.196000,0.000000,48.260000> }
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<44.780200,0.000000,48.260000>}
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<44.780200,0.000000,46.990000>}
box{<0,0,-0.152400><1.270000,0.036000,0.152400> rotate<0,-90.000000,0> translate<44.780200,0.000000,46.990000> }
//R1 silk screen
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<55.880000,0.000000,43.180000>}
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<55.880000,0.000000,44.196000>}
box{<0,0,-0.304800><1.016000,0.036000,0.304800> rotate<0,90.000000,0> translate<55.880000,0.000000,44.196000> }
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<55.880000,0.000000,53.340000>}
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<55.880000,0.000000,52.324000>}
box{<0,0,-0.304800><1.016000,0.036000,0.304800> rotate<0,-90.000000,0> translate<55.880000,0.000000,52.324000> }
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<56.769000,0.000000,51.181000>}
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<54.991000,0.000000,51.181000>}
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<54.991000,0.000000,45.339000>}
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<56.769000,0.000000,45.339000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<54.991000,0.000000,51.435000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<56.769000,0.000000,51.435000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<54.991000,0.000000,51.435000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<57.023000,0.000000,51.181000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<57.023000,0.000000,50.800000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,-90.000000,0> translate<57.023000,0.000000,50.800000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<56.896000,0.000000,50.673000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<57.023000,0.000000,50.800000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<56.896000,0.000000,50.673000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<54.737000,0.000000,51.181000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<54.737000,0.000000,50.800000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,-90.000000,0> translate<54.737000,0.000000,50.800000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<54.864000,0.000000,50.673000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<54.737000,0.000000,50.800000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<54.737000,0.000000,50.800000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<56.896000,0.000000,45.847000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<57.023000,0.000000,45.720000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<56.896000,0.000000,45.847000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<56.896000,0.000000,45.847000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<56.896000,0.000000,50.673000>}
box{<0,0,-0.076200><4.826000,0.036000,0.076200> rotate<0,90.000000,0> translate<56.896000,0.000000,50.673000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<54.864000,0.000000,45.847000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<54.737000,0.000000,45.720000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<54.737000,0.000000,45.720000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<54.864000,0.000000,45.847000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<54.864000,0.000000,50.673000>}
box{<0,0,-0.076200><4.826000,0.036000,0.076200> rotate<0,90.000000,0> translate<54.864000,0.000000,50.673000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<57.023000,0.000000,45.339000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<57.023000,0.000000,45.720000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,90.000000,0> translate<57.023000,0.000000,45.720000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<54.737000,0.000000,45.339000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<54.737000,0.000000,45.720000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,90.000000,0> translate<54.737000,0.000000,45.720000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<54.991000,0.000000,45.085000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<56.769000,0.000000,45.085000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<54.991000,0.000000,45.085000> }
box{<-0.431800,0,-0.304800><0.431800,0.036000,0.304800> rotate<0,-270.000000,0> translate<55.880000,0.000000,44.653200>}
box{<-0.431800,0,-0.304800><0.431800,0.036000,0.304800> rotate<0,-270.000000,0> translate<55.880000,0.000000,51.866800>}
//R2 silk screen
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<22.860000,0.000000,40.640000>}
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<22.860000,0.000000,41.656000>}
box{<0,0,-0.304800><1.016000,0.036000,0.304800> rotate<0,90.000000,0> translate<22.860000,0.000000,41.656000> }
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<22.860000,0.000000,50.800000>}
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<22.860000,0.000000,49.784000>}
box{<0,0,-0.304800><1.016000,0.036000,0.304800> rotate<0,-90.000000,0> translate<22.860000,0.000000,49.784000> }
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<23.749000,0.000000,48.641000>}
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<21.971000,0.000000,48.641000>}
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<21.971000,0.000000,42.799000>}
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<23.749000,0.000000,42.799000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<21.971000,0.000000,48.895000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<23.749000,0.000000,48.895000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<21.971000,0.000000,48.895000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<24.003000,0.000000,48.641000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<24.003000,0.000000,48.260000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,-90.000000,0> translate<24.003000,0.000000,48.260000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<23.876000,0.000000,48.133000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<24.003000,0.000000,48.260000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<23.876000,0.000000,48.133000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<21.717000,0.000000,48.641000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<21.717000,0.000000,48.260000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,-90.000000,0> translate<21.717000,0.000000,48.260000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<21.844000,0.000000,48.133000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<21.717000,0.000000,48.260000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<21.717000,0.000000,48.260000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<23.876000,0.000000,43.307000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<24.003000,0.000000,43.180000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<23.876000,0.000000,43.307000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<23.876000,0.000000,43.307000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<23.876000,0.000000,48.133000>}
box{<0,0,-0.076200><4.826000,0.036000,0.076200> rotate<0,90.000000,0> translate<23.876000,0.000000,48.133000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<21.844000,0.000000,43.307000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<21.717000,0.000000,43.180000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<21.717000,0.000000,43.180000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<21.844000,0.000000,43.307000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<21.844000,0.000000,48.133000>}
box{<0,0,-0.076200><4.826000,0.036000,0.076200> rotate<0,90.000000,0> translate<21.844000,0.000000,48.133000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<24.003000,0.000000,42.799000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<24.003000,0.000000,43.180000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,90.000000,0> translate<24.003000,0.000000,43.180000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<21.717000,0.000000,42.799000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<21.717000,0.000000,43.180000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,90.000000,0> translate<21.717000,0.000000,43.180000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<21.971000,0.000000,42.545000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<23.749000,0.000000,42.545000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<21.971000,0.000000,42.545000> }
box{<-0.431800,0,-0.304800><0.431800,0.036000,0.304800> rotate<0,-270.000000,0> translate<22.860000,0.000000,42.113200>}
box{<-0.431800,0,-0.304800><0.431800,0.036000,0.304800> rotate<0,-270.000000,0> translate<22.860000,0.000000,49.326800>}
//R3 silk screen
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<20.320000,0.000000,50.800000>}
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<20.320000,0.000000,49.784000>}
box{<0,0,-0.304800><1.016000,0.036000,0.304800> rotate<0,-90.000000,0> translate<20.320000,0.000000,49.784000> }
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<20.320000,0.000000,40.640000>}
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<20.320000,0.000000,41.656000>}
box{<0,0,-0.304800><1.016000,0.036000,0.304800> rotate<0,90.000000,0> translate<20.320000,0.000000,41.656000> }
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<19.431000,0.000000,42.799000>}
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<21.209000,0.000000,42.799000>}
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<21.209000,0.000000,48.641000>}
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<19.431000,0.000000,48.641000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<21.209000,0.000000,42.545000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<19.431000,0.000000,42.545000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<19.431000,0.000000,42.545000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<19.177000,0.000000,42.799000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<19.177000,0.000000,43.180000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,90.000000,0> translate<19.177000,0.000000,43.180000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<19.304000,0.000000,43.307000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<19.177000,0.000000,43.180000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<19.177000,0.000000,43.180000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<21.463000,0.000000,42.799000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<21.463000,0.000000,43.180000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,90.000000,0> translate<21.463000,0.000000,43.180000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<21.336000,0.000000,43.307000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<21.463000,0.000000,43.180000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<21.336000,0.000000,43.307000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<19.304000,0.000000,48.133000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<19.177000,0.000000,48.260000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<19.177000,0.000000,48.260000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<19.304000,0.000000,48.133000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<19.304000,0.000000,43.307000>}
box{<0,0,-0.076200><4.826000,0.036000,0.076200> rotate<0,-90.000000,0> translate<19.304000,0.000000,43.307000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<21.336000,0.000000,48.133000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<21.463000,0.000000,48.260000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<21.336000,0.000000,48.133000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<21.336000,0.000000,48.133000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<21.336000,0.000000,43.307000>}
box{<0,0,-0.076200><4.826000,0.036000,0.076200> rotate<0,-90.000000,0> translate<21.336000,0.000000,43.307000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<19.177000,0.000000,48.641000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<19.177000,0.000000,48.260000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,-90.000000,0> translate<19.177000,0.000000,48.260000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<21.463000,0.000000,48.641000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<21.463000,0.000000,48.260000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,-90.000000,0> translate<21.463000,0.000000,48.260000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<21.209000,0.000000,48.895000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<19.431000,0.000000,48.895000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<19.431000,0.000000,48.895000> }
box{<-0.431800,0,-0.304800><0.431800,0.036000,0.304800> rotate<0,-90.000000,0> translate<20.320000,0.000000,49.326800>}
box{<-0.431800,0,-0.304800><0.431800,0.036000,0.304800> rotate<0,-90.000000,0> translate<20.320000,0.000000,42.113200>}
//R4 silk screen
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<25.400000,0.000000,50.800000>}
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<25.400000,0.000000,49.784000>}
box{<0,0,-0.304800><1.016000,0.036000,0.304800> rotate<0,-90.000000,0> translate<25.400000,0.000000,49.784000> }
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<25.400000,0.000000,40.640000>}
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<25.400000,0.000000,41.656000>}
box{<0,0,-0.304800><1.016000,0.036000,0.304800> rotate<0,90.000000,0> translate<25.400000,0.000000,41.656000> }
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<24.511000,0.000000,42.799000>}
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<26.289000,0.000000,42.799000>}
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<26.289000,0.000000,48.641000>}
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<24.511000,0.000000,48.641000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<26.289000,0.000000,42.545000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<24.511000,0.000000,42.545000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<24.511000,0.000000,42.545000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<24.257000,0.000000,42.799000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<24.257000,0.000000,43.180000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,90.000000,0> translate<24.257000,0.000000,43.180000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<24.384000,0.000000,43.307000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<24.257000,0.000000,43.180000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<24.257000,0.000000,43.180000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<26.543000,0.000000,42.799000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<26.543000,0.000000,43.180000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,90.000000,0> translate<26.543000,0.000000,43.180000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<26.416000,0.000000,43.307000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<26.543000,0.000000,43.180000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<26.416000,0.000000,43.307000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<24.384000,0.000000,48.133000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<24.257000,0.000000,48.260000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<24.257000,0.000000,48.260000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<24.384000,0.000000,48.133000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<24.384000,0.000000,43.307000>}
box{<0,0,-0.076200><4.826000,0.036000,0.076200> rotate<0,-90.000000,0> translate<24.384000,0.000000,43.307000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<26.416000,0.000000,48.133000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<26.543000,0.000000,48.260000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<26.416000,0.000000,48.133000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<26.416000,0.000000,48.133000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<26.416000,0.000000,43.307000>}
box{<0,0,-0.076200><4.826000,0.036000,0.076200> rotate<0,-90.000000,0> translate<26.416000,0.000000,43.307000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<24.257000,0.000000,48.641000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<24.257000,0.000000,48.260000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,-90.000000,0> translate<24.257000,0.000000,48.260000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<26.543000,0.000000,48.641000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<26.543000,0.000000,48.260000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,-90.000000,0> translate<26.543000,0.000000,48.260000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<26.289000,0.000000,48.895000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<24.511000,0.000000,48.895000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<24.511000,0.000000,48.895000> }
box{<-0.431800,0,-0.304800><0.431800,0.036000,0.304800> rotate<0,-90.000000,0> translate<25.400000,0.000000,49.326800>}
box{<-0.431800,0,-0.304800><0.431800,0.036000,0.304800> rotate<0,-90.000000,0> translate<25.400000,0.000000,42.113200>}
//R5 silk screen
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<15.240000,0.000000,40.640000>}
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<15.240000,0.000000,41.656000>}
box{<0,0,-0.304800><1.016000,0.036000,0.304800> rotate<0,90.000000,0> translate<15.240000,0.000000,41.656000> }
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<15.240000,0.000000,50.800000>}
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<15.240000,0.000000,49.784000>}
box{<0,0,-0.304800><1.016000,0.036000,0.304800> rotate<0,-90.000000,0> translate<15.240000,0.000000,49.784000> }
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<16.129000,0.000000,48.641000>}
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<14.351000,0.000000,48.641000>}
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<14.351000,0.000000,42.799000>}
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<16.129000,0.000000,42.799000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<14.351000,0.000000,48.895000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<16.129000,0.000000,48.895000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<14.351000,0.000000,48.895000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<16.383000,0.000000,48.641000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<16.383000,0.000000,48.260000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,-90.000000,0> translate<16.383000,0.000000,48.260000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<16.256000,0.000000,48.133000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<16.383000,0.000000,48.260000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<16.256000,0.000000,48.133000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<14.097000,0.000000,48.641000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<14.097000,0.000000,48.260000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,-90.000000,0> translate<14.097000,0.000000,48.260000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<14.224000,0.000000,48.133000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<14.097000,0.000000,48.260000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<14.097000,0.000000,48.260000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<16.256000,0.000000,43.307000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<16.383000,0.000000,43.180000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<16.256000,0.000000,43.307000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<16.256000,0.000000,43.307000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<16.256000,0.000000,48.133000>}
box{<0,0,-0.076200><4.826000,0.036000,0.076200> rotate<0,90.000000,0> translate<16.256000,0.000000,48.133000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<14.224000,0.000000,43.307000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<14.097000,0.000000,43.180000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<14.097000,0.000000,43.180000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<14.224000,0.000000,43.307000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<14.224000,0.000000,48.133000>}
box{<0,0,-0.076200><4.826000,0.036000,0.076200> rotate<0,90.000000,0> translate<14.224000,0.000000,48.133000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<16.383000,0.000000,42.799000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<16.383000,0.000000,43.180000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,90.000000,0> translate<16.383000,0.000000,43.180000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<14.097000,0.000000,42.799000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<14.097000,0.000000,43.180000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,90.000000,0> translate<14.097000,0.000000,43.180000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<14.351000,0.000000,42.545000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<16.129000,0.000000,42.545000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<14.351000,0.000000,42.545000> }
box{<-0.431800,0,-0.304800><0.431800,0.036000,0.304800> rotate<0,-270.000000,0> translate<15.240000,0.000000,42.113200>}
box{<-0.431800,0,-0.304800><0.431800,0.036000,0.304800> rotate<0,-270.000000,0> translate<15.240000,0.000000,49.326800>}
//X1 silk screen
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<19.870000,0.000000,55.360000>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<19.870000,0.000000,71.110000>}
box{<0,0,-0.127000><15.750000,0.036000,0.127000> rotate<0,90.000000,0> translate<19.870000,0.000000,71.110000> }
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<19.870000,0.000000,71.110000>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<8.070000,0.000000,71.110000>}
box{<0,0,-0.127000><11.800000,0.036000,0.127000> rotate<0,0.000000,0> translate<8.070000,0.000000,71.110000> }
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<8.070000,0.000000,71.110000>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<8.070000,0.000000,55.360000>}
box{<0,0,-0.127000><15.750000,0.036000,0.127000> rotate<0,-90.000000,0> translate<8.070000,0.000000,55.360000> }
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<8.070000,0.000000,55.360000>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<19.870000,0.000000,55.360000>}
box{<0,0,-0.127000><11.800000,0.036000,0.127000> rotate<0,0.000000,0> translate<8.070000,0.000000,55.360000> }
object{ARC(0.500000,0.050800,90.000000,270.000000,0.036000) translate<16.430000,0.000000,60.730000>}
object{ARC(0.500000,0.050800,90.000000,270.000000,0.036000) translate<16.430000,0.000000,61.730000>}
object{ARC(0.500000,0.050800,270.000000,450.000000,0.036000) translate<10.305000,0.000000,61.230000>}
object{ARC(1.000000,0.050800,270.000000,450.000000,0.036000) translate<10.555000,0.000000,61.230000>}
object{ARC(1.891600,0.050800,262.405357,277.594643,0.036000) translate<10.055000,0.000000,62.605000>}
object{ARC(3.627100,0.050800,259.830509,271.889628,0.036000) translate<10.435400,0.000000,63.855100>}
object{ARC(2.374900,0.050800,90.250904,108.673740,0.036000) translate<10.565400,0.000000,59.855100>}
object{ARC(0.625000,0.050800,90.000000,270.000000,0.036000) translate<12.305000,0.000000,60.855000>}
object{ARC(0.187500,0.050800,90.000000,270.000000,0.036000) translate<12.680000,0.000000,60.917500>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<17.805000,0.000000,60.230000>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<17.805000,0.000000,62.230000>}
box{<0,0,-0.025400><2.000000,0.036000,0.025400> rotate<0,90.000000,0> translate<17.805000,0.000000,62.230000> }
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<17.805000,0.000000,62.230000>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<17.180000,0.000000,62.230000>}
box{<0,0,-0.025400><0.625000,0.036000,0.025400> rotate<0,0.000000,0> translate<17.180000,0.000000,62.230000> }
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<17.180000,0.000000,62.230000>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<17.180000,0.000000,61.230000>}
box{<0,0,-0.025400><1.000000,0.036000,0.025400> rotate<0,-90.000000,0> translate<17.180000,0.000000,61.230000> }
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<17.180000,0.000000,61.230000>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<17.180000,0.000000,60.230000>}
box{<0,0,-0.025400><1.000000,0.036000,0.025400> rotate<0,-90.000000,0> translate<17.180000,0.000000,60.230000> }
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<17.180000,0.000000,60.230000>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<17.805000,0.000000,60.230000>}
box{<0,0,-0.025400><0.625000,0.036000,0.025400> rotate<0,0.000000,0> translate<17.180000,0.000000,60.230000> }
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<17.180000,0.000000,60.230000>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<16.430000,0.000000,60.730000>}
box{<0,0,-0.025400><0.901388,0.036000,0.025400> rotate<0,33.687844,0> translate<16.430000,0.000000,60.730000> }
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<16.430000,0.000000,60.730000>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<17.180000,0.000000,61.230000>}
box{<0,0,-0.025400><0.901388,0.036000,0.025400> rotate<0,-33.687844,0> translate<16.430000,0.000000,60.730000> }
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<17.180000,0.000000,61.230000>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<16.430000,0.000000,61.730000>}
box{<0,0,-0.025400><0.901388,0.036000,0.025400> rotate<0,33.687844,0> translate<16.430000,0.000000,61.730000> }
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<16.430000,0.000000,61.730000>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<17.180000,0.000000,62.230000>}
box{<0,0,-0.025400><0.901388,0.036000,0.025400> rotate<0,-33.687844,0> translate<16.430000,0.000000,61.730000> }
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<16.430000,0.000000,62.230000>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<17.180000,0.000000,62.230000>}
box{<0,0,-0.025400><0.750000,0.036000,0.025400> rotate<0,0.000000,0> translate<16.430000,0.000000,62.230000> }
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<16.430000,0.000000,60.230000>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<17.180000,0.000000,60.230000>}
box{<0,0,-0.025400><0.750000,0.036000,0.025400> rotate<0,0.000000,0> translate<16.430000,0.000000,60.230000> }
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<15.680000,0.000000,60.230000>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<15.680000,0.000000,62.230000>}
box{<0,0,-0.025400><2.000000,0.036000,0.025400> rotate<0,90.000000,0> translate<15.680000,0.000000,62.230000> }
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<15.680000,0.000000,62.230000>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<13.930000,0.000000,62.230000>}
box{<0,0,-0.025400><1.750000,0.036000,0.025400> rotate<0,0.000000,0> translate<13.930000,0.000000,62.230000> }
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<13.930000,0.000000,62.230000>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<13.930000,0.000000,61.730000>}
box{<0,0,-0.025400><0.500000,0.036000,0.025400> rotate<0,-90.000000,0> translate<13.930000,0.000000,61.730000> }
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<13.930000,0.000000,61.730000>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<15.055000,0.000000,61.730000>}
box{<0,0,-0.025400><1.125000,0.036000,0.025400> rotate<0,0.000000,0> translate<13.930000,0.000000,61.730000> }
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<15.055000,0.000000,61.730000>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<15.055000,0.000000,61.480000>}
box{<0,0,-0.025400><0.250000,0.036000,0.025400> rotate<0,-90.000000,0> translate<15.055000,0.000000,61.480000> }
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<15.055000,0.000000,61.480000>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<13.930000,0.000000,61.480000>}
box{<0,0,-0.025400><1.125000,0.036000,0.025400> rotate<0,0.000000,0> translate<13.930000,0.000000,61.480000> }
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<13.930000,0.000000,61.480000>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<13.930000,0.000000,60.980000>}
box{<0,0,-0.025400><0.500000,0.036000,0.025400> rotate<0,-90.000000,0> translate<13.930000,0.000000,60.980000> }
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<13.930000,0.000000,60.980000>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<15.055000,0.000000,60.980000>}
box{<0,0,-0.025400><1.125000,0.036000,0.025400> rotate<0,0.000000,0> translate<13.930000,0.000000,60.980000> }
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<15.055000,0.000000,60.980000>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<15.055000,0.000000,60.730000>}
box{<0,0,-0.025400><0.250000,0.036000,0.025400> rotate<0,-90.000000,0> translate<15.055000,0.000000,60.730000> }
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<15.055000,0.000000,60.730000>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<13.930000,0.000000,60.730000>}
box{<0,0,-0.025400><1.125000,0.036000,0.025400> rotate<0,0.000000,0> translate<13.930000,0.000000,60.730000> }
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<13.930000,0.000000,60.730000>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<13.930000,0.000000,60.230000>}
box{<0,0,-0.025400><0.500000,0.036000,0.025400> rotate<0,-90.000000,0> translate<13.930000,0.000000,60.230000> }
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<13.930000,0.000000,60.230000>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<15.680000,0.000000,60.230000>}
box{<0,0,-0.025400><1.750000,0.036000,0.025400> rotate<0,0.000000,0> translate<13.930000,0.000000,60.230000> }
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<13.680000,0.000000,60.230000>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<13.680000,0.000000,62.230000>}
box{<0,0,-0.025400><2.000000,0.036000,0.025400> rotate<0,90.000000,0> translate<13.680000,0.000000,62.230000> }
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<13.680000,0.000000,62.230000>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<13.055000,0.000000,62.230000>}
box{<0,0,-0.025400><0.625000,0.036000,0.025400> rotate<0,0.000000,0> translate<13.055000,0.000000,62.230000> }
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<13.055000,0.000000,62.230000>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<13.055000,0.000000,61.480000>}
box{<0,0,-0.025400><0.750000,0.036000,0.025400> rotate<0,-90.000000,0> translate<13.055000,0.000000,61.480000> }
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<13.055000,0.000000,61.480000>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<12.555000,0.000000,62.230000>}
box{<0,0,-0.025400><0.901388,0.036000,0.025400> rotate<0,56.306216,0> translate<12.555000,0.000000,62.230000> }
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<12.555000,0.000000,62.230000>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<11.805000,0.000000,62.230000>}
box{<0,0,-0.025400><0.750000,0.036000,0.025400> rotate<0,0.000000,0> translate<11.805000,0.000000,62.230000> }
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<11.805000,0.000000,62.230000>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<12.305000,0.000000,61.480000>}
box{<0,0,-0.025400><0.901388,0.036000,0.025400> rotate<0,56.306216,0> translate<11.805000,0.000000,62.230000> }
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<13.055000,0.000000,60.730000>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<13.055000,0.000000,61.105000>}
box{<0,0,-0.025400><0.375000,0.036000,0.025400> rotate<0,90.000000,0> translate<13.055000,0.000000,61.105000> }
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<13.680000,0.000000,60.230000>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<12.305000,0.000000,60.230000>}
box{<0,0,-0.025400><1.375000,0.036000,0.025400> rotate<0,0.000000,0> translate<12.305000,0.000000,60.230000> }
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<13.055000,0.000000,60.730000>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<12.680000,0.000000,60.730000>}
box{<0,0,-0.025400><0.375000,0.036000,0.025400> rotate<0,0.000000,0> translate<12.680000,0.000000,60.730000> }
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<13.055000,0.000000,61.105000>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<12.680000,0.000000,61.105000>}
box{<0,0,-0.025400><0.375000,0.036000,0.025400> rotate<0,0.000000,0> translate<12.680000,0.000000,61.105000> }
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<10.305000,0.000000,61.230000>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<9.805000,0.000000,61.230000>}
box{<0,0,-0.025400><0.500000,0.036000,0.025400> rotate<0,0.000000,0> translate<9.805000,0.000000,61.230000> }
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<10.305000,0.000000,61.230000>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<10.305000,0.000000,61.730000>}
box{<0,0,-0.025400><0.500000,0.036000,0.025400> rotate<0,90.000000,0> translate<10.305000,0.000000,61.730000> }
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<9.810000,0.000000,60.730000>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<9.810000,0.000000,60.285000>}
box{<0,0,-0.025400><0.445000,0.036000,0.025400> rotate<0,-90.000000,0> translate<9.810000,0.000000,60.285000> }
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<9.805000,0.000000,61.230000>}
cylinder{<0,0,0><0,0.036000,0>0.025400 translate<9.805000,0.000000,62.105000>}
box{<0,0,-0.025400><0.875000,0.036000,0.025400> rotate<0,90.000000,0> translate<9.805000,0.000000,62.105000> }
//X2 silk screen
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<89.509600,0.000000,36.830000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<89.509600,0.000000,29.210000>}
box{<0,0,-0.076200><7.620000,0.036000,0.076200> rotate<0,-90.000000,0> translate<89.509600,0.000000,29.210000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.584800,0.000000,36.830000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<75.844400,0.000000,36.830000>}
box{<0,0,-0.076200><5.740400,0.036000,0.076200> rotate<0,0.000000,0> translate<75.844400,0.000000,36.830000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.584800,0.000000,29.210000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<75.844400,0.000000,29.210000>}
box{<0,0,-0.076200><5.740400,0.036000,0.076200> rotate<0,0.000000,0> translate<75.844400,0.000000,29.210000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<88.569800,0.000000,29.210000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<89.509600,0.000000,29.210000>}
box{<0,0,-0.076200><0.939800,0.036000,0.076200> rotate<0,0.000000,0> translate<88.569800,0.000000,29.210000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<88.569800,0.000000,36.830000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<89.509600,0.000000,36.830000>}
box{<0,0,-0.076200><0.939800,0.036000,0.076200> rotate<0,0.000000,0> translate<88.569800,0.000000,36.830000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<76.581000,0.000000,33.020000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<75.844400,0.000000,36.830000>}
box{<0,0,-0.076200><3.880551,0.036000,0.076200> rotate<0,79.052597,0> translate<75.844400,0.000000,36.830000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<76.581000,0.000000,33.020000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<75.844400,0.000000,29.210000>}
box{<0,0,-0.076200><3.880551,0.036000,0.076200> rotate<0,-79.052597,0> translate<75.844400,0.000000,29.210000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<82.753200,0.000000,35.991800>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<82.753200,0.000000,35.128200>}
box{<0,0,-0.076200><0.863600,0.036000,0.076200> rotate<0,-90.000000,0> translate<82.753200,0.000000,35.128200> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<82.753200,0.000000,35.128200>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.915000,0.000000,35.560000>}
box{<0,0,-0.076200><0.942884,0.036000,0.076200> rotate<0,27.253530,0> translate<81.915000,0.000000,35.560000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.915000,0.000000,35.560000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<82.753200,0.000000,35.991800>}
box{<0,0,-0.076200><0.942884,0.036000,0.076200> rotate<0,-27.253530,0> translate<81.915000,0.000000,35.560000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.915000,0.000000,35.560000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<82.169000,0.000000,35.560000>}
box{<0,0,-0.076200><0.254000,0.036000,0.076200> rotate<0,0.000000,0> translate<81.915000,0.000000,35.560000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.584800,0.000000,36.830000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.584800,0.000000,29.210000>}
box{<0,0,-0.076200><7.620000,0.036000,0.076200> rotate<0,-90.000000,0> translate<81.584800,0.000000,29.210000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<88.569800,0.000000,29.210000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<88.569800,0.000000,36.830000>}
box{<0,0,-0.076200><7.620000,0.036000,0.076200> rotate<0,90.000000,0> translate<88.569800,0.000000,36.830000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<88.569800,0.000000,39.344600>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<87.249000,0.000000,39.344600>}
box{<0,0,-0.076200><1.320800,0.036000,0.076200> rotate<0,0.000000,0> translate<87.249000,0.000000,39.344600> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.584800,0.000000,39.344600>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.584800,0.000000,38.481000>}
box{<0,0,-0.076200><0.863600,0.036000,0.076200> rotate<0,-90.000000,0> translate<81.584800,0.000000,38.481000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.584800,0.000000,26.670000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<82.931000,0.000000,26.670000>}
box{<0,0,-0.076200><1.346200,0.036000,0.076200> rotate<0,0.000000,0> translate<81.584800,0.000000,26.670000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<88.569800,0.000000,26.670000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<88.569800,0.000000,27.559000>}
box{<0,0,-0.076200><0.889000,0.036000,0.076200> rotate<0,90.000000,0> translate<88.569800,0.000000,27.559000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.584800,0.000000,38.481000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<82.931000,0.000000,38.481000>}
box{<0,0,-0.076200><1.346200,0.036000,0.076200> rotate<0,0.000000,0> translate<81.584800,0.000000,38.481000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<82.931000,0.000000,38.481000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<82.931000,0.000000,39.344600>}
box{<0,0,-0.076200><0.863600,0.036000,0.076200> rotate<0,90.000000,0> translate<82.931000,0.000000,39.344600> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<84.455000,0.000000,38.481000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<84.455000,0.000000,39.344600>}
box{<0,0,-0.076200><0.863600,0.036000,0.076200> rotate<0,90.000000,0> translate<84.455000,0.000000,39.344600> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.584800,0.000000,38.481000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.584800,0.000000,36.830000>}
box{<0,0,-0.076200><1.651000,0.036000,0.076200> rotate<0,-90.000000,0> translate<81.584800,0.000000,36.830000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<82.931000,0.000000,39.344600>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.584800,0.000000,39.344600>}
box{<0,0,-0.076200><1.346200,0.036000,0.076200> rotate<0,0.000000,0> translate<81.584800,0.000000,39.344600> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<84.455000,0.000000,39.344600>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<82.931000,0.000000,39.344600>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,0.000000,0> translate<82.931000,0.000000,39.344600> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<87.249000,0.000000,38.481000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<87.249000,0.000000,39.344600>}
box{<0,0,-0.076200><0.863600,0.036000,0.076200> rotate<0,90.000000,0> translate<87.249000,0.000000,39.344600> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<87.249000,0.000000,38.481000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<88.569800,0.000000,38.481000>}
box{<0,0,-0.076200><1.320800,0.036000,0.076200> rotate<0,0.000000,0> translate<87.249000,0.000000,38.481000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<87.249000,0.000000,39.344600>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<85.725000,0.000000,39.344600>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,0.000000,0> translate<85.725000,0.000000,39.344600> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<85.725000,0.000000,38.481000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<85.725000,0.000000,39.344600>}
box{<0,0,-0.076200><0.863600,0.036000,0.076200> rotate<0,90.000000,0> translate<85.725000,0.000000,39.344600> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<85.725000,0.000000,39.344600>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<84.455000,0.000000,39.344600>}
box{<0,0,-0.076200><1.270000,0.036000,0.076200> rotate<0,0.000000,0> translate<84.455000,0.000000,39.344600> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<88.569800,0.000000,36.830000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<88.569800,0.000000,38.481000>}
box{<0,0,-0.076200><1.651000,0.036000,0.076200> rotate<0,90.000000,0> translate<88.569800,0.000000,38.481000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.584800,0.000000,29.210000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.584800,0.000000,27.559000>}
box{<0,0,-0.076200><1.651000,0.036000,0.076200> rotate<0,-90.000000,0> translate<81.584800,0.000000,27.559000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<84.455000,0.000000,38.481000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<85.725000,0.000000,38.481000>}
box{<0,0,-0.076200><1.270000,0.036000,0.076200> rotate<0,0.000000,0> translate<84.455000,0.000000,38.481000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.584800,0.000000,27.559000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<82.931000,0.000000,27.559000>}
box{<0,0,-0.076200><1.346200,0.036000,0.076200> rotate<0,0.000000,0> translate<81.584800,0.000000,27.559000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.584800,0.000000,27.559000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.584800,0.000000,26.670000>}
box{<0,0,-0.076200><0.889000,0.036000,0.076200> rotate<0,-90.000000,0> translate<81.584800,0.000000,26.670000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<82.931000,0.000000,26.670000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<82.931000,0.000000,27.559000>}
box{<0,0,-0.076200><0.889000,0.036000,0.076200> rotate<0,90.000000,0> translate<82.931000,0.000000,27.559000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<84.455000,0.000000,26.670000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<84.455000,0.000000,27.559000>}
box{<0,0,-0.076200><0.889000,0.036000,0.076200> rotate<0,90.000000,0> translate<84.455000,0.000000,27.559000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<84.455000,0.000000,27.559000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<85.725000,0.000000,27.559000>}
box{<0,0,-0.076200><1.270000,0.036000,0.076200> rotate<0,0.000000,0> translate<84.455000,0.000000,27.559000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<85.725000,0.000000,26.670000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<85.725000,0.000000,27.559000>}
box{<0,0,-0.076200><0.889000,0.036000,0.076200> rotate<0,90.000000,0> translate<85.725000,0.000000,27.559000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<87.249000,0.000000,26.670000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<87.249000,0.000000,27.559000>}
box{<0,0,-0.076200><0.889000,0.036000,0.076200> rotate<0,90.000000,0> translate<87.249000,0.000000,27.559000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<87.249000,0.000000,27.559000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<88.569800,0.000000,27.559000>}
box{<0,0,-0.076200><1.320800,0.036000,0.076200> rotate<0,0.000000,0> translate<87.249000,0.000000,27.559000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<84.455000,0.000000,26.670000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<85.725000,0.000000,26.670000>}
box{<0,0,-0.076200><1.270000,0.036000,0.076200> rotate<0,0.000000,0> translate<84.455000,0.000000,26.670000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<82.931000,0.000000,26.670000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<84.455000,0.000000,26.670000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,0.000000,0> translate<82.931000,0.000000,26.670000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<85.725000,0.000000,26.670000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<87.249000,0.000000,26.670000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,0.000000,0> translate<85.725000,0.000000,26.670000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<87.249000,0.000000,26.670000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<88.569800,0.000000,26.670000>}
box{<0,0,-0.076200><1.320800,0.036000,0.076200> rotate<0,0.000000,0> translate<87.249000,0.000000,26.670000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<88.569800,0.000000,27.559000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<88.569800,0.000000,29.210000>}
box{<0,0,-0.076200><1.651000,0.036000,0.076200> rotate<0,90.000000,0> translate<88.569800,0.000000,29.210000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<88.569800,0.000000,38.481000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<88.569800,0.000000,39.344600>}
box{<0,0,-0.076200><0.863600,0.036000,0.076200> rotate<0,90.000000,0> translate<88.569800,0.000000,39.344600> }
box{<-0.254000,0,-0.127000><0.254000,0.036000,0.127000> rotate<0,-90.000000,0> translate<82.448400,0.000000,35.560000>}
box{<-0.190500,0,-0.063500><0.190500,0.036000,0.063500> rotate<0,-90.000000,0> translate<82.638900,0.000000,35.750500>}
box{<-0.190500,0,-0.063500><0.190500,0.036000,0.063500> rotate<0,-90.000000,0> translate<82.638900,0.000000,35.369500>}
box{<-0.127000,0,-0.127000><0.127000,0.036000,0.127000> rotate<0,-90.000000,0> translate<82.245200,0.000000,35.560000>}
//X3 silk screen
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<4.089400,0.000000,4.064000>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<6.096000,0.000000,6.070600>}
box{<0,0,-0.127000><2.837761,0.036000,0.127000> rotate<0,-44.997030,0> translate<4.089400,0.000000,4.064000> }
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<9.245600,0.000000,4.038600>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<11.150600,0.000000,6.070600>}
box{<0,0,-0.127000><2.785327,0.036000,0.127000> rotate<0,-46.844519,0> translate<9.245600,0.000000,4.038600> }
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<14.249400,0.000000,4.064000>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<16.256000,0.000000,6.070600>}
box{<0,0,-0.127000><2.837761,0.036000,0.127000> rotate<0,-44.997030,0> translate<14.249400,0.000000,4.064000> }
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<19.405600,0.000000,4.038600>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<21.310600,0.000000,6.070600>}
box{<0,0,-0.127000><2.785327,0.036000,0.127000> rotate<0,-46.844519,0> translate<19.405600,0.000000,4.038600> }
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<24.409400,0.000000,4.064000>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<26.416000,0.000000,6.070600>}
box{<0,0,-0.127000><2.837761,0.036000,0.127000> rotate<0,-44.997030,0> translate<24.409400,0.000000,4.064000> }
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<29.565600,0.000000,4.038600>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<31.470600,0.000000,6.070600>}
box{<0,0,-0.127000><2.785327,0.036000,0.127000> rotate<0,-46.844519,0> translate<29.565600,0.000000,4.038600> }
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<34.569400,0.000000,4.064000>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<36.576000,0.000000,6.070600>}
box{<0,0,-0.127000><2.837761,0.036000,0.127000> rotate<0,-44.997030,0> translate<34.569400,0.000000,4.064000> }
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<39.725600,0.000000,4.038600>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<41.630600,0.000000,6.070600>}
box{<0,0,-0.127000><2.785327,0.036000,0.127000> rotate<0,-46.844519,0> translate<39.725600,0.000000,4.038600> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<2.540000,0.000000,0.889000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,0.889000>}
box{<0,0,-0.076200><40.640000,0.036000,0.076200> rotate<0,0.000000,0> translate<2.540000,0.000000,0.889000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,10.160000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,9.906000>}
box{<0,0,-0.076200><0.254000,0.036000,0.076200> rotate<0,-90.000000,0> translate<43.180000,0.000000,9.906000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,10.160000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<33.020000,0.000000,10.160000>}
box{<0,0,-0.076200><10.160000,0.036000,0.076200> rotate<0,0.000000,0> translate<33.020000,0.000000,10.160000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<2.540000,0.000000,0.889000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<2.540000,0.000000,3.302000>}
box{<0,0,-0.076200><2.413000,0.036000,0.076200> rotate<0,90.000000,0> translate<2.540000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<2.540000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<4.191000,0.000000,3.302000>}
box{<0,0,-0.076200><1.651000,0.036000,0.076200> rotate<0,0.000000,0> translate<2.540000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<4.191000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<5.969000,0.000000,3.302000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<4.191000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<5.969000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<9.271000,0.000000,3.302000>}
box{<0,0,-0.076200><3.302000,0.036000,0.076200> rotate<0,0.000000,0> translate<5.969000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<2.540000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<2.540000,0.000000,9.906000>}
box{<0,0,-0.076200><6.604000,0.036000,0.076200> rotate<0,90.000000,0> translate<2.540000,0.000000,9.906000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,9.906000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<2.540000,0.000000,9.906000>}
box{<0,0,-0.076200><40.640000,0.036000,0.076200> rotate<0,0.000000,0> translate<2.540000,0.000000,9.906000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,9.906000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,3.302000>}
box{<0,0,-0.076200><6.604000,0.036000,0.076200> rotate<0,-90.000000,0> translate<43.180000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,0.889000>}
box{<0,0,-0.076200><2.413000,0.036000,0.076200> rotate<0,-90.000000,0> translate<43.180000,0.000000,0.889000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<2.540000,0.000000,9.906000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<2.540000,0.000000,10.160000>}
box{<0,0,-0.076200><0.254000,0.036000,0.076200> rotate<0,90.000000,0> translate<2.540000,0.000000,10.160000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<17.780000,0.000000,10.160000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<17.780000,0.000000,3.302000>}
box{<0,0,-0.076200><6.858000,0.036000,0.076200> rotate<0,-90.000000,0> translate<17.780000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<17.780000,0.000000,10.160000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<2.540000,0.000000,10.160000>}
box{<0,0,-0.076200><15.240000,0.036000,0.076200> rotate<0,0.000000,0> translate<2.540000,0.000000,10.160000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<33.020000,0.000000,10.160000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<33.020000,0.000000,3.302000>}
box{<0,0,-0.076200><6.858000,0.036000,0.076200> rotate<0,-90.000000,0> translate<33.020000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<33.020000,0.000000,10.160000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<17.780000,0.000000,10.160000>}
box{<0,0,-0.076200><15.240000,0.036000,0.076200> rotate<0,0.000000,0> translate<17.780000,0.000000,10.160000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<9.271000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<11.049000,0.000000,3.302000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<9.271000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<11.049000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<14.351000,0.000000,3.302000>}
box{<0,0,-0.076200><3.302000,0.036000,0.076200> rotate<0,0.000000,0> translate<11.049000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<14.351000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<16.129000,0.000000,3.302000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<14.351000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<16.129000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<17.780000,0.000000,3.302000>}
box{<0,0,-0.076200><1.651000,0.036000,0.076200> rotate<0,0.000000,0> translate<16.129000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<17.780000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<19.431000,0.000000,3.302000>}
box{<0,0,-0.076200><1.651000,0.036000,0.076200> rotate<0,0.000000,0> translate<17.780000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<19.431000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<21.209000,0.000000,3.302000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<19.431000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<21.209000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<24.511000,0.000000,3.302000>}
box{<0,0,-0.076200><3.302000,0.036000,0.076200> rotate<0,0.000000,0> translate<21.209000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<24.511000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<26.289000,0.000000,3.302000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<24.511000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<26.289000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<29.591000,0.000000,3.302000>}
box{<0,0,-0.076200><3.302000,0.036000,0.076200> rotate<0,0.000000,0> translate<26.289000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<29.591000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<31.369000,0.000000,3.302000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<29.591000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<31.369000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<33.020000,0.000000,3.302000>}
box{<0,0,-0.076200><1.651000,0.036000,0.076200> rotate<0,0.000000,0> translate<31.369000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<33.020000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<34.671000,0.000000,3.302000>}
box{<0,0,-0.076200><1.651000,0.036000,0.076200> rotate<0,0.000000,0> translate<33.020000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<34.671000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<36.449000,0.000000,3.302000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<34.671000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<36.449000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<39.751000,0.000000,3.302000>}
box{<0,0,-0.076200><3.302000,0.036000,0.076200> rotate<0,0.000000,0> translate<36.449000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<39.751000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<41.529000,0.000000,3.302000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<39.751000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<41.529000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,3.302000>}
box{<0,0,-0.076200><1.651000,0.036000,0.076200> rotate<0,0.000000,0> translate<41.529000,0.000000,3.302000> }
difference{
cylinder{<5.080000,0,5.080000><5.080000,0.036000,5.080000>1.574800 translate<0,0.000000,0>}
cylinder{<5.080000,-0.1,5.080000><5.080000,0.135000,5.080000>1.422400 translate<0,0.000000,0>}}
difference{
cylinder{<5.080000,0,8.559800><5.080000,0.036000,8.559800>0.584200 translate<0,0.000000,0>}
cylinder{<5.080000,-0.1,8.559800><5.080000,0.135000,8.559800>0.431800 translate<0,0.000000,0>}}
difference{
cylinder{<10.160000,0,5.080000><10.160000,0.036000,5.080000>1.574800 translate<0,0.000000,0>}
cylinder{<10.160000,-0.1,5.080000><10.160000,0.135000,5.080000>1.422400 translate<0,0.000000,0>}}
difference{
cylinder{<10.160000,0,8.559800><10.160000,0.036000,8.559800>0.584200 translate<0,0.000000,0>}
cylinder{<10.160000,-0.1,8.559800><10.160000,0.135000,8.559800>0.431800 translate<0,0.000000,0>}}
difference{
cylinder{<15.240000,0,5.080000><15.240000,0.036000,5.080000>1.574800 translate<0,0.000000,0>}
cylinder{<15.240000,-0.1,5.080000><15.240000,0.135000,5.080000>1.422400 translate<0,0.000000,0>}}
difference{
cylinder{<15.240000,0,8.559800><15.240000,0.036000,8.559800>0.584200 translate<0,0.000000,0>}
cylinder{<15.240000,-0.1,8.559800><15.240000,0.135000,8.559800>0.431800 translate<0,0.000000,0>}}
difference{
cylinder{<20.320000,0,5.080000><20.320000,0.036000,5.080000>1.574800 translate<0,0.000000,0>}
cylinder{<20.320000,-0.1,5.080000><20.320000,0.135000,5.080000>1.422400 translate<0,0.000000,0>}}
difference{
cylinder{<20.320000,0,8.559800><20.320000,0.036000,8.559800>0.584200 translate<0,0.000000,0>}
cylinder{<20.320000,-0.1,8.559800><20.320000,0.135000,8.559800>0.431800 translate<0,0.000000,0>}}
difference{
cylinder{<25.400000,0,5.080000><25.400000,0.036000,5.080000>1.574800 translate<0,0.000000,0>}
cylinder{<25.400000,-0.1,5.080000><25.400000,0.135000,5.080000>1.422400 translate<0,0.000000,0>}}
difference{
cylinder{<25.400000,0,8.559800><25.400000,0.036000,8.559800>0.584200 translate<0,0.000000,0>}
cylinder{<25.400000,-0.1,8.559800><25.400000,0.135000,8.559800>0.431800 translate<0,0.000000,0>}}
difference{
cylinder{<30.480000,0,5.080000><30.480000,0.036000,5.080000>1.574800 translate<0,0.000000,0>}
cylinder{<30.480000,-0.1,5.080000><30.480000,0.135000,5.080000>1.422400 translate<0,0.000000,0>}}
difference{
cylinder{<30.480000,0,8.559800><30.480000,0.036000,8.559800>0.584200 translate<0,0.000000,0>}
cylinder{<30.480000,-0.1,8.559800><30.480000,0.135000,8.559800>0.431800 translate<0,0.000000,0>}}
difference{
cylinder{<35.560000,0,5.080000><35.560000,0.036000,5.080000>1.574800 translate<0,0.000000,0>}
cylinder{<35.560000,-0.1,5.080000><35.560000,0.135000,5.080000>1.422400 translate<0,0.000000,0>}}
difference{
cylinder{<35.560000,0,8.559800><35.560000,0.036000,8.559800>0.584200 translate<0,0.000000,0>}
cylinder{<35.560000,-0.1,8.559800><35.560000,0.135000,8.559800>0.431800 translate<0,0.000000,0>}}
difference{
cylinder{<40.640000,0,5.080000><40.640000,0.036000,5.080000>1.574800 translate<0,0.000000,0>}
cylinder{<40.640000,-0.1,5.080000><40.640000,0.135000,5.080000>1.422400 translate<0,0.000000,0>}}
difference{
cylinder{<40.640000,0,8.559800><40.640000,0.036000,8.559800>0.584200 translate<0,0.000000,0>}
cylinder{<40.640000,-0.1,8.559800><40.640000,0.135000,8.559800>0.431800 translate<0,0.000000,0>}}
//X4 silk screen
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<44.729400,0.000000,4.064000>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<46.736000,0.000000,6.070600>}
box{<0,0,-0.127000><2.837761,0.036000,0.127000> rotate<0,-44.997030,0> translate<44.729400,0.000000,4.064000> }
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<49.885600,0.000000,4.038600>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<51.790600,0.000000,6.070600>}
box{<0,0,-0.127000><2.785327,0.036000,0.127000> rotate<0,-46.844519,0> translate<49.885600,0.000000,4.038600> }
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<54.889400,0.000000,4.064000>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<56.896000,0.000000,6.070600>}
box{<0,0,-0.127000><2.837761,0.036000,0.127000> rotate<0,-44.997030,0> translate<54.889400,0.000000,4.064000> }
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<60.045600,0.000000,4.038600>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<61.950600,0.000000,6.070600>}
box{<0,0,-0.127000><2.785327,0.036000,0.127000> rotate<0,-46.844519,0> translate<60.045600,0.000000,4.038600> }
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<65.049400,0.000000,4.064000>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<67.056000,0.000000,6.070600>}
box{<0,0,-0.127000><2.837761,0.036000,0.127000> rotate<0,-44.997030,0> translate<65.049400,0.000000,4.064000> }
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<70.205600,0.000000,4.038600>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<72.110600,0.000000,6.070600>}
box{<0,0,-0.127000><2.785327,0.036000,0.127000> rotate<0,-46.844519,0> translate<70.205600,0.000000,4.038600> }
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<75.209400,0.000000,4.064000>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<77.216000,0.000000,6.070600>}
box{<0,0,-0.127000><2.837761,0.036000,0.127000> rotate<0,-44.997030,0> translate<75.209400,0.000000,4.064000> }
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<80.365600,0.000000,4.038600>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<82.270600,0.000000,6.070600>}
box{<0,0,-0.127000><2.785327,0.036000,0.127000> rotate<0,-46.844519,0> translate<80.365600,0.000000,4.038600> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,0.889000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,0.889000>}
box{<0,0,-0.076200><40.640000,0.036000,0.076200> rotate<0,0.000000,0> translate<43.180000,0.000000,0.889000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,10.160000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,9.906000>}
box{<0,0,-0.076200><0.254000,0.036000,0.076200> rotate<0,-90.000000,0> translate<83.820000,0.000000,9.906000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,10.160000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<73.660000,0.000000,10.160000>}
box{<0,0,-0.076200><10.160000,0.036000,0.076200> rotate<0,0.000000,0> translate<73.660000,0.000000,10.160000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,0.889000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,3.302000>}
box{<0,0,-0.076200><2.413000,0.036000,0.076200> rotate<0,90.000000,0> translate<43.180000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<44.831000,0.000000,3.302000>}
box{<0,0,-0.076200><1.651000,0.036000,0.076200> rotate<0,0.000000,0> translate<43.180000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<44.831000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<46.609000,0.000000,3.302000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<44.831000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<46.609000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<49.911000,0.000000,3.302000>}
box{<0,0,-0.076200><3.302000,0.036000,0.076200> rotate<0,0.000000,0> translate<46.609000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,9.906000>}
box{<0,0,-0.076200><6.604000,0.036000,0.076200> rotate<0,90.000000,0> translate<43.180000,0.000000,9.906000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,9.906000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,9.906000>}
box{<0,0,-0.076200><40.640000,0.036000,0.076200> rotate<0,0.000000,0> translate<43.180000,0.000000,9.906000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,9.906000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,3.302000>}
box{<0,0,-0.076200><6.604000,0.036000,0.076200> rotate<0,-90.000000,0> translate<83.820000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,0.889000>}
box{<0,0,-0.076200><2.413000,0.036000,0.076200> rotate<0,-90.000000,0> translate<83.820000,0.000000,0.889000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,9.906000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,10.160000>}
box{<0,0,-0.076200><0.254000,0.036000,0.076200> rotate<0,90.000000,0> translate<43.180000,0.000000,10.160000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<58.420000,0.000000,10.160000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<58.420000,0.000000,3.302000>}
box{<0,0,-0.076200><6.858000,0.036000,0.076200> rotate<0,-90.000000,0> translate<58.420000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<58.420000,0.000000,10.160000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,10.160000>}
box{<0,0,-0.076200><15.240000,0.036000,0.076200> rotate<0,0.000000,0> translate<43.180000,0.000000,10.160000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<73.660000,0.000000,10.160000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<73.660000,0.000000,3.302000>}
box{<0,0,-0.076200><6.858000,0.036000,0.076200> rotate<0,-90.000000,0> translate<73.660000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<73.660000,0.000000,10.160000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<58.420000,0.000000,10.160000>}
box{<0,0,-0.076200><15.240000,0.036000,0.076200> rotate<0,0.000000,0> translate<58.420000,0.000000,10.160000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<49.911000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<51.689000,0.000000,3.302000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<49.911000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<51.689000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<54.991000,0.000000,3.302000>}
box{<0,0,-0.076200><3.302000,0.036000,0.076200> rotate<0,0.000000,0> translate<51.689000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<54.991000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<56.769000,0.000000,3.302000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<54.991000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<56.769000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<58.420000,0.000000,3.302000>}
box{<0,0,-0.076200><1.651000,0.036000,0.076200> rotate<0,0.000000,0> translate<56.769000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<58.420000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<60.071000,0.000000,3.302000>}
box{<0,0,-0.076200><1.651000,0.036000,0.076200> rotate<0,0.000000,0> translate<58.420000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<60.071000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<61.849000,0.000000,3.302000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<60.071000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<61.849000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<65.151000,0.000000,3.302000>}
box{<0,0,-0.076200><3.302000,0.036000,0.076200> rotate<0,0.000000,0> translate<61.849000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<65.151000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<66.929000,0.000000,3.302000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<65.151000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<66.929000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<70.231000,0.000000,3.302000>}
box{<0,0,-0.076200><3.302000,0.036000,0.076200> rotate<0,0.000000,0> translate<66.929000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<70.231000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<72.009000,0.000000,3.302000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<70.231000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<72.009000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<73.660000,0.000000,3.302000>}
box{<0,0,-0.076200><1.651000,0.036000,0.076200> rotate<0,0.000000,0> translate<72.009000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<73.660000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<75.311000,0.000000,3.302000>}
box{<0,0,-0.076200><1.651000,0.036000,0.076200> rotate<0,0.000000,0> translate<73.660000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<75.311000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<77.089000,0.000000,3.302000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<75.311000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<77.089000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<80.391000,0.000000,3.302000>}
box{<0,0,-0.076200><3.302000,0.036000,0.076200> rotate<0,0.000000,0> translate<77.089000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<80.391000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<82.169000,0.000000,3.302000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<80.391000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<82.169000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,3.302000>}
box{<0,0,-0.076200><1.651000,0.036000,0.076200> rotate<0,0.000000,0> translate<82.169000,0.000000,3.302000> }
difference{
cylinder{<45.720000,0,5.080000><45.720000,0.036000,5.080000>1.574800 translate<0,0.000000,0>}
cylinder{<45.720000,-0.1,5.080000><45.720000,0.135000,5.080000>1.422400 translate<0,0.000000,0>}}
difference{
cylinder{<45.720000,0,8.559800><45.720000,0.036000,8.559800>0.584200 translate<0,0.000000,0>}
cylinder{<45.720000,-0.1,8.559800><45.720000,0.135000,8.559800>0.431800 translate<0,0.000000,0>}}
difference{
cylinder{<50.800000,0,5.080000><50.800000,0.036000,5.080000>1.574800 translate<0,0.000000,0>}
cylinder{<50.800000,-0.1,5.080000><50.800000,0.135000,5.080000>1.422400 translate<0,0.000000,0>}}
difference{
cylinder{<50.800000,0,8.559800><50.800000,0.036000,8.559800>0.584200 translate<0,0.000000,0>}
cylinder{<50.800000,-0.1,8.559800><50.800000,0.135000,8.559800>0.431800 translate<0,0.000000,0>}}
difference{
cylinder{<55.880000,0,5.080000><55.880000,0.036000,5.080000>1.574800 translate<0,0.000000,0>}
cylinder{<55.880000,-0.1,5.080000><55.880000,0.135000,5.080000>1.422400 translate<0,0.000000,0>}}
difference{
cylinder{<55.880000,0,8.559800><55.880000,0.036000,8.559800>0.584200 translate<0,0.000000,0>}
cylinder{<55.880000,-0.1,8.559800><55.880000,0.135000,8.559800>0.431800 translate<0,0.000000,0>}}
difference{
cylinder{<60.960000,0,5.080000><60.960000,0.036000,5.080000>1.574800 translate<0,0.000000,0>}
cylinder{<60.960000,-0.1,5.080000><60.960000,0.135000,5.080000>1.422400 translate<0,0.000000,0>}}
difference{
cylinder{<60.960000,0,8.559800><60.960000,0.036000,8.559800>0.584200 translate<0,0.000000,0>}
cylinder{<60.960000,-0.1,8.559800><60.960000,0.135000,8.559800>0.431800 translate<0,0.000000,0>}}
difference{
cylinder{<66.040000,0,5.080000><66.040000,0.036000,5.080000>1.574800 translate<0,0.000000,0>}
cylinder{<66.040000,-0.1,5.080000><66.040000,0.135000,5.080000>1.422400 translate<0,0.000000,0>}}
difference{
cylinder{<66.040000,0,8.559800><66.040000,0.036000,8.559800>0.584200 translate<0,0.000000,0>}
cylinder{<66.040000,-0.1,8.559800><66.040000,0.135000,8.559800>0.431800 translate<0,0.000000,0>}}
difference{
cylinder{<71.120000,0,5.080000><71.120000,0.036000,5.080000>1.574800 translate<0,0.000000,0>}
cylinder{<71.120000,-0.1,5.080000><71.120000,0.135000,5.080000>1.422400 translate<0,0.000000,0>}}
difference{
cylinder{<71.120000,0,8.559800><71.120000,0.036000,8.559800>0.584200 translate<0,0.000000,0>}
cylinder{<71.120000,-0.1,8.559800><71.120000,0.135000,8.559800>0.431800 translate<0,0.000000,0>}}
difference{
cylinder{<76.200000,0,5.080000><76.200000,0.036000,5.080000>1.574800 translate<0,0.000000,0>}
cylinder{<76.200000,-0.1,5.080000><76.200000,0.135000,5.080000>1.422400 translate<0,0.000000,0>}}
difference{
cylinder{<76.200000,0,8.559800><76.200000,0.036000,8.559800>0.584200 translate<0,0.000000,0>}
cylinder{<76.200000,-0.1,8.559800><76.200000,0.135000,8.559800>0.431800 translate<0,0.000000,0>}}
difference{
cylinder{<81.280000,0,5.080000><81.280000,0.036000,5.080000>1.574800 translate<0,0.000000,0>}
cylinder{<81.280000,-0.1,5.080000><81.280000,0.135000,5.080000>1.422400 translate<0,0.000000,0>}}
difference{
cylinder{<81.280000,0,8.559800><81.280000,0.036000,8.559800>0.584200 translate<0,0.000000,0>}
cylinder{<81.280000,-0.1,8.559800><81.280000,0.135000,8.559800>0.431800 translate<0,0.000000,0>}}
//X5 silk screen
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<61.950600,0.000000,67.056000>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<59.944000,0.000000,65.049400>}
box{<0,0,-0.127000><2.837761,0.036000,0.127000> rotate<0,-44.997030,0> translate<59.944000,0.000000,65.049400> }
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<56.794400,0.000000,67.081400>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<54.889400,0.000000,65.049400>}
box{<0,0,-0.127000><2.785327,0.036000,0.127000> rotate<0,-46.844519,0> translate<54.889400,0.000000,65.049400> }
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<51.790600,0.000000,67.056000>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<49.784000,0.000000,65.049400>}
box{<0,0,-0.127000><2.837761,0.036000,0.127000> rotate<0,-44.997030,0> translate<49.784000,0.000000,65.049400> }
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<46.634400,0.000000,67.081400>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<44.729400,0.000000,65.049400>}
box{<0,0,-0.127000><2.785327,0.036000,0.127000> rotate<0,-46.844519,0> translate<44.729400,0.000000,65.049400> }
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<41.630600,0.000000,67.056000>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<39.624000,0.000000,65.049400>}
box{<0,0,-0.127000><2.837761,0.036000,0.127000> rotate<0,-44.997030,0> translate<39.624000,0.000000,65.049400> }
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<36.474400,0.000000,67.081400>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<34.569400,0.000000,65.049400>}
box{<0,0,-0.127000><2.785327,0.036000,0.127000> rotate<0,-46.844519,0> translate<34.569400,0.000000,65.049400> }
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<31.470600,0.000000,67.056000>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<29.464000,0.000000,65.049400>}
box{<0,0,-0.127000><2.837761,0.036000,0.127000> rotate<0,-44.997030,0> translate<29.464000,0.000000,65.049400> }
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<26.314400,0.000000,67.081400>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<24.409400,0.000000,65.049400>}
box{<0,0,-0.127000><2.785327,0.036000,0.127000> rotate<0,-46.844519,0> translate<24.409400,0.000000,65.049400> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.500000,0.000000,70.231000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<22.860000,0.000000,70.231000>}
box{<0,0,-0.076200><40.640000,0.036000,0.076200> rotate<0,0.000000,0> translate<22.860000,0.000000,70.231000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<22.860000,0.000000,60.960000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<22.860000,0.000000,61.214000>}
box{<0,0,-0.076200><0.254000,0.036000,0.076200> rotate<0,90.000000,0> translate<22.860000,0.000000,61.214000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<22.860000,0.000000,60.960000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<33.020000,0.000000,60.960000>}
box{<0,0,-0.076200><10.160000,0.036000,0.076200> rotate<0,0.000000,0> translate<22.860000,0.000000,60.960000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.500000,0.000000,70.231000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.500000,0.000000,67.818000>}
box{<0,0,-0.076200><2.413000,0.036000,0.076200> rotate<0,-90.000000,0> translate<63.500000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.500000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<61.849000,0.000000,67.818000>}
box{<0,0,-0.076200><1.651000,0.036000,0.076200> rotate<0,0.000000,0> translate<61.849000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<61.849000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<60.071000,0.000000,67.818000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<60.071000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<60.071000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<56.769000,0.000000,67.818000>}
box{<0,0,-0.076200><3.302000,0.036000,0.076200> rotate<0,0.000000,0> translate<56.769000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.500000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.500000,0.000000,61.214000>}
box{<0,0,-0.076200><6.604000,0.036000,0.076200> rotate<0,-90.000000,0> translate<63.500000,0.000000,61.214000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<22.860000,0.000000,61.214000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.500000,0.000000,61.214000>}
box{<0,0,-0.076200><40.640000,0.036000,0.076200> rotate<0,0.000000,0> translate<22.860000,0.000000,61.214000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<22.860000,0.000000,61.214000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<22.860000,0.000000,67.818000>}
box{<0,0,-0.076200><6.604000,0.036000,0.076200> rotate<0,90.000000,0> translate<22.860000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<22.860000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<22.860000,0.000000,70.231000>}
box{<0,0,-0.076200><2.413000,0.036000,0.076200> rotate<0,90.000000,0> translate<22.860000,0.000000,70.231000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.500000,0.000000,61.214000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.500000,0.000000,60.960000>}
box{<0,0,-0.076200><0.254000,0.036000,0.076200> rotate<0,-90.000000,0> translate<63.500000,0.000000,60.960000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<48.260000,0.000000,60.960000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<48.260000,0.000000,67.818000>}
box{<0,0,-0.076200><6.858000,0.036000,0.076200> rotate<0,90.000000,0> translate<48.260000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<48.260000,0.000000,60.960000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.500000,0.000000,60.960000>}
box{<0,0,-0.076200><15.240000,0.036000,0.076200> rotate<0,0.000000,0> translate<48.260000,0.000000,60.960000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<33.020000,0.000000,60.960000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<33.020000,0.000000,67.818000>}
box{<0,0,-0.076200><6.858000,0.036000,0.076200> rotate<0,90.000000,0> translate<33.020000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<33.020000,0.000000,60.960000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<48.260000,0.000000,60.960000>}
box{<0,0,-0.076200><15.240000,0.036000,0.076200> rotate<0,0.000000,0> translate<33.020000,0.000000,60.960000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<56.769000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<54.991000,0.000000,67.818000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<54.991000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<54.991000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<51.689000,0.000000,67.818000>}
box{<0,0,-0.076200><3.302000,0.036000,0.076200> rotate<0,0.000000,0> translate<51.689000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<51.689000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<49.911000,0.000000,67.818000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<49.911000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<49.911000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<48.260000,0.000000,67.818000>}
box{<0,0,-0.076200><1.651000,0.036000,0.076200> rotate<0,0.000000,0> translate<48.260000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<48.260000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<46.609000,0.000000,67.818000>}
box{<0,0,-0.076200><1.651000,0.036000,0.076200> rotate<0,0.000000,0> translate<46.609000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<46.609000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<44.831000,0.000000,67.818000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<44.831000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<44.831000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<41.529000,0.000000,67.818000>}
box{<0,0,-0.076200><3.302000,0.036000,0.076200> rotate<0,0.000000,0> translate<41.529000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<41.529000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<39.751000,0.000000,67.818000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<39.751000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<39.751000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<36.449000,0.000000,67.818000>}
box{<0,0,-0.076200><3.302000,0.036000,0.076200> rotate<0,0.000000,0> translate<36.449000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<36.449000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<34.671000,0.000000,67.818000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<34.671000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<34.671000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<33.020000,0.000000,67.818000>}
box{<0,0,-0.076200><1.651000,0.036000,0.076200> rotate<0,0.000000,0> translate<33.020000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<33.020000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<31.369000,0.000000,67.818000>}
box{<0,0,-0.076200><1.651000,0.036000,0.076200> rotate<0,0.000000,0> translate<31.369000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<31.369000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<29.591000,0.000000,67.818000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<29.591000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<29.591000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<26.289000,0.000000,67.818000>}
box{<0,0,-0.076200><3.302000,0.036000,0.076200> rotate<0,0.000000,0> translate<26.289000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<26.289000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<24.511000,0.000000,67.818000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<24.511000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<24.511000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<22.860000,0.000000,67.818000>}
box{<0,0,-0.076200><1.651000,0.036000,0.076200> rotate<0,0.000000,0> translate<22.860000,0.000000,67.818000> }
difference{
cylinder{<60.960000,0,66.040000><60.960000,0.036000,66.040000>1.574800 translate<0,0.000000,0>}
cylinder{<60.960000,-0.1,66.040000><60.960000,0.135000,66.040000>1.422400 translate<0,0.000000,0>}}
difference{
cylinder{<60.960000,0,62.560200><60.960000,0.036000,62.560200>0.584200 translate<0,0.000000,0>}
cylinder{<60.960000,-0.1,62.560200><60.960000,0.135000,62.560200>0.431800 translate<0,0.000000,0>}}
difference{
cylinder{<55.880000,0,66.040000><55.880000,0.036000,66.040000>1.574800 translate<0,0.000000,0>}
cylinder{<55.880000,-0.1,66.040000><55.880000,0.135000,66.040000>1.422400 translate<0,0.000000,0>}}
difference{
cylinder{<55.880000,0,62.560200><55.880000,0.036000,62.560200>0.584200 translate<0,0.000000,0>}
cylinder{<55.880000,-0.1,62.560200><55.880000,0.135000,62.560200>0.431800 translate<0,0.000000,0>}}
difference{
cylinder{<50.800000,0,66.040000><50.800000,0.036000,66.040000>1.574800 translate<0,0.000000,0>}
cylinder{<50.800000,-0.1,66.040000><50.800000,0.135000,66.040000>1.422400 translate<0,0.000000,0>}}
difference{
cylinder{<50.800000,0,62.560200><50.800000,0.036000,62.560200>0.584200 translate<0,0.000000,0>}
cylinder{<50.800000,-0.1,62.560200><50.800000,0.135000,62.560200>0.431800 translate<0,0.000000,0>}}
difference{
cylinder{<45.720000,0,66.040000><45.720000,0.036000,66.040000>1.574800 translate<0,0.000000,0>}
cylinder{<45.720000,-0.1,66.040000><45.720000,0.135000,66.040000>1.422400 translate<0,0.000000,0>}}
difference{
cylinder{<45.720000,0,62.560200><45.720000,0.036000,62.560200>0.584200 translate<0,0.000000,0>}
cylinder{<45.720000,-0.1,62.560200><45.720000,0.135000,62.560200>0.431800 translate<0,0.000000,0>}}
difference{
cylinder{<40.640000,0,66.040000><40.640000,0.036000,66.040000>1.574800 translate<0,0.000000,0>}
cylinder{<40.640000,-0.1,66.040000><40.640000,0.135000,66.040000>1.422400 translate<0,0.000000,0>}}
difference{
cylinder{<40.640000,0,62.560200><40.640000,0.036000,62.560200>0.584200 translate<0,0.000000,0>}
cylinder{<40.640000,-0.1,62.560200><40.640000,0.135000,62.560200>0.431800 translate<0,0.000000,0>}}
difference{
cylinder{<35.560000,0,66.040000><35.560000,0.036000,66.040000>1.574800 translate<0,0.000000,0>}
cylinder{<35.560000,-0.1,66.040000><35.560000,0.135000,66.040000>1.422400 translate<0,0.000000,0>}}
difference{
cylinder{<35.560000,0,62.560200><35.560000,0.036000,62.560200>0.584200 translate<0,0.000000,0>}
cylinder{<35.560000,-0.1,62.560200><35.560000,0.135000,62.560200>0.431800 translate<0,0.000000,0>}}
difference{
cylinder{<30.480000,0,66.040000><30.480000,0.036000,66.040000>1.574800 translate<0,0.000000,0>}
cylinder{<30.480000,-0.1,66.040000><30.480000,0.135000,66.040000>1.422400 translate<0,0.000000,0>}}
difference{
cylinder{<30.480000,0,62.560200><30.480000,0.036000,62.560200>0.584200 translate<0,0.000000,0>}
cylinder{<30.480000,-0.1,62.560200><30.480000,0.135000,62.560200>0.431800 translate<0,0.000000,0>}}
difference{
cylinder{<25.400000,0,66.040000><25.400000,0.036000,66.040000>1.574800 translate<0,0.000000,0>}
cylinder{<25.400000,-0.1,66.040000><25.400000,0.135000,66.040000>1.422400 translate<0,0.000000,0>}}
difference{
cylinder{<25.400000,0,62.560200><25.400000,0.036000,62.560200>0.584200 translate<0,0.000000,0>}
cylinder{<25.400000,-0.1,62.560200><25.400000,0.135000,62.560200>0.431800 translate<0,0.000000,0>}}
//X6 silk screen
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<85.369400,0.000000,4.064000>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<87.376000,0.000000,6.070600>}
box{<0,0,-0.127000><2.837761,0.036000,0.127000> rotate<0,-44.997030,0> translate<85.369400,0.000000,4.064000> }
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<90.525600,0.000000,4.038600>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<92.430600,0.000000,6.070600>}
box{<0,0,-0.127000><2.785327,0.036000,0.127000> rotate<0,-46.844519,0> translate<90.525600,0.000000,4.038600> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,9.906000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<93.980000,0.000000,9.906000>}
box{<0,0,-0.076200><10.160000,0.036000,0.076200> rotate<0,0.000000,0> translate<83.820000,0.000000,9.906000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<93.980000,0.000000,0.889000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<93.980000,0.000000,3.302000>}
box{<0,0,-0.076200><2.413000,0.036000,0.076200> rotate<0,90.000000,0> translate<93.980000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<93.980000,0.000000,0.889000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,0.889000>}
box{<0,0,-0.076200><10.160000,0.036000,0.076200> rotate<0,0.000000,0> translate<83.820000,0.000000,0.889000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,9.906000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,3.302000>}
box{<0,0,-0.076200><6.604000,0.036000,0.076200> rotate<0,-90.000000,0> translate<83.820000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<85.471000,0.000000,3.302000>}
box{<0,0,-0.076200><1.651000,0.036000,0.076200> rotate<0,0.000000,0> translate<83.820000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<85.471000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<87.249000,0.000000,3.302000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<85.471000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<87.249000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<90.551000,0.000000,3.302000>}
box{<0,0,-0.076200><3.302000,0.036000,0.076200> rotate<0,0.000000,0> translate<87.249000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<92.329000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<93.980000,0.000000,3.302000>}
box{<0,0,-0.076200><1.651000,0.036000,0.076200> rotate<0,0.000000,0> translate<92.329000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,0.889000>}
box{<0,0,-0.076200><2.413000,0.036000,0.076200> rotate<0,-90.000000,0> translate<83.820000,0.000000,0.889000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<93.980000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<93.980000,0.000000,9.906000>}
box{<0,0,-0.076200><6.604000,0.036000,0.076200> rotate<0,90.000000,0> translate<93.980000,0.000000,9.906000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,9.906000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,10.160000>}
box{<0,0,-0.076200><0.254000,0.036000,0.076200> rotate<0,90.000000,0> translate<83.820000,0.000000,10.160000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,10.160000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<93.980000,0.000000,10.160000>}
box{<0,0,-0.076200><10.160000,0.036000,0.076200> rotate<0,0.000000,0> translate<83.820000,0.000000,10.160000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<93.980000,0.000000,9.906000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<93.980000,0.000000,10.160000>}
box{<0,0,-0.076200><0.254000,0.036000,0.076200> rotate<0,90.000000,0> translate<93.980000,0.000000,10.160000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<90.551000,0.000000,3.302000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<92.329000,0.000000,3.302000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<90.551000,0.000000,3.302000> }
difference{
cylinder{<86.360000,0,5.080000><86.360000,0.036000,5.080000>1.574800 translate<0,0.000000,0>}
cylinder{<86.360000,-0.1,5.080000><86.360000,0.135000,5.080000>1.422400 translate<0,0.000000,0>}}
difference{
cylinder{<86.360000,0,8.559800><86.360000,0.036000,8.559800>0.584200 translate<0,0.000000,0>}
cylinder{<86.360000,-0.1,8.559800><86.360000,0.135000,8.559800>0.431800 translate<0,0.000000,0>}}
difference{
cylinder{<91.440000,0,5.080000><91.440000,0.036000,5.080000>1.574800 translate<0,0.000000,0>}
cylinder{<91.440000,-0.1,5.080000><91.440000,0.135000,5.080000>1.422400 translate<0,0.000000,0>}}
difference{
cylinder{<91.440000,0,8.559800><91.440000,0.036000,8.559800>0.584200 translate<0,0.000000,0>}
cylinder{<91.440000,-0.1,8.559800><91.440000,0.135000,8.559800>0.431800 translate<0,0.000000,0>}}
//X7 silk screen
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<82.270600,0.000000,67.056000>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<80.264000,0.000000,65.049400>}
box{<0,0,-0.127000><2.837761,0.036000,0.127000> rotate<0,-44.997030,0> translate<80.264000,0.000000,65.049400> }
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<77.114400,0.000000,67.081400>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<75.209400,0.000000,65.049400>}
box{<0,0,-0.127000><2.785327,0.036000,0.127000> rotate<0,-46.844519,0> translate<75.209400,0.000000,65.049400> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,61.214000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<73.660000,0.000000,61.214000>}
box{<0,0,-0.076200><10.160000,0.036000,0.076200> rotate<0,0.000000,0> translate<73.660000,0.000000,61.214000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<73.660000,0.000000,70.231000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<73.660000,0.000000,67.818000>}
box{<0,0,-0.076200><2.413000,0.036000,0.076200> rotate<0,-90.000000,0> translate<73.660000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<73.660000,0.000000,70.231000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,70.231000>}
box{<0,0,-0.076200><10.160000,0.036000,0.076200> rotate<0,0.000000,0> translate<73.660000,0.000000,70.231000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,61.214000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,67.818000>}
box{<0,0,-0.076200><6.604000,0.036000,0.076200> rotate<0,90.000000,0> translate<83.820000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<82.169000,0.000000,67.818000>}
box{<0,0,-0.076200><1.651000,0.036000,0.076200> rotate<0,0.000000,0> translate<82.169000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<82.169000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<80.391000,0.000000,67.818000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<80.391000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<80.391000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<77.089000,0.000000,67.818000>}
box{<0,0,-0.076200><3.302000,0.036000,0.076200> rotate<0,0.000000,0> translate<77.089000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<75.311000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<73.660000,0.000000,67.818000>}
box{<0,0,-0.076200><1.651000,0.036000,0.076200> rotate<0,0.000000,0> translate<73.660000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,70.231000>}
box{<0,0,-0.076200><2.413000,0.036000,0.076200> rotate<0,90.000000,0> translate<83.820000,0.000000,70.231000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<73.660000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<73.660000,0.000000,61.214000>}
box{<0,0,-0.076200><6.604000,0.036000,0.076200> rotate<0,-90.000000,0> translate<73.660000,0.000000,61.214000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,61.214000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,60.960000>}
box{<0,0,-0.076200><0.254000,0.036000,0.076200> rotate<0,-90.000000,0> translate<83.820000,0.000000,60.960000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,60.960000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<73.660000,0.000000,60.960000>}
box{<0,0,-0.076200><10.160000,0.036000,0.076200> rotate<0,0.000000,0> translate<73.660000,0.000000,60.960000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<73.660000,0.000000,61.214000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<73.660000,0.000000,60.960000>}
box{<0,0,-0.076200><0.254000,0.036000,0.076200> rotate<0,-90.000000,0> translate<73.660000,0.000000,60.960000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<77.089000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<75.311000,0.000000,67.818000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<75.311000,0.000000,67.818000> }
difference{
cylinder{<81.280000,0,66.040000><81.280000,0.036000,66.040000>1.574800 translate<0,0.000000,0>}
cylinder{<81.280000,-0.1,66.040000><81.280000,0.135000,66.040000>1.422400 translate<0,0.000000,0>}}
difference{
cylinder{<81.280000,0,62.560200><81.280000,0.036000,62.560200>0.584200 translate<0,0.000000,0>}
cylinder{<81.280000,-0.1,62.560200><81.280000,0.135000,62.560200>0.431800 translate<0,0.000000,0>}}
difference{
cylinder{<76.200000,0,66.040000><76.200000,0.036000,66.040000>1.574800 translate<0,0.000000,0>}
cylinder{<76.200000,-0.1,66.040000><76.200000,0.135000,66.040000>1.422400 translate<0,0.000000,0>}}
difference{
cylinder{<76.200000,0,62.560200><76.200000,0.036000,62.560200>0.584200 translate<0,0.000000,0>}
cylinder{<76.200000,-0.1,62.560200><76.200000,0.135000,62.560200>0.431800 translate<0,0.000000,0>}}
//X8 silk screen
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<72.110600,0.000000,67.056000>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<70.104000,0.000000,65.049400>}
box{<0,0,-0.127000><2.837761,0.036000,0.127000> rotate<0,-44.997030,0> translate<70.104000,0.000000,65.049400> }
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<66.954400,0.000000,67.081400>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<65.049400,0.000000,65.049400>}
box{<0,0,-0.127000><2.785327,0.036000,0.127000> rotate<0,-46.844519,0> translate<65.049400,0.000000,65.049400> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<73.660000,0.000000,61.214000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.500000,0.000000,61.214000>}
box{<0,0,-0.076200><10.160000,0.036000,0.076200> rotate<0,0.000000,0> translate<63.500000,0.000000,61.214000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.500000,0.000000,70.231000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.500000,0.000000,67.818000>}
box{<0,0,-0.076200><2.413000,0.036000,0.076200> rotate<0,-90.000000,0> translate<63.500000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.500000,0.000000,70.231000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<73.660000,0.000000,70.231000>}
box{<0,0,-0.076200><10.160000,0.036000,0.076200> rotate<0,0.000000,0> translate<63.500000,0.000000,70.231000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<73.660000,0.000000,61.214000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<73.660000,0.000000,67.818000>}
box{<0,0,-0.076200><6.604000,0.036000,0.076200> rotate<0,90.000000,0> translate<73.660000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<73.660000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<72.009000,0.000000,67.818000>}
box{<0,0,-0.076200><1.651000,0.036000,0.076200> rotate<0,0.000000,0> translate<72.009000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<72.009000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<70.231000,0.000000,67.818000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<70.231000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<70.231000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<66.929000,0.000000,67.818000>}
box{<0,0,-0.076200><3.302000,0.036000,0.076200> rotate<0,0.000000,0> translate<66.929000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<65.151000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.500000,0.000000,67.818000>}
box{<0,0,-0.076200><1.651000,0.036000,0.076200> rotate<0,0.000000,0> translate<63.500000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<73.660000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<73.660000,0.000000,70.231000>}
box{<0,0,-0.076200><2.413000,0.036000,0.076200> rotate<0,90.000000,0> translate<73.660000,0.000000,70.231000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.500000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.500000,0.000000,61.214000>}
box{<0,0,-0.076200><6.604000,0.036000,0.076200> rotate<0,-90.000000,0> translate<63.500000,0.000000,61.214000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<73.660000,0.000000,61.214000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<73.660000,0.000000,60.960000>}
box{<0,0,-0.076200><0.254000,0.036000,0.076200> rotate<0,-90.000000,0> translate<73.660000,0.000000,60.960000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<73.660000,0.000000,60.960000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.500000,0.000000,60.960000>}
box{<0,0,-0.076200><10.160000,0.036000,0.076200> rotate<0,0.000000,0> translate<63.500000,0.000000,60.960000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.500000,0.000000,61.214000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.500000,0.000000,60.960000>}
box{<0,0,-0.076200><0.254000,0.036000,0.076200> rotate<0,-90.000000,0> translate<63.500000,0.000000,60.960000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<66.929000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<65.151000,0.000000,67.818000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<65.151000,0.000000,67.818000> }
difference{
cylinder{<71.120000,0,66.040000><71.120000,0.036000,66.040000>1.574800 translate<0,0.000000,0>}
cylinder{<71.120000,-0.1,66.040000><71.120000,0.135000,66.040000>1.422400 translate<0,0.000000,0>}}
difference{
cylinder{<71.120000,0,62.560200><71.120000,0.036000,62.560200>0.584200 translate<0,0.000000,0>}
cylinder{<71.120000,-0.1,62.560200><71.120000,0.135000,62.560200>0.431800 translate<0,0.000000,0>}}
difference{
cylinder{<66.040000,0,66.040000><66.040000,0.036000,66.040000>1.574800 translate<0,0.000000,0>}
cylinder{<66.040000,-0.1,66.040000><66.040000,0.135000,66.040000>1.422400 translate<0,0.000000,0>}}
difference{
cylinder{<66.040000,0,62.560200><66.040000,0.036000,62.560200>0.584200 translate<0,0.000000,0>}
cylinder{<66.040000,-0.1,62.560200><66.040000,0.135000,62.560200>0.431800 translate<0,0.000000,0>}}
//X9 silk screen
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<92.430600,0.000000,67.056000>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<90.424000,0.000000,65.049400>}
box{<0,0,-0.127000><2.837761,0.036000,0.127000> rotate<0,-44.997030,0> translate<90.424000,0.000000,65.049400> }
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<87.274400,0.000000,67.081400>}
cylinder{<0,0,0><0,0.036000,0>0.127000 translate<85.369400,0.000000,65.049400>}
box{<0,0,-0.127000><2.785327,0.036000,0.127000> rotate<0,-46.844519,0> translate<85.369400,0.000000,65.049400> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<93.980000,0.000000,61.214000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,61.214000>}
box{<0,0,-0.076200><10.160000,0.036000,0.076200> rotate<0,0.000000,0> translate<83.820000,0.000000,61.214000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,70.231000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,67.818000>}
box{<0,0,-0.076200><2.413000,0.036000,0.076200> rotate<0,-90.000000,0> translate<83.820000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,70.231000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<93.980000,0.000000,70.231000>}
box{<0,0,-0.076200><10.160000,0.036000,0.076200> rotate<0,0.000000,0> translate<83.820000,0.000000,70.231000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<93.980000,0.000000,61.214000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<93.980000,0.000000,67.818000>}
box{<0,0,-0.076200><6.604000,0.036000,0.076200> rotate<0,90.000000,0> translate<93.980000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<93.980000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<92.329000,0.000000,67.818000>}
box{<0,0,-0.076200><1.651000,0.036000,0.076200> rotate<0,0.000000,0> translate<92.329000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<92.329000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<90.551000,0.000000,67.818000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<90.551000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<90.551000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<87.249000,0.000000,67.818000>}
box{<0,0,-0.076200><3.302000,0.036000,0.076200> rotate<0,0.000000,0> translate<87.249000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<85.471000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,67.818000>}
box{<0,0,-0.076200><1.651000,0.036000,0.076200> rotate<0,0.000000,0> translate<83.820000,0.000000,67.818000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<93.980000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<93.980000,0.000000,70.231000>}
box{<0,0,-0.076200><2.413000,0.036000,0.076200> rotate<0,90.000000,0> translate<93.980000,0.000000,70.231000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,61.214000>}
box{<0,0,-0.076200><6.604000,0.036000,0.076200> rotate<0,-90.000000,0> translate<83.820000,0.000000,61.214000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<93.980000,0.000000,61.214000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<93.980000,0.000000,60.960000>}
box{<0,0,-0.076200><0.254000,0.036000,0.076200> rotate<0,-90.000000,0> translate<93.980000,0.000000,60.960000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<93.980000,0.000000,60.960000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,60.960000>}
box{<0,0,-0.076200><10.160000,0.036000,0.076200> rotate<0,0.000000,0> translate<83.820000,0.000000,60.960000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,61.214000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.820000,0.000000,60.960000>}
box{<0,0,-0.076200><0.254000,0.036000,0.076200> rotate<0,-90.000000,0> translate<83.820000,0.000000,60.960000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<87.249000,0.000000,67.818000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<85.471000,0.000000,67.818000>}
box{<0,0,-0.076200><1.778000,0.036000,0.076200> rotate<0,0.000000,0> translate<85.471000,0.000000,67.818000> }
difference{
cylinder{<91.440000,0,66.040000><91.440000,0.036000,66.040000>1.574800 translate<0,0.000000,0>}
cylinder{<91.440000,-0.1,66.040000><91.440000,0.135000,66.040000>1.422400 translate<0,0.000000,0>}}
difference{
cylinder{<91.440000,0,62.560200><91.440000,0.036000,62.560200>0.584200 translate<0,0.000000,0>}
cylinder{<91.440000,-0.1,62.560200><91.440000,0.135000,62.560200>0.431800 translate<0,0.000000,0>}}
difference{
cylinder{<86.360000,0,66.040000><86.360000,0.036000,66.040000>1.574800 translate<0,0.000000,0>}
cylinder{<86.360000,-0.1,66.040000><86.360000,0.135000,66.040000>1.422400 translate<0,0.000000,0>}}
difference{
cylinder{<86.360000,0,62.560200><86.360000,0.036000,62.560200>0.584200 translate<0,0.000000,0>}
cylinder{<86.360000,-0.1,62.560200><86.360000,0.135000,62.560200>0.431800 translate<0,0.000000,0>}}
texture{col_slk}
}
#end
translate<mac_x_ver,mac_y_ver,mac_z_ver>
rotate<mac_x_rot,mac_y_rot,mac_z_rot>
}//End union
#end

#if(use_file_as_inc=off)
object{  MAMEPANELATMEGA32(-48.253750,0,-35.555000,pcb_rotate_x,pcb_rotate_y,pcb_rotate_z)
#if(pcb_upsidedown=on)
rotate pcb_rotdir*180
#end
}
#end


//Parts not found in 3dpack.dat or 3dusrpac.dat are:
