CREATE TABLE ADR (
  ID SERIAL,
  FOTO_ID INTEGER,
  BEZEICHNUNG VARCHAR(50) NOT NULL,
  FIRMA VARCHAR(50),
  STRASSE VARCHAR(50),
  PLZ VARCHAR(15),
  ORT VARCHAR(50),
  LAND VARCHAR(50),
  NAME VARCHAR(50),
  TELEFON VARCHAR(50),
  MOBIL VARCHAR(50),
  FAX VARCHAR(50),
  EMAIL VARCHAR(50),
  INTERNET VARCHAR(250),
  KUNDNR VARCHAR(30),
  LOGIN VARCHAR(50),
  PASSWORT VARCHAR(50),
  USSTID VARCHAR(25),
  GEBDATUM DATE,
  BANK VARCHAR(40),
  BLZ VARCHAR(40),
  KONTO VARCHAR(40),
  BEMERKUNG TEXT,
  AENDDATUM TIMESTAMP NOT NULL DEFAULT 'NOW',
  CONSTRAINT ADR_ID_PX PRIMARY KEY (ID),
  CONSTRAINT ADR_BEZEICHNUNG_IX UNIQUE (BEZEICHNUNG)
);

CREATE TABLE BAUTEIL (
  ID SERIAL,
  TREE_TYP_ID INTEGER NOT NULL,
  FOTO_ID INTEGER,
  BEZEICHNUNG VARCHAR(50) NOT NULL,
  BESCHREIBUNG TEXT,
  HANDBUCH VARCHAR(250),
  LIBRARY VARCHAR(70),
  KENNZ INTEGER,
  AENDDATUM TIMESTAMP NOT NULL DEFAULT 'NOW',
  CONSTRAINT BAUTEIL_ID_PX PRIMARY KEY (ID),
  CONSTRAINT BAUTEIL_BEZEICHNUNG_IX UNIQUE (BEZEICHNUNG)
);

CREATE TABLE BAUTEILADR (
  ID SERIAL,
  BAUTEIL_ID INTEGER NOT NULL,
  ADR_ID INTEGER NOT NULL,
  BAUTEILLAGER_ID INTEGER,
  BESTELLNR VARCHAR(50),
  EPREIS DOUBLE PRECISION,
  EPMENGE INTEGER,
  VPEMENGE INTEGER,
  BEMERKUNG VARCHAR(100),
  AENDDATUM TIMESTAMP NOT NULL DEFAULT 'NOW',
  CONSTRAINT BAUTEILADR_ID_PX PRIMARY KEY (ID)
);

CREATE TABLE BAUTEILLAGER (
  ID SERIAL,
  BAUTEIL_ID INTEGER NOT NULL,
  CASE_ID INTEGER,
  KISTE_ID INTEGER,
  ADR_ID INTEGER,
  BEZEICHNUNG VARCHAR(40),
  SMD INTEGER NOT NULL DEFAULT '0',
  SMD_TEXT VARCHAR(50),
  MENGE INTEGER,
  MENGEMIN INTEGER,
  EPREIS DOUBLE PRECISION,
  VPREIS DOUBLE PRECISION,
  HALTBAR DATE,
  LAGERNR VARCHAR(40),
  BWARE INTEGER,
  ROHS INTEGER,
  BEMERKUNG VARCHAR(100),
  HANDBUCH VARCHAR(250),
  LIBRARY VARCHAR(70),
  KENNZ INTEGER,
  GEWICHT DOUBLE PRECISION,
  BARCODE VARCHAR(30),
  AENDDATUM TIMESTAMP NOT NULL DEFAULT 'NOW',
  CONSTRAINT BAUTEILLAGER_ID_PX PRIMARY KEY (ID)
);

CREATE TABLE BESTELLEN (
  ID SERIAL,
  BAUTEIL_ID INTEGER,
  BAUTEILLAGER_ID INTEGER,
  BAUTEILADR_ID INTEGER,
  PROJEKT_ID INTEGER,
  BEZEICHNUNG VARCHAR(50),
  MENGE INTEGER,
  STATUS INTEGER,
  SDATUM DATE,
  ARCHIV INTEGER,
  BEMERKUNG VARCHAR(200),
  LIEF1_ADR_ID INTEGER,
  LIEF1_BESTELLNR VARCHAR(50),
  LIEF1_EPREIS DOUBLE PRECISION,
  LIEF1_GPREIS DOUBLE PRECISION,
  LIEF2_ADR_ID INTEGER,
  LIEF2_BESTELLNR VARCHAR(50),
  LIEF2_EPREIS DOUBLE PRECISION,
  LIEF2_GPREIS DOUBLE PRECISION,
  AENDDATUM TIMESTAMP NOT NULL DEFAULT 'NOW',
  CONSTRAINT BESTELLEN_ID_PX PRIMARY KEY (ID)
);

CREATE TABLE "case" (
  ID SERIAL,
  FOTO_ID INTEGER,
  BEZEICHNUNG VARCHAR(50) NOT NULL,
  TYP VARCHAR(50),
  PINS INTEGER,
  RASTER FLOAT,
  TEXT VARCHAR(100),
  SMD INTEGER NOT NULL,
  AENDDATUM TIMESTAMP NOT NULL DEFAULT 'NOW',
  CONSTRAINT CASE_ID_PX PRIMARY KEY (ID)
);

CREATE TABLE FOTO (
  ID SERIAL,
  ID_ID INTEGER,
  BEZEICHNUNG VARCHAR(80),
  TABELLE VARCHAR(30),
  BILDTYP VARCHAR(10) NOT NULL,
  BILD BYTEA,
  AENDDATUM TIMESTAMP NOT NULL DEFAULT 'NOW',
  CONSTRAINT FOTO_ID_PX PRIMARY KEY (ID)
);

CREATE TABLE HISTORIE (
  ID SERIAL,
  PROJEKT_ID INTEGER,
  FOTO_ID INTEGER,
  ADR_ID INTEGER,
  DATUM DATE,
  PROJEKT VARCHAR(100),
  BEZEICHNUNG VARCHAR(100),
  BESCHREIBUNG TEXT,
  VERSION VARCHAR(30),
  STATUS INTEGER,
  FSTATUS INTEGER,
  SNR VARCHAR(40),
  GNR VARCHAR(40),
  FDATUM DATE,
  FVERSION VARCHAR(30),
  KENNZ INTEGER,
  AUFWAND DOUBLE PRECISION,
  HANDBUCH VARCHAR(250),
  AENDDATUM TIMESTAMP NOT NULL DEFAULT 'NOW',
  CONSTRAINT HISTORIE_ID_PX PRIMARY KEY (ID)
);

CREATE TABLE KISTE (
  ID SERIAL,
  FOTO_ID INTEGER,
  BEZEICHNUNG VARCHAR(100) NOT NULL,
  NUMMER INTEGER,
  POSX INTEGER,
  POSY INTEGER,
  LAGERORT VARCHAR(100),
  GROESSE VARCHAR(100),
  TEXT VARCHAR(200),
  PARETIKETT VARCHAR(150),
  AENDDATUM TIMESTAMP NOT NULL DEFAULT 'NOW',
  CONSTRAINT KISTE_ID_PX PRIMARY KEY (ID)
);

CREATE TABLE PARAM (
  ID SERIAL,
  PARNR INTEGER,
  PARNAME VARCHAR(40),
  LAND VARCHAR(5),
  VALINT INTEGER,
  VALFLOAT DOUBLE PRECISION,
  VALTEXT VARCHAR(250),
  AENDDATUM TIMESTAMP NOT NULL DEFAULT 'NOW',
  CONSTRAINT PARAM_ID_PX PRIMARY KEY (ID)
);

CREATE TABLE PROJEKT (
  ID SERIAL,
  ID_ID INTEGER,
  FOTO_ID INTEGER,
  BAUTEIL_ID INTEGER,
  BAUTEILLAGER_ID INTEGER,
  ADR_ID INTEGER,
  BEZEICHNUNG VARCHAR(100) NOT NULL,
  BESCHREIBUNG TEXT,
  KENNZ INTEGER,
  MENGEFERTIG INTEGER,
  MENGEOFFEN INTEGER,
  TERMIN DATE,
  HANDBUCH VARCHAR(250),
  OPTA INTEGER,
  OPTB INTEGER,
  OPTC INTEGER,
  AENDDATUM TIMESTAMP NOT NULL DEFAULT 'NOW',
  CONSTRAINT PROJEKT_ID_PX PRIMARY KEY (ID),
  CONSTRAINT PROJEKT_BEZEICHNUNG_IX UNIQUE (BEZEICHNUNG)
);

CREATE TABLE PROJEKTPOS (
  ID SERIAL,
  PROJEKT_ID INTEGER NOT NULL,
  BAUTEIL_ID INTEGER,
  BAUTEILLAGER_ID INTEGER,
  BEZEICHNUNG VARCHAR(100),
  BEMERKUNG VARCHAR(250),
  SYMBOL VARCHAR(50),
  WERT VARCHAR(50),
  "case" VARCHAR(50),
  MENGE INTEGER,
  EPREIS DOUBLE PRECISION,
  GPREIS DOUBLE PRECISION,
  KENNZ INTEGER,
  VARIANTE VARCHAR(50),
  POSX INTEGER,
  POSY INTEGER,
  TOP INTEGER,
  SMD INTEGER,
  STATUS INTEGER,
  AENDDATUM TIMESTAMP NOT NULL DEFAULT 'NOW',
  CONSTRAINT PROJEKTPOS_ID_PX PRIMARY KEY (ID)
);

CREATE TABLE TRANSLATE (
  ID SERIAL,
  BEZNAME VARCHAR(100) NOT NULL,
  DE VARCHAR(250),
  DE_WAREN VARCHAR(250),
  EN VARCHAR(250),
  ES VARCHAR(250),
  FR VARCHAR(250),
  IT VARCHAR(250),
  NL VARCHAR(250),
  PL VARCHAR(250),
  RU VARCHAR(250),
  CONSTRAINT TRANSLATE_ID_PX PRIMARY KEY (ID)
);

CREATE TABLE TREE_TYP (
  ID SERIAL,
  ID_ID INTEGER NOT NULL,
  FOTO_ID INTEGER,
  BEZEICHNUNG VARCHAR(100) NOT NULL,
  BARFORMAT VARCHAR(40) NOT NULL,
  TEXT VARCHAR(100),
  AENDDATUM TIMESTAMP NOT NULL DEFAULT 'NOW',
  CONSTRAINT TREE_TYP_ID_PX PRIMARY KEY (ID)
);

CREATE TABLE WISSEN (
  ID SERIAL,
  FOTO_ID INTEGER,
  BEZEICHNUNG VARCHAR(100) NOT NULL,
  BESCHREIBUNG TEXT,
  THEMA VARCHAR(50),
  KENNZ INTEGER,
  HANDBUCH VARCHAR(250),
  AENDDATUM TIMESTAMP NOT NULL DEFAULT 'NOW',
  CONSTRAINT WISSEN_ID_PX PRIMARY KEY (ID)
);

CREATE FUNCTION "IF"(IN b boolean, IN "fTrue" double precision, IN "fFalse" double precision) RETURNS double precision AS $$
BEGIN
  IF (b) THEN
    RETURN "fTrue";
  ELSE 
    RETURN "fFalse";
  END IF;
END;
$$ LANGUAGE plpgsql;


CREATE INDEX BAUTEILADR_BESTELLNR_IX ON BAUTEILADR (BESTELLNR);
CREATE INDEX BAUTEILLAGER_SMD_Text_IX ON BAUTEILLAGER (SMD_TEXT);
CREATE INDEX BAUTEILLAGER_LAGERNR_IX ON BAUTEILLAGER (LAGERNR);
CREATE INDEX BAUTEILLAGER_BARCODE_IX ON BAUTEILLAGER (BARCODE);
CREATE INDEX BAUTEILLAGER_BEZ_IX ON BAUTEILLAGER (BEZEICHNUNG);

-- --------------------------------------------------------

--
-- VERSION DATENBANK HINZUFÜGEN
--
DELETE FROM PARAM WHERE PARNR=1;
INSERT INTO PARAM (PARNR, PARNAME, LAND, VALINT, VALFLOAT, VALTEXT) VALUES
(1, 'DB-Version', NULL, NULL, NULL, 'V1.2.11406');

COMMIT;
