/*#######################################################################################
AVR Small Webserver 

Copyright (C) 2004 Ulrich Radig

#######################################################################################*/

#ifndef _MAIN_H
 #define _MAIN_H

//fr die Benutzung der Platine von 
//Holger Buss (www.mikrocontroller.com) Mega32-Board
//folgendes aktivieren:
//#define ISA_CTRL


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <avr/io.h>
#include <avr/pgmspace.h>
#include <avr/interrupt.h>
#include <avr/signal.h>
#include <avr/eeprom.h>
#include <avr/wdt.h>

#include "mmc.h"
#include "interrupt4.h"
#include "fat.h"
#include "rtl8019.h"
#include "tcp.h"
#include "arp.h"
#include "ip.h"
#include "icmp.h"
#include "clock.h"
#include "uart.h"
#include "ftpd.h"
#include "webpage.h"
#include "telnet.h"
#include "webcam/mca25.h"
#include "webcam/servo.h"

extern int checksum (unsigned char * ,unsigned int,unsigned long);
extern void httpd (char* buffer,int *bufferlen);

extern const unsigned char mymac[];
extern const unsigned char MYIP[];


//buffer for webcam
#define CAM_BUFFER_LEN 512

//some webcam control stuff:
extern unsigned char webcam_busy_forconn;
extern int webcam_buffer_empty;
extern unsigned char webcam_pic_end;
extern unsigned char webcam_tmp;
//

//MTU Size setzen (min. 500 / max. 1400)
#define MTU_SIZE  800

//Der Quarz auf dem Experimentierboard hat eine Frequenz von 14.318MHz
#define SYSCLK	7372800 //14318180	//Quarz Frequenz in Hz

#if defined (__AVR_ATmega103__)
	#define Networkcard_INT_Enable()	enable_external_int (1<<INT4);
#endif
	
#if defined (__AVR_ATmega128__)
	#define Networkcard_INT_Enable()	enable_external_int (1<<INT4);
#endif
	
#if defined (__AVR_ATmega32__)	
	#define Networkcard_INT_Enable()	enable_external_int (1<<INT0);
#endif	

#if defined (__AVR_ATmega32__)	
	#define Networkcard_INT_Set()	MCUCR=0x01;
#endif	
	
#if defined (__AVR_ATmega103__)
	#define Networkcard_INT_Set()	EICR = 0x03;
#endif
	
#if defined (__AVR_ATmega128__)
	#define Networkcard_INT_Set()	EICR = 0x03;
#endif

#endif //_MAIN_H






