/*#######################################################################################
AVR Small Webserver 

Copyright (C) 2004 Ulrich Radig

Bei Fragen und Verbesserungen wendet euch per EMail an

mail@ulrichradig.de

oder im Forum meiner Web Page : www.ulrichradig.de


Dieses Programm ist freie Software. Sie k�nen es unter den Bedingungen der 
GNU General Public License, wie von der Free Software Foundation ver�fentlicht, 
weitergeben und/oder modifizieren, entweder gem� Version 2 der Lizenz oder 
(nach Ihrer Option) jeder sp�eren Version. 

Die Ver�fentlichung dieses Programms erfolgt in der Hoffnung, 
da�es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, 
sogar ohne die implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT 
F� EINEN BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License. 

Sie sollten eine Kopie der GNU General Public License zusammen mit diesem 
Programm erhalten haben. 
Falls nicht, schreiben Sie an die Free Software Foundation, 
Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA. 
#######################################################################################*/

#include "main.h"

//Die beiden hier k�nte man vieleicht doch besser ins RAM legen. Holgi
//MAC Addresse des Web Servers
const unsigned char mymac[] = {30,10,43,43,45,77};

//IP Addresse des Web Servers
const unsigned char MYIP[] = {192,168,0,101};

//############################################################################
//Hauptprogramm
int main (void)
//############################################################################
{
	UART_Init();

	printf_P(PSTR("[[[   WEBSERVER STARTING   ]]]\n"));

	#if USE_MMC	
		while (mmc_init() != 0) //ist der Rckgabewert ungleich NULL ist ein Fehler aufgetreten
								//MMC/SD-Karte wird dann neu Initialisiert
			{
			printf ("** Keine MMC/SD-Karte gefunden! **\n\n");
			}
		printf ("MMC/SD-Karte gefunden!\n\n");
		//Speichern der Cluster Size und Cluster Offset (Anfang Datenbereich)
		Cluster_Data_Store();
	#endif

	//Ausgabe meiner MAC Adresse auf Serieller Schnittstelle
	printf ("[[[ mac: %02x.%02x.02%x.02%x.02%x.%02x ]]]\n",mymac[0],mymac[1],mymac[2]
										   ,mymac[3],mymac[4],mymac[5]);

	//Ausgabe meiner IP Adresse auf Serieller Schnittstelle
	printf ("[[[  ip: %3d.%03d.%03d.%03d    ]]]\n",MYIP[0],MYIP[1],MYIP[2],MYIP[3]);	

#if USE_MCA25_CAM
	//set up camera:
	printf_P(PSTR("[[[     configuring cam    ]]]\n"));
	printf_P(PSTR("\n\ndebug output is now off!\n\n"));
	
	//DEBUG:
	MCA25_ERROR_LED_OFF();
	MCA25_CLOCK_LED_OFF();
	DDRB = 0xFF;
	
	MCA25_STATUS_LED_ON();
	mca25_init();
	mca25_configure();	
	MCA25_STATUS_LED_OFF();
#endif	

#if USE_SERVO
	servo_init();
#endif

	//Grundinizialisierung der Netzwerkkarte
	Init_Realtek_Network_Card();

	if(ReadRTL(0) == 34){
		printf ("[[[ init: ok (34)          ]]]\n"); 
	}else{
#if USE_MCA25_CAM
		mca25_uart_disabled=0;
#endif
		printf ("\n\nInit: ERROR(%d)",ReadRTL(0));
		while(1);
	}
	
	//Globale Interrupts Einschalten
	sei ();
	
	//Interrupt 4 Mega103/128 Interrupt 0 bei Mega32 
	//soll ausl�en bei ansteigender Flanke
	Networkcard_INT_Set();
	
	//Interrupt 4 oder 0 Einschalten (fr die Netzwerkkarte)
	Networkcard_INT_Enable();

	#if USE_CLOCK
		Start_Clock();
	#endif

	//Hauptprogramm l�ft st�dig in einer schleife und macht nichts
	while (1)
		{
		}
return (1);
}

