/************************************************************************************************
 * Name:			hand_auto.c																	*
 *																								*
 * Specification:	Funktionen Hand- und Automatikbetrieb										*
 * Version:			2.02																		*
 * Created:			11.06.2011 02:15:42															*
 * Modified:		29.06.2011																	*
 * Author:			Bernd H																*
 * Projekt:			Mikrocontroller gesteuerte Photovoltaikanlage mit effektiver Nachfhrung	*
 *																								*
 ************************************************************************************************/ 


#include <avr/io.h>
#include <stdio.h>
#include "map.h"
#include "hand_auto.h"
#include "special_func.h"
#include "mot_func.h"

extern uint8_t status;
extern uint8_t wait_dreh;
extern uint8_t wait_neig;
extern uint16_t sensedreh0, sensedreh300, senseneig0, senseneig90;


void tastenzuweisung(void)
{
	//Taste wird gedrckt (wegen den internen Pullups logisch=0)
	if (!(status & ((1<<M_DREH0)|(1<<M_DREH360)|(1<<M_NEIG0)|(1<<M_NEIG90))))
	{
		if (!(PIN(PORT_T_HAND)&(1<<T_DREH0))) status|=(1<<M_DREH0);
		if (!(PIN(PORT_T_HAND)&(1<<T_DREH360))) status|=(1<<M_DREH360);
		if (!(PIN(PORT_T_HAND)&(1<<T_NEIG0))) status|=(1<<M_NEIG0);
		if (!(PIN(PORT_T_HAND)&(1<<T_NEIG90))) status|=(1<<M_NEIG90);
	}	
				
	//Taste wird losgelassen
	if (PIN(PORT_T_HAND)&(1<<T_DREH0)) status&=~(1<<M_DREH0);
	if (PIN(PORT_T_HAND)&(1<<T_DREH360)) status&=~(1<<M_DREH360);
	if (PIN(PORT_T_HAND)&(1<<T_NEIG0)) status&=~(1<<M_NEIG0);
	if (PIN(PORT_T_HAND)&(1<<T_NEIG90))	status&=~(1<<M_NEIG90);
}

void auto_neig(volatile uint16_t *sense1, volatile uint16_t *sense2, volatile uint8_t result)
{

	if (result==1) 
	{ 
		status|=(1<<M_NEIG0);
		act_mot_on();
		while (*sense1 > *sense2)
		{
			//berprfung auf Ausschaltbedingung der Motoren besteht
			if (!(PIN(PORT_T_END)&(1<<T_END_NEIG0))) break;
			if ((PIN(PORT_S_HAND)&(1<<S_HAND))) break;
			*sense1=adcrequest((uint8_t) SENSOR_NEIGUNG0);
			*sense2=adcrequest((uint8_t) SENSOR_NEIGUNG90);
		}
	}
	else if (result==2) 
	{ 

		status|=(1<<M_NEIG90);
		act_mot_on();
		while (*sense1 < *sense2)
		{
			//berprfung auf Ausschaltbedingung der Motoren besteht
			if (!(PIN(PORT_T_END)&(1<<T_END_NEIG90))) break;
			if ((PIN(PORT_S_HAND)&(1<<S_HAND))) break;
			*sense1=adcrequest((uint8_t) SENSOR_NEIGUNG0);
			*sense2=adcrequest((uint8_t) SENSOR_NEIGUNG90);
		}
	}	
	
	all_mot_off();
	checkendswitch();	
}

void auto_dreh(volatile uint16_t *sense1, volatile uint16_t *sense2, volatile uint8_t result)
{

	if (result==1) 
	{ 
		status|=(1<<M_DREH0);
		act_mot_on();
		while (*sense1 > *sense2)
		{
			//berprfung auf Ausschaltbedingung der Motoren besteht
			if (!(PIN(PORT_T_END)&(1<<T_END_DREH0))) break;
			if ((PIN(PORT_S_HAND)&(1<<S_HAND))) break;
			*sense1=adcrequest((uint8_t) SENSOR_DREHUNG0);
			*sense2=adcrequest((uint8_t) SENSOR_DREHUNG300);
		}
	}
	else if (result==2) 
	{ 

		status|=(1<<M_DREH360);
		act_mot_on();
		while (*sense1 < *sense2)
		{
			//berprfung auf Ausschaltbedingung der Motoren besteht
			if (!(PIN(PORT_T_END)&(1<<T_END_DREH360))) break;
			if ((PIN(PORT_S_HAND)&(1<<S_HAND))) break;
			*sense1=adcrequest((uint8_t) SENSOR_DREHUNG0);
			*sense2=adcrequest((uint8_t) SENSOR_DREHUNG300);
		}
	}	
	
	all_mot_off();
	checkendswitch();	
}

void auto_dreh_pos0(void)
{
	status|=(1<<M_DREH0);
	act_mot_on();
	while ((PIN(PORT_T_END)&(1<<T_END_DREH0))) 
	{
		if ((PIN(PORT_S_HAND)&(1<<S_HAND))) break;
	}
	all_mot_off();
	checkendswitch();	
}



