/************************************************************************************************
 * Name:			main.c																		*
 *																								*
 * Specification:	Hauptprogramm																*
 * Version:			2.02																		*
 * Created:			29.06.2011 17:36:39															*
 * Modified:		29.06.2011																	*
 * Author:			Bernd H																*
 * Projekt:			Mikrocontroller gesteuerte Photovoltaikanlage mit effektiver Nachfhrung	*
 *																								*
 ************************************************************************************************/
 
 
#include <avr/io.h>
#include <stdio.h>
#include <avr/interrupt.h>
#define F_CPU 7372800UL
#include <util/delay.h>
#include "map.h"
#include "hand_auto.h"
#include "special_func.h"
#include "mot_func.h"
//#include <util/twi.h>
volatile uint8_t status=0x00;
volatile uint16_t wait_auto=0;
volatile uint8_t wait_adc=0;
volatile uint8_t wait_dreh=0;
volatile uint8_t wait_neig=0;


/*ISR(TWI_vect)
{
	if (TW_STATUS==TW_ST_SLA_ACK)
	{
		TWDR = 27;
		TWCR = (1<<TWINT)|(1<<TWEN)|(1<<TWEA);
		while (!(TWCR & (1<<TWINT)));
		TWCR = (1<<TWINT)|(1<<TWEN)|(1<<TWSTO)|(1<<TWEA);
	}
	
}
*/
ISR(TIMER0_COMP_vect)
{
	
	if (wait_auto < TIME_AUTO) wait_auto++;
	if (wait_adc < TIME_ADC) wait_adc++;
	if (wait_dreh < TIME_MOTOR) wait_dreh++;
	if (wait_neig < TIME_MOTOR) wait_neig++;
	
}

int main(void)
{	
	// Initialisierung 
	volatile uint8_t result=0;uint8_t i=0;
	volatile uint16_t potdrehung=0, potneigung=0;
	volatile uint16_t sensedreh0=0, sensedreh300=0, senseneig0=0, senseneig90=0; 
	
    sei();
	init_inout();
	while(1)
	{	
		// Teilinitialisierung (z.B. nach Notaus)
		cli();							//Interrupt generell ausschalten
		status=0x00;wait_auto=0;wait_adc=0;wait_dreh=0;wait_neig=0;
		sei();							//Interrupt generell einschalten
		
		while(1)
		{
			//Vorbereitung auf Hanndbetrieb
			if ((PIN(PORT_S_HAND)&(1<<S_HAND))&&(!(status & (1<<M_HAND))))
			{				
				all_mot_off();
				status|=(1<<M_HAND);
				i=0;					//Durchlufe Automatikbetrieb zurckstellen
				wait_auto=TIME_AUTO;	//Wartezeit Automatikbetrieb zurckstellen
			}
			
			//Handbetrieb verlassen
			if (!(PIN(PORT_S_HAND)&(1<<S_HAND))&&(status & (1<<M_HAND)))
			{
				all_mot_off();
				status &=~(1<<M_HAND);
			}			
			
			// Handbetrieb						
			if (status&(1<<M_HAND))	
			{		
				tastenzuweisung();
				if((status & (1<<M_DREH))||(status & (1<<M_NEIG)))
				{
					potdrehung=adcrequest((uint8_t) POTI_DREHUNG);
					potneigung=adcrequest((uint8_t) POTI_NEIGUNG);
				}
			}
			
			// Automatikbetrieb						
			if (!(status&(1<<M_HAND)))	
			{		
				cli();
				if (wait_auto==TIME_AUTO) 
				{
					//Sensorwerte Neigung neu messen
					senseneig0=adcrequest((uint8_t) SENSOR_NEIGUNG0);
					senseneig90=adcrequest((uint8_t) SENSOR_NEIGUNG90);
					//Sensorwerte Vergleichen
					result=sense_comp(&senseneig0, &senseneig90);
					if (result)
					{
						auto_neig(&sensedreh0, &sensedreh300, result);
					}
										
					//Sensorwerte Drehung neu messen
					sensedreh0=adcrequest((uint8_t) SENSOR_DREHUNG0);
					sensedreh300=adcrequest((uint8_t) SENSOR_DREHUNG300);
					//Sensorwerte Vergleichen
					result=sense_comp(&sensedreh0, &sensedreh300);
					if (result)
					{	
						if (result == 1)
						{
							auto_dreh(&sensedreh0, &sensedreh300, result);
						}
						if ((result == 2) && (!(PIN(PORT_T_END)&(1<<T_END_DREH360))))
						{
							auto_dreh_pos0();
						}
						else if ((result == 2) && (PIN(PORT_T_END)&(1<<T_END_DREH360)))
						{
							auto_dreh(&sensedreh0, &sensedreh300, result);
						}
					}					
											
					/*	Hier knnen die Anzahl der Autodurchlufe eingetragen werden, zwischen den Durchlufen
						besteht eine Pause von ca.1 sec um die Motoren zu schtzen */ 
					if (i<5)
					{
						wait_auto=TIME_AUTO-36;
						i++;
					}
					else
					{
						wait_auto=0;
						i=0;
					}
										
				}
				sei();
				
			}
			
			// Unterprogramm fr den Startbefehl der Motoren
			if (status & ((1<<M_DREH0)|(1<<M_DREH360)|(1<<M_NEIG0)|(1<<M_NEIG90))) act_mot_on();
			
			// Unterprogramm zur berprfung von Ausschaltbedingungen bei aktiven Motor
			if (PIN(PORT_MOTOREN)&((1<<A_DREH0)|(1<<A_DREH360)|(1<<A_NEIG0)|(1<<A_NEIG90))) act_mot_off();
			
			checkendswitch();
			
			// Sensorwerte messen im Ruhezustand der Motoren
			if(!(status & ((1<<M_DREH)|(1<<M_NEIG))))
			{	
				if (wait_adc==TIME_ADC)
				{
					potdrehung=adcrequest((uint8_t) POTI_DREHUNG);
					potneigung=adcrequest((uint8_t) POTI_NEIGUNG);
					sensedreh0=adcrequest((uint8_t) SENSOR_DREHUNG0);
					sensedreh300=adcrequest((uint8_t) SENSOR_DREHUNG300);
					senseneig0=adcrequest((uint8_t) SENSOR_NEIGUNG0);
					senseneig90=adcrequest((uint8_t) SENSOR_NEIGUNG90);
					wait_adc=0;
				}				
			}			
		}
		
	}

	return(0);
}