/************************************************************************************************
 * Name:			map.h																		*
 *																								*
 * Specification:	Definition aller Ein- und Ausgngen und Zuweisung Alias						*
 * Version:			2.02																		*
 * Created:			02.06.2011 21:36:39															*
 * Modified:		29.06.2011																	*
 * Author:			Bernd H																*
 * Projekt:			Mikrocontroller gesteuerte Photovoltaikanlage mit effektiver Nachfhrung	*
 *																								*
 ************************************************************************************************/ 


#ifndef MAP_H_
#define MAP_H_

#define SLAVEADR 0x27
// Eingnge:
	// mit internen Pullups:

#define PORT_T_HAND B			//Taster fr manuelle Steuerung
	#define T_DREH0 PB0
	#define T_DREH360 PB1
	#define T_NEIG0 PB2
	#define T_NEIG90 PB3

#define PORT_S_HAND D		//Schlsselschalter
	#define S_HAND PD7

#define PORT_A_LED_DREH A		//LEDs fr die Anzeige der Endschalter "Drehen"
	#define A_LED_D360 PA1
	#define A_LED_D0 PA0

#define PORT_A_LED_NEIG C		//LEDs fr die Anzeige der Endschalter "Neigen"
	#define A_LED_N0 PC6
	#define A_LED_N90 PC7
	
	
	//ohne internen Pullups:
#define	PORT_T_END B	
	#define	T_END_NEIG0 PB4		//Endschalter
	#define T_END_NEIG90 PB5			
	#define T_END_DREH0 PB6
	#define T_END_DREH360 PB7
		


#define PORT_B_NOTAUS D			//Brcke NOTAUS am Stecker
	#define B_NOTAUS PD6
	
//Ausgnge
	
	//Ausgnge drehen/neigen
	#define PORT_MOTOREN D		
	#define A_NEIG0 PD3
	#define A_NEIG90 PD2
	#define A_DREH0 PD1
	#define A_DREH360 PD0
	
	//PWM Ausgnge
	#define PWM_MOTOR_NEIG PD5
	#define PWM_MOTOR_DREH PD4
	
	//ADC Ausgnge
	#define POTI_DREHUNG 7
	#define POTI_NEIGUNG 6
	#define	SENSOR_DREHUNG0 5
	#define SENSOR_DREHUNG300 4
	#define SENSOR_NEIGUNG0 3
	#define SENSOR_NEIGUNG90 2
		
//Wartezeiten
#define TIME_AUTO 160	//Wartezeit fr den Autobetrieb (36=1 Sekunde) (Mindestzeit=72)
#define TIME_ADC 36
#define TIME_MOTOR 0	//Verzgerung bevor die Motoren die Drehrichtung ndern (36=1 Sekunde)

//Toleranzwert 
#define TOLWERT 5
	
//Merkerbits von Merkerbyte status
#define M_HAND 0
#define M_DREH 1
#define M_NEIG 2
#define M_NOTAUS 3
#define M_NEIG0 4
#define M_NEIG90 5
#define M_DREH0 6
#define M_DREH360 7



// Umwandlung Registername(Adresse) zu RegisternameAdresse
#define GLUE(a, b)		a##b
#define PORT(x)			GLUE(PORT, x)
#define PIN(x)			GLUE(PIN, x)
#define DDR(x)			GLUE(DDR, x)

#endif /* MAP_H_ */
 