/************************************************************************************************
 * Name:			mot_func.c																	*
 *																								*
 * Specification:	Funktionen Motorsteuerung									*
 * Version:			2.02																		*
 * Created:			28.06.2011 02:15:42															*
 * Modified:		29.06.2011																	*
 * Author:			Bernd H																*
 * Projekt:			Mikrocontroller gesteuerte Photovoltaikanlage mit effektiver Nachfhrung	*
 *																								*
 ************************************************************************************************/ 

#include <avr/io.h>
#include <stdio.h>
#include "map.h"
#include "mot_func.h"
#include "hand_auto.h"
#include "special_func.h"

extern uint8_t status;
extern uint8_t wait_dreh;
extern uint8_t wait_neig;

void act_mot_on(void)
{
	if((!(status & (1<<M_DREH)))&&(!(status & (1<<M_NEIG)))) //berspringe den nchsten Block wenn kein Einschalten des Motors notwendig
	{
		//Motoren einschalten (mit der Bedingung, dass kein Endschalter gedrckt und der Motor nicht bereits in der entgegengesetzten Richtung luft	
		if (wait_dreh == TIME_MOTOR)
		{	
			if ((status & (1<<M_DREH0))&&(PIN(PORT_T_END) & (1<<T_END_DREH0)))
			{
				status|=(1<<M_DREH);
				pwm_on();
				PORT(PORT_MOTOREN)|=(1<<A_DREH0);
			}
			else if ((status & (1<<M_DREH360))&&(PIN(PORT_T_END)&(1<<T_END_DREH360)))
			{
				status|=(1<<M_DREH);
				pwm_on();
				PORT(PORT_MOTOREN)|=(1<<A_DREH360);
			}					
		}		
	
		if (wait_neig == TIME_MOTOR)
		{		
			if ((status & (1<<M_NEIG0))&&(PIN(PORT_T_END)&(1<<T_END_NEIG0)))
			{
				status|=(1<<M_NEIG);
				pwm_on();
				PORT(PORT_MOTOREN)|=(1<<A_NEIG0);
			}
			else if ((status & (1<<M_NEIG90))&&(PIN(PORT_T_END)&(1<<T_END_NEIG90)))
			{
				status|=(1<<M_NEIG);
				pwm_on();
				PORT(PORT_MOTOREN)|=(1<<A_NEIG90);
			}				
		}	
	}	
	
}

void act_mot_off(void)
{
	
	//Motoren ausschalten:
	if (((!(status & (1<<M_DREH0)))||(!(PIN(PORT_T_END)&(1<<T_END_DREH0))))&&(PIN(PORT_MOTOREN)&(1<<A_DREH0)))
	{
		PORT(PORT_MOTOREN)&=~(1<<A_DREH0);
		pwm_off();
		status &=~(1<<M_DREH);
		wait_dreh=0;		//Wartezeit fr drehen starten (Counter loeschen)	
	}
	
	if (((!(status & (1<<M_DREH360)))||(!(PIN(PORT_T_END)&(1<<T_END_DREH360))))&&(PIN(PORT_MOTOREN)&(1<<A_DREH360)))
	{
		PORT(PORT_MOTOREN)&=~(1<<A_DREH360);
		pwm_off();
		status&=~(1<<M_DREH);
		wait_dreh=0;		//Wartezeit fr drehen starten	
	}
	
	if (((!(status & (1<<M_NEIG0)))||(!(PIN(PORT_T_END)&(1<<T_END_NEIG0))))&&(PIN(PORT_MOTOREN)&(1<<A_NEIG0)))
	{
		PORT(PORT_MOTOREN)&=~(1<<A_NEIG0);
		pwm_off();
		status&=~(1<<M_NEIG);
		wait_neig=0;		//Wartezeit fr neigen starten	
	}
	
	if (((!(status & (1<<M_NEIG90)))||(!(PIN(PORT_T_END)&(1<<T_END_NEIG90))))&&(PIN(PORT_MOTOREN)&(1<<A_NEIG90)))
	{
		PORT(PORT_MOTOREN)&=~(1<<A_NEIG90);
		pwm_off();
		status&=~(1<<M_NEIG);
		wait_neig=0;		//Wartezeit fr neigen starten	
	}
}

void all_mot_off(void)
{
	pwm_off();
	PORT(PORT_MOTOREN)&=~((1<<A_NEIG0)|(1<<A_NEIG90)|(1<<A_DREH0)|(1<<A_DREH360));
	status &=~((1<<M_NEIG90)|(1<<M_NEIG0)|(1<<M_DREH360)|(1<<M_DREH0)|(1<<M_NEIG)|(1<<M_DREH));
	wait_neig=0;
	wait_dreh=0;

}