/************************************************************************************************
 * Name:			special_func.c																*
 *																								*
 * Specification:	Spezialfunktionen (init, pwm...)										*
 * Version:			2.02																		*
 * Created:			03.06.2011 01:20:11															*
 * Modified:		29.06.2011																	*
 * Author:			Bernd H																*
 * Projekt:			Mikrocontroller gesteuerte Photovoltaikanlage mit effektiver Nachfhrung	*
 *																								*
 ************************************************************************************************/ 


#include <avr/io.h>
#include <avr/interrupt.h>
#include <util/twi.h>
#include "map.h"
#include "mot_func.h"
#include "hand_auto.h"
extern uint8_t status;



void init_inout(void)
{
	// Alle Eingnge und internen Pullups initialialisieren	
	DDR(PORT_S_HAND)&= ~(1<<S_HAND);
	PORT(PORT_T_HAND) |= (1<<T_DREH360)|(1<<T_DREH0)|(1<<T_NEIG0)|(1<<T_NEIG90);	//Pullups Handtaster ein
	PORT(PORT_S_HAND) |= (1<<S_HAND);												//Pullups Schlsselschalter ein
	DDR(PORT_A_LED_DREH) |= (1<<A_LED_D0)|(1<<A_LED_D360);					//LEDs fr die Anzeige der Endschalter
	DDR(PORT_A_LED_NEIG) |= (1<<A_LED_N90)|(1<<A_LED_N0);
	PORT(PORT_A_LED_DREH) &= ~((1<<A_LED_D0)|(1<<A_LED_D360));
	PORT(PORT_A_LED_NEIG) &= ~((1<<A_LED_D0)|(1<<A_LED_D360));
	
	//Ausgnge Motoren definieren
	DDR(PORT_MOTOREN)|=(1<<A_DREH0)|(1<<A_DREH360)|(1<<A_NEIG0)|(1<<A_NEIG90)|(1<<PWM_MOTOR_DREH)|(1<<PWM_MOTOR_NEIG);
	PORT(PORT_MOTOREN)&=~((1<<A_DREH0)|(1<<A_DREH360)|(1<<A_NEIG0)|(1<<A_NEIG90)|(1<<PWM_MOTOR_DREH)|(1<<PWM_MOTOR_NEIG));
	
	//Timer0 initialisieren:
	TIMSK |= (1<<OCIE0);			//IRQ auf Compare Match
	OCR0 = (uint8_t)200;			//Vergleichswert auf 200 setzten (gibt bei einem Precscaler von 1/1024 --> 36 Hz
	TCCR0 |= (1<<WGM01);			//CTC-Modus
	TCCR0 |= (1<<CS02)|(1<<CS00);	//Prescaler auf 1/1024
	//TWAR = (SLAVEADR<<1) | (1<<TWGCE);	// Slaveadresse fr den TWI initialisieren
	//TWCR = (1<<TWEN)|(1<<TWINT)|(1<<TWEA)|(1<<TWIE); //TWI aktivieren
	
}

void pwm_on(void)
{
	
	if ((status & (1<<M_NEIG0))||(status & (1<<M_NEIG90)))
	{
		ICR1=(uint16_t)600;		// TOP Wert Einstellen (ergibt F=6 Hz)
		OCR1A=(uint16_t)160;		// ergibt bei U=24 V durch die PWM ca. 5,6 V 
		TCCR1A|=(1<<COM1A1);		//Noninverting Mode auf OC1A (PWM_MOTOR_DREH)	
	}
	else if ((status & (1<<M_DREH0))||(status & (1<<M_DREH360)))
	{
		ICR1=(uint16_t)1000;		// TOP Wert Einstellen (ergibt F=6 Hz)
		OCR1B=(uint16_t)400;		// ergibt bei U=24 V durch die PWM ca. 5,6 V
		TCCR1A|=(1<<COM1B1);		//Noninverting Mode auf OC1B (PWM_MOTOR_NEIG)		
	}
	
	TCCR1A|=(1<<WGM11);				//Fast PWM14 A
	TCCR1B|=(1<<WGM13)|(1<<WGM12);	//Fast PWM14 B
	TCCR1B|=(1<<CS11)|(1<<CS10); 	//Prescaler clk/1024

}

void pwm_off(void)
{
	
	TCCR1B&=~((1<<CS12)|(1<<CS11)|(1<<CS10)); //Timer1 stop
	TCCR1A&=~((1<<COM1A1)|(1<<COM1B1)); //Ausgang OC1A und OC1B aus
}

uint16_t adcrequest(uint8_t adcport)
{
	volatile uint8_t i=0;
	volatile uint16_t adcwert=0;
	ADMUX=0x00;
	ADMUX|=(1<<REFS0);					// Vergleich mit AVCC
	ADMUX|=adcport;
	ADCSRA|=(1<<ADEN)|(1<<ADPS2)|(1<<ADPS1);	//Wandlungstaktteiler=64 entspricht 115,2 kHz 
	ADCSRA|=(1<<ADSC);
	while(ADCSRA & (1<<ADSC));			// eine Dummy-Konvertierung
	adcwert=ADCW;
	adcwert=0;
	if((status & (1<<M_DREH))||(status & (1<<M_NEIG)))
	{
		ADCSRA|=(1<<ADSC);				//ADC Wandlung starten
		//auf die Wandlung warten und whrend der Wandlung Motoren berprfen
		while(ADCSRA & (1<<ADSC))// act_mot_off();		
		adcwert=ADCW;					//Wandlung zuornden			
	}
	else
	{
		for (i=0;i<4;i++)				//vier Wandlungen durchfhren um einen genaueren Wert zu erhalten
		{
		ADCSRA|=(1<<ADSC);				//ADC Wandlung starten
		while(ADCSRA & (1<<ADSC));		//auf die Wandlung warten
		adcwert+=ADCW;
		}
		adcwert/=4;		
	}
	ADCSRA&= ~(1<<ADEN);					//ADC Wandler ausschalten um Strom zu sparen
	return adcwert;	
}

void checkendswitch(void)
{
		if (!(PIN(PORT_T_END)&(1<<T_END_DREH360)))  PORT(PORT_A_LED_DREH) |= (1<<A_LED_D360);
		if (!(PIN(PORT_T_END)&(1<<T_END_DREH0))) PORT(PORT_A_LED_DREH) |= (1<<A_LED_D0);
		if (!(PIN(PORT_T_END)&(1<<T_END_NEIG0))) PORT(PORT_A_LED_NEIG) |= (1<<A_LED_N0);
		if (!(PIN(PORT_T_END)&(1<<T_END_NEIG90)))PORT(PORT_A_LED_NEIG) |= (1<<A_LED_N90);
		if (PIN(PORT_T_END)&(1<<T_END_DREH360)) PORT(PORT_A_LED_DREH) &= ~(1<<A_LED_D360);
		if (PIN(PORT_T_END)&(1<<T_END_DREH0)) PORT(PORT_A_LED_DREH) &= ~(1<<A_LED_D0);
		if (PIN(PORT_T_END)&(1<<T_END_NEIG0)) PORT(PORT_A_LED_NEIG) &= ~(1<<A_LED_N0);
		if (PIN(PORT_T_END)&(1<<T_END_NEIG90)) PORT(PORT_A_LED_NEIG) &= ~(1<<A_LED_N90);
}

int8_t sense_comp(volatile uint16_t *wert1, volatile uint16_t *wert2)
{
	volatile uint16_t diff;
	
	if (*wert1 == *wert2)return 0;
	if (*wert1 > *wert2)
	{
		diff=*wert1 - *wert2;
		if (diff > TOLWERT) return 1;
		if (diff <= TOLWERT)return 0;
	}
	if (*wert1 < *wert2)
	{
		diff=*wert2 - *wert1;
		if (diff > TOLWERT) return 2;
		if (diff <= TOLWERT)return 0;
	}
	return 0;
}





