// file: TomCat.cpp

#include <stdio.h>
//#include "nios.h" 

#include "tc_vars.h"
#include "hardware_t.h"
#include "flash_t.h"
#include "display_t.h"
#include "signal_t.h"
#include "commif_t.h"
#include "userif_t.h"

int main(void)										// Main program
{
	printf("\r\n\r\n**********************************************\r\n");
	printf("        BlueFlash firmware starting!\r\n");	
	printf("**********************************************\r\n\r\n");

	Hardware::Init();
	
	Display::Init();

	Hardware::Start_Up();
	
	printf("Ready - press h for help\r\n");
	printf("**********************************************\r\n\r\n");

	// main loop
	while (0 == 0)
	{
		UserIF::Rotary_Interface();

		UserIF::Keyboard_Interface();

		Hardware::Handle_ADC();

		Signal::ProcessSignalData();

		Display::DrawSignals();		

		Hardware::TransferPlanes();

		CommIF::Transfer_USB_Data();

		AMDFlash::Write_Config_Flash();

	}
	
	//return 0;									// Exit
}



